/*
* Miax
*
*  Copyright (C) 2004 by Ubaldo Porcheddu <ubaldo@eja.it>
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
                  

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <termios.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <unistd.h>

static int baudrate=B9600, fd_modem, m_status=0;
extern int debug;


int tty_modem_close() {

	char buf[4096];

	tty_modem("AT+CHUP\r",buf);
	tty_modem("ATH\r",buf);
	m_status=-1;

   	return close(fd_modem);;
	}  
  

int tty_modem_init(char *dev) {
  
	char buf[4096];
	struct termios newtio;
  
	bzero(&newtio, sizeof(newtio));
	newtio.c_cflag = CRTSCTS | CS8 | CLOCAL | CREAD | O_NDELAY;
	if ( fd_modem = open(dev, O_RDWR | O_NOCTTY | O_NONBLOCK) ) {
		cfsetispeed(&newtio,baudrate);
		cfsetospeed(&newtio,baudrate);
		newtio.c_cflag &= ~CRTSCTS; 
		newtio.c_iflag = IGNPAR;
		newtio.c_oflag = 0;
		newtio.c_lflag = 0;
		newtio.c_cc[VTIME] = 1;
		newtio.c_cc[VMIN] = 0;
		tcflush(fd_modem, TCIOFLUSH);
		tcsetattr(fd_modem,TCSANOW,&newtio);
		tty_modem("ATZHE1+CLIP=1\r",buf);

		m_status=1;
		}
	
	return fd_modem;
	}


int tty_modem(char* send, char *receive) {
	
	int l=0, in=0, out=0, timeout=10;
	char tmp[4096];
        	 
	if (strlen(send)) {
		while ((timeout--) > 0) {
			usleep(100000);
			ioctl(fd_modem,TIOCMGET,&out);
       	 		if (out & TIOCM_CTS) {
				l=write(fd_modem,send,strlen(send));
				break;        	 
	       			}
	       		}
	       	}
	if (m_status >= 0) {
		ioctl(fd_modem,FIONREAD,&in);
		memset(receive,0,1024);
		
		while ((timeout--) > 0) {  
			l=read(fd_modem,tmp,in);
			if (l > 0) { 
				strncat(receive,tmp,in); 
				if (strchr(receive,'\r')) { break; }
				}
			else { usleep(100000); }
			}	
		if (strlen(receive) > 0 && debug > 3) { fprintf(stderr, "%s\n", receive); }
		
		}
		
	return l;
	}


int tty_modem_loop(int status, char *number) {

	char buf[1024], tmp[4096];
	int l=0;

	if (m_status < 0) { return -1; }

    	if (status == 130 && m_status != 3) {
    		tty_modem("ATA\r",tmp);
    		m_status=3;
    		status=0;
    		return 100;
    		}
	if (status == 100 && m_status != 2) {
		sprintf(buf,"ATDT%s;\r",number);
		tty_modem(buf,tmp);
		status=0;
		m_status=2;
		return 130;
		}    	

	if (tty_modem("",buf)) {  
                if (strstr(buf,"+CLIP:") && m_status != 4) { 
                	strcpy(tmp,strtok(buf,"\""));
                	strcpy(number,strtok(NULL,"\""));
                	m_status=4;
                	return 101;
                	}
                if (strstr(buf,"ERROR")) { return 1; }
                if (strstr(buf,"BUSY")) { return -2; }
		if (strstr(buf,"NO DIALTONE")) { return -3; }
		if (strstr(buf,"NO CARRIER")) { return -4; }
                if (strstr(buf,"RING")) { return 2; }
                if (strstr(buf,"OK")) { return 1; }                                   
		}
			
	return 0;
	}
