%define contentdir %{_datadir}/netdata

# This is temporary and should eventually be resolved. This bypasses
# the default rhel __os_install_post which throws a python compile
# error.
%define __os_install_post %{nil}

#
# Conditional build:
%bcond_without  systemd  # systemd
%bcond_with     nfacct   # build with nfacct plugin

%if 0%{?fedora} || 0%{?rhel} >= 7
%else
%undefine	with_systemd
%endif

Summary:	Real-time performance monitoring, done right
Name:		netdata
Version:	1.3.0
Release:	1%{?dist}
License:	GPL v3+
Group:		Applications/System
Source0:	http://firehol.org/download/netdata/releases/v1.3.0/%{name}-1.3.0.tar.xz
URL:		http://netdata.firehol.org/
BuildRequires:	pkgconfig
BuildRequires:	xz
BuildRequires:	zlib-devel

# Packages can be found in the EPEL repo
%if %{with nfacct}
BuildRequires:	libmnl-devel
BuildRequires:	libnetfilter_acct-devel
%endif

Requires(pre): /usr/sbin/groupadd
Requires(pre): /usr/sbin/useradd

%if %{with systemd}
Requires(preun):  systemd-units
Requires(postun): systemd-units
Requires(post):   systemd-units
%else
Requires(post):   chkconfig
%endif

BuildRoot:	%{tmpdir}/%{name}-%{version}-root-%(id -u -n)

%description
netdata is the fastest way to visualize metrics. It is a resource
efficient, highly optimized system for collecting and visualizing any
type of realtime timeseries data, from CPU usage, disk activity, SQL
queries, API calls, web site visitors, etc.

netdata tries to visualize the truth of now, in its greatest detail,
so that you can get insights of what is happening now and what just
happened, on your systems and applications.

%prep
%setup -q -n %{name}-1.3.0

%build
%configure \
	--with-zlib \
	--with-math \
	%{?with_nfacct:--enable-plugin-nfacct} \
	--with-user=netdata
%{__make} %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
%{__make} %{?_smp_mflags} DESTDIR=$RPM_BUILD_ROOT install

find $RPM_BUILD_ROOT -name .keep -print0 | xargs --null --no-run-if-empty rm

install -m 644 -p system/netdata.conf $RPM_BUILD_ROOT%{_sysconfdir}/%{name}

mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d
install -m 644 -p system/netdata.logrotate $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/%{name}

%if %{with systemd}
install -d $RPM_BUILD_ROOT%{_unitdir}
install -m 644 -p system/netdata.service $RPM_BUILD_ROOT%{_unitdir}/netdata.service
%else
# install SYSV init stuff
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
install -m755 system/netdata-init-d \
        $RPM_BUILD_ROOT/etc/rc.d/init.d/netdata
%endif

%if %{with systemd}
%pre
# Add the "netdata" user
/usr/sbin/groupadd -r netdata 2> /dev/null || :
/usr/sbin/useradd -c "netdata" -g netdata \
        -s /sbin/nologin -r -d %{contentdir} netdata 2> /dev/null || :

%post
%systemd_post netdata.service

%preun
%systemd_preun netdata.service

%postun
%systemd_postun_with_restart netdata.service
%else
%pre
# Add the "netdata" user
getent group netdata >/dev/null || groupadd -r netdata
getent passwd netdata >/dev/null || \
  useradd -r -g netdata -s /sbin/nologin \
    -d %{contentdir} -c "netdata" netdata
exit 0

%post
# Register the netdata service
/sbin/chkconfig --add netdata
# Only gets run on initial install (not upgrades or uninstalls)
if [ $1 = 1 ]; then
        # Start the netdata service
        /sbin/service netdata start
fi
exit 0

%preun
# Only gets run on uninstall (not upgrades)
if [ $1 = 0 ]; then
        /sbin/service netdata stop > /dev/null 2>&1
        /sbin/chkconfig --del netdata
fi
exit 0

%postun
# Only gets run on upgrade (not uninstalls)
if [ $1 != 0 ]; then
        /sbin/service netdata condrestart 2>&1 > /dev/null
fi
exit 0
%endif

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)

%dir %{_sysconfdir}/%{name}
%config(noreplace) %{_sysconfdir}/%{name}/*.conf
%config(noreplace) %{_sysconfdir}/%{name}/health.d/*.conf
%config(noreplace) %{_sysconfdir}/%{name}/python.d/*.conf
%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}

%{_libexecdir}/%{name}
%{_sbindir}/%{name}

%attr(0700,netdata,netdata) %dir %{_localstatedir}/cache/%{name}
%attr(0700,netdata,netdata) %dir %{_localstatedir}/log/%{name}
%attr(0700,netdata,netdata) %dir %{_localstatedir}/lib/%{name}

%dir %{_datadir}/%{name}

%if %{with systemd}
%{_unitdir}/netdata.service
%else
%{_sysconfdir}/rc.d/init.d/netdata
%endif

# Enforce 0644 for files and 0755 for directories
# for the netdata web directory
%defattr(0644,root,netdata,0755)
%{_datadir}/%{name}/web

%changelog
* Sun Aug 28 2016 Costa Tsaousis <costa@tsaousis.gr> - 1.3.0-1
- netdata now has health monitoring
- netdata now generates badges
- netdata now has python plugins
- Several more improvements, new features and bugfixes.
* Tue Jul 26 2016 Jason Barnett <J@sonBarnett.com> - 1.2.0-2
- Added support for EL6
- Corrected several Requires statements
- Changed default to build without nfacct
- Removed --docdir from configure
* Mon May 16 2016 Costa Tsaousis <costa@tsaousis.gr> - 1.2.0-1
- netdata is now 30% faster.
- netdata now has a registry (my-netdata menu on the dashboard).
- netdata now monitors Linux containers.
- Several more improvements, new features and bugfixes.
* Wed Apr 20 2016 Costa Tsaousis <costa@tsaousis.gr> - 1.1.0-1
- Several new features (IPv6, SYNPROXY, Users, Users Groups).
- A lot of bug fixes and optimizations.
* Tue Mar 22 2016 Costa Tsaousis <costa@tsaousis.gr> - 1.0.0-1
- First public release.
* Sun Nov 15 2015 Alon Bar-Lev <alonbl@redhat.com> - 0.0.0-1
- Initial add.
