# Open Lighting Architecture - OLA

[www.openlighting.org/ola](https://www.openlighting.org/ola)

[![Build Status](https://travis-ci.org/OpenLightingProject/ola.svg?branch=master)](https://travis-ci.org/OpenLightingProject/ola) [![Coverity Scan Status](https://scan.coverity.com/projects/3514/badge.svg)](https://scan.coverity.com/projects/3514) [![Coverage Status](https://coveralls.io/repos/OpenLightingProject/ola/badge.png?branch=master)](https://coveralls.io/r/OpenLightingProject/ola?branch=master)

The Open Lighting Architecture (OLA) is a framework for controlling
entertainment lighting equipment. Within the entertainment lighting industry,
the [Digital Multiplex protocol](https://en.wikipedia.org/wiki/DMX512)
(DMX-512) and IP variants such as [Streaming ACN]
(https://en.wikipedia.org/wiki/Architecture_for_Control_Networks#External_Extensions)
(sACN) are used to control lighting fixtures.

OLA provides the distribution layer that abstracts away the various protocols
used. This allows authors of lighting control software to focus on generating
the control information, rather than having to implement support for different
hardware devices & network protocols. OLA runs on Linux & Mac OS X, some
features will also work on Windows.

OLA can also be used to convert between different network protocols. With the
use of a USB to DMX512 device, OLA can act as a DMX-over-IP to DMX512 gateway.

OLA consists of three parts, the daemon olad, the olad plugins and the client
library, libola.

Documentation on OLA, including examples on how to get started, are
provided on the [Open Lighting Architecture Docs]
(https://docs.openlighting.org/ola/doc/latest/) site. The pages are
automatically updated from the git repository.

## Downloading OLA

OLA is distributed in a number of formats, including
[Debian](https://www.debian.org/) / [Ubuntu](http://www.ubuntu.com/) Packages
and [MacPorts](https://www.macports.org/). The [OLA Downloads]
(https://www.openlighting.org/ola/getting-started/downloads/) page has more
information.

Tagged releases in the git repository are signed. To import the public key, run:

    $ git cat-file blob simon-pubkey | gpg --import

and then to verify the release:

    $ git tag -v 0.9.6

## Support

Support for OLA is provided via the mailing list and IRC channel. The
[Getting Help](https://www.openlighting.org/ola/get-help/) page has more
details.

## Components
### Plugins

The OLA plugins are located in ./plugins. For a walkthrough of an example see
plugins/osc/README.

### C++ Library

The C++ Client is in ./ola. The [C++ DMX Client API Tutorial]
(https://docs.openlighting.org/ola/doc/latest/dmx_cpp_client_tutorial.html)
has various examples on how one can use the client.

### Python Module

The Python module can be built by running configure with
--enable-python-libs. There are examples on how to use the Python API in
python/examples.

### Java Library

There is an experimental Java library which can be built by running configure
with --enable-java-libs.

## Credits

The AUTHORS files contains a list of code contributors. A [full list of
supporters](https://www.openlighting.org/openlightingproject/about/supporters/)
is published on the website.
