
/*
 * The olsr.org Optimized Link-State Routing daemon version 2 (olsrd2)
 * Copyright (c) 2004-2015, the olsr.org team - see HISTORY file
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * * Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in
 *   the documentation and/or other materials provided with the
 *   distribution.
 * * Neither the name of olsr.org, olsrd nor the names of its
 *   contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Visit http://www.olsr.org for more information.
 *
 * If you find this software useful feel free to make a donation
 * to the project. For more information see the website or contact
 * the copyright holders.
 *
 */

#include "common/common_types.h"
#include "rfc5444/rfc5444.h"
#include "cunit/cunit.h"

static const uint64_t _timetlv_table[256] = {
  0x00000000u,0x00000001u,0x00000001u,0x00000001u,0x00000001u,0x00000001u,0x00000001u,0x00000001u,
  0x00000001u,0x00000002u,0x00000002u,0x00000002u,0x00000002u,0x00000003u,0x00000003u,0x00000003u,
  0x00000003u,0x00000004u,0x00000004u,0x00000005u,0x00000005u,0x00000006u,0x00000006u,0x00000007u,
  0x00000007u,0x00000008u,0x00000009u,0x0000000au,0x0000000bu,0x0000000cu,0x0000000du,0x0000000eu,
  0x0000000fu,0x00000011u,0x00000013u,0x00000015u,0x00000017u,0x00000019u,0x0000001bu,0x0000001du,
  0x0000001fu,0x00000023u,0x00000027u,0x0000002au,0x0000002eu,0x00000032u,0x00000036u,0x0000003au,
  0x0000003eu,0x00000046u,0x0000004eu,0x00000055u,0x0000005du,0x00000065u,0x0000006du,0x00000075u,
  0x0000007du,0x0000008cu,0x0000009cu,0x000000abu,0x000000bbu,0x000000cbu,0x000000dau,0x000000eau,
  0x000000fau,0x00000119u,0x00000138u,0x00000157u,0x00000177u,0x00000196u,0x000001b5u,0x000001d4u,
  0x000001f4u,0x00000232u,0x00000271u,0x000002afu,0x000002eeu,0x0000032cu,0x0000036bu,0x000003a9u,
  0x000003e8u,0x00000465u,0x000004e2u,0x0000055fu,0x000005dcu,0x00000659u,0x000006d6u,0x00000753u,
  0x000007d0u,0x000008cau,0x000009c4u,0x00000abeu,0x00000bb8u,0x00000cb2u,0x00000dacu,0x00000ea6u,
  0x00000fa0u,0x00001194u,0x00001388u,0x0000157cu,0x00001770u,0x00001964u,0x00001b58u,0x00001d4cu,
  0x00001f40u,0x00002328u,0x00002710u,0x00002af8u,0x00002ee0u,0x000032c8u,0x000036b0u,0x00003a98u,
  0x00003e80u,0x00004650u,0x00004e20u,0x000055f0u,0x00005dc0u,0x00006590u,0x00006d60u,0x00007530u,
  0x00007d00u,0x00008ca0u,0x00009c40u,0x0000abe0u,0x0000bb80u,0x0000cb20u,0x0000dac0u,0x0000ea60u,
  0x0000fa00u,0x00011940u,0x00013880u,0x000157c0u,0x00017700u,0x00019640u,0x0001b580u,0x0001d4c0u,
  0x0001f400u,0x00023280u,0x00027100u,0x0002af80u,0x0002ee00u,0x00032c80u,0x00036b00u,0x0003a980u,
  0x0003e800u,0x00046500u,0x0004e200u,0x00055f00u,0x0005dc00u,0x00065900u,0x0006d600u,0x00075300u,
  0x0007d000u,0x0008ca00u,0x0009c400u,0x000abe00u,0x000bb800u,0x000cb200u,0x000dac00u,0x000ea600u,
  0x000fa000u,0x00119400u,0x00138800u,0x00157c00u,0x00177000u,0x00196400u,0x001b5800u,0x001d4c00u,
  0x001f4000u,0x00232800u,0x00271000u,0x002af800u,0x002ee000u,0x0032c800u,0x0036b000u,0x003a9800u,
  0x003e8000u,0x00465000u,0x004e2000u,0x0055f000u,0x005dc000u,0x00659000u,0x006d6000u,0x00753000u,
  0x007d0000u,0x008ca000u,0x009c4000u,0x00abe000u,0x00bb8000u,0x00cb2000u,0x00dac000u,0x00ea6000u,
  0x00fa0000u,0x01194000u,0x01388000u,0x0157c000u,0x01770000u,0x01964000u,0x01b58000u,0x01d4c000u,
  0x01f40000u,0x02328000u,0x02710000u,0x02af8000u,0x02ee0000u,0x032c8000u,0x036b0000u,0x03a98000u,
  0x03e80000u,0x04650000u,0x04e20000u,0x055f0000u,0x05dc0000u,0x06590000u,0x06d60000u,0x07530000u,
  0x07d00000u,0x08ca0000u,0x09c40000u,0x0abe0000u,0x0bb80000u,0x0cb20000u,0x0dac0000u,0x0ea60000u,
  0x0fa00000u,0x11940000u,0x13880000u,0x157c0000u,0x17700000u,0x19640000u,0x1b580000u,0x1d4c0000u,
  0x1f400000u,0x23280000u,0x27100000u,0x2af80000u,0x2ee00000u,0x32c80000u,0x36b00000u,0x3a980000u,
  0x3e800000u,0x46500000u,0x4e200000u,0x55f00000u,0x5dc00000u,0x65900000u,0x6d600000u,0x75300000u,
  0x7d000000u,0x8ca00000u,0x9c400000u,0xabe00000u,0xbb800000u,0xcb200000u,0xdac00000u,UINT64_MAX,
};

static const uint32_t _metric_table[4096] = {
  0x000001, 0x000002, 0x000003, 0x000004, 0x000005, 0x000006, 0x000007, 0x000008,
  0x000009, 0x00000a, 0x00000b, 0x00000c, 0x00000d, 0x00000e, 0x00000f, 0x000010,
  0x000011, 0x000012, 0x000013, 0x000014, 0x000015, 0x000016, 0x000017, 0x000018,
  0x000019, 0x00001a, 0x00001b, 0x00001c, 0x00001d, 0x00001e, 0x00001f, 0x000020,
  0x000021, 0x000022, 0x000023, 0x000024, 0x000025, 0x000026, 0x000027, 0x000028,
  0x000029, 0x00002a, 0x00002b, 0x00002c, 0x00002d, 0x00002e, 0x00002f, 0x000030,
  0x000031, 0x000032, 0x000033, 0x000034, 0x000035, 0x000036, 0x000037, 0x000038,
  0x000039, 0x00003a, 0x00003b, 0x00003c, 0x00003d, 0x00003e, 0x00003f, 0x000040,
  0x000041, 0x000042, 0x000043, 0x000044, 0x000045, 0x000046, 0x000047, 0x000048,
  0x000049, 0x00004a, 0x00004b, 0x00004c, 0x00004d, 0x00004e, 0x00004f, 0x000050,
  0x000051, 0x000052, 0x000053, 0x000054, 0x000055, 0x000056, 0x000057, 0x000058,
  0x000059, 0x00005a, 0x00005b, 0x00005c, 0x00005d, 0x00005e, 0x00005f, 0x000060,
  0x000061, 0x000062, 0x000063, 0x000064, 0x000065, 0x000066, 0x000067, 0x000068,
  0x000069, 0x00006a, 0x00006b, 0x00006c, 0x00006d, 0x00006e, 0x00006f, 0x000070,
  0x000071, 0x000072, 0x000073, 0x000074, 0x000075, 0x000076, 0x000077, 0x000078,
  0x000079, 0x00007a, 0x00007b, 0x00007c, 0x00007d, 0x00007e, 0x00007f, 0x000080,
  0x000081, 0x000082, 0x000083, 0x000084, 0x000085, 0x000086, 0x000087, 0x000088,
  0x000089, 0x00008a, 0x00008b, 0x00008c, 0x00008d, 0x00008e, 0x00008f, 0x000090,
  0x000091, 0x000092, 0x000093, 0x000094, 0x000095, 0x000096, 0x000097, 0x000098,
  0x000099, 0x00009a, 0x00009b, 0x00009c, 0x00009d, 0x00009e, 0x00009f, 0x0000a0,
  0x0000a1, 0x0000a2, 0x0000a3, 0x0000a4, 0x0000a5, 0x0000a6, 0x0000a7, 0x0000a8,
  0x0000a9, 0x0000aa, 0x0000ab, 0x0000ac, 0x0000ad, 0x0000ae, 0x0000af, 0x0000b0,
  0x0000b1, 0x0000b2, 0x0000b3, 0x0000b4, 0x0000b5, 0x0000b6, 0x0000b7, 0x0000b8,
  0x0000b9, 0x0000ba, 0x0000bb, 0x0000bc, 0x0000bd, 0x0000be, 0x0000bf, 0x0000c0,
  0x0000c1, 0x0000c2, 0x0000c3, 0x0000c4, 0x0000c5, 0x0000c6, 0x0000c7, 0x0000c8,
  0x0000c9, 0x0000ca, 0x0000cb, 0x0000cc, 0x0000cd, 0x0000ce, 0x0000cf, 0x0000d0,
  0x0000d1, 0x0000d2, 0x0000d3, 0x0000d4, 0x0000d5, 0x0000d6, 0x0000d7, 0x0000d8,
  0x0000d9, 0x0000da, 0x0000db, 0x0000dc, 0x0000dd, 0x0000de, 0x0000df, 0x0000e0,
  0x0000e1, 0x0000e2, 0x0000e3, 0x0000e4, 0x0000e5, 0x0000e6, 0x0000e7, 0x0000e8,
  0x0000e9, 0x0000ea, 0x0000eb, 0x0000ec, 0x0000ed, 0x0000ee, 0x0000ef, 0x0000f0,
  0x0000f1, 0x0000f2, 0x0000f3, 0x0000f4, 0x0000f5, 0x0000f6, 0x0000f7, 0x0000f8,
  0x0000f9, 0x0000fa, 0x0000fb, 0x0000fc, 0x0000fd, 0x0000fe, 0x0000ff, 0x000100,
  0x000102, 0x000104, 0x000106, 0x000108, 0x00010a, 0x00010c, 0x00010e, 0x000110,
  0x000112, 0x000114, 0x000116, 0x000118, 0x00011a, 0x00011c, 0x00011e, 0x000120,
  0x000122, 0x000124, 0x000126, 0x000128, 0x00012a, 0x00012c, 0x00012e, 0x000130,
  0x000132, 0x000134, 0x000136, 0x000138, 0x00013a, 0x00013c, 0x00013e, 0x000140,
  0x000142, 0x000144, 0x000146, 0x000148, 0x00014a, 0x00014c, 0x00014e, 0x000150,
  0x000152, 0x000154, 0x000156, 0x000158, 0x00015a, 0x00015c, 0x00015e, 0x000160,
  0x000162, 0x000164, 0x000166, 0x000168, 0x00016a, 0x00016c, 0x00016e, 0x000170,
  0x000172, 0x000174, 0x000176, 0x000178, 0x00017a, 0x00017c, 0x00017e, 0x000180,
  0x000182, 0x000184, 0x000186, 0x000188, 0x00018a, 0x00018c, 0x00018e, 0x000190,
  0x000192, 0x000194, 0x000196, 0x000198, 0x00019a, 0x00019c, 0x00019e, 0x0001a0,
  0x0001a2, 0x0001a4, 0x0001a6, 0x0001a8, 0x0001aa, 0x0001ac, 0x0001ae, 0x0001b0,
  0x0001b2, 0x0001b4, 0x0001b6, 0x0001b8, 0x0001ba, 0x0001bc, 0x0001be, 0x0001c0,
  0x0001c2, 0x0001c4, 0x0001c6, 0x0001c8, 0x0001ca, 0x0001cc, 0x0001ce, 0x0001d0,
  0x0001d2, 0x0001d4, 0x0001d6, 0x0001d8, 0x0001da, 0x0001dc, 0x0001de, 0x0001e0,
  0x0001e2, 0x0001e4, 0x0001e6, 0x0001e8, 0x0001ea, 0x0001ec, 0x0001ee, 0x0001f0,
  0x0001f2, 0x0001f4, 0x0001f6, 0x0001f8, 0x0001fa, 0x0001fc, 0x0001fe, 0x000200,
  0x000202, 0x000204, 0x000206, 0x000208, 0x00020a, 0x00020c, 0x00020e, 0x000210,
  0x000212, 0x000214, 0x000216, 0x000218, 0x00021a, 0x00021c, 0x00021e, 0x000220,
  0x000222, 0x000224, 0x000226, 0x000228, 0x00022a, 0x00022c, 0x00022e, 0x000230,
  0x000232, 0x000234, 0x000236, 0x000238, 0x00023a, 0x00023c, 0x00023e, 0x000240,
  0x000242, 0x000244, 0x000246, 0x000248, 0x00024a, 0x00024c, 0x00024e, 0x000250,
  0x000252, 0x000254, 0x000256, 0x000258, 0x00025a, 0x00025c, 0x00025e, 0x000260,
  0x000262, 0x000264, 0x000266, 0x000268, 0x00026a, 0x00026c, 0x00026e, 0x000270,
  0x000272, 0x000274, 0x000276, 0x000278, 0x00027a, 0x00027c, 0x00027e, 0x000280,
  0x000282, 0x000284, 0x000286, 0x000288, 0x00028a, 0x00028c, 0x00028e, 0x000290,
  0x000292, 0x000294, 0x000296, 0x000298, 0x00029a, 0x00029c, 0x00029e, 0x0002a0,
  0x0002a2, 0x0002a4, 0x0002a6, 0x0002a8, 0x0002aa, 0x0002ac, 0x0002ae, 0x0002b0,
  0x0002b2, 0x0002b4, 0x0002b6, 0x0002b8, 0x0002ba, 0x0002bc, 0x0002be, 0x0002c0,
  0x0002c2, 0x0002c4, 0x0002c6, 0x0002c8, 0x0002ca, 0x0002cc, 0x0002ce, 0x0002d0,
  0x0002d2, 0x0002d4, 0x0002d6, 0x0002d8, 0x0002da, 0x0002dc, 0x0002de, 0x0002e0,
  0x0002e2, 0x0002e4, 0x0002e6, 0x0002e8, 0x0002ea, 0x0002ec, 0x0002ee, 0x0002f0,
  0x0002f2, 0x0002f4, 0x0002f6, 0x0002f8, 0x0002fa, 0x0002fc, 0x0002fe, 0x000300,
  0x000304, 0x000308, 0x00030c, 0x000310, 0x000314, 0x000318, 0x00031c, 0x000320,
  0x000324, 0x000328, 0x00032c, 0x000330, 0x000334, 0x000338, 0x00033c, 0x000340,
  0x000344, 0x000348, 0x00034c, 0x000350, 0x000354, 0x000358, 0x00035c, 0x000360,
  0x000364, 0x000368, 0x00036c, 0x000370, 0x000374, 0x000378, 0x00037c, 0x000380,
  0x000384, 0x000388, 0x00038c, 0x000390, 0x000394, 0x000398, 0x00039c, 0x0003a0,
  0x0003a4, 0x0003a8, 0x0003ac, 0x0003b0, 0x0003b4, 0x0003b8, 0x0003bc, 0x0003c0,
  0x0003c4, 0x0003c8, 0x0003cc, 0x0003d0, 0x0003d4, 0x0003d8, 0x0003dc, 0x0003e0,
  0x0003e4, 0x0003e8, 0x0003ec, 0x0003f0, 0x0003f4, 0x0003f8, 0x0003fc, 0x000400,
  0x000404, 0x000408, 0x00040c, 0x000410, 0x000414, 0x000418, 0x00041c, 0x000420,
  0x000424, 0x000428, 0x00042c, 0x000430, 0x000434, 0x000438, 0x00043c, 0x000440,
  0x000444, 0x000448, 0x00044c, 0x000450, 0x000454, 0x000458, 0x00045c, 0x000460,
  0x000464, 0x000468, 0x00046c, 0x000470, 0x000474, 0x000478, 0x00047c, 0x000480,
  0x000484, 0x000488, 0x00048c, 0x000490, 0x000494, 0x000498, 0x00049c, 0x0004a0,
  0x0004a4, 0x0004a8, 0x0004ac, 0x0004b0, 0x0004b4, 0x0004b8, 0x0004bc, 0x0004c0,
  0x0004c4, 0x0004c8, 0x0004cc, 0x0004d0, 0x0004d4, 0x0004d8, 0x0004dc, 0x0004e0,
  0x0004e4, 0x0004e8, 0x0004ec, 0x0004f0, 0x0004f4, 0x0004f8, 0x0004fc, 0x000500,
  0x000504, 0x000508, 0x00050c, 0x000510, 0x000514, 0x000518, 0x00051c, 0x000520,
  0x000524, 0x000528, 0x00052c, 0x000530, 0x000534, 0x000538, 0x00053c, 0x000540,
  0x000544, 0x000548, 0x00054c, 0x000550, 0x000554, 0x000558, 0x00055c, 0x000560,
  0x000564, 0x000568, 0x00056c, 0x000570, 0x000574, 0x000578, 0x00057c, 0x000580,
  0x000584, 0x000588, 0x00058c, 0x000590, 0x000594, 0x000598, 0x00059c, 0x0005a0,
  0x0005a4, 0x0005a8, 0x0005ac, 0x0005b0, 0x0005b4, 0x0005b8, 0x0005bc, 0x0005c0,
  0x0005c4, 0x0005c8, 0x0005cc, 0x0005d0, 0x0005d4, 0x0005d8, 0x0005dc, 0x0005e0,
  0x0005e4, 0x0005e8, 0x0005ec, 0x0005f0, 0x0005f4, 0x0005f8, 0x0005fc, 0x000600,
  0x000604, 0x000608, 0x00060c, 0x000610, 0x000614, 0x000618, 0x00061c, 0x000620,
  0x000624, 0x000628, 0x00062c, 0x000630, 0x000634, 0x000638, 0x00063c, 0x000640,
  0x000644, 0x000648, 0x00064c, 0x000650, 0x000654, 0x000658, 0x00065c, 0x000660,
  0x000664, 0x000668, 0x00066c, 0x000670, 0x000674, 0x000678, 0x00067c, 0x000680,
  0x000684, 0x000688, 0x00068c, 0x000690, 0x000694, 0x000698, 0x00069c, 0x0006a0,
  0x0006a4, 0x0006a8, 0x0006ac, 0x0006b0, 0x0006b4, 0x0006b8, 0x0006bc, 0x0006c0,
  0x0006c4, 0x0006c8, 0x0006cc, 0x0006d0, 0x0006d4, 0x0006d8, 0x0006dc, 0x0006e0,
  0x0006e4, 0x0006e8, 0x0006ec, 0x0006f0, 0x0006f4, 0x0006f8, 0x0006fc, 0x000700,
  0x000708, 0x000710, 0x000718, 0x000720, 0x000728, 0x000730, 0x000738, 0x000740,
  0x000748, 0x000750, 0x000758, 0x000760, 0x000768, 0x000770, 0x000778, 0x000780,
  0x000788, 0x000790, 0x000798, 0x0007a0, 0x0007a8, 0x0007b0, 0x0007b8, 0x0007c0,
  0x0007c8, 0x0007d0, 0x0007d8, 0x0007e0, 0x0007e8, 0x0007f0, 0x0007f8, 0x000800,
  0x000808, 0x000810, 0x000818, 0x000820, 0x000828, 0x000830, 0x000838, 0x000840,
  0x000848, 0x000850, 0x000858, 0x000860, 0x000868, 0x000870, 0x000878, 0x000880,
  0x000888, 0x000890, 0x000898, 0x0008a0, 0x0008a8, 0x0008b0, 0x0008b8, 0x0008c0,
  0x0008c8, 0x0008d0, 0x0008d8, 0x0008e0, 0x0008e8, 0x0008f0, 0x0008f8, 0x000900,
  0x000908, 0x000910, 0x000918, 0x000920, 0x000928, 0x000930, 0x000938, 0x000940,
  0x000948, 0x000950, 0x000958, 0x000960, 0x000968, 0x000970, 0x000978, 0x000980,
  0x000988, 0x000990, 0x000998, 0x0009a0, 0x0009a8, 0x0009b0, 0x0009b8, 0x0009c0,
  0x0009c8, 0x0009d0, 0x0009d8, 0x0009e0, 0x0009e8, 0x0009f0, 0x0009f8, 0x000a00,
  0x000a08, 0x000a10, 0x000a18, 0x000a20, 0x000a28, 0x000a30, 0x000a38, 0x000a40,
  0x000a48, 0x000a50, 0x000a58, 0x000a60, 0x000a68, 0x000a70, 0x000a78, 0x000a80,
  0x000a88, 0x000a90, 0x000a98, 0x000aa0, 0x000aa8, 0x000ab0, 0x000ab8, 0x000ac0,
  0x000ac8, 0x000ad0, 0x000ad8, 0x000ae0, 0x000ae8, 0x000af0, 0x000af8, 0x000b00,
  0x000b08, 0x000b10, 0x000b18, 0x000b20, 0x000b28, 0x000b30, 0x000b38, 0x000b40,
  0x000b48, 0x000b50, 0x000b58, 0x000b60, 0x000b68, 0x000b70, 0x000b78, 0x000b80,
  0x000b88, 0x000b90, 0x000b98, 0x000ba0, 0x000ba8, 0x000bb0, 0x000bb8, 0x000bc0,
  0x000bc8, 0x000bd0, 0x000bd8, 0x000be0, 0x000be8, 0x000bf0, 0x000bf8, 0x000c00,
  0x000c08, 0x000c10, 0x000c18, 0x000c20, 0x000c28, 0x000c30, 0x000c38, 0x000c40,
  0x000c48, 0x000c50, 0x000c58, 0x000c60, 0x000c68, 0x000c70, 0x000c78, 0x000c80,
  0x000c88, 0x000c90, 0x000c98, 0x000ca0, 0x000ca8, 0x000cb0, 0x000cb8, 0x000cc0,
  0x000cc8, 0x000cd0, 0x000cd8, 0x000ce0, 0x000ce8, 0x000cf0, 0x000cf8, 0x000d00,
  0x000d08, 0x000d10, 0x000d18, 0x000d20, 0x000d28, 0x000d30, 0x000d38, 0x000d40,
  0x000d48, 0x000d50, 0x000d58, 0x000d60, 0x000d68, 0x000d70, 0x000d78, 0x000d80,
  0x000d88, 0x000d90, 0x000d98, 0x000da0, 0x000da8, 0x000db0, 0x000db8, 0x000dc0,
  0x000dc8, 0x000dd0, 0x000dd8, 0x000de0, 0x000de8, 0x000df0, 0x000df8, 0x000e00,
  0x000e08, 0x000e10, 0x000e18, 0x000e20, 0x000e28, 0x000e30, 0x000e38, 0x000e40,
  0x000e48, 0x000e50, 0x000e58, 0x000e60, 0x000e68, 0x000e70, 0x000e78, 0x000e80,
  0x000e88, 0x000e90, 0x000e98, 0x000ea0, 0x000ea8, 0x000eb0, 0x000eb8, 0x000ec0,
  0x000ec8, 0x000ed0, 0x000ed8, 0x000ee0, 0x000ee8, 0x000ef0, 0x000ef8, 0x000f00,
  0x000f10, 0x000f20, 0x000f30, 0x000f40, 0x000f50, 0x000f60, 0x000f70, 0x000f80,
  0x000f90, 0x000fa0, 0x000fb0, 0x000fc0, 0x000fd0, 0x000fe0, 0x000ff0, 0x001000,
  0x001010, 0x001020, 0x001030, 0x001040, 0x001050, 0x001060, 0x001070, 0x001080,
  0x001090, 0x0010a0, 0x0010b0, 0x0010c0, 0x0010d0, 0x0010e0, 0x0010f0, 0x001100,
  0x001110, 0x001120, 0x001130, 0x001140, 0x001150, 0x001160, 0x001170, 0x001180,
  0x001190, 0x0011a0, 0x0011b0, 0x0011c0, 0x0011d0, 0x0011e0, 0x0011f0, 0x001200,
  0x001210, 0x001220, 0x001230, 0x001240, 0x001250, 0x001260, 0x001270, 0x001280,
  0x001290, 0x0012a0, 0x0012b0, 0x0012c0, 0x0012d0, 0x0012e0, 0x0012f0, 0x001300,
  0x001310, 0x001320, 0x001330, 0x001340, 0x001350, 0x001360, 0x001370, 0x001380,
  0x001390, 0x0013a0, 0x0013b0, 0x0013c0, 0x0013d0, 0x0013e0, 0x0013f0, 0x001400,
  0x001410, 0x001420, 0x001430, 0x001440, 0x001450, 0x001460, 0x001470, 0x001480,
  0x001490, 0x0014a0, 0x0014b0, 0x0014c0, 0x0014d0, 0x0014e0, 0x0014f0, 0x001500,
  0x001510, 0x001520, 0x001530, 0x001540, 0x001550, 0x001560, 0x001570, 0x001580,
  0x001590, 0x0015a0, 0x0015b0, 0x0015c0, 0x0015d0, 0x0015e0, 0x0015f0, 0x001600,
  0x001610, 0x001620, 0x001630, 0x001640, 0x001650, 0x001660, 0x001670, 0x001680,
  0x001690, 0x0016a0, 0x0016b0, 0x0016c0, 0x0016d0, 0x0016e0, 0x0016f0, 0x001700,
  0x001710, 0x001720, 0x001730, 0x001740, 0x001750, 0x001760, 0x001770, 0x001780,
  0x001790, 0x0017a0, 0x0017b0, 0x0017c0, 0x0017d0, 0x0017e0, 0x0017f0, 0x001800,
  0x001810, 0x001820, 0x001830, 0x001840, 0x001850, 0x001860, 0x001870, 0x001880,
  0x001890, 0x0018a0, 0x0018b0, 0x0018c0, 0x0018d0, 0x0018e0, 0x0018f0, 0x001900,
  0x001910, 0x001920, 0x001930, 0x001940, 0x001950, 0x001960, 0x001970, 0x001980,
  0x001990, 0x0019a0, 0x0019b0, 0x0019c0, 0x0019d0, 0x0019e0, 0x0019f0, 0x001a00,
  0x001a10, 0x001a20, 0x001a30, 0x001a40, 0x001a50, 0x001a60, 0x001a70, 0x001a80,
  0x001a90, 0x001aa0, 0x001ab0, 0x001ac0, 0x001ad0, 0x001ae0, 0x001af0, 0x001b00,
  0x001b10, 0x001b20, 0x001b30, 0x001b40, 0x001b50, 0x001b60, 0x001b70, 0x001b80,
  0x001b90, 0x001ba0, 0x001bb0, 0x001bc0, 0x001bd0, 0x001be0, 0x001bf0, 0x001c00,
  0x001c10, 0x001c20, 0x001c30, 0x001c40, 0x001c50, 0x001c60, 0x001c70, 0x001c80,
  0x001c90, 0x001ca0, 0x001cb0, 0x001cc0, 0x001cd0, 0x001ce0, 0x001cf0, 0x001d00,
  0x001d10, 0x001d20, 0x001d30, 0x001d40, 0x001d50, 0x001d60, 0x001d70, 0x001d80,
  0x001d90, 0x001da0, 0x001db0, 0x001dc0, 0x001dd0, 0x001de0, 0x001df0, 0x001e00,
  0x001e10, 0x001e20, 0x001e30, 0x001e40, 0x001e50, 0x001e60, 0x001e70, 0x001e80,
  0x001e90, 0x001ea0, 0x001eb0, 0x001ec0, 0x001ed0, 0x001ee0, 0x001ef0, 0x001f00,
  0x001f20, 0x001f40, 0x001f60, 0x001f80, 0x001fa0, 0x001fc0, 0x001fe0, 0x002000,
  0x002020, 0x002040, 0x002060, 0x002080, 0x0020a0, 0x0020c0, 0x0020e0, 0x002100,
  0x002120, 0x002140, 0x002160, 0x002180, 0x0021a0, 0x0021c0, 0x0021e0, 0x002200,
  0x002220, 0x002240, 0x002260, 0x002280, 0x0022a0, 0x0022c0, 0x0022e0, 0x002300,
  0x002320, 0x002340, 0x002360, 0x002380, 0x0023a0, 0x0023c0, 0x0023e0, 0x002400,
  0x002420, 0x002440, 0x002460, 0x002480, 0x0024a0, 0x0024c0, 0x0024e0, 0x002500,
  0x002520, 0x002540, 0x002560, 0x002580, 0x0025a0, 0x0025c0, 0x0025e0, 0x002600,
  0x002620, 0x002640, 0x002660, 0x002680, 0x0026a0, 0x0026c0, 0x0026e0, 0x002700,
  0x002720, 0x002740, 0x002760, 0x002780, 0x0027a0, 0x0027c0, 0x0027e0, 0x002800,
  0x002820, 0x002840, 0x002860, 0x002880, 0x0028a0, 0x0028c0, 0x0028e0, 0x002900,
  0x002920, 0x002940, 0x002960, 0x002980, 0x0029a0, 0x0029c0, 0x0029e0, 0x002a00,
  0x002a20, 0x002a40, 0x002a60, 0x002a80, 0x002aa0, 0x002ac0, 0x002ae0, 0x002b00,
  0x002b20, 0x002b40, 0x002b60, 0x002b80, 0x002ba0, 0x002bc0, 0x002be0, 0x002c00,
  0x002c20, 0x002c40, 0x002c60, 0x002c80, 0x002ca0, 0x002cc0, 0x002ce0, 0x002d00,
  0x002d20, 0x002d40, 0x002d60, 0x002d80, 0x002da0, 0x002dc0, 0x002de0, 0x002e00,
  0x002e20, 0x002e40, 0x002e60, 0x002e80, 0x002ea0, 0x002ec0, 0x002ee0, 0x002f00,
  0x002f20, 0x002f40, 0x002f60, 0x002f80, 0x002fa0, 0x002fc0, 0x002fe0, 0x003000,
  0x003020, 0x003040, 0x003060, 0x003080, 0x0030a0, 0x0030c0, 0x0030e0, 0x003100,
  0x003120, 0x003140, 0x003160, 0x003180, 0x0031a0, 0x0031c0, 0x0031e0, 0x003200,
  0x003220, 0x003240, 0x003260, 0x003280, 0x0032a0, 0x0032c0, 0x0032e0, 0x003300,
  0x003320, 0x003340, 0x003360, 0x003380, 0x0033a0, 0x0033c0, 0x0033e0, 0x003400,
  0x003420, 0x003440, 0x003460, 0x003480, 0x0034a0, 0x0034c0, 0x0034e0, 0x003500,
  0x003520, 0x003540, 0x003560, 0x003580, 0x0035a0, 0x0035c0, 0x0035e0, 0x003600,
  0x003620, 0x003640, 0x003660, 0x003680, 0x0036a0, 0x0036c0, 0x0036e0, 0x003700,
  0x003720, 0x003740, 0x003760, 0x003780, 0x0037a0, 0x0037c0, 0x0037e0, 0x003800,
  0x003820, 0x003840, 0x003860, 0x003880, 0x0038a0, 0x0038c0, 0x0038e0, 0x003900,
  0x003920, 0x003940, 0x003960, 0x003980, 0x0039a0, 0x0039c0, 0x0039e0, 0x003a00,
  0x003a20, 0x003a40, 0x003a60, 0x003a80, 0x003aa0, 0x003ac0, 0x003ae0, 0x003b00,
  0x003b20, 0x003b40, 0x003b60, 0x003b80, 0x003ba0, 0x003bc0, 0x003be0, 0x003c00,
  0x003c20, 0x003c40, 0x003c60, 0x003c80, 0x003ca0, 0x003cc0, 0x003ce0, 0x003d00,
  0x003d20, 0x003d40, 0x003d60, 0x003d80, 0x003da0, 0x003dc0, 0x003de0, 0x003e00,
  0x003e20, 0x003e40, 0x003e60, 0x003e80, 0x003ea0, 0x003ec0, 0x003ee0, 0x003f00,
  0x003f40, 0x003f80, 0x003fc0, 0x004000, 0x004040, 0x004080, 0x0040c0, 0x004100,
  0x004140, 0x004180, 0x0041c0, 0x004200, 0x004240, 0x004280, 0x0042c0, 0x004300,
  0x004340, 0x004380, 0x0043c0, 0x004400, 0x004440, 0x004480, 0x0044c0, 0x004500,
  0x004540, 0x004580, 0x0045c0, 0x004600, 0x004640, 0x004680, 0x0046c0, 0x004700,
  0x004740, 0x004780, 0x0047c0, 0x004800, 0x004840, 0x004880, 0x0048c0, 0x004900,
  0x004940, 0x004980, 0x0049c0, 0x004a00, 0x004a40, 0x004a80, 0x004ac0, 0x004b00,
  0x004b40, 0x004b80, 0x004bc0, 0x004c00, 0x004c40, 0x004c80, 0x004cc0, 0x004d00,
  0x004d40, 0x004d80, 0x004dc0, 0x004e00, 0x004e40, 0x004e80, 0x004ec0, 0x004f00,
  0x004f40, 0x004f80, 0x004fc0, 0x005000, 0x005040, 0x005080, 0x0050c0, 0x005100,
  0x005140, 0x005180, 0x0051c0, 0x005200, 0x005240, 0x005280, 0x0052c0, 0x005300,
  0x005340, 0x005380, 0x0053c0, 0x005400, 0x005440, 0x005480, 0x0054c0, 0x005500,
  0x005540, 0x005580, 0x0055c0, 0x005600, 0x005640, 0x005680, 0x0056c0, 0x005700,
  0x005740, 0x005780, 0x0057c0, 0x005800, 0x005840, 0x005880, 0x0058c0, 0x005900,
  0x005940, 0x005980, 0x0059c0, 0x005a00, 0x005a40, 0x005a80, 0x005ac0, 0x005b00,
  0x005b40, 0x005b80, 0x005bc0, 0x005c00, 0x005c40, 0x005c80, 0x005cc0, 0x005d00,
  0x005d40, 0x005d80, 0x005dc0, 0x005e00, 0x005e40, 0x005e80, 0x005ec0, 0x005f00,
  0x005f40, 0x005f80, 0x005fc0, 0x006000, 0x006040, 0x006080, 0x0060c0, 0x006100,
  0x006140, 0x006180, 0x0061c0, 0x006200, 0x006240, 0x006280, 0x0062c0, 0x006300,
  0x006340, 0x006380, 0x0063c0, 0x006400, 0x006440, 0x006480, 0x0064c0, 0x006500,
  0x006540, 0x006580, 0x0065c0, 0x006600, 0x006640, 0x006680, 0x0066c0, 0x006700,
  0x006740, 0x006780, 0x0067c0, 0x006800, 0x006840, 0x006880, 0x0068c0, 0x006900,
  0x006940, 0x006980, 0x0069c0, 0x006a00, 0x006a40, 0x006a80, 0x006ac0, 0x006b00,
  0x006b40, 0x006b80, 0x006bc0, 0x006c00, 0x006c40, 0x006c80, 0x006cc0, 0x006d00,
  0x006d40, 0x006d80, 0x006dc0, 0x006e00, 0x006e40, 0x006e80, 0x006ec0, 0x006f00,
  0x006f40, 0x006f80, 0x006fc0, 0x007000, 0x007040, 0x007080, 0x0070c0, 0x007100,
  0x007140, 0x007180, 0x0071c0, 0x007200, 0x007240, 0x007280, 0x0072c0, 0x007300,
  0x007340, 0x007380, 0x0073c0, 0x007400, 0x007440, 0x007480, 0x0074c0, 0x007500,
  0x007540, 0x007580, 0x0075c0, 0x007600, 0x007640, 0x007680, 0x0076c0, 0x007700,
  0x007740, 0x007780, 0x0077c0, 0x007800, 0x007840, 0x007880, 0x0078c0, 0x007900,
  0x007940, 0x007980, 0x0079c0, 0x007a00, 0x007a40, 0x007a80, 0x007ac0, 0x007b00,
  0x007b40, 0x007b80, 0x007bc0, 0x007c00, 0x007c40, 0x007c80, 0x007cc0, 0x007d00,
  0x007d40, 0x007d80, 0x007dc0, 0x007e00, 0x007e40, 0x007e80, 0x007ec0, 0x007f00,
  0x007f80, 0x008000, 0x008080, 0x008100, 0x008180, 0x008200, 0x008280, 0x008300,
  0x008380, 0x008400, 0x008480, 0x008500, 0x008580, 0x008600, 0x008680, 0x008700,
  0x008780, 0x008800, 0x008880, 0x008900, 0x008980, 0x008a00, 0x008a80, 0x008b00,
  0x008b80, 0x008c00, 0x008c80, 0x008d00, 0x008d80, 0x008e00, 0x008e80, 0x008f00,
  0x008f80, 0x009000, 0x009080, 0x009100, 0x009180, 0x009200, 0x009280, 0x009300,
  0x009380, 0x009400, 0x009480, 0x009500, 0x009580, 0x009600, 0x009680, 0x009700,
  0x009780, 0x009800, 0x009880, 0x009900, 0x009980, 0x009a00, 0x009a80, 0x009b00,
  0x009b80, 0x009c00, 0x009c80, 0x009d00, 0x009d80, 0x009e00, 0x009e80, 0x009f00,
  0x009f80, 0x00a000, 0x00a080, 0x00a100, 0x00a180, 0x00a200, 0x00a280, 0x00a300,
  0x00a380, 0x00a400, 0x00a480, 0x00a500, 0x00a580, 0x00a600, 0x00a680, 0x00a700,
  0x00a780, 0x00a800, 0x00a880, 0x00a900, 0x00a980, 0x00aa00, 0x00aa80, 0x00ab00,
  0x00ab80, 0x00ac00, 0x00ac80, 0x00ad00, 0x00ad80, 0x00ae00, 0x00ae80, 0x00af00,
  0x00af80, 0x00b000, 0x00b080, 0x00b100, 0x00b180, 0x00b200, 0x00b280, 0x00b300,
  0x00b380, 0x00b400, 0x00b480, 0x00b500, 0x00b580, 0x00b600, 0x00b680, 0x00b700,
  0x00b780, 0x00b800, 0x00b880, 0x00b900, 0x00b980, 0x00ba00, 0x00ba80, 0x00bb00,
  0x00bb80, 0x00bc00, 0x00bc80, 0x00bd00, 0x00bd80, 0x00be00, 0x00be80, 0x00bf00,
  0x00bf80, 0x00c000, 0x00c080, 0x00c100, 0x00c180, 0x00c200, 0x00c280, 0x00c300,
  0x00c380, 0x00c400, 0x00c480, 0x00c500, 0x00c580, 0x00c600, 0x00c680, 0x00c700,
  0x00c780, 0x00c800, 0x00c880, 0x00c900, 0x00c980, 0x00ca00, 0x00ca80, 0x00cb00,
  0x00cb80, 0x00cc00, 0x00cc80, 0x00cd00, 0x00cd80, 0x00ce00, 0x00ce80, 0x00cf00,
  0x00cf80, 0x00d000, 0x00d080, 0x00d100, 0x00d180, 0x00d200, 0x00d280, 0x00d300,
  0x00d380, 0x00d400, 0x00d480, 0x00d500, 0x00d580, 0x00d600, 0x00d680, 0x00d700,
  0x00d780, 0x00d800, 0x00d880, 0x00d900, 0x00d980, 0x00da00, 0x00da80, 0x00db00,
  0x00db80, 0x00dc00, 0x00dc80, 0x00dd00, 0x00dd80, 0x00de00, 0x00de80, 0x00df00,
  0x00df80, 0x00e000, 0x00e080, 0x00e100, 0x00e180, 0x00e200, 0x00e280, 0x00e300,
  0x00e380, 0x00e400, 0x00e480, 0x00e500, 0x00e580, 0x00e600, 0x00e680, 0x00e700,
  0x00e780, 0x00e800, 0x00e880, 0x00e900, 0x00e980, 0x00ea00, 0x00ea80, 0x00eb00,
  0x00eb80, 0x00ec00, 0x00ec80, 0x00ed00, 0x00ed80, 0x00ee00, 0x00ee80, 0x00ef00,
  0x00ef80, 0x00f000, 0x00f080, 0x00f100, 0x00f180, 0x00f200, 0x00f280, 0x00f300,
  0x00f380, 0x00f400, 0x00f480, 0x00f500, 0x00f580, 0x00f600, 0x00f680, 0x00f700,
  0x00f780, 0x00f800, 0x00f880, 0x00f900, 0x00f980, 0x00fa00, 0x00fa80, 0x00fb00,
  0x00fb80, 0x00fc00, 0x00fc80, 0x00fd00, 0x00fd80, 0x00fe00, 0x00fe80, 0x00ff00,
  0x010000, 0x010100, 0x010200, 0x010300, 0x010400, 0x010500, 0x010600, 0x010700,
  0x010800, 0x010900, 0x010a00, 0x010b00, 0x010c00, 0x010d00, 0x010e00, 0x010f00,
  0x011000, 0x011100, 0x011200, 0x011300, 0x011400, 0x011500, 0x011600, 0x011700,
  0x011800, 0x011900, 0x011a00, 0x011b00, 0x011c00, 0x011d00, 0x011e00, 0x011f00,
  0x012000, 0x012100, 0x012200, 0x012300, 0x012400, 0x012500, 0x012600, 0x012700,
  0x012800, 0x012900, 0x012a00, 0x012b00, 0x012c00, 0x012d00, 0x012e00, 0x012f00,
  0x013000, 0x013100, 0x013200, 0x013300, 0x013400, 0x013500, 0x013600, 0x013700,
  0x013800, 0x013900, 0x013a00, 0x013b00, 0x013c00, 0x013d00, 0x013e00, 0x013f00,
  0x014000, 0x014100, 0x014200, 0x014300, 0x014400, 0x014500, 0x014600, 0x014700,
  0x014800, 0x014900, 0x014a00, 0x014b00, 0x014c00, 0x014d00, 0x014e00, 0x014f00,
  0x015000, 0x015100, 0x015200, 0x015300, 0x015400, 0x015500, 0x015600, 0x015700,
  0x015800, 0x015900, 0x015a00, 0x015b00, 0x015c00, 0x015d00, 0x015e00, 0x015f00,
  0x016000, 0x016100, 0x016200, 0x016300, 0x016400, 0x016500, 0x016600, 0x016700,
  0x016800, 0x016900, 0x016a00, 0x016b00, 0x016c00, 0x016d00, 0x016e00, 0x016f00,
  0x017000, 0x017100, 0x017200, 0x017300, 0x017400, 0x017500, 0x017600, 0x017700,
  0x017800, 0x017900, 0x017a00, 0x017b00, 0x017c00, 0x017d00, 0x017e00, 0x017f00,
  0x018000, 0x018100, 0x018200, 0x018300, 0x018400, 0x018500, 0x018600, 0x018700,
  0x018800, 0x018900, 0x018a00, 0x018b00, 0x018c00, 0x018d00, 0x018e00, 0x018f00,
  0x019000, 0x019100, 0x019200, 0x019300, 0x019400, 0x019500, 0x019600, 0x019700,
  0x019800, 0x019900, 0x019a00, 0x019b00, 0x019c00, 0x019d00, 0x019e00, 0x019f00,
  0x01a000, 0x01a100, 0x01a200, 0x01a300, 0x01a400, 0x01a500, 0x01a600, 0x01a700,
  0x01a800, 0x01a900, 0x01aa00, 0x01ab00, 0x01ac00, 0x01ad00, 0x01ae00, 0x01af00,
  0x01b000, 0x01b100, 0x01b200, 0x01b300, 0x01b400, 0x01b500, 0x01b600, 0x01b700,
  0x01b800, 0x01b900, 0x01ba00, 0x01bb00, 0x01bc00, 0x01bd00, 0x01be00, 0x01bf00,
  0x01c000, 0x01c100, 0x01c200, 0x01c300, 0x01c400, 0x01c500, 0x01c600, 0x01c700,
  0x01c800, 0x01c900, 0x01ca00, 0x01cb00, 0x01cc00, 0x01cd00, 0x01ce00, 0x01cf00,
  0x01d000, 0x01d100, 0x01d200, 0x01d300, 0x01d400, 0x01d500, 0x01d600, 0x01d700,
  0x01d800, 0x01d900, 0x01da00, 0x01db00, 0x01dc00, 0x01dd00, 0x01de00, 0x01df00,
  0x01e000, 0x01e100, 0x01e200, 0x01e300, 0x01e400, 0x01e500, 0x01e600, 0x01e700,
  0x01e800, 0x01e900, 0x01ea00, 0x01eb00, 0x01ec00, 0x01ed00, 0x01ee00, 0x01ef00,
  0x01f000, 0x01f100, 0x01f200, 0x01f300, 0x01f400, 0x01f500, 0x01f600, 0x01f700,
  0x01f800, 0x01f900, 0x01fa00, 0x01fb00, 0x01fc00, 0x01fd00, 0x01fe00, 0x01ff00,
  0x020100, 0x020300, 0x020500, 0x020700, 0x020900, 0x020b00, 0x020d00, 0x020f00,
  0x021100, 0x021300, 0x021500, 0x021700, 0x021900, 0x021b00, 0x021d00, 0x021f00,
  0x022100, 0x022300, 0x022500, 0x022700, 0x022900, 0x022b00, 0x022d00, 0x022f00,
  0x023100, 0x023300, 0x023500, 0x023700, 0x023900, 0x023b00, 0x023d00, 0x023f00,
  0x024100, 0x024300, 0x024500, 0x024700, 0x024900, 0x024b00, 0x024d00, 0x024f00,
  0x025100, 0x025300, 0x025500, 0x025700, 0x025900, 0x025b00, 0x025d00, 0x025f00,
  0x026100, 0x026300, 0x026500, 0x026700, 0x026900, 0x026b00, 0x026d00, 0x026f00,
  0x027100, 0x027300, 0x027500, 0x027700, 0x027900, 0x027b00, 0x027d00, 0x027f00,
  0x028100, 0x028300, 0x028500, 0x028700, 0x028900, 0x028b00, 0x028d00, 0x028f00,
  0x029100, 0x029300, 0x029500, 0x029700, 0x029900, 0x029b00, 0x029d00, 0x029f00,
  0x02a100, 0x02a300, 0x02a500, 0x02a700, 0x02a900, 0x02ab00, 0x02ad00, 0x02af00,
  0x02b100, 0x02b300, 0x02b500, 0x02b700, 0x02b900, 0x02bb00, 0x02bd00, 0x02bf00,
  0x02c100, 0x02c300, 0x02c500, 0x02c700, 0x02c900, 0x02cb00, 0x02cd00, 0x02cf00,
  0x02d100, 0x02d300, 0x02d500, 0x02d700, 0x02d900, 0x02db00, 0x02dd00, 0x02df00,
  0x02e100, 0x02e300, 0x02e500, 0x02e700, 0x02e900, 0x02eb00, 0x02ed00, 0x02ef00,
  0x02f100, 0x02f300, 0x02f500, 0x02f700, 0x02f900, 0x02fb00, 0x02fd00, 0x02ff00,
  0x030100, 0x030300, 0x030500, 0x030700, 0x030900, 0x030b00, 0x030d00, 0x030f00,
  0x031100, 0x031300, 0x031500, 0x031700, 0x031900, 0x031b00, 0x031d00, 0x031f00,
  0x032100, 0x032300, 0x032500, 0x032700, 0x032900, 0x032b00, 0x032d00, 0x032f00,
  0x033100, 0x033300, 0x033500, 0x033700, 0x033900, 0x033b00, 0x033d00, 0x033f00,
  0x034100, 0x034300, 0x034500, 0x034700, 0x034900, 0x034b00, 0x034d00, 0x034f00,
  0x035100, 0x035300, 0x035500, 0x035700, 0x035900, 0x035b00, 0x035d00, 0x035f00,
  0x036100, 0x036300, 0x036500, 0x036700, 0x036900, 0x036b00, 0x036d00, 0x036f00,
  0x037100, 0x037300, 0x037500, 0x037700, 0x037900, 0x037b00, 0x037d00, 0x037f00,
  0x038100, 0x038300, 0x038500, 0x038700, 0x038900, 0x038b00, 0x038d00, 0x038f00,
  0x039100, 0x039300, 0x039500, 0x039700, 0x039900, 0x039b00, 0x039d00, 0x039f00,
  0x03a100, 0x03a300, 0x03a500, 0x03a700, 0x03a900, 0x03ab00, 0x03ad00, 0x03af00,
  0x03b100, 0x03b300, 0x03b500, 0x03b700, 0x03b900, 0x03bb00, 0x03bd00, 0x03bf00,
  0x03c100, 0x03c300, 0x03c500, 0x03c700, 0x03c900, 0x03cb00, 0x03cd00, 0x03cf00,
  0x03d100, 0x03d300, 0x03d500, 0x03d700, 0x03d900, 0x03db00, 0x03dd00, 0x03df00,
  0x03e100, 0x03e300, 0x03e500, 0x03e700, 0x03e900, 0x03eb00, 0x03ed00, 0x03ef00,
  0x03f100, 0x03f300, 0x03f500, 0x03f700, 0x03f900, 0x03fb00, 0x03fd00, 0x03ff00,
  0x040300, 0x040700, 0x040b00, 0x040f00, 0x041300, 0x041700, 0x041b00, 0x041f00,
  0x042300, 0x042700, 0x042b00, 0x042f00, 0x043300, 0x043700, 0x043b00, 0x043f00,
  0x044300, 0x044700, 0x044b00, 0x044f00, 0x045300, 0x045700, 0x045b00, 0x045f00,
  0x046300, 0x046700, 0x046b00, 0x046f00, 0x047300, 0x047700, 0x047b00, 0x047f00,
  0x048300, 0x048700, 0x048b00, 0x048f00, 0x049300, 0x049700, 0x049b00, 0x049f00,
  0x04a300, 0x04a700, 0x04ab00, 0x04af00, 0x04b300, 0x04b700, 0x04bb00, 0x04bf00,
  0x04c300, 0x04c700, 0x04cb00, 0x04cf00, 0x04d300, 0x04d700, 0x04db00, 0x04df00,
  0x04e300, 0x04e700, 0x04eb00, 0x04ef00, 0x04f300, 0x04f700, 0x04fb00, 0x04ff00,
  0x050300, 0x050700, 0x050b00, 0x050f00, 0x051300, 0x051700, 0x051b00, 0x051f00,
  0x052300, 0x052700, 0x052b00, 0x052f00, 0x053300, 0x053700, 0x053b00, 0x053f00,
  0x054300, 0x054700, 0x054b00, 0x054f00, 0x055300, 0x055700, 0x055b00, 0x055f00,
  0x056300, 0x056700, 0x056b00, 0x056f00, 0x057300, 0x057700, 0x057b00, 0x057f00,
  0x058300, 0x058700, 0x058b00, 0x058f00, 0x059300, 0x059700, 0x059b00, 0x059f00,
  0x05a300, 0x05a700, 0x05ab00, 0x05af00, 0x05b300, 0x05b700, 0x05bb00, 0x05bf00,
  0x05c300, 0x05c700, 0x05cb00, 0x05cf00, 0x05d300, 0x05d700, 0x05db00, 0x05df00,
  0x05e300, 0x05e700, 0x05eb00, 0x05ef00, 0x05f300, 0x05f700, 0x05fb00, 0x05ff00,
  0x060300, 0x060700, 0x060b00, 0x060f00, 0x061300, 0x061700, 0x061b00, 0x061f00,
  0x062300, 0x062700, 0x062b00, 0x062f00, 0x063300, 0x063700, 0x063b00, 0x063f00,
  0x064300, 0x064700, 0x064b00, 0x064f00, 0x065300, 0x065700, 0x065b00, 0x065f00,
  0x066300, 0x066700, 0x066b00, 0x066f00, 0x067300, 0x067700, 0x067b00, 0x067f00,
  0x068300, 0x068700, 0x068b00, 0x068f00, 0x069300, 0x069700, 0x069b00, 0x069f00,
  0x06a300, 0x06a700, 0x06ab00, 0x06af00, 0x06b300, 0x06b700, 0x06bb00, 0x06bf00,
  0x06c300, 0x06c700, 0x06cb00, 0x06cf00, 0x06d300, 0x06d700, 0x06db00, 0x06df00,
  0x06e300, 0x06e700, 0x06eb00, 0x06ef00, 0x06f300, 0x06f700, 0x06fb00, 0x06ff00,
  0x070300, 0x070700, 0x070b00, 0x070f00, 0x071300, 0x071700, 0x071b00, 0x071f00,
  0x072300, 0x072700, 0x072b00, 0x072f00, 0x073300, 0x073700, 0x073b00, 0x073f00,
  0x074300, 0x074700, 0x074b00, 0x074f00, 0x075300, 0x075700, 0x075b00, 0x075f00,
  0x076300, 0x076700, 0x076b00, 0x076f00, 0x077300, 0x077700, 0x077b00, 0x077f00,
  0x078300, 0x078700, 0x078b00, 0x078f00, 0x079300, 0x079700, 0x079b00, 0x079f00,
  0x07a300, 0x07a700, 0x07ab00, 0x07af00, 0x07b300, 0x07b700, 0x07bb00, 0x07bf00,
  0x07c300, 0x07c700, 0x07cb00, 0x07cf00, 0x07d300, 0x07d700, 0x07db00, 0x07df00,
  0x07e300, 0x07e700, 0x07eb00, 0x07ef00, 0x07f300, 0x07f700, 0x07fb00, 0x07ff00,
  0x080700, 0x080f00, 0x081700, 0x081f00, 0x082700, 0x082f00, 0x083700, 0x083f00,
  0x084700, 0x084f00, 0x085700, 0x085f00, 0x086700, 0x086f00, 0x087700, 0x087f00,
  0x088700, 0x088f00, 0x089700, 0x089f00, 0x08a700, 0x08af00, 0x08b700, 0x08bf00,
  0x08c700, 0x08cf00, 0x08d700, 0x08df00, 0x08e700, 0x08ef00, 0x08f700, 0x08ff00,
  0x090700, 0x090f00, 0x091700, 0x091f00, 0x092700, 0x092f00, 0x093700, 0x093f00,
  0x094700, 0x094f00, 0x095700, 0x095f00, 0x096700, 0x096f00, 0x097700, 0x097f00,
  0x098700, 0x098f00, 0x099700, 0x099f00, 0x09a700, 0x09af00, 0x09b700, 0x09bf00,
  0x09c700, 0x09cf00, 0x09d700, 0x09df00, 0x09e700, 0x09ef00, 0x09f700, 0x09ff00,
  0x0a0700, 0x0a0f00, 0x0a1700, 0x0a1f00, 0x0a2700, 0x0a2f00, 0x0a3700, 0x0a3f00,
  0x0a4700, 0x0a4f00, 0x0a5700, 0x0a5f00, 0x0a6700, 0x0a6f00, 0x0a7700, 0x0a7f00,
  0x0a8700, 0x0a8f00, 0x0a9700, 0x0a9f00, 0x0aa700, 0x0aaf00, 0x0ab700, 0x0abf00,
  0x0ac700, 0x0acf00, 0x0ad700, 0x0adf00, 0x0ae700, 0x0aef00, 0x0af700, 0x0aff00,
  0x0b0700, 0x0b0f00, 0x0b1700, 0x0b1f00, 0x0b2700, 0x0b2f00, 0x0b3700, 0x0b3f00,
  0x0b4700, 0x0b4f00, 0x0b5700, 0x0b5f00, 0x0b6700, 0x0b6f00, 0x0b7700, 0x0b7f00,
  0x0b8700, 0x0b8f00, 0x0b9700, 0x0b9f00, 0x0ba700, 0x0baf00, 0x0bb700, 0x0bbf00,
  0x0bc700, 0x0bcf00, 0x0bd700, 0x0bdf00, 0x0be700, 0x0bef00, 0x0bf700, 0x0bff00,
  0x0c0700, 0x0c0f00, 0x0c1700, 0x0c1f00, 0x0c2700, 0x0c2f00, 0x0c3700, 0x0c3f00,
  0x0c4700, 0x0c4f00, 0x0c5700, 0x0c5f00, 0x0c6700, 0x0c6f00, 0x0c7700, 0x0c7f00,
  0x0c8700, 0x0c8f00, 0x0c9700, 0x0c9f00, 0x0ca700, 0x0caf00, 0x0cb700, 0x0cbf00,
  0x0cc700, 0x0ccf00, 0x0cd700, 0x0cdf00, 0x0ce700, 0x0cef00, 0x0cf700, 0x0cff00,
  0x0d0700, 0x0d0f00, 0x0d1700, 0x0d1f00, 0x0d2700, 0x0d2f00, 0x0d3700, 0x0d3f00,
  0x0d4700, 0x0d4f00, 0x0d5700, 0x0d5f00, 0x0d6700, 0x0d6f00, 0x0d7700, 0x0d7f00,
  0x0d8700, 0x0d8f00, 0x0d9700, 0x0d9f00, 0x0da700, 0x0daf00, 0x0db700, 0x0dbf00,
  0x0dc700, 0x0dcf00, 0x0dd700, 0x0ddf00, 0x0de700, 0x0def00, 0x0df700, 0x0dff00,
  0x0e0700, 0x0e0f00, 0x0e1700, 0x0e1f00, 0x0e2700, 0x0e2f00, 0x0e3700, 0x0e3f00,
  0x0e4700, 0x0e4f00, 0x0e5700, 0x0e5f00, 0x0e6700, 0x0e6f00, 0x0e7700, 0x0e7f00,
  0x0e8700, 0x0e8f00, 0x0e9700, 0x0e9f00, 0x0ea700, 0x0eaf00, 0x0eb700, 0x0ebf00,
  0x0ec700, 0x0ecf00, 0x0ed700, 0x0edf00, 0x0ee700, 0x0eef00, 0x0ef700, 0x0eff00,
  0x0f0700, 0x0f0f00, 0x0f1700, 0x0f1f00, 0x0f2700, 0x0f2f00, 0x0f3700, 0x0f3f00,
  0x0f4700, 0x0f4f00, 0x0f5700, 0x0f5f00, 0x0f6700, 0x0f6f00, 0x0f7700, 0x0f7f00,
  0x0f8700, 0x0f8f00, 0x0f9700, 0x0f9f00, 0x0fa700, 0x0faf00, 0x0fb700, 0x0fbf00,
  0x0fc700, 0x0fcf00, 0x0fd700, 0x0fdf00, 0x0fe700, 0x0fef00, 0x0ff700, 0x0fff00,
  0x100f00, 0x101f00, 0x102f00, 0x103f00, 0x104f00, 0x105f00, 0x106f00, 0x107f00,
  0x108f00, 0x109f00, 0x10af00, 0x10bf00, 0x10cf00, 0x10df00, 0x10ef00, 0x10ff00,
  0x110f00, 0x111f00, 0x112f00, 0x113f00, 0x114f00, 0x115f00, 0x116f00, 0x117f00,
  0x118f00, 0x119f00, 0x11af00, 0x11bf00, 0x11cf00, 0x11df00, 0x11ef00, 0x11ff00,
  0x120f00, 0x121f00, 0x122f00, 0x123f00, 0x124f00, 0x125f00, 0x126f00, 0x127f00,
  0x128f00, 0x129f00, 0x12af00, 0x12bf00, 0x12cf00, 0x12df00, 0x12ef00, 0x12ff00,
  0x130f00, 0x131f00, 0x132f00, 0x133f00, 0x134f00, 0x135f00, 0x136f00, 0x137f00,
  0x138f00, 0x139f00, 0x13af00, 0x13bf00, 0x13cf00, 0x13df00, 0x13ef00, 0x13ff00,
  0x140f00, 0x141f00, 0x142f00, 0x143f00, 0x144f00, 0x145f00, 0x146f00, 0x147f00,
  0x148f00, 0x149f00, 0x14af00, 0x14bf00, 0x14cf00, 0x14df00, 0x14ef00, 0x14ff00,
  0x150f00, 0x151f00, 0x152f00, 0x153f00, 0x154f00, 0x155f00, 0x156f00, 0x157f00,
  0x158f00, 0x159f00, 0x15af00, 0x15bf00, 0x15cf00, 0x15df00, 0x15ef00, 0x15ff00,
  0x160f00, 0x161f00, 0x162f00, 0x163f00, 0x164f00, 0x165f00, 0x166f00, 0x167f00,
  0x168f00, 0x169f00, 0x16af00, 0x16bf00, 0x16cf00, 0x16df00, 0x16ef00, 0x16ff00,
  0x170f00, 0x171f00, 0x172f00, 0x173f00, 0x174f00, 0x175f00, 0x176f00, 0x177f00,
  0x178f00, 0x179f00, 0x17af00, 0x17bf00, 0x17cf00, 0x17df00, 0x17ef00, 0x17ff00,
  0x180f00, 0x181f00, 0x182f00, 0x183f00, 0x184f00, 0x185f00, 0x186f00, 0x187f00,
  0x188f00, 0x189f00, 0x18af00, 0x18bf00, 0x18cf00, 0x18df00, 0x18ef00, 0x18ff00,
  0x190f00, 0x191f00, 0x192f00, 0x193f00, 0x194f00, 0x195f00, 0x196f00, 0x197f00,
  0x198f00, 0x199f00, 0x19af00, 0x19bf00, 0x19cf00, 0x19df00, 0x19ef00, 0x19ff00,
  0x1a0f00, 0x1a1f00, 0x1a2f00, 0x1a3f00, 0x1a4f00, 0x1a5f00, 0x1a6f00, 0x1a7f00,
  0x1a8f00, 0x1a9f00, 0x1aaf00, 0x1abf00, 0x1acf00, 0x1adf00, 0x1aef00, 0x1aff00,
  0x1b0f00, 0x1b1f00, 0x1b2f00, 0x1b3f00, 0x1b4f00, 0x1b5f00, 0x1b6f00, 0x1b7f00,
  0x1b8f00, 0x1b9f00, 0x1baf00, 0x1bbf00, 0x1bcf00, 0x1bdf00, 0x1bef00, 0x1bff00,
  0x1c0f00, 0x1c1f00, 0x1c2f00, 0x1c3f00, 0x1c4f00, 0x1c5f00, 0x1c6f00, 0x1c7f00,
  0x1c8f00, 0x1c9f00, 0x1caf00, 0x1cbf00, 0x1ccf00, 0x1cdf00, 0x1cef00, 0x1cff00,
  0x1d0f00, 0x1d1f00, 0x1d2f00, 0x1d3f00, 0x1d4f00, 0x1d5f00, 0x1d6f00, 0x1d7f00,
  0x1d8f00, 0x1d9f00, 0x1daf00, 0x1dbf00, 0x1dcf00, 0x1ddf00, 0x1def00, 0x1dff00,
  0x1e0f00, 0x1e1f00, 0x1e2f00, 0x1e3f00, 0x1e4f00, 0x1e5f00, 0x1e6f00, 0x1e7f00,
  0x1e8f00, 0x1e9f00, 0x1eaf00, 0x1ebf00, 0x1ecf00, 0x1edf00, 0x1eef00, 0x1eff00,
  0x1f0f00, 0x1f1f00, 0x1f2f00, 0x1f3f00, 0x1f4f00, 0x1f5f00, 0x1f6f00, 0x1f7f00,
  0x1f8f00, 0x1f9f00, 0x1faf00, 0x1fbf00, 0x1fcf00, 0x1fdf00, 0x1fef00, 0x1fff00,
  0x201f00, 0x203f00, 0x205f00, 0x207f00, 0x209f00, 0x20bf00, 0x20df00, 0x20ff00,
  0x211f00, 0x213f00, 0x215f00, 0x217f00, 0x219f00, 0x21bf00, 0x21df00, 0x21ff00,
  0x221f00, 0x223f00, 0x225f00, 0x227f00, 0x229f00, 0x22bf00, 0x22df00, 0x22ff00,
  0x231f00, 0x233f00, 0x235f00, 0x237f00, 0x239f00, 0x23bf00, 0x23df00, 0x23ff00,
  0x241f00, 0x243f00, 0x245f00, 0x247f00, 0x249f00, 0x24bf00, 0x24df00, 0x24ff00,
  0x251f00, 0x253f00, 0x255f00, 0x257f00, 0x259f00, 0x25bf00, 0x25df00, 0x25ff00,
  0x261f00, 0x263f00, 0x265f00, 0x267f00, 0x269f00, 0x26bf00, 0x26df00, 0x26ff00,
  0x271f00, 0x273f00, 0x275f00, 0x277f00, 0x279f00, 0x27bf00, 0x27df00, 0x27ff00,
  0x281f00, 0x283f00, 0x285f00, 0x287f00, 0x289f00, 0x28bf00, 0x28df00, 0x28ff00,
  0x291f00, 0x293f00, 0x295f00, 0x297f00, 0x299f00, 0x29bf00, 0x29df00, 0x29ff00,
  0x2a1f00, 0x2a3f00, 0x2a5f00, 0x2a7f00, 0x2a9f00, 0x2abf00, 0x2adf00, 0x2aff00,
  0x2b1f00, 0x2b3f00, 0x2b5f00, 0x2b7f00, 0x2b9f00, 0x2bbf00, 0x2bdf00, 0x2bff00,
  0x2c1f00, 0x2c3f00, 0x2c5f00, 0x2c7f00, 0x2c9f00, 0x2cbf00, 0x2cdf00, 0x2cff00,
  0x2d1f00, 0x2d3f00, 0x2d5f00, 0x2d7f00, 0x2d9f00, 0x2dbf00, 0x2ddf00, 0x2dff00,
  0x2e1f00, 0x2e3f00, 0x2e5f00, 0x2e7f00, 0x2e9f00, 0x2ebf00, 0x2edf00, 0x2eff00,
  0x2f1f00, 0x2f3f00, 0x2f5f00, 0x2f7f00, 0x2f9f00, 0x2fbf00, 0x2fdf00, 0x2fff00,
  0x301f00, 0x303f00, 0x305f00, 0x307f00, 0x309f00, 0x30bf00, 0x30df00, 0x30ff00,
  0x311f00, 0x313f00, 0x315f00, 0x317f00, 0x319f00, 0x31bf00, 0x31df00, 0x31ff00,
  0x321f00, 0x323f00, 0x325f00, 0x327f00, 0x329f00, 0x32bf00, 0x32df00, 0x32ff00,
  0x331f00, 0x333f00, 0x335f00, 0x337f00, 0x339f00, 0x33bf00, 0x33df00, 0x33ff00,
  0x341f00, 0x343f00, 0x345f00, 0x347f00, 0x349f00, 0x34bf00, 0x34df00, 0x34ff00,
  0x351f00, 0x353f00, 0x355f00, 0x357f00, 0x359f00, 0x35bf00, 0x35df00, 0x35ff00,
  0x361f00, 0x363f00, 0x365f00, 0x367f00, 0x369f00, 0x36bf00, 0x36df00, 0x36ff00,
  0x371f00, 0x373f00, 0x375f00, 0x377f00, 0x379f00, 0x37bf00, 0x37df00, 0x37ff00,
  0x381f00, 0x383f00, 0x385f00, 0x387f00, 0x389f00, 0x38bf00, 0x38df00, 0x38ff00,
  0x391f00, 0x393f00, 0x395f00, 0x397f00, 0x399f00, 0x39bf00, 0x39df00, 0x39ff00,
  0x3a1f00, 0x3a3f00, 0x3a5f00, 0x3a7f00, 0x3a9f00, 0x3abf00, 0x3adf00, 0x3aff00,
  0x3b1f00, 0x3b3f00, 0x3b5f00, 0x3b7f00, 0x3b9f00, 0x3bbf00, 0x3bdf00, 0x3bff00,
  0x3c1f00, 0x3c3f00, 0x3c5f00, 0x3c7f00, 0x3c9f00, 0x3cbf00, 0x3cdf00, 0x3cff00,
  0x3d1f00, 0x3d3f00, 0x3d5f00, 0x3d7f00, 0x3d9f00, 0x3dbf00, 0x3ddf00, 0x3dff00,
  0x3e1f00, 0x3e3f00, 0x3e5f00, 0x3e7f00, 0x3e9f00, 0x3ebf00, 0x3edf00, 0x3eff00,
  0x3f1f00, 0x3f3f00, 0x3f5f00, 0x3f7f00, 0x3f9f00, 0x3fbf00, 0x3fdf00, 0x3fff00,
  0x403f00, 0x407f00, 0x40bf00, 0x40ff00, 0x413f00, 0x417f00, 0x41bf00, 0x41ff00,
  0x423f00, 0x427f00, 0x42bf00, 0x42ff00, 0x433f00, 0x437f00, 0x43bf00, 0x43ff00,
  0x443f00, 0x447f00, 0x44bf00, 0x44ff00, 0x453f00, 0x457f00, 0x45bf00, 0x45ff00,
  0x463f00, 0x467f00, 0x46bf00, 0x46ff00, 0x473f00, 0x477f00, 0x47bf00, 0x47ff00,
  0x483f00, 0x487f00, 0x48bf00, 0x48ff00, 0x493f00, 0x497f00, 0x49bf00, 0x49ff00,
  0x4a3f00, 0x4a7f00, 0x4abf00, 0x4aff00, 0x4b3f00, 0x4b7f00, 0x4bbf00, 0x4bff00,
  0x4c3f00, 0x4c7f00, 0x4cbf00, 0x4cff00, 0x4d3f00, 0x4d7f00, 0x4dbf00, 0x4dff00,
  0x4e3f00, 0x4e7f00, 0x4ebf00, 0x4eff00, 0x4f3f00, 0x4f7f00, 0x4fbf00, 0x4fff00,
  0x503f00, 0x507f00, 0x50bf00, 0x50ff00, 0x513f00, 0x517f00, 0x51bf00, 0x51ff00,
  0x523f00, 0x527f00, 0x52bf00, 0x52ff00, 0x533f00, 0x537f00, 0x53bf00, 0x53ff00,
  0x543f00, 0x547f00, 0x54bf00, 0x54ff00, 0x553f00, 0x557f00, 0x55bf00, 0x55ff00,
  0x563f00, 0x567f00, 0x56bf00, 0x56ff00, 0x573f00, 0x577f00, 0x57bf00, 0x57ff00,
  0x583f00, 0x587f00, 0x58bf00, 0x58ff00, 0x593f00, 0x597f00, 0x59bf00, 0x59ff00,
  0x5a3f00, 0x5a7f00, 0x5abf00, 0x5aff00, 0x5b3f00, 0x5b7f00, 0x5bbf00, 0x5bff00,
  0x5c3f00, 0x5c7f00, 0x5cbf00, 0x5cff00, 0x5d3f00, 0x5d7f00, 0x5dbf00, 0x5dff00,
  0x5e3f00, 0x5e7f00, 0x5ebf00, 0x5eff00, 0x5f3f00, 0x5f7f00, 0x5fbf00, 0x5fff00,
  0x603f00, 0x607f00, 0x60bf00, 0x60ff00, 0x613f00, 0x617f00, 0x61bf00, 0x61ff00,
  0x623f00, 0x627f00, 0x62bf00, 0x62ff00, 0x633f00, 0x637f00, 0x63bf00, 0x63ff00,
  0x643f00, 0x647f00, 0x64bf00, 0x64ff00, 0x653f00, 0x657f00, 0x65bf00, 0x65ff00,
  0x663f00, 0x667f00, 0x66bf00, 0x66ff00, 0x673f00, 0x677f00, 0x67bf00, 0x67ff00,
  0x683f00, 0x687f00, 0x68bf00, 0x68ff00, 0x693f00, 0x697f00, 0x69bf00, 0x69ff00,
  0x6a3f00, 0x6a7f00, 0x6abf00, 0x6aff00, 0x6b3f00, 0x6b7f00, 0x6bbf00, 0x6bff00,
  0x6c3f00, 0x6c7f00, 0x6cbf00, 0x6cff00, 0x6d3f00, 0x6d7f00, 0x6dbf00, 0x6dff00,
  0x6e3f00, 0x6e7f00, 0x6ebf00, 0x6eff00, 0x6f3f00, 0x6f7f00, 0x6fbf00, 0x6fff00,
  0x703f00, 0x707f00, 0x70bf00, 0x70ff00, 0x713f00, 0x717f00, 0x71bf00, 0x71ff00,
  0x723f00, 0x727f00, 0x72bf00, 0x72ff00, 0x733f00, 0x737f00, 0x73bf00, 0x73ff00,
  0x743f00, 0x747f00, 0x74bf00, 0x74ff00, 0x753f00, 0x757f00, 0x75bf00, 0x75ff00,
  0x763f00, 0x767f00, 0x76bf00, 0x76ff00, 0x773f00, 0x777f00, 0x77bf00, 0x77ff00,
  0x783f00, 0x787f00, 0x78bf00, 0x78ff00, 0x793f00, 0x797f00, 0x79bf00, 0x79ff00,
  0x7a3f00, 0x7a7f00, 0x7abf00, 0x7aff00, 0x7b3f00, 0x7b7f00, 0x7bbf00, 0x7bff00,
  0x7c3f00, 0x7c7f00, 0x7cbf00, 0x7cff00, 0x7d3f00, 0x7d7f00, 0x7dbf00, 0x7dff00,
  0x7e3f00, 0x7e7f00, 0x7ebf00, 0x7eff00, 0x7f3f00, 0x7f7f00, 0x7fbf00, 0x7fff00,
  0x807f00, 0x80ff00, 0x817f00, 0x81ff00, 0x827f00, 0x82ff00, 0x837f00, 0x83ff00,
  0x847f00, 0x84ff00, 0x857f00, 0x85ff00, 0x867f00, 0x86ff00, 0x877f00, 0x87ff00,
  0x887f00, 0x88ff00, 0x897f00, 0x89ff00, 0x8a7f00, 0x8aff00, 0x8b7f00, 0x8bff00,
  0x8c7f00, 0x8cff00, 0x8d7f00, 0x8dff00, 0x8e7f00, 0x8eff00, 0x8f7f00, 0x8fff00,
  0x907f00, 0x90ff00, 0x917f00, 0x91ff00, 0x927f00, 0x92ff00, 0x937f00, 0x93ff00,
  0x947f00, 0x94ff00, 0x957f00, 0x95ff00, 0x967f00, 0x96ff00, 0x977f00, 0x97ff00,
  0x987f00, 0x98ff00, 0x997f00, 0x99ff00, 0x9a7f00, 0x9aff00, 0x9b7f00, 0x9bff00,
  0x9c7f00, 0x9cff00, 0x9d7f00, 0x9dff00, 0x9e7f00, 0x9eff00, 0x9f7f00, 0x9fff00,
  0xa07f00, 0xa0ff00, 0xa17f00, 0xa1ff00, 0xa27f00, 0xa2ff00, 0xa37f00, 0xa3ff00,
  0xa47f00, 0xa4ff00, 0xa57f00, 0xa5ff00, 0xa67f00, 0xa6ff00, 0xa77f00, 0xa7ff00,
  0xa87f00, 0xa8ff00, 0xa97f00, 0xa9ff00, 0xaa7f00, 0xaaff00, 0xab7f00, 0xabff00,
  0xac7f00, 0xacff00, 0xad7f00, 0xadff00, 0xae7f00, 0xaeff00, 0xaf7f00, 0xafff00,
  0xb07f00, 0xb0ff00, 0xb17f00, 0xb1ff00, 0xb27f00, 0xb2ff00, 0xb37f00, 0xb3ff00,
  0xb47f00, 0xb4ff00, 0xb57f00, 0xb5ff00, 0xb67f00, 0xb6ff00, 0xb77f00, 0xb7ff00,
  0xb87f00, 0xb8ff00, 0xb97f00, 0xb9ff00, 0xba7f00, 0xbaff00, 0xbb7f00, 0xbbff00,
  0xbc7f00, 0xbcff00, 0xbd7f00, 0xbdff00, 0xbe7f00, 0xbeff00, 0xbf7f00, 0xbfff00,
  0xc07f00, 0xc0ff00, 0xc17f00, 0xc1ff00, 0xc27f00, 0xc2ff00, 0xc37f00, 0xc3ff00,
  0xc47f00, 0xc4ff00, 0xc57f00, 0xc5ff00, 0xc67f00, 0xc6ff00, 0xc77f00, 0xc7ff00,
  0xc87f00, 0xc8ff00, 0xc97f00, 0xc9ff00, 0xca7f00, 0xcaff00, 0xcb7f00, 0xcbff00,
  0xcc7f00, 0xccff00, 0xcd7f00, 0xcdff00, 0xce7f00, 0xceff00, 0xcf7f00, 0xcfff00,
  0xd07f00, 0xd0ff00, 0xd17f00, 0xd1ff00, 0xd27f00, 0xd2ff00, 0xd37f00, 0xd3ff00,
  0xd47f00, 0xd4ff00, 0xd57f00, 0xd5ff00, 0xd67f00, 0xd6ff00, 0xd77f00, 0xd7ff00,
  0xd87f00, 0xd8ff00, 0xd97f00, 0xd9ff00, 0xda7f00, 0xdaff00, 0xdb7f00, 0xdbff00,
  0xdc7f00, 0xdcff00, 0xdd7f00, 0xddff00, 0xde7f00, 0xdeff00, 0xdf7f00, 0xdfff00,
  0xe07f00, 0xe0ff00, 0xe17f00, 0xe1ff00, 0xe27f00, 0xe2ff00, 0xe37f00, 0xe3ff00,
  0xe47f00, 0xe4ff00, 0xe57f00, 0xe5ff00, 0xe67f00, 0xe6ff00, 0xe77f00, 0xe7ff00,
  0xe87f00, 0xe8ff00, 0xe97f00, 0xe9ff00, 0xea7f00, 0xeaff00, 0xeb7f00, 0xebff00,
  0xec7f00, 0xecff00, 0xed7f00, 0xedff00, 0xee7f00, 0xeeff00, 0xef7f00, 0xefff00,
  0xf07f00, 0xf0ff00, 0xf17f00, 0xf1ff00, 0xf27f00, 0xf2ff00, 0xf37f00, 0xf3ff00,
  0xf47f00, 0xf4ff00, 0xf57f00, 0xf5ff00, 0xf67f00, 0xf6ff00, 0xf77f00, 0xf7ff00,
  0xf87f00, 0xf8ff00, 0xf97f00, 0xf9ff00, 0xfa7f00, 0xfaff00, 0xfb7f00, 0xfbff00,
  0xfc7f00, 0xfcff00, 0xfd7f00, 0xfdff00, 0xfe7f00, 0xfeff00, 0xff7f00, 0xffff00,
};

static uint16_t
_get_encoded_value(struct rfc7181_metric_field *value) {
  return 256 * value->b[0] + value->b[1];
}

static void
test_timetlv_decoding(void) {
  uint64_t encoded, decoded;

  START_TEST();

  for (encoded = 0; encoded < 256; encoded++) {
    decoded = rfc5497_timetlv_decode(encoded);
    CHECK_TRUE(decoded == _timetlv_table[encoded],
        "decode(%"PRIu64") != %"PRIu64" (was %"PRIu64" instead)",
        encoded, _timetlv_table[encoded], decoded);
  }

  END_TEST();
}

static void
test_timetlv_encoding_exact(void) {
  uint64_t encoded, decoded, i;

  START_TEST();

  for (i=1; i<256; i++) {
    if (_timetlv_table[i] == _timetlv_table[i-1]) {
      continue;
    }

    decoded = _timetlv_table[i];
    encoded = rfc5497_timetlv_encode(decoded);

    CHECK_TRUE(encoded == i, "encode(%"PRIu64") != %"PRIu64, decoded, i);
  }

  END_TEST();
}

static void
_do_timetlv_average_test(uint64_t decoded) {
  uint64_t encoded;

  encoded = rfc5497_timetlv_encode(decoded);

  CHECK_TRUE(_timetlv_table[encoded] > decoded,
      "encode(%"PRIu64")=%"PRIu64", decode(%"PRIu64")=%"PRIu64", %"PRIu64" <= %"PRIu64,
      decoded, encoded,
      encoded, _timetlv_table[encoded],
      _timetlv_table[encoded-1], decoded);

  if (encoded > 0) {
    CHECK_TRUE(_timetlv_table[encoded-1] < decoded,
        "encode(%"PRIu64")=%"PRIu64", decode(%"PRIu64"-1)=%"PRIu64", %"PRIu64" >= %"PRIu64,
        decoded, encoded,
        encoded, _timetlv_table[encoded-1],
        _timetlv_table[encoded-1], decoded);
  }
}

static void
test_timetlv_encoding_average(void) {
  uint32_t decoded;

  int i,j;


  START_TEST();

  for (i=1; i<256; i++) {
    if (_timetlv_table[i] - _timetlv_table[i-1] < 2) {
      continue;
    }

    for (j = 1; j<5; j++) {
      decoded = _timetlv_table[i] - j;

      if (_timetlv_table[i-1] < decoded) {
        _do_timetlv_average_test(decoded);
      }
    }
    for (j = 1; j<5; j++) {
      decoded = _timetlv_table[i-1] + j;

      if (_timetlv_table[i] > decoded) {
        _do_timetlv_average_test(decoded);
      }
    }
  }
  END_TEST();
}

static void
test_metric_decoding(void) {
  uint32_t encoded, decoded;
  struct rfc7181_metric_field metric;
  START_TEST();

  for (encoded = 0; encoded < 4096; encoded++) {
    metric.b[0] = encoded >> 8;
    metric.b[1] = encoded & 255;
    decoded = rfc7181_metric_decode(&metric);
    CHECK_TRUE(decoded == _metric_table[encoded], "decode(%u) != %u", encoded, decoded);
  }

  END_TEST();
}

static void
test_metric_encoding_exact(void) {
  uint32_t decoded, i;
  struct rfc7181_metric_field metric;
  START_TEST();

  for (i=0; i<4096; i++) {
    decoded = _metric_table[i];
    CHECK_TRUE(!rfc7181_metric_encode(&metric, decoded),
        "Metric encoding failed : %u", decoded);

    CHECK_TRUE(_get_encoded_value(&metric) == i, "encode(%u) != %u", decoded, i);
  }

  END_TEST();
}

static void
_do_metric_average_test(uint32_t decoded) {
  struct rfc7181_metric_field metric;
  uint32_t encoded;

  CHECK_TRUE(!rfc7181_metric_encode(&metric, decoded),
      "Metric encoding failed: %u", decoded);
  encoded = _get_encoded_value(&metric);

  CHECK_TRUE(_metric_table[encoded] > decoded, "encode(%u)=%u, decode(%u)=%u, %u <= %u",
      decoded, encoded,
      encoded, _metric_table[encoded],
      _metric_table[encoded-1], decoded);
  CHECK_TRUE(_metric_table[encoded-1] < decoded, "encode(%u)=%u, decode(%u-1)=%u, %u >= %u",
      decoded, encoded,
      encoded, _metric_table[encoded-1],
      _metric_table[encoded-1], decoded);
}

static void
test_metric_encoding_average(void) {
  uint32_t decoded;

  int i,j;


  START_TEST();

  for (i=1; i<4096; i++) {
    if (_metric_table[i] - _metric_table[i-1] < 2) {
      continue;
    }

    for (j = 1; j<5; j++) {
      decoded = _metric_table[i] - j;

      if (_metric_table[i-1] < decoded) {
        _do_metric_average_test(decoded);
      }
    }
    for (j = 1; j<5; j++) {
      decoded = _metric_table[i-1] + j;

      if (_metric_table[i] > decoded) {
        _do_metric_average_test(decoded);
      }
    }
  }
  END_TEST();
}


int main(int argc __attribute__ ((unused)), char **argv __attribute__ ((unused))) {
  BEGIN_TESTING(NULL);

  test_timetlv_decoding();
  test_timetlv_encoding_exact();
  test_timetlv_encoding_average();

  test_metric_decoding();
  test_metric_encoding_exact();
  test_metric_encoding_average();

  return FINISH_TESTING();
}
