/******************************************************************************
 *
 * helpers.c - part of smap
 *
 * this file keeps all dirty little helpers
 *
 * $Id: helpers.c,v 1.5 2007-10-07 10:15:11 hscholz Exp $
 *****************************************************************************/

#ifndef _HELPERS_C
#define _HELPERS_C

#include "config.h"

#ifdef __FreeBSD__
#define HAVE_STRNSTR
#endif

#ifndef HAVE_STRNSTR

/*
 * Find the first occurrence of find in s, where the search is limited to the
 * first slen characters of s.
 * 
 * This function has been taken directly from FreeBSD libc:
 * http://www.freebsd.org/cgi/cvsweb.cgi/src/lib/libc/string/strnstr.c?rev=1.2.10.1&content-type=text/x-cvsweb-markup
 * since Linux and OpenBSD don't have it
 */

char * strnstr(s, find, slen)
	const char *s;
	const char *find;
	size_t slen;
{
	char c, sc;
	size_t len;

	if ((c = *find++) != '\0') {
		len = strlen(find);
		do {
			do {
				if (slen-- < 1 || (sc = *s++) == '\0')
					return (NULL);
			} while (sc != c);
			if (len > slen)
				return (NULL);
		} while (strncmp(s, find, len) != 0);
		s--;
	}
	return ((char *)s);
}
#endif /* HAVE_STRNSTR */

/******************************************************************************
 *
 * set_timeout()
 *
 * set a timeval timeout based on msecs passed
 *
 *****************************************************************************/

int set_timeout(struct timeval *timeval, unsigned int msec) {

    if (msec == 0)
        return 0;

    timeval->tv_sec = 0;
    timeval->tv_usec = 0;

    if (msec < 1000) {
        timeval->tv_usec = msec * 1000;
        return 1;
    }

    timeval->tv_sec = (long) (msec/1000);
    timeval->tv_usec = (suseconds_t) ((msec - (timeval->tv_sec * 1000))*1000);

    return 1;
}

#endif /* _HELPERS_C */
