#ifndef _PROTOTYPES_H
#define _PROTOTYPES_H

/* error.c */
void error(int, char *, ... );

/* icmpping.c */
unsigned short icmp_in_cksum(unsigned short *, int);
int icmpping(struct in_addr);
char *icmp_message_str(struct icmp *);

/* fingerprint.c */
int fingerprint_init(fingerprint *);
void fingerprint_info(fingerprint);
void fingerprint_headers(fingerprint *);
int fingerprint_lookup(fingerprint);
int fingerprint_loaddb(void);
void fingerprint_dumpdb(void);
void fingerprint_destroydb(void);
int fingerprint_getvalue(char *);
void fingerprint_free(fingerprint);

/* worker.c */
void *worker_start(void *);

/* listener.c */
void listener_sighandler(int);
void *listener_start(void *);

/* randomizer.c */
void randomizer_init(void);
unsigned int randomizer(int, char *, int);

/* request.c */
int request_generate(unsigned int, char *, unsigned int, unsigned int, unsigned int *);

/* scan.c */
int scan_do (task_t *, unsigned int);

/* tasks.c */
task_t *task_get_by_id(int);
task_t *task_get_by_target(struct in_addr *);
void task_list(void);
int task_list_append(task_t *);
int task_create (void); /* obsolete ? */
int task_add(unsigned int, struct in_addr);
void task_destroy(unsigned int);
void task_finish(task_t *);

/* transport_udp.c */
int udp_send(task_t *, char *);
int udp_setup_sender(void);
int udp_setup_rawsock(void);

/* transport_tcp.c */
int tcp_setup_sender(void);

/* helpers.c */
#ifndef __FreeBSD__
char *strnstr(const char *, const char *, size_t);
#endif
int set_timeout(struct timeval *, unsigned int);

/* localip.c */
int get_localip(void);

/* stun.c */
int stun_getip(char *);

/* response.c */
int response_reason(int *, char *);
unsigned int response_getcallid(char *);

/* state.c */
void state_list(void);
void state_remove_by_tid(unsigned int);
void state_remove(state_t *);
state_t *state_lookup_by_callid(unsigned int);
task_t *state_lookup_task_by_callid(unsigned int);
int state_add(task_t *, unsigned int, unsigned int);

/* ack.c */
int ack_o_matic(task_t *, char *response);

/* sip.c */
char *sip_getheader(char *, char *);
int sip_getheaderp(char *, char *, char **, int *);
int sip_getcseq(char *, unsigned int *);
int sip_parse(char *);
int sip_getcseqmethod(char *);

/* results.c */
void results_print(task_t *);

/* test_accept.c */
int test_accept(int *, char *);

/* test_allow.c */
int test_allow(int *, char *);

/* test_headers.c */
int test_headers(int *, char *);

/* test_supported.c */
int test_supported(int *, char *);

/* test_via.c */
int test_via(int *, char *);

/* smap.c */
void main_sighandler(int);

/* stats.c */
void stats_init(void);
void stats_dump(void);


#endif /* _PROTOTYPES_H */
