/******************************************************************************
 *
 * scan.c - network scanner part of smap
 *
 * How to add a new test:
 *
 * - add new storage to fingerprint struct (i.e. fingerprint.newmethod)
 * - add symbol (i.e. SIP_NEWMETHOD) to config.h enumeration
 * - add the test itself to requestn.c:request_generate()
 * - invoke test by adding to scan_tests[] below
 * - add fingerprinting information to fingerprint.db
 *
 * $Id: scan.c,v 1.33 2007-10-14 10:02:18 hscholz Exp $
 *****************************************************************************/
#ifndef _SCAN_C
#define _SCAN_C

#include "config.h"

struct scan_test_t scan_tests[] = {
    { SIP_OPTIONS, offsetof(fingerprint, options),
        "SIP OPTIONS request (valid)" },
    { SIP_BROKENFROMTO, offsetof(fingerprint, brokenfromto),
        "SIP OPTIONS request with broken To/FROM URI (invalid)" },
    { SIP_NEWMETHOD, offsetof(fingerprint, newmethod),
        "SIP request with unknown 'NEWMETHOD' request method (invalid)" },
    { SIP_PRACK, offsetof(fingerprint, prack),
        "SIP PRACK to non-existent transaction" },
    { SIP_INVITE, offsetof(fingerprint, invite),
        "SIP INVITE to non-existent extension" },
    { SIP_PING, offsetof(fingerprint, ping),
        "SIP PING request (valid)" },
    { SIP_TMP, offsetof(fingerprint, tmp), "scratchpad" },
    { 0, 0, ""}
};

/******************************************************************************
 *  
 * scan_do()
 *
 * invoke a transport independent scan by sending a single request
 *
 ****************************************************************************/

int scan_do(task_t *task, unsigned int requesttype) {

	char req[SIPLEN];
	unsigned int callid;

	FUNCTION(__FILE__, __FUNCTION__);	

	bzero(&req, SIPLEN);
	if (request_generate(requesttype, (char *) &req, 12345, task->transport, &callid) != 1) {
		error(ERR_ERROR, "request_generate() failed");
		return 0;
	}
	state_add(task, callid, requesttype);
	switch (task->transport) {
	case TRANSPORT_UDP:
		udp_send(task, req);
		break;
	case TRANSPORT_TCP:
		error(ERR_ERROR, "TCP transport yet to be implemented");
		break;
	default:
		error(ERR_FATAL, "task->transport broken");
		break;
	}

	return 1;
}

#endif /* _SCAN_C */
