/******************************************************************************
 *
 * sip.c - part of smap
 * 
 * $Id: sip.c,v 1.12 2007-10-14 10:02:18 hscholz Exp $
 *****************************************************************************/
#ifndef _SIP_C
#define _SIP_C

#include "config.h"

/******************************************************************************
 *
 * sip_getheader()
 *
 * return a pointer to the text representation of the header search for
 * including the leading header name
 * Return NULL in case of problems.
 * Don't forget to free the memory!
 *
 *****************************************************************************/

char *sip_getheader(char *msg, char *hdr) {

	char *str = NULL;
	char *p, *n;

	p = strcasestr(msg, hdr);
	if (p == NULL) return NULL;
	p += strlen(hdr); /* skip leading \r\n plus header name */
	while ((*p == ' ') || (*p == '\t') || (*p == ':'))
        p++; /* eat spaces and ':', not 100% SIP complaint ;) */
	n = strstr(p, "\r\n"); /* find end of current line */
	if (n == NULL) return NULL;
	str = malloc((int) (n-p)+1);
	if (!str) return NULL;
	memcpy(str, p, (int) (n-p));
	str[n-p] = '\0';
	return str;

}

/******************************************************************************
 *
 * sip_getheaderp()
 *
 * return pointer + len to header inside a given buffer
 * Does not allocate any memory.
 * Takes a buffer and header name and returns pointer to start of header
 * plus len minus the trailing \r\n
 *
 *****************************************************************************/

int sip_getheaderp(char *buf, char *hdrname, char **dst, int *len) {

	char *p, *q;

	if (!buf) return 0;

	p = strcasestr(buf, hdrname);
	if (!p) return 0;
	p += 2;
	q = strstr(p, "\r\n");
	if (!q) return 0;
	*len = q-p;
	*dst = p;

	return 1;
}

/******************************************************************************
 *
 * sip_getcseq()
 *
 * get Cseq integer from a given buffer
 * takes a char * to the whole SIP message as argument
 *
 *****************************************************************************/

int sip_getcseq(char *buf, unsigned int *cseq) {

	char *p;
	int i = 0;

	if (!buf) return 0;

	p = strcasestr(buf, "\r\nCSeq:");
	if (!p) return 0;
	p += 7;

	while ((*p == ' ') || (*p == '\t'))
		p++; /* eat space */

	while ((p != NULL) && (*p >= '0') && (*p <= '9')) {
		i *= 10;		/* FIXME: overflow possible */
		i += *p - '0';
		p++;
	}
	if (i < 0) return 0;
	*cseq = (unsigned int) i;
	return 1;
}

/******************************************************************************
 *
 * sip_getcseqmethod()
 *
 * get SIP method name from CSeq line
 * takes a char * to the whole SIP message as argument
 *
 *****************************************************************************/

int sip_getcseqmethod(char *buf) {
	char *p;

	if (!buf) return 0;

	p = strcasestr(buf, "\r\nCSeq:");
	if (!p) return 0;
	p += 7;

	while ((*p == ' ') || (*p == '\t'))
		p++; /* eat space */

	while ((p != NULL) && (*p >= '0') && (*p <= '9')) {
		p++; /* eat CSeq value */
	}

	while ((*p == ' ') || (*p == '\t'))
		p++; /* eat space */

	/* method name as string should be here */
	if (!strnstr(p, "INVITE", strlen("INVITE"))) {
		return METH_INVITE;
	} else if (!strnstr(p, "OPTIONS", strlen("OPTIONS"))) {
		return METH_OPTIONS;
	} else if (!strnstr(p, "NEWMETHOD", strlen("NEWMETHOD"))) {
		return METH_NEWMETHOD;
	} else if (!strnstr(p, "PRACK", strlen("PRACK"))) {
		return METH_PRACK;
	} else if (!strnstr(p, "PING", strlen("PING"))) {
		return METH_PING;
	} else {
		/* no match */
		return -1;
	}

}
#endif /* _SIP_C */
