#ifndef _STATS_C
#define _STATS_C
#include "config.h"

/******************************************************************************
 *
 * stats_init()
 *
 * initialize stats structure
 *
 *****************************************************************************/

void stats_init(void) {
	extern struct stats_t stats;

	stats.scanned = 0;
	stats.up = 0;
	stats.sip = 0;
}

/******************************************************************************
 *
 * stats_dump()
 *
 * print scan statistics
 *
 *****************************************************************************/

void stats_dump(void) {
	extern pthread_mutex_t scrlock;

	pthread_mutex_lock(&scrlock);
	if ((config.flags & FLAG_NOICMPPING) || (config.flags & FLAG_NOROOT)) {
		printf("\n%d host%s scanned, %d SIP enabled (%.1f%%)\n",
			stats.scanned, (stats.scanned > 1) ? "s" : "", stats.sip,
			(double) (stats.sip*100)/stats.scanned);
	} else {
		printf("\n%d host%s scanned, %d ICMP reachable,"
			" %d SIP enabled (%.1f%%)\n",
			stats.scanned, (stats.scanned > 1) ? "s" : "", stats.up, stats.sip,
			(double) (stats.sip*100)/stats.scanned);
	}
	pthread_mutex_unlock(&scrlock);
}

#endif /* _STATS_C */
