/******************************************************************************
 *
 * worker.c - part of smap
 *
 * $Id: worker.c,v 1.2 2007-10-07 10:45:20 hscholz Exp $
 *
 *****************************************************************************/
#ifndef _WORKER_C
#define _WORKER_C
#include "config.h"

/******************************************************************************
 *
 * worker_start()
 *
 * manage tasks
 *
 *****************************************************************************/

void *worker_start(void *nix) {
	extern task_t *tasks;
	extern struct stats_t stats;
	extern struct scan_test_t scan_tests[];
	task_t *task, *nexttask;
	struct timeval curtime;
	unsigned int nowmsg;

worker_start:

	task = tasks;
	nowmsg = 0;
	while (task) {
		gettimeofday(&curtime, NULL);
		nexttask = task->next; /* we might remove task so store next task */
		switch (task->state) {
			case S_START:
				error(ERR_DEBUG, "moving %d from S_START to S_PING\n", task->tid);
				task->state = S_PING;
				stats.scanned++;
				/* fall through */
			case S_PING:
				/* check if we have to wait some more */
				if (config.ratelimit && (nowmsg >= config.ratelimit))
					goto worker_ratelimit;
				nowmsg++;

				if (!(config.flags & FLAG_NOROOT) &&
					!(config.flags & FLAG_NOICMPPING)) {
					/* doing ICMP ping */
					(void) icmpping(task->target);
				}
				task->state = S_PROCESSING;
				break;
			case S_PROCESSING:
				error(ERR_DEBUG, "%s/%d request: %s\n", inet_ntoa(task->target), task->tid, scan_tests[task->test].name);

				/* check if we have to wait some more */
				if (config.ratelimit && (nowmsg >= config.ratelimit))
					goto worker_ratelimit;
				nowmsg++;
						
				task->lastmod.tv_sec = curtime.tv_sec;	
				task->lastmod.tv_usec = curtime.tv_usec;	

				/* invoke test */
				scan_do(task, scan_tests[task->test].requesttype);

				task->test++; /* next test */
				/* all tests done? */
				if (scan_tests[task->test].requesttype == 0)
					task->state = S_COLLECT;
				break;
			case S_COLLECT:
				/* wait some time for responses and move to next state */
				task->state = S_DONE;
				break;
			case S_DONE:
				error(ERR_DEBUG, "processing finished task %d\n", task->tid);
				task_finish(task);
				break;
			default:
				error(ERR_ERROR, "worker: %d is in unsupported state!\n", task->tid);
				break;
		}
		task = nexttask;
	}

worker_ratelimit:

	sleep(1);
	/* we sleep exactly one second (well, kind of) to allow
 	 * for quick and dirty message/sec rate calculation
 	 *
 	 * this also allows for some late messages to be still processed
 	 * by listener
 	 */
	if (active_tasks > 0)
		goto worker_start;
	return NULL;
}

#endif /* _WORKER_C */
