#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
#ifndef HEADER_DH_H
# include <openssl/dh.h>
#endif

DH *get_dh2048()
{
    static unsigned char dhp_2048[] = {
	0x89, 0x9D, 0x84, 0xB8, 0x3A, 0x2D, 0xD4, 0xF7, 0x41, 0x5A, 
	0xBB, 0x27, 0x00, 0x69, 0xAE, 0xB4, 0xAC, 0x5E, 0xD8, 0xEB, 
	0xAE, 0x3D, 0x0E, 0x1A, 0x05, 0xD5, 0xE5, 0xEF, 0x2B, 0x8E, 
	0x4F, 0xF3, 0x65, 0x3C, 0xE3, 0x40, 0x6B, 0xFB, 0xA7, 0x24, 
	0x58, 0x85, 0xE4, 0xFA, 0x86, 0x0D, 0xED, 0x8D, 0xBF, 0xA0, 
	0x4D, 0x58, 0xC9, 0x30, 0x26, 0x3B, 0xF0, 0x1E, 0xAF, 0x15, 
	0x6F, 0x4E, 0x71, 0x2D, 0xF1, 0x67, 0xED, 0x44, 0x8C, 0x04, 
	0x04, 0x23, 0xE4, 0xA8, 0x5B, 0x7B, 0x28, 0x32, 0x0D, 0x67, 
	0xBB, 0x7E, 0xE5, 0x1B, 0x58, 0x6F, 0x0C, 0x3C, 0x0A, 0x8A, 
	0x3E, 0xC8, 0x8A, 0x10, 0xCA, 0x74, 0x94, 0x6E, 0xC8, 0xC0, 
	0x52, 0x9C, 0xE5, 0x45, 0xE7, 0x0A, 0x78, 0x9B, 0x30, 0x60, 
	0x70, 0xEA, 0xF2, 0xEF, 0xB6, 0xD5, 0x28, 0x2F, 0xA1, 0x92, 
	0xA6, 0x94, 0x45, 0x03, 0x5A, 0x8F, 0xF3, 0x17, 0x93, 0x99, 
	0x28, 0x1B, 0x9C, 0xE1, 0x3F, 0x96, 0x4E, 0x95, 0x62, 0x72, 
	0x79, 0x8E, 0xD9, 0xE6, 0x42, 0xEF, 0xF5, 0x46, 0xBF, 0xB3, 
	0x2B, 0x23, 0x5D, 0xEF, 0x11, 0x18, 0x81, 0x85, 0xBB, 0xD9, 
	0xD1, 0x32, 0x96, 0xEE, 0x98, 0x8C, 0x14, 0x6E, 0x57, 0x68, 
	0xAD, 0x5B, 0xE0, 0xF4, 0x7A, 0x75, 0x9E, 0x8D, 0xB0, 0x18, 
	0x9A, 0xFD, 0x1E, 0x0C, 0xD9, 0x23, 0x4B, 0xF1, 0xF3, 0x92, 
	0xD8, 0x23, 0x41, 0xE0, 0xEC, 0x94, 0xDE, 0xF3, 0x34, 0x87, 
	0xF6, 0x87, 0x35, 0xF4, 0x48, 0x9B, 0xB7, 0x3B, 0x4E, 0xCD, 
	0x1A, 0x8D, 0xFC, 0x5A, 0xD1, 0x39, 0x41, 0x33, 0x66, 0xE2, 
	0x06, 0xEE, 0x2C, 0x1B, 0x5F, 0x5C, 0xB2, 0xF2, 0xB3, 0xBA, 
	0xA3, 0x58, 0x8B, 0xF2, 0xD2, 0x9A, 0xAF, 0x03, 0xA2, 0x84, 
	0x7D, 0xA1, 0xAA, 0x23, 0x3A, 0x7B, 0xE2, 0xF8, 0xAF, 0xA6, 
	0xE3, 0x5B, 0xCE, 0x25, 0x68, 0x7B
    };
    static unsigned char dhg_2048[] = {
	0x02
    };
    DH *dh = DH_new();
    BIGNUM *dhp_bn, *dhg_bn;

    if (dh == NULL)
        return NULL;
    dhp_bn = BN_bin2bn(dhp_2048, sizeof (dhp_2048), NULL);
    dhg_bn = BN_bin2bn(dhg_2048, sizeof (dhg_2048), NULL);
    if (dhp_bn == NULL || dhg_bn == NULL
            || !DH_set0_pqg(dh, dhp_bn, NULL, dhg_bn)) {
        DH_free(dh);
        BN_free(dhp_bn);
        BN_free(dhg_bn);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
