/*
 * Decompiled with CFR 0.152.
 */
package org.junit;

import org.junit.Assert;

public class ComparisonFailure
extends AssertionError {
    private static final int MAX_CONTEXT_LENGTH = 20;
    private static final long serialVersionUID = 1L;
    private String fExpected;
    private String fActual;

    public ComparisonFailure(String string, String string2, String string3) {
        super((Object)string);
        this.fExpected = string2;
        this.fActual = string3;
    }

    public String getMessage() {
        return new ComparisonCompactor(20, this.fExpected, this.fActual).compact(super.getMessage());
    }

    public String getActual() {
        return this.fActual;
    }

    public String getExpected() {
        return this.fExpected;
    }

    private static class ComparisonCompactor {
        private static final String ELLIPSIS = "...";
        private static final String DIFF_END = "]";
        private static final String DIFF_START = "[";
        private final int contextLength;
        private final String expected;
        private final String actual;

        public ComparisonCompactor(int n, String string, String string2) {
            this.contextLength = n;
            this.expected = string;
            this.actual = string2;
        }

        public String compact(String string) {
            if (this.expected == null || this.actual == null || this.expected.equals(this.actual)) {
                return Assert.format(string, this.expected, this.actual);
            }
            DiffExtractor diffExtractor = new DiffExtractor();
            String string2 = diffExtractor.compactPrefix();
            String string3 = diffExtractor.compactSuffix();
            return Assert.format(string, string2 + diffExtractor.expectedDiff() + string3, string2 + diffExtractor.actualDiff() + string3);
        }

        private String sharedPrefix() {
            int n = Math.min(this.expected.length(), this.actual.length());
            for (int i = 0; i < n; ++i) {
                if (this.expected.charAt(i) == this.actual.charAt(i)) continue;
                return this.expected.substring(0, i);
            }
            return this.expected.substring(0, n);
        }

        private String sharedSuffix(String string) {
            int n;
            int n2 = Math.min(this.expected.length() - string.length(), this.actual.length() - string.length()) - 1;
            for (n = 0; n <= n2 && this.expected.charAt(this.expected.length() - 1 - n) == this.actual.charAt(this.actual.length() - 1 - n); ++n) {
            }
            return this.expected.substring(this.expected.length() - n);
        }

        private class DiffExtractor {
            private final String sharedPrefix;
            private final String sharedSuffix;

            private DiffExtractor() {
                this.sharedPrefix = ComparisonCompactor.this.sharedPrefix();
                this.sharedSuffix = ComparisonCompactor.this.sharedSuffix(this.sharedPrefix);
            }

            public String expectedDiff() {
                return this.extractDiff(ComparisonCompactor.this.expected);
            }

            public String actualDiff() {
                return this.extractDiff(ComparisonCompactor.this.actual);
            }

            public String compactPrefix() {
                if (this.sharedPrefix.length() <= ComparisonCompactor.this.contextLength) {
                    return this.sharedPrefix;
                }
                return ComparisonCompactor.ELLIPSIS + this.sharedPrefix.substring(this.sharedPrefix.length() - ComparisonCompactor.this.contextLength);
            }

            public String compactSuffix() {
                if (this.sharedSuffix.length() <= ComparisonCompactor.this.contextLength) {
                    return this.sharedSuffix;
                }
                return this.sharedSuffix.substring(0, ComparisonCompactor.this.contextLength) + ComparisonCompactor.ELLIPSIS;
            }

            private String extractDiff(String string) {
                return ComparisonCompactor.DIFF_START + string.substring(this.sharedPrefix.length(), string.length() - this.sharedSuffix.length()) + ComparisonCompactor.DIFF_END;
            }
        }
    }
}

