/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.internal.ArrayComparisonFailure;

public abstract class ComparisonCriteria {
    public void arrayEquals(String string, Object object, Object object2) throws ArrayComparisonFailure {
        if (object == object2 || Arrays.deepEquals(new Object[]{object}, new Object[]{object2})) {
            return;
        }
        String string2 = string == null ? "" : string + ": ";
        int n = this.assertArraysAreSameLength(object, object2, string2);
        for (int i = 0; i < n; ++i) {
            Object object3 = Array.get(object, i);
            Object object4 = Array.get(object2, i);
            if (this.isArray(object3) && this.isArray(object4)) {
                try {
                    this.arrayEquals(string, object3, object4);
                    continue;
                }
                catch (ArrayComparisonFailure arrayComparisonFailure) {
                    arrayComparisonFailure.addDimension(i);
                    throw arrayComparisonFailure;
                }
            }
            try {
                this.assertElementsEqual(object3, object4);
                continue;
            }
            catch (AssertionError assertionError) {
                throw new ArrayComparisonFailure(string2, assertionError, i);
            }
        }
    }

    private boolean isArray(Object object) {
        return object != null && object.getClass().isArray();
    }

    private int assertArraysAreSameLength(Object object, Object object2, String string) {
        int n;
        int n2;
        if (object == null) {
            Assert.fail(string + "expected array was null");
        }
        if (object2 == null) {
            Assert.fail(string + "actual array was null");
        }
        if ((n2 = Array.getLength(object2)) != (n = Array.getLength(object))) {
            Assert.fail(string + "array lengths differed, expected.length=" + n + " actual.length=" + n2);
        }
        return n;
    }

    protected abstract void assertElementsEqual(Object var1, Object var2);
}

