/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners.rules;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.internal.runners.rules.ValidationError;
import org.junit.rules.MethodRule;
import org.junit.rules.TestRule;
import org.junit.runners.model.FrameworkMember;
import org.junit.runners.model.TestClass;

public class RuleMemberValidator {
    public static final RuleMemberValidator CLASS_RULE_VALIDATOR = RuleMemberValidator.classRuleValidatorBuilder().withValidator(new DeclaringClassMustBePublic()).withValidator(new MemberMustBeStatic()).withValidator(new MemberMustBePublic()).withValidator(new FieldMustBeATestRule()).build();
    public static final RuleMemberValidator RULE_VALIDATOR = RuleMemberValidator.testRuleValidatorBuilder().withValidator(new MemberMustBeNonStaticOrAlsoClassRule()).withValidator(new MemberMustBePublic()).withValidator(new FieldMustBeARule()).build();
    public static final RuleMemberValidator CLASS_RULE_METHOD_VALIDATOR = RuleMemberValidator.classRuleValidatorBuilder().forMethods().withValidator(new DeclaringClassMustBePublic()).withValidator(new MemberMustBeStatic()).withValidator(new MemberMustBePublic()).withValidator(new MethodMustBeATestRule()).build();
    public static final RuleMemberValidator RULE_METHOD_VALIDATOR = RuleMemberValidator.testRuleValidatorBuilder().forMethods().withValidator(new MemberMustBeNonStaticOrAlsoClassRule()).withValidator(new MemberMustBePublic()).withValidator(new MethodMustBeARule()).build();
    private final Class<? extends Annotation> annotation;
    private final boolean methods;
    private final List<RuleValidator> validatorStrategies;

    RuleMemberValidator(Builder builder) {
        this.annotation = builder.annotation;
        this.methods = builder.methods;
        this.validatorStrategies = builder.validators;
    }

    public void validate(TestClass testClass, List<Throwable> list) {
        List<FrameworkMember> list2 = this.methods ? testClass.getAnnotatedMethods(this.annotation) : testClass.getAnnotatedFields(this.annotation);
        for (FrameworkMember frameworkMember : list2) {
            this.validateMember(frameworkMember, list);
        }
    }

    private void validateMember(FrameworkMember<?> frameworkMember, List<Throwable> list) {
        for (RuleValidator ruleValidator : this.validatorStrategies) {
            ruleValidator.validate(frameworkMember, this.annotation, list);
        }
    }

    private static Builder classRuleValidatorBuilder() {
        return new Builder(ClassRule.class);
    }

    private static Builder testRuleValidatorBuilder() {
        return new Builder(Rule.class);
    }

    private static boolean isRuleType(FrameworkMember<?> frameworkMember) {
        return RuleMemberValidator.isMethodRule(frameworkMember) || RuleMemberValidator.isTestRule(frameworkMember);
    }

    private static boolean isTestRule(FrameworkMember<?> frameworkMember) {
        return TestRule.class.isAssignableFrom(frameworkMember.getType());
    }

    private static boolean isMethodRule(FrameworkMember<?> frameworkMember) {
        return MethodRule.class.isAssignableFrom(frameworkMember.getType());
    }

    private static final class FieldMustBeATestRule
    implements RuleValidator {
        private FieldMustBeATestRule() {
        }

        @Override
        public void validate(FrameworkMember<?> frameworkMember, Class<? extends Annotation> clazz, List<Throwable> list) {
            if (!RuleMemberValidator.isTestRule(frameworkMember)) {
                list.add(new ValidationError(frameworkMember, clazz, "must implement TestRule."));
            }
        }
    }

    private static final class MethodMustBeATestRule
    implements RuleValidator {
        private MethodMustBeATestRule() {
        }

        @Override
        public void validate(FrameworkMember<?> frameworkMember, Class<? extends Annotation> clazz, List<Throwable> list) {
            if (!RuleMemberValidator.isTestRule(frameworkMember)) {
                list.add(new ValidationError(frameworkMember, clazz, "must return an implementation of TestRule."));
            }
        }
    }

    private static final class MethodMustBeARule
    implements RuleValidator {
        private MethodMustBeARule() {
        }

        @Override
        public void validate(FrameworkMember<?> frameworkMember, Class<? extends Annotation> clazz, List<Throwable> list) {
            if (!RuleMemberValidator.isRuleType(frameworkMember)) {
                list.add(new ValidationError(frameworkMember, clazz, "must return an implementation of MethodRule or TestRule."));
            }
        }
    }

    private static final class FieldMustBeARule
    implements RuleValidator {
        private FieldMustBeARule() {
        }

        @Override
        public void validate(FrameworkMember<?> frameworkMember, Class<? extends Annotation> clazz, List<Throwable> list) {
            if (!RuleMemberValidator.isRuleType(frameworkMember)) {
                list.add(new ValidationError(frameworkMember, clazz, "must implement MethodRule or TestRule."));
            }
        }
    }

    private static final class MemberMustBePublic
    implements RuleValidator {
        private MemberMustBePublic() {
        }

        @Override
        public void validate(FrameworkMember<?> frameworkMember, Class<? extends Annotation> clazz, List<Throwable> list) {
            if (!frameworkMember.isPublic()) {
                list.add(new ValidationError(frameworkMember, clazz, "must be public."));
            }
        }
    }

    private static final class DeclaringClassMustBePublic
    implements RuleValidator {
        private DeclaringClassMustBePublic() {
        }

        @Override
        public void validate(FrameworkMember<?> frameworkMember, Class<? extends Annotation> clazz, List<Throwable> list) {
            if (!this.isDeclaringClassPublic(frameworkMember)) {
                list.add(new ValidationError(frameworkMember, clazz, "must be declared in a public class."));
            }
        }

        private boolean isDeclaringClassPublic(FrameworkMember<?> frameworkMember) {
            return Modifier.isPublic(frameworkMember.getDeclaringClass().getModifiers());
        }
    }

    private static final class MemberMustBeStatic
    implements RuleValidator {
        private MemberMustBeStatic() {
        }

        @Override
        public void validate(FrameworkMember<?> frameworkMember, Class<? extends Annotation> clazz, List<Throwable> list) {
            if (!frameworkMember.isStatic()) {
                list.add(new ValidationError(frameworkMember, clazz, "must be static."));
            }
        }
    }

    private static final class MemberMustBeNonStaticOrAlsoClassRule
    implements RuleValidator {
        private MemberMustBeNonStaticOrAlsoClassRule() {
        }

        @Override
        public void validate(FrameworkMember<?> frameworkMember, Class<? extends Annotation> clazz, List<Throwable> list) {
            boolean bl;
            boolean bl2 = RuleMemberValidator.isMethodRule(frameworkMember);
            boolean bl3 = bl = frameworkMember.getAnnotation(ClassRule.class) != null;
            if (frameworkMember.isStatic() && (bl2 || !bl)) {
                String string = RuleMemberValidator.isMethodRule(frameworkMember) ? "must not be static." : "must not be static or it must be annotated with @ClassRule.";
                list.add(new ValidationError(frameworkMember, clazz, string));
            }
        }
    }

    static interface RuleValidator {
        public void validate(FrameworkMember<?> var1, Class<? extends Annotation> var2, List<Throwable> var3);
    }

    private static class Builder {
        private final Class<? extends Annotation> annotation;
        private boolean methods;
        private final List<RuleValidator> validators;

        private Builder(Class<? extends Annotation> clazz) {
            this.annotation = clazz;
            this.methods = false;
            this.validators = new ArrayList<RuleValidator>();
        }

        Builder forMethods() {
            this.methods = true;
            return this;
        }

        Builder withValidator(RuleValidator ruleValidator) {
            this.validators.add(ruleValidator);
            return this;
        }

        RuleMemberValidator build() {
            return new RuleMemberValidator(this);
        }
    }
}

