/*
 * Decompiled with CFR 0.152.
 */
package org.junit.rules;

import java.lang.management.ManagementFactory;
import java.util.List;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class DisableOnDebug
implements TestRule {
    private final TestRule rule;
    private final boolean debugging;

    public DisableOnDebug(TestRule testRule) {
        this(testRule, ManagementFactory.getRuntimeMXBean().getInputArguments());
    }

    DisableOnDebug(TestRule testRule, List<String> list) {
        this.rule = testRule;
        this.debugging = DisableOnDebug.isDebugging(list);
    }

    @Override
    public Statement apply(Statement statement, Description description) {
        if (this.debugging) {
            return statement;
        }
        return this.rule.apply(statement, description);
    }

    private static boolean isDebugging(List<String> list) {
        for (String string : list) {
            if ("-Xdebug".equals(string)) {
                return true;
            }
            if (!string.startsWith("-agentlib:jdwp")) continue;
            return true;
        }
        return false;
    }

    public boolean isDebugging() {
        return this.debugging;
    }
}

