/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runners;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.List;
import org.junit.internal.builders.AllDefaultPossibilitiesBuilder;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class Suite
extends ParentRunner<Runner> {
    private final List<Runner> runners;

    public static Runner emptySuite() {
        try {
            return new Suite((Class)null, new Class[0]);
        }
        catch (InitializationError initializationError) {
            throw new RuntimeException("This shouldn't be possible");
        }
    }

    private static Class<?>[] getAnnotatedClasses(Class<?> clazz) throws InitializationError {
        SuiteClasses suiteClasses = clazz.getAnnotation(SuiteClasses.class);
        if (suiteClasses == null) {
            throw new InitializationError(String.format("class '%s' must have a SuiteClasses annotation", clazz.getName()));
        }
        return suiteClasses.value();
    }

    public Suite(Class<?> clazz, RunnerBuilder runnerBuilder) throws InitializationError {
        this(runnerBuilder, clazz, Suite.getAnnotatedClasses(clazz));
    }

    public Suite(RunnerBuilder runnerBuilder, Class<?>[] classArray) throws InitializationError {
        this(null, runnerBuilder.runners(null, classArray));
    }

    protected Suite(Class<?> clazz, Class<?>[] classArray) throws InitializationError {
        this(new AllDefaultPossibilitiesBuilder(true), clazz, classArray);
    }

    protected Suite(RunnerBuilder runnerBuilder, Class<?> clazz, Class<?>[] classArray) throws InitializationError {
        this(clazz, runnerBuilder.runners(clazz, classArray));
    }

    protected Suite(Class<?> clazz, List<Runner> list) throws InitializationError {
        super(clazz);
        this.runners = Collections.unmodifiableList(list);
    }

    @Override
    protected List<Runner> getChildren() {
        return this.runners;
    }

    @Override
    protected Description describeChild(Runner runner) {
        return runner.getDescription();
    }

    @Override
    protected void runChild(Runner runner, RunNotifier runNotifier) {
        runner.run(runNotifier);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface SuiteClasses {
        public Class<?>[] value();
    }
}

