/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental.categories;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runners.model.FrameworkMethod;
import org.junit.validator.AnnotationValidator;

public final class CategoryValidator
extends AnnotationValidator {
    private static final Set<Class<? extends Annotation>> INCOMPATIBLE_ANNOTATIONS = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(BeforeClass.class, AfterClass.class, Before.class, After.class)));

    @Override
    public List<Exception> validateAnnotatedMethod(FrameworkMethod frameworkMethod) {
        Annotation[] annotationArray;
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        for (Annotation annotation : annotationArray = frameworkMethod.getAnnotations()) {
            for (Class<? extends Annotation> clazz : INCOMPATIBLE_ANNOTATIONS) {
                if (!annotation.annotationType().isAssignableFrom(clazz)) continue;
                this.addErrorMessage(arrayList, clazz);
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    private void addErrorMessage(List<Exception> list, Class<?> clazz) {
        String string = String.format("@%s can not be combined with @Category", clazz.getSimpleName());
        list.add(new Exception(string));
    }
}

