/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runners;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.internal.runners.rules.RuleMemberValidator;
import org.junit.internal.runners.statements.ExpectException;
import org.junit.internal.runners.statements.Fail;
import org.junit.internal.runners.statements.FailOnTimeout;
import org.junit.internal.runners.statements.InvokeMethod;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.MethodRule;
import org.junit.rules.RunRules;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class BlockJUnit4ClassRunner
extends ParentRunner<FrameworkMethod> {
    private final ConcurrentHashMap<FrameworkMethod, Description> methodDescriptions = new ConcurrentHashMap();

    public BlockJUnit4ClassRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    @Override
    protected void runChild(FrameworkMethod frameworkMethod, RunNotifier runNotifier) {
        Description description = this.describeChild(frameworkMethod);
        if (this.isIgnored(frameworkMethod)) {
            runNotifier.fireTestIgnored(description);
        } else {
            this.runLeaf(this.methodBlock(frameworkMethod), description, runNotifier);
        }
    }

    @Override
    protected boolean isIgnored(FrameworkMethod frameworkMethod) {
        return frameworkMethod.getAnnotation(Ignore.class) != null;
    }

    @Override
    protected Description describeChild(FrameworkMethod frameworkMethod) {
        Description description = this.methodDescriptions.get(frameworkMethod);
        if (description == null) {
            description = Description.createTestDescription(this.getTestClass().getJavaClass(), this.testName(frameworkMethod), frameworkMethod.getAnnotations());
            this.methodDescriptions.putIfAbsent(frameworkMethod, description);
        }
        return description;
    }

    @Override
    protected List<FrameworkMethod> getChildren() {
        return this.computeTestMethods();
    }

    protected List<FrameworkMethod> computeTestMethods() {
        return this.getTestClass().getAnnotatedMethods(Test.class);
    }

    @Override
    protected void collectInitializationErrors(List<Throwable> list) {
        super.collectInitializationErrors(list);
        this.validateNoNonStaticInnerClass(list);
        this.validateConstructor(list);
        this.validateInstanceMethods(list);
        this.validateFields(list);
        this.validateMethods(list);
    }

    protected void validateNoNonStaticInnerClass(List<Throwable> list) {
        if (this.getTestClass().isANonStaticInnerClass()) {
            String string = "The inner class " + this.getTestClass().getName() + " is not static.";
            list.add(new Exception(string));
        }
    }

    protected void validateConstructor(List<Throwable> list) {
        this.validateOnlyOneConstructor(list);
        this.validateZeroArgConstructor(list);
    }

    protected void validateOnlyOneConstructor(List<Throwable> list) {
        if (!this.hasOneConstructor()) {
            String string = "Test class should have exactly one public constructor";
            list.add(new Exception(string));
        }
    }

    protected void validateZeroArgConstructor(List<Throwable> list) {
        if (!this.getTestClass().isANonStaticInnerClass() && this.hasOneConstructor() && this.getTestClass().getOnlyConstructor().getParameterTypes().length != 0) {
            String string = "Test class should have exactly one public zero-argument constructor";
            list.add(new Exception(string));
        }
    }

    private boolean hasOneConstructor() {
        return this.getTestClass().getJavaClass().getConstructors().length == 1;
    }

    @Deprecated
    protected void validateInstanceMethods(List<Throwable> list) {
        this.validatePublicVoidNoArgMethods(After.class, false, list);
        this.validatePublicVoidNoArgMethods(Before.class, false, list);
        this.validateTestMethods(list);
        if (this.computeTestMethods().size() == 0) {
            list.add(new Exception("No runnable methods"));
        }
    }

    protected void validateFields(List<Throwable> list) {
        RuleMemberValidator.RULE_VALIDATOR.validate(this.getTestClass(), list);
    }

    private void validateMethods(List<Throwable> list) {
        RuleMemberValidator.RULE_METHOD_VALIDATOR.validate(this.getTestClass(), list);
    }

    protected void validateTestMethods(List<Throwable> list) {
        this.validatePublicVoidNoArgMethods(Test.class, false, list);
    }

    protected Object createTest() throws Exception {
        return this.getTestClass().getOnlyConstructor().newInstance(new Object[0]);
    }

    protected String testName(FrameworkMethod frameworkMethod) {
        return frameworkMethod.getName();
    }

    protected Statement methodBlock(FrameworkMethod frameworkMethod) {
        Object object;
        try {
            object = new ReflectiveCallable(){

                @Override
                protected Object runReflectiveCall() throws Throwable {
                    return BlockJUnit4ClassRunner.this.createTest();
                }
            }.run();
        }
        catch (Throwable throwable) {
            return new Fail(throwable);
        }
        Statement statement = this.methodInvoker(frameworkMethod, object);
        statement = this.possiblyExpectingExceptions(frameworkMethod, object, statement);
        statement = this.withPotentialTimeout(frameworkMethod, object, statement);
        statement = this.withBefores(frameworkMethod, object, statement);
        statement = this.withAfters(frameworkMethod, object, statement);
        statement = this.withRules(frameworkMethod, object, statement);
        return statement;
    }

    protected Statement methodInvoker(FrameworkMethod frameworkMethod, Object object) {
        return new InvokeMethod(frameworkMethod, object);
    }

    protected Statement possiblyExpectingExceptions(FrameworkMethod frameworkMethod, Object object, Statement statement) {
        Test test = frameworkMethod.getAnnotation(Test.class);
        return this.expectsException(test) ? new ExpectException(statement, this.getExpectedException(test)) : statement;
    }

    @Deprecated
    protected Statement withPotentialTimeout(FrameworkMethod frameworkMethod, Object object, Statement statement) {
        long l = this.getTimeout(frameworkMethod.getAnnotation(Test.class));
        if (l <= 0L) {
            return statement;
        }
        return FailOnTimeout.builder().withTimeout(l, TimeUnit.MILLISECONDS).build(statement);
    }

    protected Statement withBefores(FrameworkMethod frameworkMethod, Object object, Statement statement) {
        List<FrameworkMethod> list = this.getTestClass().getAnnotatedMethods(Before.class);
        return list.isEmpty() ? statement : new RunBefores(statement, list, object);
    }

    protected Statement withAfters(FrameworkMethod frameworkMethod, Object object, Statement statement) {
        List<FrameworkMethod> list = this.getTestClass().getAnnotatedMethods(After.class);
        return list.isEmpty() ? statement : new RunAfters(statement, list, object);
    }

    private Statement withRules(FrameworkMethod frameworkMethod, Object object, Statement statement) {
        List<TestRule> list = this.getTestRules(object);
        Statement statement2 = statement;
        statement2 = this.withMethodRules(frameworkMethod, list, object, statement2);
        statement2 = this.withTestRules(frameworkMethod, list, statement2);
        return statement2;
    }

    private Statement withMethodRules(FrameworkMethod frameworkMethod, List<TestRule> list, Object object, Statement statement) {
        for (MethodRule methodRule : this.getMethodRules(object)) {
            if (list.contains(methodRule)) continue;
            statement = methodRule.apply(statement, frameworkMethod, object);
        }
        return statement;
    }

    private List<MethodRule> getMethodRules(Object object) {
        return this.rules(object);
    }

    protected List<MethodRule> rules(Object object) {
        List<MethodRule> list = this.getTestClass().getAnnotatedMethodValues(object, Rule.class, MethodRule.class);
        list.addAll(this.getTestClass().getAnnotatedFieldValues(object, Rule.class, MethodRule.class));
        return list;
    }

    private Statement withTestRules(FrameworkMethod frameworkMethod, List<TestRule> list, Statement statement) {
        return list.isEmpty() ? statement : new RunRules(statement, list, this.describeChild(frameworkMethod));
    }

    protected List<TestRule> getTestRules(Object object) {
        List<TestRule> list = this.getTestClass().getAnnotatedMethodValues(object, Rule.class, TestRule.class);
        list.addAll(this.getTestClass().getAnnotatedFieldValues(object, Rule.class, TestRule.class));
        return list;
    }

    private Class<? extends Throwable> getExpectedException(Test test) {
        if (test == null || test.expected() == Test.None.class) {
            return null;
        }
        return test.expected();
    }

    private boolean expectsException(Test test) {
        return this.getExpectedException(test) != null;
    }

    private long getTimeout(Test test) {
        if (test == null) {
            return 0L;
        }
        return test.timeout();
    }
}

