/*
 * Copyright (C) 2014 - 2016 Freescale Semiconductor, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0+
 */

#ifndef __ASM_ARCH_IMX6SLL_PINS_H__
#define __ASM_ARCH_IMX6SLL_PINS_H__

#include <asm/imx-common/iomux-v3.h>

enum {
	MX6_PAD_WDOG_B__WDOG1_B                               = IOMUX_PAD(0x02DC, 0x0014, 0, 0x0000, 0, 0),
	MX6_PAD_WDOG_B__WDOG1_RESET_B_DEB                     = IOMUX_PAD(0x02DC, 0x0014, 1, 0x0000, 0, 0),
	MX6_PAD_WDOG_B__UART5_RI_B                            = IOMUX_PAD(0x02DC, 0x0014, 2, 0x0000, 0, 0),
	MX6_PAD_WDOG_B__GPIO3_IO18                            = IOMUX_PAD(0x02DC, 0x0014, 5, 0x0000, 0, 0),

	MX6_PAD_REF_CLK_24M__XTALOSC_REF_CLK_24M              = IOMUX_PAD(0x02E0, 0x0018, 0, 0x0000, 0, 0),
	MX6_PAD_REF_CLK_24M__I2C3_SCL                         = IOMUX_PAD(0x02E0, 0x0018, IOMUX_CONFIG_SION | 1, 0x068C, 0, 0),
	MX6_PAD_REF_CLK_24M__PWM3_OUT                         = IOMUX_PAD(0x02E0, 0x0018, 2, 0x0000, 0, 0),
	MX6_PAD_REF_CLK_24M__USB_OTG2_ID                      = IOMUX_PAD(0x02E0, 0x0018, 3, 0x0560, 0, 0),
	MX6_PAD_REF_CLK_24M__CCM_PMIC_READY                   = IOMUX_PAD(0x02E0, 0x0018, 4, 0x05AC, 0, 0),
	MX6_PAD_REF_CLK_24M__GPIO3_IO21                       = IOMUX_PAD(0x02E0, 0x0018, 5, 0x0000, 0, 0),
	MX6_PAD_REF_CLK_24M__SD3_WP                           = IOMUX_PAD(0x02E0, 0x0018, 6, 0x0794, 0, 0),

	MX6_PAD_REF_CLK_32K__XTALOSC_REF_CLK_32K              = IOMUX_PAD(0x02E4, 0x001C, 0, 0x0000, 0, 0),
	MX6_PAD_REF_CLK_32K__I2C3_SDA                         = IOMUX_PAD(0x02E4, 0x001C, IOMUX_CONFIG_SION | 1, 0x0690, 0, 0),
	MX6_PAD_REF_CLK_32K__PWM4_OUT                         = IOMUX_PAD(0x02E4, 0x001C, 2, 0x0000, 0, 0),
	MX6_PAD_REF_CLK_32K__USB_OTG1_ID                      = IOMUX_PAD(0x02E4, 0x001C, 3, 0x055C, 0, 0),
	MX6_PAD_REF_CLK_32K__SD1_LCTL                         = IOMUX_PAD(0x02E4, 0x001C, 4, 0x0000, 0, 0),
	MX6_PAD_REF_CLK_32K__GPIO3_IO22                       = IOMUX_PAD(0x02E4, 0x001C, 5, 0x0000, 0, 0),
	MX6_PAD_REF_CLK_32K__SD3_CD_B                         = IOMUX_PAD(0x02E4, 0x001C, 6, 0x0780, 0, 0),

	MX6_PAD_PWM1__PWM1_OUT                                = IOMUX_PAD(0x02E8, 0x0020, 0, 0x0000, 0, 0),
	MX6_PAD_PWM1__CCM_CLKO                                = IOMUX_PAD(0x02E8, 0x0020, 1, 0x0000, 0, 0),
	MX6_PAD_PWM1__AUDIO_CLK_OUT                           = IOMUX_PAD(0x02E8, 0x0020, 2, 0x0000, 0, 0),
	MX6_PAD_PWM1__CSI_MCLK                                = IOMUX_PAD(0x02E8, 0x0020, 4, 0x0000, 0, 0),
	MX6_PAD_PWM1__GPIO3_IO23                              = IOMUX_PAD(0x02E8, 0x0020, 5, 0x0000, 0, 0),
	MX6_PAD_PWM1__EPIT1_OUT                               = IOMUX_PAD(0x02E8, 0x0020, 6, 0x0000, 0, 0),

	MX6_PAD_KEY_COL0__KEY_COL0                            = IOMUX_PAD(0x02EC, 0x0024, 0, 0x06A0, 0, 0),
	MX6_PAD_KEY_COL0__I2C2_SCL                            = IOMUX_PAD(0x02EC, 0x0024, IOMUX_CONFIG_SION | 1, 0x0684, 0, 0),
	MX6_PAD_KEY_COL0__LCD_DATA00                          = IOMUX_PAD(0x02EC, 0x0024, 2, 0x06D8, 0, 0),
	MX6_PAD_KEY_COL0__SD1_CD_B                            = IOMUX_PAD(0x02EC, 0x0024, 4, 0x0770, 1, 0),
	MX6_PAD_KEY_COL0__GPIO3_IO24                          = IOMUX_PAD(0x02EC, 0x0024, 5, 0x0000, 0, 0),

	MX6_PAD_KEY_ROW0__KEY_ROW0                            = IOMUX_PAD(0x02F0, 0x0028, 0, 0x06C0, 0, 0),
	MX6_PAD_KEY_ROW0__I2C2_SDA                            = IOMUX_PAD(0x02F0, 0x0028, IOMUX_CONFIG_SION | 1, 0x0688, 0, 0),
	MX6_PAD_KEY_ROW0__LCD_DATA01                          = IOMUX_PAD(0x02F0, 0x0028, 2, 0x06DC, 0, 0),
	MX6_PAD_KEY_ROW0__SD1_WP                              = IOMUX_PAD(0x02F0, 0x0028, 4, 0x0774, 1, 0),
	MX6_PAD_KEY_ROW0__GPIO3_IO25                          = IOMUX_PAD(0x02F0, 0x0028, 5, 0x0000, 0, 0),

	MX6_PAD_KEY_COL1__KEY_COL1                            = IOMUX_PAD(0x02F4, 0x002C, 0, 0x06A4, 0, 0),
	MX6_PAD_KEY_COL1__ECSPI4_MOSI                         = IOMUX_PAD(0x02F4, 0x002C, 1, 0x0658, 1, 0),
	MX6_PAD_KEY_COL1__LCD_DATA02                          = IOMUX_PAD(0x02F4, 0x002C, 2, 0x06E0, 0, 0),
	MX6_PAD_KEY_COL1__SD3_DATA4                           = IOMUX_PAD(0x02F4, 0x002C, 4, 0x0784, 0, 0),
	MX6_PAD_KEY_COL1__GPIO3_IO26                          = IOMUX_PAD(0x02F4, 0x002C, 5, 0x0000, 0, 0),

	MX6_PAD_KEY_ROW1__KEY_ROW1                            = IOMUX_PAD(0x02F8, 0x0030, 0, 0x06C4, 0, 0),
	MX6_PAD_KEY_ROW1__ECSPI4_MISO                         = IOMUX_PAD(0x02F8, 0x0030, 1, 0x0654, 1, 0),
	MX6_PAD_KEY_ROW1__LCD_DATA03                          = IOMUX_PAD(0x02F8, 0x0030, 2, 0x06E4, 0, 0),
	MX6_PAD_KEY_ROW1__CSI_FIELD                           = IOMUX_PAD(0x02F8, 0x0030, 3, 0x0000, 0, 0),
	MX6_PAD_KEY_ROW1__SD3_DATA5                           = IOMUX_PAD(0x02F8, 0x0030, 4, 0x0788, 0, 0),
	MX6_PAD_KEY_ROW1__GPIO3_IO27                          = IOMUX_PAD(0x02F8, 0x0030, 5, 0x0000, 0, 0),

	MX6_PAD_KEY_COL2__KEY_COL2                            = IOMUX_PAD(0x02FC, 0x0034, 0, 0x06A8, 0, 0),
	MX6_PAD_KEY_COL2__ECSPI4_SS0                          = IOMUX_PAD(0x02FC, 0x0034, 1, 0x065C, 1, 0),
	MX6_PAD_KEY_COL2__LCD_DATA04                          = IOMUX_PAD(0x02FC, 0x0034, 2, 0x06E8, 0, 0),
	MX6_PAD_KEY_COL2__CSI_DATA12                          = IOMUX_PAD(0x02FC, 0x0034, 3, 0x05B8, 1, 0),
	MX6_PAD_KEY_COL2__SD3_DATA6                           = IOMUX_PAD(0x02FC, 0x0034, 4, 0x078C, 0, 0),
	MX6_PAD_KEY_COL2__GPIO3_IO28                          = IOMUX_PAD(0x02FC, 0x0034, 5, 0x0000, 0, 0),

	MX6_PAD_KEY_ROW2__KEY_ROW2                            = IOMUX_PAD(0x0300, 0x0038, 0, 0x06C8, 0, 0),
	MX6_PAD_KEY_ROW2__ECSPI4_SCLK                         = IOMUX_PAD(0x0300, 0x0038, 1, 0x0650, 1, 0),
	MX6_PAD_KEY_ROW2__LCD_DATA05                          = IOMUX_PAD(0x0300, 0x0038, 2, 0x06EC, 0, 0),
	MX6_PAD_KEY_ROW2__CSI_DATA13                          = IOMUX_PAD(0x0300, 0x0038, 3, 0x05BC, 1, 0),
	MX6_PAD_KEY_ROW2__SD3_DATA7                           = IOMUX_PAD(0x0300, 0x0038, 4, 0x0790, 0, 0),
	MX6_PAD_KEY_ROW2__GPIO3_IO29                          = IOMUX_PAD(0x0300, 0x0038, 5, 0x0000, 0, 0),

	MX6_PAD_KEY_COL3__KEY_COL3                            = IOMUX_PAD(0x0304, 0x003C, 0, 0x06AC, 0, 0),
	MX6_PAD_KEY_COL3__AUD6_RXFS                           = IOMUX_PAD(0x0304, 0x003C, 1, 0x05A0, 1, 0),
	MX6_PAD_KEY_COL3__LCD_DATA06                          = IOMUX_PAD(0x0304, 0x003C, 2, 0x06F0, 0, 0),
	MX6_PAD_KEY_COL3__CSI_DATA14                          = IOMUX_PAD(0x0304, 0x003C, 3, 0x05C0, 1, 0),
	MX6_PAD_KEY_COL3__GPIO3_IO30                          = IOMUX_PAD(0x0304, 0x003C, 5, 0x0000, 0, 0),
	MX6_PAD_KEY_COL3__SD1_RESET                           = IOMUX_PAD(0x0304, 0x003C, 6, 0x0000, 0, 0),

	MX6_PAD_KEY_ROW3__KEY_ROW3                            = IOMUX_PAD(0x0308, 0x0040, 0, 0x06CC, 1, 0),
	MX6_PAD_KEY_ROW3__AUD6_RXC                            = IOMUX_PAD(0x0308, 0x0040, 1, 0x059C, 1, 0),
	MX6_PAD_KEY_ROW3__LCD_DATA07                          = IOMUX_PAD(0x0308, 0x0040, 2, 0x06F4, 1, 0),
	MX6_PAD_KEY_ROW3__CSI_DATA15                          = IOMUX_PAD(0x0308, 0x0040, 3, 0x05C4, 2, 0),
	MX6_PAD_KEY_ROW3__GPIO3_IO31                          = IOMUX_PAD(0x0308, 0x0040, 5, 0x0000, 0, 0),
	MX6_PAD_KEY_ROW3__SD1_VSELECT                         = IOMUX_PAD(0x0308, 0x0040, 6, 0x0000, 0, 0),

	MX6_PAD_KEY_COL4__KEY_COL4                            = IOMUX_PAD(0x030C, 0x0044, 0, 0x06B0, 1, 0),
	MX6_PAD_KEY_COL4__AUD6_RXD                            = IOMUX_PAD(0x030C, 0x0044, 1, 0x0594, 1, 0),
	MX6_PAD_KEY_COL4__LCD_DATA08                          = IOMUX_PAD(0x030C, 0x0044, 2, 0x06F8, 1, 0),
	MX6_PAD_KEY_COL4__CSI_DATA16                          = IOMUX_PAD(0x030C, 0x0044, 3, 0x0000, 0, 0),
	MX6_PAD_KEY_COL4__GPIO4_IO00                          = IOMUX_PAD(0x030C, 0x0044, 5, 0x0000, 0, 0),
	MX6_PAD_KEY_COL4__USB_OTG1_PWR                        = IOMUX_PAD(0x030C, 0x0044, 6, 0x0000, 0, 0),

	MX6_PAD_KEY_ROW4__KEY_ROW4                            = IOMUX_PAD(0x0310, 0x0048, 0, 0x06D0, 1, 0),
	MX6_PAD_KEY_ROW4__AUD6_TXC                            = IOMUX_PAD(0x0310, 0x0048, 1, 0x05A4, 1, 0),
	MX6_PAD_KEY_ROW4__LCD_DATA09                          = IOMUX_PAD(0x0310, 0x0048, 2, 0x06FC, 1, 0),
	MX6_PAD_KEY_ROW4__CSI_DATA17                          = IOMUX_PAD(0x0310, 0x0048, 3, 0x0000, 0, 0),
	MX6_PAD_KEY_ROW4__GPIO4_IO01                          = IOMUX_PAD(0x0310, 0x0048, 5, 0x0000, 0, 0),
	MX6_PAD_KEY_ROW4__USB_OTG1_OC                         = IOMUX_PAD(0x0310, 0x0048, 6, 0x076C, 2, 0),

	MX6_PAD_KEY_COL5__KEY_COL5                            = IOMUX_PAD(0x0314, 0x004C, 0, 0x0694, 1, 0),
	MX6_PAD_KEY_COL5__AUD6_TXFS                           = IOMUX_PAD(0x0314, 0x004C, 1, 0x05A8, 1, 0),
	MX6_PAD_KEY_COL5__LCD_DATA10                          = IOMUX_PAD(0x0314, 0x004C, 2, 0x0700, 0, 0),
	MX6_PAD_KEY_COL5__CSI_DATA18                          = IOMUX_PAD(0x0314, 0x004C, 3, 0x0000, 0, 0),
	MX6_PAD_KEY_COL5__GPIO4_IO02                          = IOMUX_PAD(0x0314, 0x004C, 5, 0x0000, 0, 0),
	MX6_PAD_KEY_COL5__USB_OTG2_PWR                        = IOMUX_PAD(0x0314, 0x004C, 6, 0x0000, 0, 0),

	MX6_PAD_KEY_ROW5__KEY_ROW5                            = IOMUX_PAD(0x0318, 0x0050, 0, 0x06B4, 2, 0),
	MX6_PAD_KEY_ROW5__AUD6_TXD                            = IOMUX_PAD(0x0318, 0x0050, 1, 0x0598, 1, 0),
	MX6_PAD_KEY_ROW5__LCD_DATA11                          = IOMUX_PAD(0x0318, 0x0050, 2, 0x0704, 1, 0),
	MX6_PAD_KEY_ROW5__CSI_DATA19                          = IOMUX_PAD(0x0318, 0x0050, 3, 0x0000, 0, 0),
	MX6_PAD_KEY_ROW5__GPIO4_IO03                          = IOMUX_PAD(0x0318, 0x0050, 5, 0x0000, 0, 0),
	MX6_PAD_KEY_ROW5__USB_OTG2_OC                         = IOMUX_PAD(0x0318, 0x0050, 6, 0x0768, 3, 0),

	MX6_PAD_KEY_COL6__KEY_COL6                            = IOMUX_PAD(0x031C, 0x0054, 0, 0x0698, 2, 0),
	MX6_PAD_KEY_COL6__UART4_DCE_RX                        = IOMUX_PAD(0x031C, 0x0054, 1, 0x075C, 2, 0),
	MX6_PAD_KEY_COL6__UART4_DTE_TX                        = IOMUX_PAD(0x031C, 0x0054, 1, 0x0000, 0, 0),
	MX6_PAD_KEY_COL6__LCD_DATA12                          = IOMUX_PAD(0x031C, 0x0054, 2, 0x0708, 1, 0),
	MX6_PAD_KEY_COL6__CSI_DATA20                          = IOMUX_PAD(0x031C, 0x0054, 3, 0x0000, 0, 0),
	MX6_PAD_KEY_COL6__GPIO4_IO04                          = IOMUX_PAD(0x031C, 0x0054, 5, 0x0000, 0, 0),
	MX6_PAD_KEY_COL6__SD3_RESET                           = IOMUX_PAD(0x031C, 0x0054, 6, 0x0000, 0, 0),

	MX6_PAD_KEY_ROW6__KEY_ROW6                            = IOMUX_PAD(0x0320, 0x0058, 0, 0x06B8, 2, 0),
	MX6_PAD_KEY_ROW6__UART4_DCE_TX                        = IOMUX_PAD(0x0320, 0x0058, 1, 0x0000, 0, 0),
	MX6_PAD_KEY_ROW6__UART4_DTE_RX                        = IOMUX_PAD(0x0320, 0x0058, 1, 0x075C, 3, 0),
	MX6_PAD_KEY_ROW6__LCD_DATA13                          = IOMUX_PAD(0x0320, 0x0058, 2, 0x070C, 1, 0),
	MX6_PAD_KEY_ROW6__CSI_DATA21                          = IOMUX_PAD(0x0320, 0x0058, 3, 0x0000, 0, 0),
	MX6_PAD_KEY_ROW6__GPIO4_IO05                          = IOMUX_PAD(0x0320, 0x0058, 5, 0x0000, 0, 0),
	MX6_PAD_KEY_ROW6__SD3_VSELECT                         = IOMUX_PAD(0x0320, 0x0058, 6, 0x0000, 0, 0),

	MX6_PAD_KEY_COL7__KEY_COL7                            = IOMUX_PAD(0x0324, 0x005C, 0, 0x069C, 2, 0),
	MX6_PAD_KEY_COL7__UART4_DCE_RTS                       = IOMUX_PAD(0x0324, 0x005C, 1, 0x0758, 2, 0),
	MX6_PAD_KEY_COL7__UART4_DTE_CTS                       = IOMUX_PAD(0x0324, 0x005C, 1, 0x0000, 0, 0),
	MX6_PAD_KEY_COL7__LCD_DATA14                          = IOMUX_PAD(0x0324, 0x005C, 2, 0x0710, 1, 0),
	MX6_PAD_KEY_COL7__CSI_DATA22                          = IOMUX_PAD(0x0324, 0x005C, 3, 0x0000, 0, 0),
	MX6_PAD_KEY_COL7__GPIO4_IO06                          = IOMUX_PAD(0x0324, 0x005C, 5, 0x0000, 0, 0),
	MX6_PAD_KEY_COL7__SD1_WP                              = IOMUX_PAD(0x0324, 0x005C, 6, 0x0774, 3, 0),

	MX6_PAD_KEY_ROW7__KEY_ROW7                            = IOMUX_PAD(0x0328, 0x0060, 0, 0x06BC, 2, 0),
	MX6_PAD_KEY_ROW7__UART4_DCE_CTS                       = IOMUX_PAD(0x0328, 0x0060, 1, 0x0000, 0, 0),
	MX6_PAD_KEY_ROW7__UART4_DTE_RTS                       = IOMUX_PAD(0x0328, 0x0060, 1, 0x0758, 3, 0),
	MX6_PAD_KEY_ROW7__LCD_DATA15                          = IOMUX_PAD(0x0328, 0x0060, 2, 0x0714, 1, 0),
	MX6_PAD_KEY_ROW7__CSI_DATA23                          = IOMUX_PAD(0x0328, 0x0060, 3, 0x0000, 0, 0),
	MX6_PAD_KEY_ROW7__GPIO4_IO07                          = IOMUX_PAD(0x0328, 0x0060, 5, 0x0000, 0, 0),
	MX6_PAD_KEY_ROW7__SD1_CD_B                            = IOMUX_PAD(0x0328, 0x0060, 6, 0x0770, 3, 0),

	MX6_PAD_EPDC_DATA00__EPDC_DATA00                      = IOMUX_PAD(0x032C, 0x0064, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA00__ECSPI4_MOSI                      = IOMUX_PAD(0x032C, 0x0064, 1, 0x0658, 2, 0),
	MX6_PAD_EPDC_DATA00__LCD_DATA24                       = IOMUX_PAD(0x032C, 0x0064, 2, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA00__CSI_DATA00                       = IOMUX_PAD(0x032C, 0x0064, 3, 0x05C8, 2, 0),
	MX6_PAD_EPDC_DATA00__GPIO1_IO07                       = IOMUX_PAD(0x032C, 0x0064, 5, 0x0000, 0, 0),

	MX6_PAD_EPDC_DATA01__EPDC_DATA01                      = IOMUX_PAD(0x0330, 0x0068, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA01__ECSPI4_MISO                      = IOMUX_PAD(0x0330, 0x0068, 1, 0x0654, 2, 0),
	MX6_PAD_EPDC_DATA01__LCD_DATA25                       = IOMUX_PAD(0x0330, 0x0068, 2, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA01__CSI_DATA01                       = IOMUX_PAD(0x0330, 0x0068, 3, 0x05CC, 2, 0),
	MX6_PAD_EPDC_DATA01__GPIO1_IO08                       = IOMUX_PAD(0x0330, 0x0068, 5, 0x0000, 0, 0),

	MX6_PAD_EPDC_DATA02__EPDC_DATA02                      = IOMUX_PAD(0x0334, 0x006C, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA02__ECSPI4_SS0                       = IOMUX_PAD(0x0334, 0x006C, 1, 0x065C, 2, 0),
	MX6_PAD_EPDC_DATA02__LCD_DATA26                       = IOMUX_PAD(0x0334, 0x006C, 2, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA02__CSI_DATA02                       = IOMUX_PAD(0x0334, 0x006C, 3, 0x05D0, 2, 0),
	MX6_PAD_EPDC_DATA02__GPIO1_IO09                       = IOMUX_PAD(0x0334, 0x006C, 5, 0x0000, 0, 0),

	MX6_PAD_EPDC_DATA03__EPDC_DATA03                      = IOMUX_PAD(0x0338, 0x0070, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA03__ECSPI4_SCLK                      = IOMUX_PAD(0x0338, 0x0070, 1, 0x0650, 2, 0),
	MX6_PAD_EPDC_DATA03__LCD_DATA27                       = IOMUX_PAD(0x0338, 0x0070, 2, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA03__CSI_DATA03                       = IOMUX_PAD(0x0338, 0x0070, 3, 0x05D4, 2, 0),
	MX6_PAD_EPDC_DATA03__GPIO1_IO10                       = IOMUX_PAD(0x0338, 0x0070, 5, 0x0000, 0, 0),

	MX6_PAD_EPDC_DATA04__EPDC_DATA04                      = IOMUX_PAD(0x033C, 0x0074, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA04__ECSPI4_SS1                       = IOMUX_PAD(0x033C, 0x0074, 1, 0x0660, 1, 0),
	MX6_PAD_EPDC_DATA04__LCD_DATA28                       = IOMUX_PAD(0x033C, 0x0074, 2, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA04__CSI_DATA04                       = IOMUX_PAD(0x033C, 0x0074, 3, 0x05D8, 2, 0),
	MX6_PAD_EPDC_DATA04__GPIO1_IO11                       = IOMUX_PAD(0x033C, 0x0074, 5, 0x0000, 0, 0),

	MX6_PAD_EPDC_DATA05__EPDC_DATA05                      = IOMUX_PAD(0x0340, 0x0078, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA05__ECSPI4_SS2                       = IOMUX_PAD(0x0340, 0x0078, 1, 0x0664, 1, 0),
	MX6_PAD_EPDC_DATA05__LCD_DATA29                       = IOMUX_PAD(0x0340, 0x0078, 2, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA05__CSI_DATA05                       = IOMUX_PAD(0x0340, 0x0078, 3, 0x05DC, 2, 0),
	MX6_PAD_EPDC_DATA05__GPIO1_IO12                       = IOMUX_PAD(0x0340, 0x0078, 5, 0x0000, 0, 0),

	MX6_PAD_EPDC_DATA06__EPDC_DATA06                      = IOMUX_PAD(0x0344, 0x007C, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA06__ECSPI4_SS3                       = IOMUX_PAD(0x0344, 0x007C, 1, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA06__LCD_DATA30                       = IOMUX_PAD(0x0344, 0x007C, 2, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA06__CSI_DATA06                       = IOMUX_PAD(0x0344, 0x007C, 3, 0x05E0, 2, 0),
	MX6_PAD_EPDC_DATA06__GPIO1_IO13                       = IOMUX_PAD(0x0344, 0x007C, 5, 0x0000, 0, 0),

	MX6_PAD_EPDC_DATA07__EPDC_DATA07                      = IOMUX_PAD(0x0348, 0x0080, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA07__ECSPI4_RDY                       = IOMUX_PAD(0x0348, 0x0080, 1, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA07__LCD_DATA31                       = IOMUX_PAD(0x0348, 0x0080, 2, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA07__CSI_DATA07                       = IOMUX_PAD(0x0348, 0x0080, 3, 0x05E4, 2, 0),
	MX6_PAD_EPDC_DATA07__GPIO1_IO14                       = IOMUX_PAD(0x0348, 0x0080, 5, 0x0000, 0, 0),

	MX6_PAD_EPDC_DATA08__EPDC_DATA08                      = IOMUX_PAD(0x034C, 0x0084, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA08__ECSPI3_MOSI                      = IOMUX_PAD(0x034C, 0x0084, 1, 0x063C, 2, 0),
	MX6_PAD_EPDC_DATA08__EPDC_PWR_CTRL0                   = IOMUX_PAD(0x034C, 0x0084, 2, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA08__GPIO1_IO15                       = IOMUX_PAD(0x034C, 0x0084, 5, 0x0000, 0, 0),

	MX6_PAD_EPDC_DATA09__EPDC_DATA09                      = IOMUX_PAD(0x0350, 0x0088, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA09__ECSPI3_MISO                      = IOMUX_PAD(0x0350, 0x0088, 1, 0x0638, 2, 0),
	MX6_PAD_EPDC_DATA09__EPDC_PWR_CTRL1                   = IOMUX_PAD(0x0350, 0x0088, 2, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA09__GPIO1_IO16                       = IOMUX_PAD(0x0350, 0x0088, 5, 0x0000, 0, 0),

	MX6_PAD_EPDC_DATA10__EPDC_DATA10                      = IOMUX_PAD(0x0354, 0x008C, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA10__ECSPI3_SS0                       = IOMUX_PAD(0x0354, 0x008C, 1, 0x0648, 2, 0),
	MX6_PAD_EPDC_DATA10__EPDC_PWR_CTRL2                   = IOMUX_PAD(0x0354, 0x008C, 2, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA10__GPIO1_IO17                       = IOMUX_PAD(0x0354, 0x008C, 5, 0x0000, 0, 0),

	MX6_PAD_EPDC_DATA11__EPDC_DATA11                      = IOMUX_PAD(0x0358, 0x0090, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA11__ECSPI3_SCLK                      = IOMUX_PAD(0x0358, 0x0090, 1, 0x0630, 2, 0),
	MX6_PAD_EPDC_DATA11__EPDC_PWR_CTRL3                   = IOMUX_PAD(0x0358, 0x0090, 2, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA11__GPIO1_IO18                       = IOMUX_PAD(0x0358, 0x0090, 5, 0x0000, 0, 0),

	MX6_PAD_EPDC_DATA12__EPDC_DATA12                      = IOMUX_PAD(0x035C, 0x0094, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA12__UART2_DCE_RX                     = IOMUX_PAD(0x035C, 0x0094, 1, 0x074C, 4, 0),
	MX6_PAD_EPDC_DATA12__UART2_DTE_TX                     = IOMUX_PAD(0x035C, 0x0094, 1, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA12__EPDC_PWR_COM                     = IOMUX_PAD(0x035C, 0x0094, 2, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA12__GPIO1_IO19                       = IOMUX_PAD(0x035C, 0x0094, 5, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA12__ECSPI3_SS1                       = IOMUX_PAD(0x035C, 0x0094, 6, 0x064C, 1, 0),

	MX6_PAD_EPDC_DATA13__EPDC_DATA13                      = IOMUX_PAD(0x0360, 0x0098, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA13__UART2_DCE_TX                     = IOMUX_PAD(0x0360, 0x0098, 1, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA13__UART2_DTE_RX                     = IOMUX_PAD(0x0360, 0x0098, 1, 0x074C, 5, 0),
	MX6_PAD_EPDC_DATA13__EPDC_PWR_IRQ                     = IOMUX_PAD(0x0360, 0x0098, 2, 0x0668, 0, 0),
	MX6_PAD_EPDC_DATA13__GPIO1_IO20                       = IOMUX_PAD(0x0360, 0x0098, 5, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA13__ECSPI3_SS2                       = IOMUX_PAD(0x0360, 0x0098, 6, 0x0640, 1, 0),

	MX6_PAD_EPDC_DATA14__EPDC_DATA14                      = IOMUX_PAD(0x0364, 0x009C, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA14__UART2_DCE_RTS                    = IOMUX_PAD(0x0364, 0x009C, 1, 0x0748, 4, 0),
	MX6_PAD_EPDC_DATA14__UART2_DTE_CTS                    = IOMUX_PAD(0x0364, 0x009C, 1, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA14__EPDC_PWR_STAT                    = IOMUX_PAD(0x0364, 0x009C, 2, 0x066C, 0, 0),
	MX6_PAD_EPDC_DATA14__GPIO1_IO21                       = IOMUX_PAD(0x0364, 0x009C, 5, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA14__ECSPI3_SS3                       = IOMUX_PAD(0x0364, 0x009C, 6, 0x0644, 1, 0),

	MX6_PAD_EPDC_DATA15__EPDC_DATA15                      = IOMUX_PAD(0x0368, 0x00A0, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA15__UART2_DCE_CTS                    = IOMUX_PAD(0x0368, 0x00A0, 1, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA15__UART2_DTE_RTS                    = IOMUX_PAD(0x0368, 0x00A0, 1, 0x0748, 5, 0),
	MX6_PAD_EPDC_DATA15__EPDC_PWR_WAKE                    = IOMUX_PAD(0x0368, 0x00A0, 2, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA15__GPIO1_IO22                       = IOMUX_PAD(0x0368, 0x00A0, 5, 0x0000, 0, 0),
	MX6_PAD_EPDC_DATA15__ECSPI3_RDY                       = IOMUX_PAD(0x0368, 0x00A0, 6, 0x0634, 1, 0),

	MX6_PAD_EPDC_SDCLK__EPDC_SDCLK_P                      = IOMUX_PAD(0x036C, 0x00A4, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_SDCLK__ECSPI2_MOSI                       = IOMUX_PAD(0x036C, 0x00A4, 1, 0x0624, 2, 0),
	MX6_PAD_EPDC_SDCLK__I2C2_SCL                          = IOMUX_PAD(0x036C, 0x00A4, IOMUX_CONFIG_SION | 2, 0x0684, 2, 0),
	MX6_PAD_EPDC_SDCLK__CSI_DATA08                        = IOMUX_PAD(0x036C, 0x00A4, 3, 0x05E8, 2, 0),
	MX6_PAD_EPDC_SDCLK__GPIO1_IO23                        = IOMUX_PAD(0x036C, 0x00A4, 5, 0x0000, 0, 0),

	MX6_PAD_EPDC_SDLE__EPDC_SDLE                          = IOMUX_PAD(0x0370, 0x00A8, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_SDLE__ECSPI2_MISO                        = IOMUX_PAD(0x0370, 0x00A8, 1, 0x0620, 2, 0),
	MX6_PAD_EPDC_SDLE__I2C2_SDA                           = IOMUX_PAD(0x0370, 0x00A8, IOMUX_CONFIG_SION | 2, 0x0688, 2, 0),
	MX6_PAD_EPDC_SDLE__CSI_DATA09                         = IOMUX_PAD(0x0370, 0x00A8, 3, 0x05EC, 2, 0),
	MX6_PAD_EPDC_SDLE__GPIO1_IO24                         = IOMUX_PAD(0x0370, 0x00A8, 5, 0x0000, 0, 0),

	MX6_PAD_EPDC_SDOE__EPDC_SDOE                          = IOMUX_PAD(0x0374, 0x00AC, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_SDOE__ECSPI2_SS0                         = IOMUX_PAD(0x0374, 0x00AC, 1, 0x0628, 1, 0),
	MX6_PAD_EPDC_SDOE__CSI_DATA10                         = IOMUX_PAD(0x0374, 0x00AC, 3, 0x05B0, 2, 0),
	MX6_PAD_EPDC_SDOE__GPIO1_IO25                         = IOMUX_PAD(0x0374, 0x00AC, 5, 0x0000, 0, 0),

	MX6_PAD_EPDC_SDSHR__EPDC_SDSHR                        = IOMUX_PAD(0x0378, 0x00B0, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_SDSHR__ECSPI2_SCLK                       = IOMUX_PAD(0x0378, 0x00B0, 1, 0x061C, 2, 0),
	MX6_PAD_EPDC_SDSHR__EPDC_SDCE4                        = IOMUX_PAD(0x0378, 0x00B0, 2, 0x0000, 0, 0),
	MX6_PAD_EPDC_SDSHR__CSI_DATA11                        = IOMUX_PAD(0x0378, 0x00B0, 3, 0x05B4, 2, 0),
	MX6_PAD_EPDC_SDSHR__GPIO1_IO26                        = IOMUX_PAD(0x0378, 0x00B0, 5, 0x0000, 0, 0),

	MX6_PAD_EPDC_SDCE0__EPDC_SDCE0                        = IOMUX_PAD(0x037C, 0x00B4, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_SDCE0__ECSPI2_SS1                        = IOMUX_PAD(0x037C, 0x00B4, 1, 0x062C, 1, 0),
	MX6_PAD_EPDC_SDCE0__PWM3_OUT                          = IOMUX_PAD(0x037C, 0x00B4, 2, 0x0000, 0, 0),
	MX6_PAD_EPDC_SDCE0__GPIO1_IO27                        = IOMUX_PAD(0x037C, 0x00B4, 5, 0x0000, 0, 0),

	MX6_PAD_EPDC_SDCE1__EPDC_SDCE1                        = IOMUX_PAD(0x0380, 0x00B8, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_SDCE1__WDOG2_B                           = IOMUX_PAD(0x0380, 0x00B8, 1, 0x0000, 0, 0),
	MX6_PAD_EPDC_SDCE1__PWM4_OUT                          = IOMUX_PAD(0x0380, 0x00B8, 2, 0x0000, 0, 0),
	MX6_PAD_EPDC_SDCE1__GPIO1_IO28                        = IOMUX_PAD(0x0380, 0x00B8, 5, 0x0000, 0, 0),

	MX6_PAD_EPDC_SDCE2__EPDC_SDCE2                        = IOMUX_PAD(0x0384, 0x00BC, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_SDCE2__I2C3_SCL                          = IOMUX_PAD(0x0384, 0x00BC, IOMUX_CONFIG_SION | 1, 0x068C, 2, 0),
	MX6_PAD_EPDC_SDCE2__PWM1_OUT                          = IOMUX_PAD(0x0384, 0x00BC, 2, 0x0000, 0, 0),
	MX6_PAD_EPDC_SDCE2__GPIO1_IO29                        = IOMUX_PAD(0x0384, 0x00BC, 5, 0x0000, 0, 0),

	MX6_PAD_EPDC_SDCE3__EPDC_SDCE3                        = IOMUX_PAD(0x0388, 0x00C0, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_SDCE3__I2C3_SDA                          = IOMUX_PAD(0x0388, 0x00C0, IOMUX_CONFIG_SION | 1, 0x0690, 2, 0),
	MX6_PAD_EPDC_SDCE3__PWM2_OUT                          = IOMUX_PAD(0x0388, 0x00C0, 2, 0x0000, 0, 0),
	MX6_PAD_EPDC_SDCE3__GPIO1_IO30                        = IOMUX_PAD(0x0388, 0x00C0, 5, 0x0000, 0, 0),

	MX6_PAD_EPDC_GDCLK__EPDC_GDCLK                        = IOMUX_PAD(0x038C, 0x00C4, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_GDCLK__ECSPI2_SS2                        = IOMUX_PAD(0x038C, 0x00C4, 1, 0x0000, 0, 0),
	MX6_PAD_EPDC_GDCLK__CSI_PIXCLK                        = IOMUX_PAD(0x038C, 0x00C4, 3, 0x05F4, 2, 0),
	MX6_PAD_EPDC_GDCLK__GPIO1_IO31                        = IOMUX_PAD(0x038C, 0x00C4, 5, 0x0000, 0, 0),
	MX6_PAD_EPDC_GDCLK__SD2_RESET                         = IOMUX_PAD(0x038C, 0x00C4, 6, 0x0000, 0, 0),

	MX6_PAD_EPDC_GDOE__EPDC_GDOE                          = IOMUX_PAD(0x0390, 0x00C8, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_GDOE__ECSPI2_SS3                         = IOMUX_PAD(0x0390, 0x00C8, 1, 0x0000, 0, 0),
	MX6_PAD_EPDC_GDOE__CSI_HSYNC                          = IOMUX_PAD(0x0390, 0x00C8, 3, 0x05F0, 2, 0),
	MX6_PAD_EPDC_GDOE__GPIO2_IO00                         = IOMUX_PAD(0x0390, 0x00C8, 5, 0x0000, 0, 0),
	MX6_PAD_EPDC_GDOE__SD2_VSELECT                        = IOMUX_PAD(0x0390, 0x00C8, 6, 0x0000, 0, 0),

	MX6_PAD_EPDC_GDRL__EPDC_GDRL                          = IOMUX_PAD(0x0394, 0x00CC, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_GDRL__ECSPI2_RDY                         = IOMUX_PAD(0x0394, 0x00CC, 1, 0x0000, 0, 0),
	MX6_PAD_EPDC_GDRL__CSI_MCLK                           = IOMUX_PAD(0x0394, 0x00CC, 3, 0x0000, 0, 0),
	MX6_PAD_EPDC_GDRL__GPIO2_IO01                         = IOMUX_PAD(0x0394, 0x00CC, 5, 0x0000, 0, 0),
	MX6_PAD_EPDC_GDRL__SD2_WP                             = IOMUX_PAD(0x0394, 0x00CC, 6, 0x077C, 2, 0),

	MX6_PAD_EPDC_GDSP__EPDC_GDSP                          = IOMUX_PAD(0x0398, 0x00D0, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_GDSP__PWM4_OUT                           = IOMUX_PAD(0x0398, 0x00D0, 1, 0x0000, 0, 0),
	MX6_PAD_EPDC_GDSP__CSI_VSYNC                          = IOMUX_PAD(0x0398, 0x00D0, 3, 0x05F8, 2, 0),
	MX6_PAD_EPDC_GDSP__GPIO2_IO02                         = IOMUX_PAD(0x0398, 0x00D0, 5, 0x0000, 0, 0),
	MX6_PAD_EPDC_GDSP__SD2_CD_B                           = IOMUX_PAD(0x0398, 0x00D0, 6, 0x0778, 2, 0),

	MX6_PAD_EPDC_VCOM0__EPDC_VCOM0                        = IOMUX_PAD(0x039C, 0x00D4, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_VCOM0__AUD5_RXFS                         = IOMUX_PAD(0x039C, 0x00D4, 1, 0x0588, 1, 0),
	MX6_PAD_EPDC_VCOM0__UART3_DCE_RX                      = IOMUX_PAD(0x039C, 0x00D4, 2, 0x0754, 4, 0),
	MX6_PAD_EPDC_VCOM0__UART3_DTE_TX                      = IOMUX_PAD(0x039C, 0x00D4, 2, 0x0000, 0, 0),
	MX6_PAD_EPDC_VCOM0__GPIO2_IO03                        = IOMUX_PAD(0x039C, 0x00D4, 5, 0x0000, 0, 0),
	MX6_PAD_EPDC_VCOM0__EPDC_SDCE5                        = IOMUX_PAD(0x039C, 0x00D4, 6, 0x0000, 0, 0),

	MX6_PAD_EPDC_VCOM1__EPDC_VCOM1                        = IOMUX_PAD(0x03A0, 0x00D8, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_VCOM1__AUD5_RXD                          = IOMUX_PAD(0x03A0, 0x00D8, 1, 0x057C, 1, 0),
	MX6_PAD_EPDC_VCOM1__UART3_DCE_TX                      = IOMUX_PAD(0x03A0, 0x00D8, 2, 0x0000, 0, 0),
	MX6_PAD_EPDC_VCOM1__UART3_DTE_RX                      = IOMUX_PAD(0x03A0, 0x00D8, 2, 0x0754, 5, 0),
	MX6_PAD_EPDC_VCOM1__GPIO2_IO04                        = IOMUX_PAD(0x03A0, 0x00D8, 5, 0x0000, 0, 0),
	MX6_PAD_EPDC_VCOM1__EPDC_SDCE6                        = IOMUX_PAD(0x03A0, 0x00D8, 6, 0x0000, 0, 0),

	MX6_PAD_EPDC_BDR0__EPDC_BDR0                          = IOMUX_PAD(0x03A4, 0x00DC, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_BDR0__UART3_DCE_RTS                      = IOMUX_PAD(0x03A4, 0x00DC, 2, 0x0750, 2, 0),
	MX6_PAD_EPDC_BDR0__UART3_DTE_CTS                      = IOMUX_PAD(0x03A4, 0x00DC, 2, 0x0000, 0, 0),
	MX6_PAD_EPDC_BDR0__GPIO2_IO05                         = IOMUX_PAD(0x03A4, 0x00DC, 5, 0x0000, 0, 0),
	MX6_PAD_EPDC_BDR0__EPDC_SDCE7                         = IOMUX_PAD(0x03A4, 0x00DC, 6, 0x0000, 0, 0),

	MX6_PAD_EPDC_BDR1__EPDC_BDR1                          = IOMUX_PAD(0x03A8, 0x00E0, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_BDR1__UART3_DCE_CTS                      = IOMUX_PAD(0x03A8, 0x00E0, 2, 0x0000, 0, 0),
	MX6_PAD_EPDC_BDR1__UART3_DTE_RTS                      = IOMUX_PAD(0x03A8, 0x00E0, 2, 0x0750, 3, 0),
	MX6_PAD_EPDC_BDR1__GPIO2_IO06                         = IOMUX_PAD(0x03A8, 0x00E0, 5, 0x0000, 0, 0),
	MX6_PAD_EPDC_BDR1__EPDC_SDCE8                         = IOMUX_PAD(0x03A8, 0x00E0, 6, 0x0000, 0, 0),

	MX6_PAD_EPDC_PWR_CTRL0__EPDC_PWR_CTRL0                = IOMUX_PAD(0x03AC, 0x00E4, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_PWR_CTRL0__AUD5_RXC                      = IOMUX_PAD(0x03AC, 0x00E4, 1, 0x0584, 1, 0),
	MX6_PAD_EPDC_PWR_CTRL0__LCD_DATA16                    = IOMUX_PAD(0x03AC, 0x00E4, 2, 0x0718, 1, 0),
	MX6_PAD_EPDC_PWR_CTRL0__GPIO2_IO07                    = IOMUX_PAD(0x03AC, 0x00E4, 5, 0x0000, 0, 0),

	MX6_PAD_EPDC_PWR_CTRL1__EPDC_PWR_CTRL1                = IOMUX_PAD(0x03B0, 0x00E8, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_PWR_CTRL1__AUD5_TXFS                     = IOMUX_PAD(0x03B0, 0x00E8, 1, 0x0590, 1, 0),
	MX6_PAD_EPDC_PWR_CTRL1__LCD_DATA17                    = IOMUX_PAD(0x03B0, 0x00E8, 2, 0x071C, 1, 0),
	MX6_PAD_EPDC_PWR_CTRL1__GPIO2_IO08                    = IOMUX_PAD(0x03B0, 0x00E8, 5, 0x0000, 0, 0),

	MX6_PAD_EPDC_PWR_CTRL2__EPDC_PWR_CTRL2                = IOMUX_PAD(0x03B4, 0x00EC, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_PWR_CTRL2__AUD5_TXD                      = IOMUX_PAD(0x03B4, 0x00EC, 1, 0x0580, 1, 0),
	MX6_PAD_EPDC_PWR_CTRL2__LCD_DATA18                    = IOMUX_PAD(0x03B4, 0x00EC, 2, 0x0720, 1, 0),
	MX6_PAD_EPDC_PWR_CTRL2__GPIO2_IO09                    = IOMUX_PAD(0x03B4, 0x00EC, 5, 0x0000, 0, 0),

	MX6_PAD_EPDC_PWR_CTRL3__EPDC_PWR_CTRL3                = IOMUX_PAD(0x03B8, 0x00F0, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_PWR_CTRL3__AUD5_TXC                      = IOMUX_PAD(0x03B8, 0x00F0, 1, 0x058C, 1, 0),
	MX6_PAD_EPDC_PWR_CTRL3__LCD_DATA19                    = IOMUX_PAD(0x03B8, 0x00F0, 2, 0x0724, 1, 0),
	MX6_PAD_EPDC_PWR_CTRL3__GPIO2_IO10                    = IOMUX_PAD(0x03B8, 0x00F0, 5, 0x0000, 0, 0),

	MX6_PAD_EPDC_PWR_COM__EPDC_PWR_COM                    = IOMUX_PAD(0x03BC, 0x00F4, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_PWR_COM__LCD_DATA20                      = IOMUX_PAD(0x03BC, 0x00F4, 2, 0x0728, 1, 0),
	MX6_PAD_EPDC_PWR_COM__USB_OTG1_ID                     = IOMUX_PAD(0x03BC, 0x00F4, 4, 0x055C, 4, 0),
	MX6_PAD_EPDC_PWR_COM__GPIO2_IO11                      = IOMUX_PAD(0x03BC, 0x00F4, 5, 0x0000, 0, 0),
	MX6_PAD_EPDC_PWR_COM__SD3_RESET                       = IOMUX_PAD(0x03BC, 0x00F4, 6, 0x0000, 0, 0),

	MX6_PAD_EPDC_PWR_IRQ__EPDC_PWR_IRQ                    = IOMUX_PAD(0x03C0, 0x00F8, 0, 0x0668, 1, 0),
	MX6_PAD_EPDC_PWR_IRQ__LCD_DATA21                      = IOMUX_PAD(0x03C0, 0x00F8, 2, 0x072C, 1, 0),
	MX6_PAD_EPDC_PWR_IRQ__USB_OTG2_ID                     = IOMUX_PAD(0x03C0, 0x00F8, 4, 0x0560, 3, 0),
	MX6_PAD_EPDC_PWR_IRQ__GPIO2_IO12                      = IOMUX_PAD(0x03C0, 0x00F8, 5, 0x0000, 0, 0),
	MX6_PAD_EPDC_PWR_IRQ__SD3_VSELECT                     = IOMUX_PAD(0x03C0, 0x00F8, 6, 0x0000, 0, 0),

	MX6_PAD_EPDC_PWR_STAT__EPDC_PWR_STAT                  = IOMUX_PAD(0x03C4, 0x00FC, 0, 0x066C, 1, 0),
	MX6_PAD_EPDC_PWR_STAT__LCD_DATA22                     = IOMUX_PAD(0x03C4, 0x00FC, 2, 0x0730, 1, 0),
	MX6_PAD_EPDC_PWR_STAT__ARM_EVENTI                     = IOMUX_PAD(0x03C4, 0x00FC, 4, 0x0000, 0, 0),
	MX6_PAD_EPDC_PWR_STAT__GPIO2_IO13                     = IOMUX_PAD(0x03C4, 0x00FC, 5, 0x0000, 0, 0),
	MX6_PAD_EPDC_PWR_STAT__SD3_WP                         = IOMUX_PAD(0x03C4, 0x00FC, 6, 0x0794, 2, 0),

	MX6_PAD_EPDC_PWR_WAKE__EPDC_PWR_WAKE                  = IOMUX_PAD(0x03C8, 0x0100, 0, 0x0000, 0, 0),
	MX6_PAD_EPDC_PWR_WAKE__LCD_DATA23                     = IOMUX_PAD(0x03C8, 0x0100, 2, 0x0734, 1, 0),
	MX6_PAD_EPDC_PWR_WAKE__ARM_EVENTO                     = IOMUX_PAD(0x03C8, 0x0100, 4, 0x0000, 0, 0),
	MX6_PAD_EPDC_PWR_WAKE__GPIO2_IO14                     = IOMUX_PAD(0x03C8, 0x0100, 5, 0x0000, 0, 0),
	MX6_PAD_EPDC_PWR_WAKE__SD3_CD_B                       = IOMUX_PAD(0x03C8, 0x0100, 6, 0x0780, 2, 0),

	MX6_PAD_LCD_CLK__LCD_CLK                              = IOMUX_PAD(0x03CC, 0x0104, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_CLK__LCD_WR_RWN                           = IOMUX_PAD(0x03CC, 0x0104, 2, 0x0000, 0, 0),
	MX6_PAD_LCD_CLK__PWM4_OUT                             = IOMUX_PAD(0x03CC, 0x0104, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_CLK__GPIO2_IO15                           = IOMUX_PAD(0x03CC, 0x0104, 5, 0x0000, 0, 0),

	MX6_PAD_LCD_ENABLE__LCD_ENABLE                        = IOMUX_PAD(0x03D0, 0x0108, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_ENABLE__LCD_RD_E                          = IOMUX_PAD(0x03D0, 0x0108, 2, 0x0000, 0, 0),
	MX6_PAD_LCD_ENABLE__UART2_DCE_RX                      = IOMUX_PAD(0x03D0, 0x0108, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_ENABLE__UART2_DTE_TX                      = IOMUX_PAD(0x03D0, 0x0108, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_ENABLE__GPIO2_IO16                        = IOMUX_PAD(0x03D0, 0x0108, 5, 0x0000, 0, 0),

	MX6_PAD_LCD_HSYNC__LCD_HSYNC                          = IOMUX_PAD(0x03D4, 0x010C, 0, 0x06D4, 0, 0),
	MX6_PAD_LCD_HSYNC__LCD_CS                             = IOMUX_PAD(0x03D4, 0x010C, 2, 0x0000, 0, 0),
	MX6_PAD_LCD_HSYNC__UART2_DCE_TX                       = IOMUX_PAD(0x03D4, 0x010C, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_HSYNC__UART2_DTE_RX                       = IOMUX_PAD(0x03D4, 0x010C, 4, 0x074C, 1, 0),
	MX6_PAD_LCD_HSYNC__GPIO2_IO17                         = IOMUX_PAD(0x03D4, 0x010C, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_HSYNC__ARM_TRACE_CLK                      = IOMUX_PAD(0x03D4, 0x010C, 6, 0x0000, 0, 0),

	MX6_PAD_LCD_VSYNC__LCD_VSYNC                          = IOMUX_PAD(0x03D8, 0x0110, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_VSYNC__LCD_RS                             = IOMUX_PAD(0x03D8, 0x0110, 2, 0x0000, 0, 0),
	MX6_PAD_LCD_VSYNC__UART2_DCE_RTS                      = IOMUX_PAD(0x03D8, 0x0110, 4, 0x0748, 0, 0),
	MX6_PAD_LCD_VSYNC__UART2_DTE_CTS                      = IOMUX_PAD(0x03D8, 0x0110, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_VSYNC__GPIO2_IO18                         = IOMUX_PAD(0x03D8, 0x0110, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_VSYNC__ARM_TRACE_CTL                      = IOMUX_PAD(0x03D8, 0x0110, 6, 0x0000, 0, 0),

	MX6_PAD_LCD_RESET__LCD_RESET                          = IOMUX_PAD(0x03DC, 0x0114, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_RESET__LCD_BUSY                           = IOMUX_PAD(0x03DC, 0x0114, 2, 0x06D4, 1, 0),
	MX6_PAD_LCD_RESET__UART2_DCE_CTS                      = IOMUX_PAD(0x03DC, 0x0114, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_RESET__UART2_DTE_RTS                      = IOMUX_PAD(0x03DC, 0x0114, 4, 0x0748, 1, 0),
	MX6_PAD_LCD_RESET__GPIO2_IO19                         = IOMUX_PAD(0x03DC, 0x0114, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_RESET__CCM_PMIC_READY                     = IOMUX_PAD(0x03DC, 0x0114, 6, 0x05AC, 2, 0),

	MX6_PAD_LCD_DATA00__LCD_DATA00                        = IOMUX_PAD(0x03E0, 0x0118, 0, 0x06D8, 1, 0),
	MX6_PAD_LCD_DATA00__ECSPI1_MOSI                       = IOMUX_PAD(0x03E0, 0x0118, 1, 0x0608, 0, 0),
	MX6_PAD_LCD_DATA00__USB_OTG2_ID                       = IOMUX_PAD(0x03E0, 0x0118, 2, 0x0560, 2, 0),
	MX6_PAD_LCD_DATA00__PWM1_OUT                          = IOMUX_PAD(0x03E0, 0x0118, 3, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA00__UART5_DTR_B                       = IOMUX_PAD(0x03E0, 0x0118, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA00__GPIO2_IO20                        = IOMUX_PAD(0x03E0, 0x0118, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA00__ARM_TRACE00                       = IOMUX_PAD(0x03E0, 0x0118, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA00__SRC_BOOT_CFG00                    = IOMUX_PAD(0x03E0, 0x0118, 7, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA01__LCD_DATA01                        = IOMUX_PAD(0x03E4, 0x011C, 0, 0x06DC, 1, 0),
	MX6_PAD_LCD_DATA01__ECSPI1_MISO                       = IOMUX_PAD(0x03E4, 0x011C, 1, 0x0604, 0, 0),
	MX6_PAD_LCD_DATA01__USB_OTG1_ID                       = IOMUX_PAD(0x03E4, 0x011C, 2, 0x055C, 3, 0),
	MX6_PAD_LCD_DATA01__PWM2_OUT                          = IOMUX_PAD(0x03E4, 0x011C, 3, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA01__AUD4_RXFS                         = IOMUX_PAD(0x03E4, 0x011C, 4, 0x0570, 0, 0),
	MX6_PAD_LCD_DATA01__GPIO2_IO21                        = IOMUX_PAD(0x03E4, 0x011C, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA01__ARM_TRACE01                       = IOMUX_PAD(0x03E4, 0x011C, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA01__SRC_BOOT_CFG01                    = IOMUX_PAD(0x03E4, 0x011C, 7, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA02__LCD_DATA02                        = IOMUX_PAD(0x03E8, 0x0120, 0, 0x06E0, 1, 0),
	MX6_PAD_LCD_DATA02__ECSPI1_SS0                        = IOMUX_PAD(0x03E8, 0x0120, 1, 0x0614, 0, 0),
	MX6_PAD_LCD_DATA02__EPIT2_OUT                         = IOMUX_PAD(0x03E8, 0x0120, 2, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA02__PWM3_OUT                          = IOMUX_PAD(0x03E8, 0x0120, 3, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA02__AUD4_RXC                          = IOMUX_PAD(0x03E8, 0x0120, 4, 0x056C, 0, 0),
	MX6_PAD_LCD_DATA02__GPIO2_IO22                        = IOMUX_PAD(0x03E8, 0x0120, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA02__ARM_TRACE02                       = IOMUX_PAD(0x03E8, 0x0120, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA02__SRC_BOOT_CFG02                    = IOMUX_PAD(0x03E8, 0x0120, 7, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA03__LCD_DATA03                        = IOMUX_PAD(0x03EC, 0x0124, 0, 0x06E4, 1, 0),
	MX6_PAD_LCD_DATA03__ECSPI1_SCLK                       = IOMUX_PAD(0x03EC, 0x0124, 1, 0x05FC, 0, 0),
	MX6_PAD_LCD_DATA03__UART5_DSR_B                       = IOMUX_PAD(0x03EC, 0x0124, 2, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA03__PWM4_OUT                          = IOMUX_PAD(0x03EC, 0x0124, 3, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA03__AUD4_RXD                          = IOMUX_PAD(0x03EC, 0x0124, 4, 0x0564, 0, 0),
	MX6_PAD_LCD_DATA03__GPIO2_IO23                        = IOMUX_PAD(0x03EC, 0x0124, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA03__ARM_TRACE03                       = IOMUX_PAD(0x03EC, 0x0124, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA03__SRC_BOOT_CFG03                    = IOMUX_PAD(0x03EC, 0x0124, 7, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA04__LCD_DATA04                        = IOMUX_PAD(0x03F0, 0x0128, 0, 0x06E8, 1, 0),
	MX6_PAD_LCD_DATA04__ECSPI1_SS1                        = IOMUX_PAD(0x03F0, 0x0128, 1, 0x060C, 1, 0),
	MX6_PAD_LCD_DATA04__CSI_VSYNC                         = IOMUX_PAD(0x03F0, 0x0128, 2, 0x05F8, 0, 0),
	MX6_PAD_LCD_DATA04__WDOG2_RESET_B_DEB                 = IOMUX_PAD(0x03F0, 0x0128, 3, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA04__AUD4_TXC                          = IOMUX_PAD(0x03F0, 0x0128, 4, 0x0574, 0, 0),
	MX6_PAD_LCD_DATA04__GPIO2_IO24                        = IOMUX_PAD(0x03F0, 0x0128, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA04__ARM_TRACE04                       = IOMUX_PAD(0x03F0, 0x0128, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA04__SRC_BOOT_CFG04                    = IOMUX_PAD(0x03F0, 0x0128, 7, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA05__LCD_DATA05                        = IOMUX_PAD(0x03F4, 0x012C, 0, 0x06EC, 1, 0),
	MX6_PAD_LCD_DATA05__ECSPI1_SS2                        = IOMUX_PAD(0x03F4, 0x012C, 1, 0x0610, 1, 0),
	MX6_PAD_LCD_DATA05__CSI_HSYNC                         = IOMUX_PAD(0x03F4, 0x012C, 2, 0x05F0, 0, 0),
	MX6_PAD_LCD_DATA05__AUD4_TXFS                         = IOMUX_PAD(0x03F4, 0x012C, 4, 0x0578, 0, 0),
	MX6_PAD_LCD_DATA05__GPIO2_IO25                        = IOMUX_PAD(0x03F4, 0x012C, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA05__ARM_TRACE05                       = IOMUX_PAD(0x03F4, 0x012C, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA05__SRC_BOOT_CFG05                    = IOMUX_PAD(0x03F4, 0x012C, 7, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA06__LCD_DATA06                        = IOMUX_PAD(0x03F8, 0x0130, 0, 0x06F0, 1, 0),
	MX6_PAD_LCD_DATA06__ECSPI1_SS3                        = IOMUX_PAD(0x03F8, 0x0130, 1, 0x0618, 0, 0),
	MX6_PAD_LCD_DATA06__CSI_PIXCLK                        = IOMUX_PAD(0x03F8, 0x0130, 2, 0x05F4, 0, 0),
	MX6_PAD_LCD_DATA06__AUD4_TXD                          = IOMUX_PAD(0x03F8, 0x0130, 4, 0x0568, 0, 0),
	MX6_PAD_LCD_DATA06__GPIO2_IO26                        = IOMUX_PAD(0x03F8, 0x0130, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA06__ARM_TRACE06                       = IOMUX_PAD(0x03F8, 0x0130, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA06__SRC_BOOT_CFG06                    = IOMUX_PAD(0x03F8, 0x0130, 7, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA07__LCD_DATA07                        = IOMUX_PAD(0x03FC, 0x0134, 0, 0x06F4, 0, 0),
	MX6_PAD_LCD_DATA07__ECSPI1_RDY                        = IOMUX_PAD(0x03FC, 0x0134, 1, 0x0600, 0, 0),
	MX6_PAD_LCD_DATA07__CSI_MCLK                          = IOMUX_PAD(0x03FC, 0x0134, 2, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA07__AUDIO_CLK_OUT                     = IOMUX_PAD(0x03FC, 0x0134, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA07__GPIO2_IO27                        = IOMUX_PAD(0x03FC, 0x0134, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA07__ARM_TRACE07                       = IOMUX_PAD(0x03FC, 0x0134, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA07__SRC_BOOT_CFG07                    = IOMUX_PAD(0x03FC, 0x0134, 7, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA08__LCD_DATA08                        = IOMUX_PAD(0x0400, 0x0138, 0, 0x06F8, 0, 0),
	MX6_PAD_LCD_DATA08__KEY_COL0                          = IOMUX_PAD(0x0400, 0x0138, 1, 0x06A0, 1, 0),
	MX6_PAD_LCD_DATA08__CSI_DATA09                        = IOMUX_PAD(0x0400, 0x0138, 2, 0x05EC, 0, 0),
	MX6_PAD_LCD_DATA08__ECSPI2_SCLK                       = IOMUX_PAD(0x0400, 0x0138, 4, 0x061C, 0, 0),
	MX6_PAD_LCD_DATA08__GPIO2_IO28                        = IOMUX_PAD(0x0400, 0x0138, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA08__ARM_TRACE08                       = IOMUX_PAD(0x0400, 0x0138, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA08__SRC_BOOT_CFG08                    = IOMUX_PAD(0x0400, 0x0138, 7, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA09__LCD_DATA09                        = IOMUX_PAD(0x0404, 0x013C, 0, 0x06FC, 0, 0),
	MX6_PAD_LCD_DATA09__KEY_ROW0                          = IOMUX_PAD(0x0404, 0x013C, 1, 0x06C0, 1, 0),
	MX6_PAD_LCD_DATA09__CSI_DATA08                        = IOMUX_PAD(0x0404, 0x013C, 2, 0x05E8, 0, 0),
	MX6_PAD_LCD_DATA09__ECSPI2_MOSI                       = IOMUX_PAD(0x0404, 0x013C, 4, 0x0624, 0, 0),
	MX6_PAD_LCD_DATA09__GPIO2_IO29                        = IOMUX_PAD(0x0404, 0x013C, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA09__ARM_TRACE09                       = IOMUX_PAD(0x0404, 0x013C, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA09__SRC_BOOT_CFG09                    = IOMUX_PAD(0x0404, 0x013C, 7, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA10__LCD_DATA10                        = IOMUX_PAD(0x0408, 0x0140, 0, 0x0700, 1, 0),
	MX6_PAD_LCD_DATA10__KEY_COL1                          = IOMUX_PAD(0x0408, 0x0140, 1, 0x06A4, 1, 0),
	MX6_PAD_LCD_DATA10__CSI_DATA07                        = IOMUX_PAD(0x0408, 0x0140, 2, 0x05E4, 0, 0),
	MX6_PAD_LCD_DATA10__ECSPI2_MISO                       = IOMUX_PAD(0x0408, 0x0140, 4, 0x0620, 0, 0),
	MX6_PAD_LCD_DATA10__GPIO2_IO30                        = IOMUX_PAD(0x0408, 0x0140, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA10__ARM_TRACE10                       = IOMUX_PAD(0x0408, 0x0140, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA10__SRC_BOOT_CFG10                    = IOMUX_PAD(0x0408, 0x0140, 7, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA11__LCD_DATA11                        = IOMUX_PAD(0x040C, 0x0144, 0, 0x0704, 0, 0),
	MX6_PAD_LCD_DATA11__KEY_ROW1                          = IOMUX_PAD(0x040C, 0x0144, 1, 0x06C4, 1, 0),
	MX6_PAD_LCD_DATA11__CSI_DATA06                        = IOMUX_PAD(0x040C, 0x0144, 2, 0x05E0, 0, 0),
	MX6_PAD_LCD_DATA11__ECSPI2_SS1                        = IOMUX_PAD(0x040C, 0x0144, 4, 0x062C, 0, 0),
	MX6_PAD_LCD_DATA11__GPIO2_IO31                        = IOMUX_PAD(0x040C, 0x0144, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA11__ARM_TRACE11                       = IOMUX_PAD(0x040C, 0x0144, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA11__SRC_BOOT_CFG11                    = IOMUX_PAD(0x040C, 0x0144, 7, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA12__LCD_DATA12                        = IOMUX_PAD(0x0410, 0x0148, 0, 0x0708, 0, 0),
	MX6_PAD_LCD_DATA12__KEY_COL2                          = IOMUX_PAD(0x0410, 0x0148, 1, 0x06A8, 1, 0),
	MX6_PAD_LCD_DATA12__CSI_DATA05                        = IOMUX_PAD(0x0410, 0x0148, 2, 0x05DC, 0, 0),
	MX6_PAD_LCD_DATA12__UART5_DCE_RTS                     = IOMUX_PAD(0x0410, 0x0148, 4, 0x0760, 0, 0),
	MX6_PAD_LCD_DATA12__UART5_DTE_CTS                     = IOMUX_PAD(0x0410, 0x0148, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA12__GPIO3_IO00                        = IOMUX_PAD(0x0410, 0x0148, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA12__ARM_TRACE12                       = IOMUX_PAD(0x0410, 0x0148, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA12__SRC_BOOT_CFG12                    = IOMUX_PAD(0x0410, 0x0148, 7, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA13__LCD_DATA13                        = IOMUX_PAD(0x0414, 0x014C, 0, 0x070C, 0, 0),
	MX6_PAD_LCD_DATA13__KEY_ROW2                          = IOMUX_PAD(0x0414, 0x014C, 1, 0x06C8, 1, 0),
	MX6_PAD_LCD_DATA13__CSI_DATA04                        = IOMUX_PAD(0x0414, 0x014C, 2, 0x05D8, 0, 0),
	MX6_PAD_LCD_DATA13__UART5_DCE_CTS                     = IOMUX_PAD(0x0414, 0x014C, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA13__UART5_DTE_RTS                     = IOMUX_PAD(0x0414, 0x014C, 4, 0x0760, 1, 0),
	MX6_PAD_LCD_DATA13__GPIO3_IO01                        = IOMUX_PAD(0x0414, 0x014C, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA13__ARM_TRACE13                       = IOMUX_PAD(0x0414, 0x014C, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA13__SRC_BOOT_CFG13                    = IOMUX_PAD(0x0414, 0x014C, 7, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA14__LCD_DATA14                        = IOMUX_PAD(0x0418, 0x0150, 0, 0x0710, 0, 0),
	MX6_PAD_LCD_DATA14__KEY_COL3                          = IOMUX_PAD(0x0418, 0x0150, 1, 0x06AC, 1, 0),
	MX6_PAD_LCD_DATA14__CSI_DATA03                        = IOMUX_PAD(0x0418, 0x0150, 2, 0x05D4, 0, 0),
	MX6_PAD_LCD_DATA14__UART5_DCE_RX                      = IOMUX_PAD(0x0418, 0x0150, 4, 0x0764, 0, 0),
	MX6_PAD_LCD_DATA14__UART5_DTE_TX                      = IOMUX_PAD(0x0418, 0x0150, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA14__GPIO3_IO02                        = IOMUX_PAD(0x0418, 0x0150, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA14__ARM_TRACE14                       = IOMUX_PAD(0x0418, 0x0150, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA14__SRC_BOOT_CFG14                    = IOMUX_PAD(0x0418, 0x0150, 7, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA15__LCD_DATA15                        = IOMUX_PAD(0x041C, 0x0154, 0, 0x0714, 0, 0),
	MX6_PAD_LCD_DATA15__KEY_ROW3                          = IOMUX_PAD(0x041C, 0x0154, 1, 0x06CC, 0, 0),
	MX6_PAD_LCD_DATA15__CSI_DATA02                        = IOMUX_PAD(0x041C, 0x0154, 2, 0x05D0, 0, 0),
	MX6_PAD_LCD_DATA15__UART5_DCE_TX                      = IOMUX_PAD(0x041C, 0x0154, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA15__UART5_DTE_RX                      = IOMUX_PAD(0x041C, 0x0154, 4, 0x0764, 1, 0),
	MX6_PAD_LCD_DATA15__GPIO3_IO03                        = IOMUX_PAD(0x041C, 0x0154, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA15__ARM_TRACE15                       = IOMUX_PAD(0x041C, 0x0154, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA15__SRC_BOOT_CFG15                    = IOMUX_PAD(0x041C, 0x0154, 7, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA16__LCD_DATA16                        = IOMUX_PAD(0x0420, 0x0158, 0, 0x0718, 0, 0),
	MX6_PAD_LCD_DATA16__KEY_COL4                          = IOMUX_PAD(0x0420, 0x0158, 1, 0x06B0, 0, 0),
	MX6_PAD_LCD_DATA16__CSI_DATA01                        = IOMUX_PAD(0x0420, 0x0158, 2, 0x05CC, 0, 0),
	MX6_PAD_LCD_DATA16__I2C2_SCL                          = IOMUX_PAD(0x0420, 0x0158, IOMUX_CONFIG_SION | 4, 0x0684, 1, 0),
	MX6_PAD_LCD_DATA16__GPIO3_IO04                        = IOMUX_PAD(0x0420, 0x0158, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA16__SRC_BOOT_CFG24                    = IOMUX_PAD(0x0420, 0x0158, 7, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA17__LCD_DATA17                        = IOMUX_PAD(0x0424, 0x015C, 0, 0x071C, 0, 0),
	MX6_PAD_LCD_DATA17__KEY_ROW4                          = IOMUX_PAD(0x0424, 0x015C, 1, 0x06D0, 0, 0),
	MX6_PAD_LCD_DATA17__CSI_DATA00                        = IOMUX_PAD(0x0424, 0x015C, 2, 0x05C8, 0, 0),
	MX6_PAD_LCD_DATA17__I2C2_SDA                          = IOMUX_PAD(0x0424, 0x015C, IOMUX_CONFIG_SION | 4, 0x0688, 1, 0),
	MX6_PAD_LCD_DATA17__GPIO3_IO05                        = IOMUX_PAD(0x0424, 0x015C, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA17__SRC_BOOT_CFG25                    = IOMUX_PAD(0x0424, 0x015C, 7, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA18__LCD_DATA18                        = IOMUX_PAD(0x0428, 0x0160, 0, 0x0720, 0, 0),
	MX6_PAD_LCD_DATA18__KEY_COL5                          = IOMUX_PAD(0x0428, 0x0160, 1, 0x0694, 2, 0),
	MX6_PAD_LCD_DATA18__CSI_DATA15                        = IOMUX_PAD(0x0428, 0x0160, 2, 0x05C4, 1, 0),
	MX6_PAD_LCD_DATA18__GPT_CAPTURE1                      = IOMUX_PAD(0x0428, 0x0160, 4, 0x0670, 1, 0),
	MX6_PAD_LCD_DATA18__GPIO3_IO06                        = IOMUX_PAD(0x0428, 0x0160, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA18__SRC_BOOT_CFG26                    = IOMUX_PAD(0x0428, 0x0160, 7, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA19__LCD_DATA19                        = IOMUX_PAD(0x042C, 0x0164, 0, 0x0724, 0, 0),
	MX6_PAD_LCD_DATA19__KEY_ROW5                          = IOMUX_PAD(0x042C, 0x0164, 1, 0x06B4, 1, 0),
	MX6_PAD_LCD_DATA19__CSI_DATA14                        = IOMUX_PAD(0x042C, 0x0164, 2, 0x05C0, 2, 0),
	MX6_PAD_LCD_DATA19__GPT_CAPTURE2                      = IOMUX_PAD(0x042C, 0x0164, 4, 0x0674, 1, 0),
	MX6_PAD_LCD_DATA19__GPIO3_IO07                        = IOMUX_PAD(0x042C, 0x0164, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA19__SRC_BOOT_CFG27                    = IOMUX_PAD(0x042C, 0x0164, 7, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA20__LCD_DATA20                        = IOMUX_PAD(0x0430, 0x0168, 0, 0x0728, 0, 0),
	MX6_PAD_LCD_DATA20__KEY_COL6                          = IOMUX_PAD(0x0430, 0x0168, 1, 0x0698, 1, 0),
	MX6_PAD_LCD_DATA20__CSI_DATA13                        = IOMUX_PAD(0x0430, 0x0168, 2, 0x05BC, 2, 0),
	MX6_PAD_LCD_DATA20__GPT_COMPARE1                      = IOMUX_PAD(0x0430, 0x0168, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA20__GPIO3_IO08                        = IOMUX_PAD(0x0430, 0x0168, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA20__SRC_BOOT_CFG28                    = IOMUX_PAD(0x0430, 0x0168, 7, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA21__LCD_DATA21                        = IOMUX_PAD(0x0434, 0x016C, 0, 0x072C, 0, 0),
	MX6_PAD_LCD_DATA21__KEY_ROW6                          = IOMUX_PAD(0x0434, 0x016C, 1, 0x06B8, 1, 0),
	MX6_PAD_LCD_DATA21__CSI_DATA12                        = IOMUX_PAD(0x0434, 0x016C, 2, 0x05B8, 2, 0),
	MX6_PAD_LCD_DATA21__GPT_COMPARE2                      = IOMUX_PAD(0x0434, 0x016C, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA21__GPIO3_IO09                        = IOMUX_PAD(0x0434, 0x016C, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA21__SRC_BOOT_CFG29                    = IOMUX_PAD(0x0434, 0x016C, 7, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA22__LCD_DATA22                        = IOMUX_PAD(0x0438, 0x0170, 0, 0x0730, 0, 0),
	MX6_PAD_LCD_DATA22__KEY_COL7                          = IOMUX_PAD(0x0438, 0x0170, 1, 0x069C, 1, 0),
	MX6_PAD_LCD_DATA22__CSI_DATA11                        = IOMUX_PAD(0x0438, 0x0170, 2, 0x05B4, 1, 0),
	MX6_PAD_LCD_DATA22__GPT_COMPARE3                      = IOMUX_PAD(0x0438, 0x0170, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA22__GPIO3_IO10                        = IOMUX_PAD(0x0438, 0x0170, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA22__SRC_BOOT_CFG30                    = IOMUX_PAD(0x0438, 0x0170, 7, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA23__LCD_DATA23                        = IOMUX_PAD(0x043C, 0x0174, 0, 0x0734, 0, 0),
	MX6_PAD_LCD_DATA23__KEY_ROW7                          = IOMUX_PAD(0x043C, 0x0174, 1, 0x06BC, 1, 0),
	MX6_PAD_LCD_DATA23__CSI_DATA10                        = IOMUX_PAD(0x043C, 0x0174, 2, 0x05B0, 1, 0),
	MX6_PAD_LCD_DATA23__GPT_CLKIN                         = IOMUX_PAD(0x043C, 0x0174, 4, 0x0678, 1, 0),
	MX6_PAD_LCD_DATA23__GPIO3_IO11                        = IOMUX_PAD(0x043C, 0x0174, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA23__SRC_BOOT_CFG31                    = IOMUX_PAD(0x043C, 0x0174, 7, 0x0000, 0, 0),

	MX6_PAD_AUD_RXFS__AUD3_RXFS                           = IOMUX_PAD(0x0440, 0x0178, 0, 0x0000, 0, 0),
	MX6_PAD_AUD_RXFS__I2C1_SCL                            = IOMUX_PAD(0x0440, 0x0178, IOMUX_CONFIG_SION | 1, 0x067C, 1, 0),
	MX6_PAD_AUD_RXFS__UART3_DCE_RX                        = IOMUX_PAD(0x0440, 0x0178, 2, 0x0754, 0, 0),
	MX6_PAD_AUD_RXFS__UART3_DTE_TX                        = IOMUX_PAD(0x0440, 0x0178, 2, 0x0000, 0, 0),
	MX6_PAD_AUD_RXFS__I2C3_SCL                            = IOMUX_PAD(0x0440, 0x0178, IOMUX_CONFIG_SION | 4, 0x068C, 1, 0),
	MX6_PAD_AUD_RXFS__GPIO1_IO00                          = IOMUX_PAD(0x0440, 0x0178, 5, 0x0000, 0, 0),
	MX6_PAD_AUD_RXFS__ECSPI3_SS0                          = IOMUX_PAD(0x0440, 0x0178, 6, 0x0648, 0, 0),
	MX6_PAD_AUD_RXFS__MBIST_BEND                          = IOMUX_PAD(0x0440, 0x0178, 7, 0x0000, 0, 0),

	MX6_PAD_AUD_RXC__AUD3_RXC                             = IOMUX_PAD(0x0444, 0x017C, 0, 0x0000, 0, 0),
	MX6_PAD_AUD_RXC__I2C1_SDA                             = IOMUX_PAD(0x0444, 0x017C, IOMUX_CONFIG_SION | 1, 0x0680, 1, 0),
	MX6_PAD_AUD_RXC__UART3_DCE_TX                         = IOMUX_PAD(0x0444, 0x017C, 2, 0x0000, 0, 0),
	MX6_PAD_AUD_RXC__UART3_DTE_RX                         = IOMUX_PAD(0x0444, 0x017C, 2, 0x0754, 1, 0),
	MX6_PAD_AUD_RXC__I2C3_SDA                             = IOMUX_PAD(0x0444, 0x017C, IOMUX_CONFIG_SION | 4, 0x0690, 1, 0),
	MX6_PAD_AUD_RXC__GPIO1_IO01                           = IOMUX_PAD(0x0444, 0x017C, 5, 0x0000, 0, 0),
	MX6_PAD_AUD_RXC__ECSPI3_SS1                           = IOMUX_PAD(0x0444, 0x017C, 6, 0x064C, 0, 0),

	MX6_PAD_AUD_RXD__AUD3_RXD                             = IOMUX_PAD(0x0448, 0x0180, 0, 0x0000, 0, 0),
	MX6_PAD_AUD_RXD__ECSPI3_MOSI                          = IOMUX_PAD(0x0448, 0x0180, 1, 0x063C, 0, 0),
	MX6_PAD_AUD_RXD__UART4_DCE_RX                         = IOMUX_PAD(0x0448, 0x0180, 2, 0x075C, 0, 0),
	MX6_PAD_AUD_RXD__UART4_DTE_TX                         = IOMUX_PAD(0x0448, 0x0180, 2, 0x0000, 0, 0),
	MX6_PAD_AUD_RXD__SD1_LCTL                             = IOMUX_PAD(0x0448, 0x0180, 4, 0x0000, 0, 0),
	MX6_PAD_AUD_RXD__GPIO1_IO02                           = IOMUX_PAD(0x0448, 0x0180, 5, 0x0000, 0, 0),

	MX6_PAD_AUD_TXC__AUD3_TXC                             = IOMUX_PAD(0x044C, 0x0184, 0, 0x0000, 0, 0),
	MX6_PAD_AUD_TXC__ECSPI3_MISO                          = IOMUX_PAD(0x044C, 0x0184, 1, 0x0638, 0, 0),
	MX6_PAD_AUD_TXC__UART4_DCE_TX                         = IOMUX_PAD(0x044C, 0x0184, 2, 0x0000, 0, 0),
	MX6_PAD_AUD_TXC__UART4_DTE_RX                         = IOMUX_PAD(0x044C, 0x0184, 2, 0x075C, 1, 0),
	MX6_PAD_AUD_TXC__SD2_LCTL                             = IOMUX_PAD(0x044C, 0x0184, 4, 0x0000, 0, 0),
	MX6_PAD_AUD_TXC__GPIO1_IO03                           = IOMUX_PAD(0x044C, 0x0184, 5, 0x0000, 0, 0),

	MX6_PAD_AUD_TXFS__AUD3_TXFS                           = IOMUX_PAD(0x0450, 0x0188, 0, 0x0000, 0, 0),
	MX6_PAD_AUD_TXFS__PWM3_OUT                            = IOMUX_PAD(0x0450, 0x0188, 1, 0x0000, 0, 0),
	MX6_PAD_AUD_TXFS__UART4_DCE_RTS                       = IOMUX_PAD(0x0450, 0x0188, 2, 0x0758, 0, 0),
	MX6_PAD_AUD_TXFS__UART4_DTE_CTS                       = IOMUX_PAD(0x0450, 0x0188, 2, 0x0000, 0, 0),
	MX6_PAD_AUD_TXFS__SD3_LCTL                            = IOMUX_PAD(0x0450, 0x0188, 4, 0x0000, 0, 0),
	MX6_PAD_AUD_TXFS__GPIO1_IO04                          = IOMUX_PAD(0x0450, 0x0188, 5, 0x0000, 0, 0),

	MX6_PAD_AUD_TXD__AUD3_TXD                             = IOMUX_PAD(0x0454, 0x018C, 0, 0x0000, 0, 0),
	MX6_PAD_AUD_TXD__ECSPI3_SCLK                          = IOMUX_PAD(0x0454, 0x018C, 1, 0x0630, 0, 0),
	MX6_PAD_AUD_TXD__UART4_DCE_CTS                        = IOMUX_PAD(0x0454, 0x018C, 2, 0x0000, 0, 0),
	MX6_PAD_AUD_TXD__UART4_DTE_RTS                        = IOMUX_PAD(0x0454, 0x018C, 2, 0x0758, 1, 0),
	MX6_PAD_AUD_TXD__GPIO1_IO05                           = IOMUX_PAD(0x0454, 0x018C, 5, 0x0000, 0, 0),

	MX6_PAD_AUD_MCLK__AUDIO_CLK_OUT                       = IOMUX_PAD(0x0458, 0x0190, 0, 0x0000, 0, 0),
	MX6_PAD_AUD_MCLK__PWM4_OUT                            = IOMUX_PAD(0x0458, 0x0190, 1, 0x0000, 0, 0),
	MX6_PAD_AUD_MCLK__ECSPI3_RDY                          = IOMUX_PAD(0x0458, 0x0190, 2, 0x0634, 0, 0),
	MX6_PAD_AUD_MCLK__WDOG2_RESET_B_DEB                   = IOMUX_PAD(0x0458, 0x0190, 4, 0x0000, 0, 0),
	MX6_PAD_AUD_MCLK__GPIO1_IO06                          = IOMUX_PAD(0x0458, 0x0190, 5, 0x0000, 0, 0),
	MX6_PAD_AUD_MCLK__SPDIF_EXT_CLK                       = IOMUX_PAD(0x0458, 0x0190, 6, 0x073C, 1, 0),

	MX6_PAD_UART1_RXD__UART1_DCE_RX                       = IOMUX_PAD(0x045C, 0x0194, 0, 0x0744, 0, 0),

	MX6_PAD_UART1_RXD__UART1_DTE_TX                       = IOMUX_PAD(0x045C, 0x0194, 0, 0x0000, 0, 0),
	MX6_PAD_UART1_RXD__PWM1_OUT                           = IOMUX_PAD(0x045C, 0x0194, 1, 0x0000, 0, 0),
	MX6_PAD_UART1_RXD__UART4_DCE_RX                       = IOMUX_PAD(0x045C, 0x0194, 2, 0x075C, 4, 0),
	MX6_PAD_UART1_RXD__UART4_DTE_TX                       = IOMUX_PAD(0x045C, 0x0194, 2, 0x0000, 0, 0),
	MX6_PAD_UART1_RXD__UART5_DCE_RX                       = IOMUX_PAD(0x045C, 0x0194, 4, 0x0764, 6, 0),
	MX6_PAD_UART1_RXD__UART5_DTE_TX                       = IOMUX_PAD(0x045C, 0x0194, 4, 0x0000, 0, 0),
	MX6_PAD_UART1_RXD__GPIO3_IO16                         = IOMUX_PAD(0x045C, 0x0194, 5, 0x0000, 0, 0),

	MX6_PAD_UART1_TXD__UART1_DCE_TX                       = IOMUX_PAD(0x0460, 0x0198, 0, 0x0000, 0, 0),

	MX6_PAD_UART1_TXD__UART1_DTE_RX                       = IOMUX_PAD(0x0460, 0x0198, 0, 0x0744, 1, 0),
	MX6_PAD_UART1_TXD__PWM2_OUT                           = IOMUX_PAD(0x0460, 0x0198, 1, 0x0000, 0, 0),
	MX6_PAD_UART1_TXD__UART4_DCE_TX                       = IOMUX_PAD(0x0460, 0x0198, 2, 0x0000, 0, 0),
	MX6_PAD_UART1_TXD__UART4_DTE_RX                       = IOMUX_PAD(0x0460, 0x0198, 2, 0x075C, 5, 0),
	MX6_PAD_UART1_TXD__UART5_DCE_TX                       = IOMUX_PAD(0x0460, 0x0198, 4, 0x0000, 0, 0),
	MX6_PAD_UART1_TXD__UART5_DTE_RX                       = IOMUX_PAD(0x0460, 0x0198, 4, 0x0764, 7, 0),
	MX6_PAD_UART1_TXD__GPIO3_IO17                         = IOMUX_PAD(0x0460, 0x0198, 5, 0x0000, 0, 0),
	MX6_PAD_UART1_TXD__UART5_DCD_B                        = IOMUX_PAD(0x0460, 0x0198, 7, 0x0000, 0, 0),

	MX6_PAD_I2C1_SCL__I2C1_SCL                            = IOMUX_PAD(0x0464, 0x019C, IOMUX_CONFIG_SION | 0, 0x067C, 0, 0),
	MX6_PAD_I2C1_SCL__UART1_DCE_RTS                       = IOMUX_PAD(0x0464, 0x019C, 1, 0x0740, 0, 0),
	MX6_PAD_I2C1_SCL__UART1_DTE_CTS                       = IOMUX_PAD(0x0464, 0x019C, 1, 0x0000, 0, 0),
	MX6_PAD_I2C1_SCL__ECSPI3_SS2                          = IOMUX_PAD(0x0464, 0x019C, 2, 0x0640, 0, 0),
	MX6_PAD_I2C1_SCL__SD3_RESET                           = IOMUX_PAD(0x0464, 0x019C, 4, 0x0000, 0, 0),
	MX6_PAD_I2C1_SCL__GPIO3_IO12                          = IOMUX_PAD(0x0464, 0x019C, 5, 0x0000, 0, 0),
	MX6_PAD_I2C1_SCL__ECSPI1_SS1                          = IOMUX_PAD(0x0464, 0x019C, 6, 0x060C, 0, 0),

	MX6_PAD_I2C1_SDA__I2C1_SDA                            = IOMUX_PAD(0x0468, 0x01A0, IOMUX_CONFIG_SION | 0, 0x0680, 0, 0),
	MX6_PAD_I2C1_SDA__UART1_DCE_CTS                       = IOMUX_PAD(0x0468, 0x01A0, 1, 0x0000, 0, 0),
	MX6_PAD_I2C1_SDA__UART1_DTE_RTS                       = IOMUX_PAD(0x0468, 0x01A0, 1, 0x0740, 1, 0),
	MX6_PAD_I2C1_SDA__ECSPI3_SS3                          = IOMUX_PAD(0x0468, 0x01A0, 2, 0x0644, 0, 0),
	MX6_PAD_I2C1_SDA__SD3_VSELECT                         = IOMUX_PAD(0x0468, 0x01A0, 4, 0x0000, 0, 0),
	MX6_PAD_I2C1_SDA__GPIO3_IO13                          = IOMUX_PAD(0x0468, 0x01A0, 5, 0x0000, 0, 0),
	MX6_PAD_I2C1_SDA__ECSPI1_SS2                          = IOMUX_PAD(0x0468, 0x01A0, 6, 0x0610, 0, 0),

	MX6_PAD_I2C2_SCL__I2C2_SCL                            = IOMUX_PAD(0x046C, 0x01A4, IOMUX_CONFIG_SION | 0, 0x0684, 3, 0),
	MX6_PAD_I2C2_SCL__AUD4_RXFS                           = IOMUX_PAD(0x046C, 0x01A4, 1, 0x0570, 2, 0),
	MX6_PAD_I2C2_SCL__SPDIF_IN                            = IOMUX_PAD(0x046C, 0x01A4, 2, 0x0738, 2, 0),
	MX6_PAD_I2C2_SCL__SD3_WP                              = IOMUX_PAD(0x046C, 0x01A4, 4, 0x0794, 3, 0),
	MX6_PAD_I2C2_SCL__GPIO3_IO14                          = IOMUX_PAD(0x046C, 0x01A4, 5, 0x0000, 0, 0),
	MX6_PAD_I2C2_SCL__ECSPI1_RDY                          = IOMUX_PAD(0x046C, 0x01A4, 6, 0x0600, 1, 0),

	MX6_PAD_I2C2_SDA__I2C2_SDA                            = IOMUX_PAD(0x0470, 0x01A8, IOMUX_CONFIG_SION | 0, 0x0688, 3, 0),
	MX6_PAD_I2C2_SDA__AUD4_RXC                            = IOMUX_PAD(0x0470, 0x01A8, 1, 0x056C, 2, 0),
	MX6_PAD_I2C2_SDA__SPDIF_OUT                           = IOMUX_PAD(0x0470, 0x01A8, 2, 0x0000, 0, 0),
	MX6_PAD_I2C2_SDA__SD3_CD_B                            = IOMUX_PAD(0x0470, 0x01A8, 4, 0x0780, 3, 0),
	MX6_PAD_I2C2_SDA__GPIO3_IO15                          = IOMUX_PAD(0x0470, 0x01A8, 5, 0x0000, 0, 0),

	MX6_PAD_ECSPI1_SCLK__ECSPI1_SCLK                      = IOMUX_PAD(0x0474, 0x01AC, 0, 0x05FC, 1, 0),
	MX6_PAD_ECSPI1_SCLK__AUD4_TXD                         = IOMUX_PAD(0x0474, 0x01AC, 1, 0x0568, 1, 0),
	MX6_PAD_ECSPI1_SCLK__UART5_DCE_RX                     = IOMUX_PAD(0x0474, 0x01AC, 2, 0x0764, 2, 0),
	MX6_PAD_ECSPI1_SCLK__UART5_DTE_TX                     = IOMUX_PAD(0x0474, 0x01AC, 2, 0x0000, 0, 0),
	MX6_PAD_ECSPI1_SCLK__EPDC_VCOM0                       = IOMUX_PAD(0x0474, 0x01AC, 3, 0x0000, 0, 0),
	MX6_PAD_ECSPI1_SCLK__SD2_RESET                        = IOMUX_PAD(0x0474, 0x01AC, 4, 0x0000, 0, 0),
	MX6_PAD_ECSPI1_SCLK__GPIO4_IO08                       = IOMUX_PAD(0x0474, 0x01AC, 5, 0x0000, 0, 0),
	MX6_PAD_ECSPI1_SCLK__USB_OTG2_OC                      = IOMUX_PAD(0x0474, 0x01AC, 6, 0x0768, 1, 0),

	MX6_PAD_ECSPI1_MOSI__ECSPI1_MOSI                      = IOMUX_PAD(0x0478, 0x01B0, 0, 0x0608, 1, 0),
	MX6_PAD_ECSPI1_MOSI__AUD4_TXC                         = IOMUX_PAD(0x0478, 0x01B0, 1, 0x0574, 1, 0),
	MX6_PAD_ECSPI1_MOSI__UART5_DCE_TX                     = IOMUX_PAD(0x0478, 0x01B0, 2, 0x0000, 0, 0),
	MX6_PAD_ECSPI1_MOSI__UART5_DTE_RX                     = IOMUX_PAD(0x0478, 0x01B0, 2, 0x0764, 3, 0),
	MX6_PAD_ECSPI1_MOSI__EPDC_VCOM1                       = IOMUX_PAD(0x0478, 0x01B0, 3, 0x0000, 0, 0),
	MX6_PAD_ECSPI1_MOSI__SD2_VSELECT                      = IOMUX_PAD(0x0478, 0x01B0, 4, 0x0000, 0, 0),
	MX6_PAD_ECSPI1_MOSI__GPIO4_IO09                       = IOMUX_PAD(0x0478, 0x01B0, 5, 0x0000, 0, 0),

	MX6_PAD_ECSPI1_MISO__ECSPI1_MISO                      = IOMUX_PAD(0x047C, 0x01B4, 0, 0x0604, 1, 0),
	MX6_PAD_ECSPI1_MISO__AUD4_TXFS                        = IOMUX_PAD(0x047C, 0x01B4, 1, 0x0578, 1, 0),
	MX6_PAD_ECSPI1_MISO__UART5_DCE_RTS                    = IOMUX_PAD(0x047C, 0x01B4, 2, 0x0760, 2, 0),
	MX6_PAD_ECSPI1_MISO__UART5_DTE_CTS                    = IOMUX_PAD(0x047C, 0x01B4, 2, 0x0000, 0, 0),
	MX6_PAD_ECSPI1_MISO__EPDC_BDR0                        = IOMUX_PAD(0x047C, 0x01B4, 3, 0x0000, 0, 0),
	MX6_PAD_ECSPI1_MISO__SD2_WP                           = IOMUX_PAD(0x047C, 0x01B4, 4, 0x077C, 0, 0),
	MX6_PAD_ECSPI1_MISO__GPIO4_IO10                       = IOMUX_PAD(0x047C, 0x01B4, 5, 0x0000, 0, 0),

	MX6_PAD_ECSPI1_SS0__ECSPI1_SS0                        = IOMUX_PAD(0x0480, 0x01B8, 0, 0x0614, 1, 0),
	MX6_PAD_ECSPI1_SS0__AUD4_RXD                          = IOMUX_PAD(0x0480, 0x01B8, 1, 0x0564, 1, 0),
	MX6_PAD_ECSPI1_SS0__UART5_DCE_CTS                     = IOMUX_PAD(0x0480, 0x01B8, 2, 0x0000, 0, 0),
	MX6_PAD_ECSPI1_SS0__UART5_DTE_RTS                     = IOMUX_PAD(0x0480, 0x01B8, 2, 0x0760, 3, 0),
	MX6_PAD_ECSPI1_SS0__EPDC_BDR1                         = IOMUX_PAD(0x0480, 0x01B8, 3, 0x0000, 0, 0),
	MX6_PAD_ECSPI1_SS0__SD2_CD_B                          = IOMUX_PAD(0x0480, 0x01B8, 4, 0x0778, 0, 0),
	MX6_PAD_ECSPI1_SS0__GPIO4_IO11                        = IOMUX_PAD(0x0480, 0x01B8, 5, 0x0000, 0, 0),
	MX6_PAD_ECSPI1_SS0__USB_OTG2_PWR                      = IOMUX_PAD(0x0480, 0x01B8, 6, 0x0000, 0, 0),

	MX6_PAD_ECSPI2_SCLK__ECSPI2_SCLK                      = IOMUX_PAD(0x0484, 0x01BC, 0, 0x061C, 1, 0),
	MX6_PAD_ECSPI2_SCLK__SPDIF_EXT_CLK                    = IOMUX_PAD(0x0484, 0x01BC, 1, 0x073C, 2, 0),
	MX6_PAD_ECSPI2_SCLK__UART3_DCE_RX                     = IOMUX_PAD(0x0484, 0x01BC, 2, 0x0754, 2, 0),
	MX6_PAD_ECSPI2_SCLK__UART3_DTE_TX                     = IOMUX_PAD(0x0484, 0x01BC, 2, 0x0000, 0, 0),
	MX6_PAD_ECSPI2_SCLK__CSI_PIXCLK                       = IOMUX_PAD(0x0484, 0x01BC, 3, 0x05F4, 1, 0),
	MX6_PAD_ECSPI2_SCLK__SD1_RESET                        = IOMUX_PAD(0x0484, 0x01BC, 4, 0x0000, 0, 0),
	MX6_PAD_ECSPI2_SCLK__GPIO4_IO12                       = IOMUX_PAD(0x0484, 0x01BC, 5, 0x0000, 0, 0),
	MX6_PAD_ECSPI2_SCLK__USB_OTG2_OC                      = IOMUX_PAD(0x0484, 0x01BC, 6, 0x0768, 2, 0),

	MX6_PAD_ECSPI2_MOSI__ECSPI2_MOSI                      = IOMUX_PAD(0x0488, 0x01C0, 0, 0x0624, 1, 0),
	MX6_PAD_ECSPI2_MOSI__SDMA_EXT_EVENT1                  = IOMUX_PAD(0x0488, 0x01C0, 1, 0x0000, 0, 0),
	MX6_PAD_ECSPI2_MOSI__UART3_DCE_TX                     = IOMUX_PAD(0x0488, 0x01C0, 2, 0x0000, 0, 0),
	MX6_PAD_ECSPI2_MOSI__UART3_DTE_RX                     = IOMUX_PAD(0x0488, 0x01C0, 2, 0x0754, 3, 0),
	MX6_PAD_ECSPI2_MOSI__CSI_HSYNC                        = IOMUX_PAD(0x0488, 0x01C0, 3, 0x05F0, 1, 0),
	MX6_PAD_ECSPI2_MOSI__SD1_VSELECT                      = IOMUX_PAD(0x0488, 0x01C0, 4, 0x0000, 0, 0),
	MX6_PAD_ECSPI2_MOSI__GPIO4_IO13                       = IOMUX_PAD(0x0488, 0x01C0, 5, 0x0000, 0, 0),

	MX6_PAD_ECSPI2_MISO__ECSPI2_MISO                      = IOMUX_PAD(0x048C, 0x01C4, 0, 0x0620, 1, 0),
	MX6_PAD_ECSPI2_MISO__SDMA_EXT_EVENT0                  = IOMUX_PAD(0x048C, 0x01C4, 1, 0x0000, 0, 0),
	MX6_PAD_ECSPI2_MISO__UART3_DCE_RTS                    = IOMUX_PAD(0x048C, 0x01C4, 2, 0x0750, 0, 0),
	MX6_PAD_ECSPI2_MISO__UART3_DTE_CTS                    = IOMUX_PAD(0x048C, 0x01C4, 2, 0x0000, 0, 0),
	MX6_PAD_ECSPI2_MISO__CSI_MCLK                         = IOMUX_PAD(0x048C, 0x01C4, 3, 0x0000, 0, 0),
	MX6_PAD_ECSPI2_MISO__SD1_WP                           = IOMUX_PAD(0x048C, 0x01C4, 4, 0x0774, 2, 0),
	MX6_PAD_ECSPI2_MISO__GPIO4_IO14                       = IOMUX_PAD(0x048C, 0x01C4, 5, 0x0000, 0, 0),
	MX6_PAD_ECSPI2_MISO__USB_OTG1_OC                      = IOMUX_PAD(0x048C, 0x01C4, 6, 0x076C, 1, 0),

	MX6_PAD_ECSPI2_SS0__ECSPI2_SS0                        = IOMUX_PAD(0x0490, 0x01C8, 0, 0x0628, 0, 0),
	MX6_PAD_ECSPI2_SS0__ECSPI1_SS3                        = IOMUX_PAD(0x0490, 0x01C8, 1, 0x0618, 1, 0),
	MX6_PAD_ECSPI2_SS0__UART3_DCE_CTS                     = IOMUX_PAD(0x0490, 0x01C8, 2, 0x0000, 0, 0),
	MX6_PAD_ECSPI2_SS0__UART3_DTE_RTS                     = IOMUX_PAD(0x0490, 0x01C8, 2, 0x0750, 1, 0),
	MX6_PAD_ECSPI2_SS0__CSI_VSYNC                         = IOMUX_PAD(0x0490, 0x01C8, 3, 0x05F8, 1, 0),
	MX6_PAD_ECSPI2_SS0__SD1_CD_B                          = IOMUX_PAD(0x0490, 0x01C8, 4, 0x0770, 2, 0),
	MX6_PAD_ECSPI2_SS0__GPIO4_IO15                        = IOMUX_PAD(0x0490, 0x01C8, 5, 0x0000, 0, 0),
	MX6_PAD_ECSPI2_SS0__USB_OTG1_PWR                      = IOMUX_PAD(0x0490, 0x01C8, 6, 0x0000, 0, 0),

	MX6_PAD_SD1_CLK__SD1_CLK                              = IOMUX_PAD(0x0494, 0x01CC, 0, 0x0000, 0, 0),
	MX6_PAD_SD1_CLK__KEY_COL0                             = IOMUX_PAD(0x0494, 0x01CC, 2, 0x06A0, 2, 0),
	MX6_PAD_SD1_CLK__EPDC_SDCE4                           = IOMUX_PAD(0x0494, 0x01CC, 3, 0x0000, 0, 0),
	MX6_PAD_SD1_CLK__GPIO5_IO15                           = IOMUX_PAD(0x0494, 0x01CC, 5, 0x0000, 0, 0),

	MX6_PAD_SD1_CMD__SD1_CMD                              = IOMUX_PAD(0x0498, 0x01D0, 0, 0x0000, 0, 0),
	MX6_PAD_SD1_CMD__KEY_ROW0                             = IOMUX_PAD(0x0498, 0x01D0, 2, 0x06C0, 2, 0),
	MX6_PAD_SD1_CMD__EPDC_SDCE5                           = IOMUX_PAD(0x0498, 0x01D0, 3, 0x0000, 0, 0),
	MX6_PAD_SD1_CMD__GPIO5_IO14                           = IOMUX_PAD(0x0498, 0x01D0, 5, 0x0000, 0, 0),

	MX6_PAD_SD1_DATA0__SD1_DATA0                          = IOMUX_PAD(0x049C, 0x01D4, 0, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA0__KEY_COL1                           = IOMUX_PAD(0x049C, 0x01D4, 2, 0x06A4, 2, 0),
	MX6_PAD_SD1_DATA0__EPDC_SDCE6                         = IOMUX_PAD(0x049C, 0x01D4, 3, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA0__GPIO5_IO11                         = IOMUX_PAD(0x049C, 0x01D4, 5, 0x0000, 0, 0),

	MX6_PAD_SD1_DATA1__SD1_DATA1                          = IOMUX_PAD(0x04A0, 0x01D8, 0, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA1__KEY_ROW1                           = IOMUX_PAD(0x04A0, 0x01D8, 2, 0x06C4, 2, 0),
	MX6_PAD_SD1_DATA1__EPDC_SDCE7                         = IOMUX_PAD(0x04A0, 0x01D8, 3, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA1__GPIO5_IO08                         = IOMUX_PAD(0x04A0, 0x01D8, 5, 0x0000, 0, 0),

	MX6_PAD_SD1_DATA2__SD1_DATA2                          = IOMUX_PAD(0x04A4, 0x01DC, 0, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA2__KEY_COL2                           = IOMUX_PAD(0x04A4, 0x01DC, 2, 0x06A8, 2, 0),
	MX6_PAD_SD1_DATA2__EPDC_SDCE8                         = IOMUX_PAD(0x04A4, 0x01DC, 3, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA2__GPIO5_IO13                         = IOMUX_PAD(0x04A4, 0x01DC, 5, 0x0000, 0, 0),

	MX6_PAD_SD1_DATA3__SD1_DATA3                          = IOMUX_PAD(0x04A8, 0x01E0, 0, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA3__KEY_ROW2                           = IOMUX_PAD(0x04A8, 0x01E0, 2, 0x06C8, 2, 0),
	MX6_PAD_SD1_DATA3__EPDC_SDCE9                         = IOMUX_PAD(0x04A8, 0x01E0, 3, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA3__GPIO5_IO06                         = IOMUX_PAD(0x04A8, 0x01E0, 5, 0x0000, 0, 0),

	MX6_PAD_SD1_DATA4__SD1_DATA4                          = IOMUX_PAD(0x04AC, 0x01E4, 0, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA4__KEY_COL3                           = IOMUX_PAD(0x04AC, 0x01E4, 2, 0x06AC, 2, 0),
	MX6_PAD_SD1_DATA4__EPDC_SDCLK_N                       = IOMUX_PAD(0x04AC, 0x01E4, 3, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA4__UART4_DCE_RX                       = IOMUX_PAD(0x04AC, 0x01E4, 4, 0x075C, 6, 0),
	MX6_PAD_SD1_DATA4__UART4_DTE_TX                       = IOMUX_PAD(0x04AC, 0x01E4, 4, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA4__GPIO5_IO12                         = IOMUX_PAD(0x04AC, 0x01E4, 5, 0x0000, 0, 0),

	MX6_PAD_SD1_DATA5__SD1_DATA5                          = IOMUX_PAD(0x04B0, 0x01E8, 0, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA5__KEY_ROW3                           = IOMUX_PAD(0x04B0, 0x01E8, 2, 0x06CC, 2, 0),
	MX6_PAD_SD1_DATA5__EPDC_SDOED                         = IOMUX_PAD(0x04B0, 0x01E8, 3, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA5__UART4_DCE_TX                       = IOMUX_PAD(0x04B0, 0x01E8, 4, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA5__UART4_DTE_RX                       = IOMUX_PAD(0x04B0, 0x01E8, 4, 0x075C, 7, 0),
	MX6_PAD_SD1_DATA5__GPIO5_IO09                         = IOMUX_PAD(0x04B0, 0x01E8, 5, 0x0000, 0, 0),

	MX6_PAD_SD1_DATA6__SD1_DATA6                          = IOMUX_PAD(0x04B4, 0x01EC, 0, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA6__KEY_COL4                           = IOMUX_PAD(0x04B4, 0x01EC, 2, 0x06B0, 2, 0),
	MX6_PAD_SD1_DATA6__EPDC_SDOEZ                         = IOMUX_PAD(0x04B4, 0x01EC, 3, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA6__UART4_DCE_RTS                      = IOMUX_PAD(0x04B4, 0x01EC, 4, 0x0758, 4, 0),
	MX6_PAD_SD1_DATA6__UART4_DTE_CTS                      = IOMUX_PAD(0x04B4, 0x01EC, 4, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA6__GPIO5_IO07                         = IOMUX_PAD(0x04B4, 0x01EC, 5, 0x0000, 0, 0),

	MX6_PAD_SD1_DATA7__SD1_DATA7                          = IOMUX_PAD(0x04B8, 0x01F0, 0, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA7__KEY_ROW4                           = IOMUX_PAD(0x04B8, 0x01F0, 2, 0x06D0, 2, 0),
	MX6_PAD_SD1_DATA7__CCM_PMIC_READY                     = IOMUX_PAD(0x04B8, 0x01F0, 3, 0x05AC, 3, 0),
	MX6_PAD_SD1_DATA7__UART4_DCE_CTS                      = IOMUX_PAD(0x04B8, 0x01F0, 4, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA7__UART4_DTE_RTS                      = IOMUX_PAD(0x04B8, 0x01F0, 4, 0x0758, 5, 0),
	MX6_PAD_SD1_DATA7__GPIO5_IO10                         = IOMUX_PAD(0x04B8, 0x01F0, 5, 0x0000, 0, 0),

	MX6_PAD_SD2_RESET__SD2_RESET                          = IOMUX_PAD(0x04BC, 0x01F4, 0, 0x0000, 0, 0),
	MX6_PAD_SD2_RESET__WDOG2_B                            = IOMUX_PAD(0x04BC, 0x01F4, 2, 0x0000, 0, 0),
	MX6_PAD_SD2_RESET__SPDIF_OUT                          = IOMUX_PAD(0x04BC, 0x01F4, 3, 0x0000, 0, 0),
	MX6_PAD_SD2_RESET__CSI_MCLK                           = IOMUX_PAD(0x04BC, 0x01F4, 4, 0x0000, 0, 0),
	MX6_PAD_SD2_RESET__GPIO4_IO27                         = IOMUX_PAD(0x04BC, 0x01F4, 5, 0x0000, 0, 0),

	MX6_PAD_SD2_CLK__SD2_CLK                              = IOMUX_PAD(0x04C0, 0x01F8, 0, 0x0000, 0, 0),
	MX6_PAD_SD2_CLK__AUD4_RXFS                            = IOMUX_PAD(0x04C0, 0x01F8, 1, 0x0570, 1, 0),
	MX6_PAD_SD2_CLK__ECSPI3_SCLK                          = IOMUX_PAD(0x04C0, 0x01F8, 2, 0x0630, 1, 0),
	MX6_PAD_SD2_CLK__CSI_DATA00                           = IOMUX_PAD(0x04C0, 0x01F8, 3, 0x05C8, 1, 0),
	MX6_PAD_SD2_CLK__GPIO5_IO05                           = IOMUX_PAD(0x04C0, 0x01F8, 5, 0x0000, 0, 0),

	MX6_PAD_SD2_CMD__SD2_CMD                              = IOMUX_PAD(0x04C4, 0x01FC, 0, 0x0000, 0, 0),
	MX6_PAD_SD2_CMD__AUD4_RXC                             = IOMUX_PAD(0x04C4, 0x01FC, 1, 0x056C, 1, 0),
	MX6_PAD_SD2_CMD__ECSPI3_SS0                           = IOMUX_PAD(0x04C4, 0x01FC, 2, 0x0648, 1, 0),
	MX6_PAD_SD2_CMD__CSI_DATA01                           = IOMUX_PAD(0x04C4, 0x01FC, 3, 0x05CC, 1, 0),
	MX6_PAD_SD2_CMD__EPIT1_OUT                            = IOMUX_PAD(0x04C4, 0x01FC, 4, 0x0000, 0, 0),
	MX6_PAD_SD2_CMD__GPIO5_IO04                           = IOMUX_PAD(0x04C4, 0x01FC, 5, 0x0000, 0, 0),

	MX6_PAD_SD2_DATA0__SD2_DATA0                          = IOMUX_PAD(0x04C8, 0x0200, 0, 0x0000, 0, 0),
	MX6_PAD_SD2_DATA0__AUD4_RXD                           = IOMUX_PAD(0x04C8, 0x0200, 1, 0x0564, 2, 0),
	MX6_PAD_SD2_DATA0__ECSPI3_MOSI                        = IOMUX_PAD(0x04C8, 0x0200, 2, 0x063C, 1, 0),
	MX6_PAD_SD2_DATA0__CSI_DATA02                         = IOMUX_PAD(0x04C8, 0x0200, 3, 0x05D0, 1, 0),
	MX6_PAD_SD2_DATA0__UART5_DCE_RTS                      = IOMUX_PAD(0x04C8, 0x0200, 4, 0x0760, 4, 0),
	MX6_PAD_SD2_DATA0__UART5_DTE_CTS                      = IOMUX_PAD(0x04C8, 0x0200, 4, 0x0000, 0, 0),
	MX6_PAD_SD2_DATA0__GPIO5_IO01                         = IOMUX_PAD(0x04C8, 0x0200, 5, 0x0000, 0, 0),

	MX6_PAD_SD2_DATA1__SD2_DATA1                          = IOMUX_PAD(0x04CC, 0x0204, 0, 0x0000, 0, 0),
	MX6_PAD_SD2_DATA1__AUD4_TXC                           = IOMUX_PAD(0x04CC, 0x0204, 1, 0x0574, 2, 0),
	MX6_PAD_SD2_DATA1__ECSPI3_MISO                        = IOMUX_PAD(0x04CC, 0x0204, 2, 0x0638, 1, 0),
	MX6_PAD_SD2_DATA1__CSI_DATA03                         = IOMUX_PAD(0x04CC, 0x0204, 3, 0x05D4, 1, 0),
	MX6_PAD_SD2_DATA1__UART5_DCE_CTS                      = IOMUX_PAD(0x04CC, 0x0204, 4, 0x0000, 0, 0),
	MX6_PAD_SD2_DATA1__UART5_DTE_RTS                      = IOMUX_PAD(0x04CC, 0x0204, 4, 0x0760, 5, 0),
	MX6_PAD_SD2_DATA1__GPIO4_IO30                         = IOMUX_PAD(0x04CC, 0x0204, 5, 0x0000, 0, 0),

	MX6_PAD_SD2_DATA2__SD2_DATA2                          = IOMUX_PAD(0x04D0, 0x0208, 0, 0x0000, 0, 0),
	MX6_PAD_SD2_DATA2__AUD4_TXFS                          = IOMUX_PAD(0x04D0, 0x0208, 1, 0x0578, 2, 0),
	MX6_PAD_SD2_DATA2__CSI_DATA04                         = IOMUX_PAD(0x04D0, 0x0208, 3, 0x05D8, 1, 0),
	MX6_PAD_SD2_DATA2__UART5_DCE_RX                       = IOMUX_PAD(0x04D0, 0x0208, 4, 0x0764, 4, 0),
	MX6_PAD_SD2_DATA2__UART5_DTE_TX                       = IOMUX_PAD(0x04D0, 0x0208, 4, 0x0000, 0, 0),
	MX6_PAD_SD2_DATA2__GPIO5_IO03                         = IOMUX_PAD(0x04D0, 0x0208, 5, 0x0000, 0, 0),

	MX6_PAD_SD2_DATA3__SD2_DATA3                          = IOMUX_PAD(0x04D4, 0x020C, 0, 0x0000, 0, 0),
	MX6_PAD_SD2_DATA3__AUD4_TXD                           = IOMUX_PAD(0x04D4, 0x020C, 1, 0x0568, 2, 0),
	MX6_PAD_SD2_DATA3__CSI_DATA05                         = IOMUX_PAD(0x04D4, 0x020C, 3, 0x05DC, 1, 0),
	MX6_PAD_SD2_DATA3__UART5_DCE_TX                       = IOMUX_PAD(0x04D4, 0x020C, 4, 0x0000, 0, 0),
	MX6_PAD_SD2_DATA3__UART5_DTE_RX                       = IOMUX_PAD(0x04D4, 0x020C, 4, 0x0764, 5, 0),
	MX6_PAD_SD2_DATA3__GPIO4_IO28                         = IOMUX_PAD(0x04D4, 0x020C, 5, 0x0000, 0, 0),

	MX6_PAD_SD2_DATA4__SD2_DATA4                          = IOMUX_PAD(0x04D8, 0x0210, 0, 0x0000, 0, 0),
	MX6_PAD_SD2_DATA4__SD3_DATA4                          = IOMUX_PAD(0x04D8, 0x0210, 1, 0x0784, 1, 0),
	MX6_PAD_SD2_DATA4__UART2_DCE_RX                       = IOMUX_PAD(0x04D8, 0x0210, 2, 0x074C, 2, 0),
	MX6_PAD_SD2_DATA4__UART2_DTE_TX                       = IOMUX_PAD(0x04D8, 0x0210, 2, 0x0000, 0, 0),
	MX6_PAD_SD2_DATA4__CSI_DATA06                         = IOMUX_PAD(0x04D8, 0x0210, 3, 0x05E0, 1, 0),
	MX6_PAD_SD2_DATA4__SPDIF_OUT                          = IOMUX_PAD(0x04D8, 0x0210, 4, 0x0000, 0, 0),
	MX6_PAD_SD2_DATA4__GPIO5_IO02                         = IOMUX_PAD(0x04D8, 0x0210, 5, 0x0000, 0, 0),

	MX6_PAD_SD2_DATA5__SD2_DATA5                          = IOMUX_PAD(0x04DC, 0x0214, 0, 0x0000, 0, 0),
	MX6_PAD_SD2_DATA5__SD3_DATA5                          = IOMUX_PAD(0x04DC, 0x0214, 1, 0x0788, 1, 0),
	MX6_PAD_SD2_DATA5__UART2_DCE_TX                       = IOMUX_PAD(0x04DC, 0x0214, 2, 0x0000, 0, 0),
	MX6_PAD_SD2_DATA5__UART2_DTE_RX                       = IOMUX_PAD(0x04DC, 0x0214, 2, 0x074C, 3, 0),
	MX6_PAD_SD2_DATA5__CSI_DATA07                         = IOMUX_PAD(0x04DC, 0x0214, 3, 0x05E4, 1, 0),
	MX6_PAD_SD2_DATA5__SPDIF_IN                           = IOMUX_PAD(0x04DC, 0x0214, 4, 0x0738, 1, 0),
	MX6_PAD_SD2_DATA5__GPIO4_IO31                         = IOMUX_PAD(0x04DC, 0x0214, 5, 0x0000, 0, 0),

	MX6_PAD_SD2_DATA6__SD2_DATA6                          = IOMUX_PAD(0x04E0, 0x0218, 0, 0x0000, 0, 0),
	MX6_PAD_SD2_DATA6__SD3_DATA6                          = IOMUX_PAD(0x04E0, 0x0218, 1, 0x078C, 1, 0),
	MX6_PAD_SD2_DATA6__UART2_DCE_RTS                      = IOMUX_PAD(0x04E0, 0x0218, 2, 0x0748, 2, 0),
	MX6_PAD_SD2_DATA6__UART2_DTE_CTS                      = IOMUX_PAD(0x04E0, 0x0218, 2, 0x0000, 0, 0),
	MX6_PAD_SD2_DATA6__CSI_DATA08                         = IOMUX_PAD(0x04E0, 0x0218, 3, 0x05E8, 1, 0),
	MX6_PAD_SD2_DATA6__SD2_WP                             = IOMUX_PAD(0x04E0, 0x0218, 4, 0x077C, 1, 0),
	MX6_PAD_SD2_DATA6__GPIO4_IO29                         = IOMUX_PAD(0x04E0, 0x0218, 5, 0x0000, 0, 0),

	MX6_PAD_SD2_DATA7__SD2_DATA7                          = IOMUX_PAD(0x04E4, 0x021C, 0, 0x0000, 0, 0),
	MX6_PAD_SD2_DATA7__SD3_DATA7                          = IOMUX_PAD(0x04E4, 0x021C, 1, 0x0790, 1, 0),
	MX6_PAD_SD2_DATA7__UART2_DCE_CTS                      = IOMUX_PAD(0x04E4, 0x021C, 2, 0x0000, 0, 0),
	MX6_PAD_SD2_DATA7__UART2_DTE_RTS                      = IOMUX_PAD(0x04E4, 0x021C, 2, 0x0748, 3, 0),
	MX6_PAD_SD2_DATA7__CSI_DATA09                         = IOMUX_PAD(0x04E4, 0x021C, 3, 0x05EC, 1, 0),
	MX6_PAD_SD2_DATA7__SD2_CD_B                           = IOMUX_PAD(0x04E4, 0x021C, 4, 0x0778, 1, 0),
	MX6_PAD_SD2_DATA7__GPIO5_IO00                         = IOMUX_PAD(0x04E4, 0x021C, 5, 0x0000, 0, 0),

	MX6_PAD_SD3_CLK__SD3_CLK                              = IOMUX_PAD(0x04E8, 0x0220, 0, 0x0000, 0, 0),
	MX6_PAD_SD3_CLK__AUD5_RXFS                            = IOMUX_PAD(0x04E8, 0x0220, 1, 0x0588, 0, 0),
	MX6_PAD_SD3_CLK__KEY_COL5                             = IOMUX_PAD(0x04E8, 0x0220, 2, 0x0694, 0, 0),
	MX6_PAD_SD3_CLK__CSI_DATA10                           = IOMUX_PAD(0x04E8, 0x0220, 3, 0x05B0, 0, 0),
	MX6_PAD_SD3_CLK__WDOG1_RESET_B_DEB                    = IOMUX_PAD(0x04E8, 0x0220, 4, 0x0000, 0, 0),
	MX6_PAD_SD3_CLK__GPIO5_IO18                           = IOMUX_PAD(0x04E8, 0x0220, 5, 0x0000, 0, 0),
	MX6_PAD_SD3_CLK__USB_OTG1_PWR                         = IOMUX_PAD(0x04E8, 0x0220, 6, 0x0000, 0, 0),

	MX6_PAD_SD3_CMD__SD3_CMD                              = IOMUX_PAD(0x04EC, 0x0224, 0, 0x0000, 0, 0),
	MX6_PAD_SD3_CMD__AUD5_RXC                             = IOMUX_PAD(0x04EC, 0x0224, 1, 0x0584, 0, 0),
	MX6_PAD_SD3_CMD__KEY_ROW5                             = IOMUX_PAD(0x04EC, 0x0224, 2, 0x06B4, 0, 0),
	MX6_PAD_SD3_CMD__CSI_DATA11                           = IOMUX_PAD(0x04EC, 0x0224, 3, 0x05B4, 0, 0),
	MX6_PAD_SD3_CMD__USB_OTG2_ID                          = IOMUX_PAD(0x04EC, 0x0224, 4, 0x0560, 1, 0),
	MX6_PAD_SD3_CMD__GPIO5_IO21                           = IOMUX_PAD(0x04EC, 0x0224, 5, 0x0000, 0, 0),
	MX6_PAD_SD3_CMD__USB_OTG2_PWR                         = IOMUX_PAD(0x04EC, 0x0224, 6, 0x0000, 0, 0),

	MX6_PAD_SD3_DATA0__SD3_DATA0                          = IOMUX_PAD(0x04F0, 0x0228, 0, 0x0000, 0, 0),
	MX6_PAD_SD3_DATA0__AUD5_RXD                           = IOMUX_PAD(0x04F0, 0x0228, 1, 0x057C, 0, 0),
	MX6_PAD_SD3_DATA0__KEY_COL6                           = IOMUX_PAD(0x04F0, 0x0228, 2, 0x0698, 0, 0),
	MX6_PAD_SD3_DATA0__CSI_DATA12                         = IOMUX_PAD(0x04F0, 0x0228, 3, 0x05B8, 0, 0),
	MX6_PAD_SD3_DATA0__USB_OTG1_ID                        = IOMUX_PAD(0x04F0, 0x0228, 4, 0x055C, 1, 0),
	MX6_PAD_SD3_DATA0__GPIO5_IO19                         = IOMUX_PAD(0x04F0, 0x0228, 5, 0x0000, 0, 0),

	MX6_PAD_SD3_DATA1__SD3_DATA1                          = IOMUX_PAD(0x04F4, 0x022C, 0, 0x0000, 0, 0),
	MX6_PAD_SD3_DATA1__AUD5_TXC                           = IOMUX_PAD(0x04F4, 0x022C, 1, 0x058C, 0, 0),
	MX6_PAD_SD3_DATA1__KEY_ROW6                           = IOMUX_PAD(0x04F4, 0x022C, 2, 0x06B8, 0, 0),
	MX6_PAD_SD3_DATA1__CSI_DATA13                         = IOMUX_PAD(0x04F4, 0x022C, 3, 0x05BC, 0, 0),
	MX6_PAD_SD3_DATA1__SD1_VSELECT                        = IOMUX_PAD(0x04F4, 0x022C, 4, 0x0000, 0, 0),
	MX6_PAD_SD3_DATA1__GPIO5_IO20                         = IOMUX_PAD(0x04F4, 0x022C, 5, 0x0000, 0, 0),
	MX6_PAD_SD3_DATA1__JTAG_DE_B                          = IOMUX_PAD(0x04F4, 0x022C, 6, 0x0000, 0, 0),

	MX6_PAD_SD3_DATA2__SD3_DATA2                          = IOMUX_PAD(0x04F8, 0x0230, 0, 0x0000, 0, 0),
	MX6_PAD_SD3_DATA2__AUD5_TXFS                          = IOMUX_PAD(0x04F8, 0x0230, 1, 0x0590, 0, 0),
	MX6_PAD_SD3_DATA2__KEY_COL7                           = IOMUX_PAD(0x04F8, 0x0230, 2, 0x069C, 0, 0),
	MX6_PAD_SD3_DATA2__CSI_DATA14                         = IOMUX_PAD(0x04F8, 0x0230, 3, 0x05C0, 0, 0),
	MX6_PAD_SD3_DATA2__EPIT1_OUT                          = IOMUX_PAD(0x04F8, 0x0230, 4, 0x0000, 0, 0),
	MX6_PAD_SD3_DATA2__GPIO5_IO16                         = IOMUX_PAD(0x04F8, 0x0230, 5, 0x0000, 0, 0),
	MX6_PAD_SD3_DATA2__USB_OTG2_OC                        = IOMUX_PAD(0x04F8, 0x0230, 6, 0x0768, 0, 0),

	MX6_PAD_SD3_DATA3__SD3_DATA3                          = IOMUX_PAD(0x04FC, 0x0234, 0, 0x0000, 0, 0),
	MX6_PAD_SD3_DATA3__AUD5_TXD                           = IOMUX_PAD(0x04FC, 0x0234, 1, 0x0580, 0, 0),
	MX6_PAD_SD3_DATA3__KEY_ROW7                           = IOMUX_PAD(0x04FC, 0x0234, 2, 0x06BC, 0, 0),
	MX6_PAD_SD3_DATA3__CSI_DATA15                         = IOMUX_PAD(0x04FC, 0x0234, 3, 0x05C4, 0, 0),
	MX6_PAD_SD3_DATA3__EPIT2_OUT                          = IOMUX_PAD(0x04FC, 0x0234, 4, 0x0000, 0, 0),
	MX6_PAD_SD3_DATA3__GPIO5_IO17                         = IOMUX_PAD(0x04FC, 0x0234, 5, 0x0000, 0, 0),
	MX6_PAD_SD3_DATA3__USB_OTG1_OC                        = IOMUX_PAD(0x04FC, 0x0234, 6, 0x076C, 0, 0),

	MX6_PAD_GPIO4_IO20__SD1_STROBE                        = IOMUX_PAD(0x0500, 0x0238, 0, 0x0000, 0, 0),
	MX6_PAD_GPIO4_IO20__AUD6_RXFS                         = IOMUX_PAD(0x0500, 0x0238, 2, 0x05A0, 0, 0),
	MX6_PAD_GPIO4_IO20__ECSPI4_SS0                        = IOMUX_PAD(0x0500, 0x0238, 3, 0x065C, 0, 0),
	MX6_PAD_GPIO4_IO20__GPT_CAPTURE1                      = IOMUX_PAD(0x0500, 0x0238, 4, 0x0670, 0, 0),
	MX6_PAD_GPIO4_IO20__GPIO4_IO20                        = IOMUX_PAD(0x0500, 0x0238, 5, 0x0000, 0, 0),

	MX6_PAD_GPIO4_IO21__SD2_STROBE                        = IOMUX_PAD(0x0504, 0x023C, 0, 0x0000, 0, 0),
	MX6_PAD_GPIO4_IO21__AUD6_RXC                          = IOMUX_PAD(0x0504, 0x023C, 2, 0x059C, 0, 0),
	MX6_PAD_GPIO4_IO21__ECSPI4_SCLK                       = IOMUX_PAD(0x0504, 0x023C, 3, 0x0650, 0, 0),
	MX6_PAD_GPIO4_IO21__GPT_CAPTURE2                      = IOMUX_PAD(0x0504, 0x023C, 4, 0x0674, 0, 0),
	MX6_PAD_GPIO4_IO21__GPIO4_IO21                        = IOMUX_PAD(0x0504, 0x023C, 5, 0x0000, 0, 0),

	MX6_PAD_GPIO4_IO19__SD3_STROBE                        = IOMUX_PAD(0x0508, 0x0240, 0, 0x0000, 0, 0),
	MX6_PAD_GPIO4_IO19__AUD6_RXD                          = IOMUX_PAD(0x0508, 0x0240, 2, 0x0594, 0, 0),
	MX6_PAD_GPIO4_IO19__ECSPI4_MOSI                       = IOMUX_PAD(0x0508, 0x0240, 3, 0x0658, 0, 0),
	MX6_PAD_GPIO4_IO19__GPT_COMPARE1                      = IOMUX_PAD(0x0508, 0x0240, 4, 0x0000, 0, 0),
	MX6_PAD_GPIO4_IO19__GPIO4_IO19                        = IOMUX_PAD(0x0508, 0x0240, 5, 0x0000, 0, 0),
	MX6_PAD_GPIO4_IO25__AUD6_TXC                          = IOMUX_PAD(0x050C, 0x0244, 2, 0x05A4, 0, 0),
	MX6_PAD_GPIO4_IO25__ECSPI4_MISO                       = IOMUX_PAD(0x050C, 0x0244, 3, 0x0654, 0, 0),
	MX6_PAD_GPIO4_IO25__GPT_COMPARE2                      = IOMUX_PAD(0x050C, 0x0244, 4, 0x0000, 0, 0),
	MX6_PAD_GPIO4_IO25__GPIO4_IO25                        = IOMUX_PAD(0x050C, 0x0244, 5, 0x0000, 0, 0),
	MX6_PAD_GPIO4_IO18__AUD6_TXFS                         = IOMUX_PAD(0x0510, 0x0248, 2, 0x05A8, 0, 0),
	MX6_PAD_GPIO4_IO18__ECSPI4_SS1                        = IOMUX_PAD(0x0510, 0x0248, 3, 0x0660, 0, 0),
	MX6_PAD_GPIO4_IO18__GPT_COMPARE3                      = IOMUX_PAD(0x0510, 0x0248, 4, 0x0000, 0, 0),
	MX6_PAD_GPIO4_IO18__GPIO4_IO18                        = IOMUX_PAD(0x0510, 0x0248, 5, 0x0000, 0, 0),
	MX6_PAD_GPIO4_IO24__AUD6_TXD                          = IOMUX_PAD(0x0514, 0x024C, 2, 0x0598, 0, 0),
	MX6_PAD_GPIO4_IO24__ECSPI4_SS2                        = IOMUX_PAD(0x0514, 0x024C, 3, 0x0664, 0, 0),
	MX6_PAD_GPIO4_IO24__GPT_CLKIN                         = IOMUX_PAD(0x0514, 0x024C, 4, 0x0678, 0, 0),
	MX6_PAD_GPIO4_IO24__GPIO4_IO24                        = IOMUX_PAD(0x0514, 0x024C, 5, 0x0000, 0, 0),
	MX6_PAD_GPIO4_IO23__AUDIO_CLK_OUT                     = IOMUX_PAD(0x0518, 0x0250, 2, 0x0000, 0, 0),
	MX6_PAD_GPIO4_IO23__SD1_RESET                         = IOMUX_PAD(0x0518, 0x0250, 3, 0x0000, 0, 0),
	MX6_PAD_GPIO4_IO23__SD3_RESET                         = IOMUX_PAD(0x0518, 0x0250, 4, 0x0000, 0, 0),
	MX6_PAD_GPIO4_IO23__GPIO4_IO23                        = IOMUX_PAD(0x0518, 0x0250, 5, 0x0000, 0, 0),
	MX6_PAD_GPIO4_IO17__USB_OTG1_ID                       = IOMUX_PAD(0x051C, 0x0254, 2, 0x055C, 2, 0),
	MX6_PAD_GPIO4_IO17__SD1_VSELECT                       = IOMUX_PAD(0x051C, 0x0254, 3, 0x0000, 0, 0),
	MX6_PAD_GPIO4_IO17__SD3_VSELECT                       = IOMUX_PAD(0x051C, 0x0254, 4, 0x0000, 0, 0),
	MX6_PAD_GPIO4_IO17__GPIO4_IO17                        = IOMUX_PAD(0x051C, 0x0254, 5, 0x0000, 0, 0),
	MX6_PAD_GPIO4_IO22__SPDIF_IN                          = IOMUX_PAD(0x0520, 0x0258, 2, 0x0738, 0, 0),
	MX6_PAD_GPIO4_IO22__SD1_WP                            = IOMUX_PAD(0x0520, 0x0258, 3, 0x0774, 0, 0),
	MX6_PAD_GPIO4_IO22__SD3_WP                            = IOMUX_PAD(0x0520, 0x0258, 4, 0x0794, 1, 0),
	MX6_PAD_GPIO4_IO22__GPIO4_IO22                        = IOMUX_PAD(0x0520, 0x0258, 5, 0x0000, 0, 0),
	MX6_PAD_GPIO4_IO16__SPDIF_OUT                         = IOMUX_PAD(0x0524, 0x025C, 2, 0x0000, 0, 0),
	MX6_PAD_GPIO4_IO16__SD1_CD_B                          = IOMUX_PAD(0x0524, 0x025C, 3, 0x0770, 0, 0),
	MX6_PAD_GPIO4_IO16__SD3_CD_B                          = IOMUX_PAD(0x0524, 0x025C, 4, 0x0780, 1, 0),
	MX6_PAD_GPIO4_IO16__GPIO4_IO16                        = IOMUX_PAD(0x0524, 0x025C, 5, 0x0000, 0, 0),
	MX6_PAD_GPIO4_IO26__WDOG1_B                           = IOMUX_PAD(0x0528, 0x0260, 2, 0x0000, 0, 0),
	MX6_PAD_GPIO4_IO26__PWM4_OUT                          = IOMUX_PAD(0x0528, 0x0260, 3, 0x0000, 0, 0),
	MX6_PAD_GPIO4_IO26__CCM_PMIC_READY                    = IOMUX_PAD(0x0528, 0x0260, 4, 0x05AC, 1, 0),
	MX6_PAD_GPIO4_IO26__GPIO4_IO26                        = IOMUX_PAD(0x0528, 0x0260, 5, 0x0000, 0, 0),
	MX6_PAD_GPIO4_IO26__SPDIF_EXT_CLK                     = IOMUX_PAD(0x0528, 0x0260, 6, 0x073C, 0, 0),
};
#endif  /* __ASM_ARCH_IMX6SLL_PINS_H__ */
