/*
 * AM33XX-CM3 firmware
 *
 * Cortex-M3 (CM3) firmware for power management on Texas Instruments' AM33XX series of SoCs
 *
 * Copyright (C) 2011 Texas Instruments Incorporated - http://www.ti.com/
 *
 *  This software is licensed under the  standard terms and conditions in the Texas Instruments  Incorporated
 *  Technology and Software Publicly Available Software License Agreement , a copy of which is included in the
 *  software download.
*/

#ifndef __PRM335X_H
#define __PRM335X_H

#define AM335X_PRM_BASE               0x44E00000

#define AM335X_PRM_REGADDR(inst, reg)                         \
	(AM335X_PRM_BASE + (inst) + (reg))

/* PRM instances */
#define AM335X_PRM_OCP_SOCKET_MOD	0x0B00
#define AM335X_PRM_PER_MOD		0x0C00
#define AM335X_PRM_WKUP_MOD		0x0D00
#define AM335X_PRM_MPU_MOD		0x0E00
#define AM335X_PRM_DEVICE_MOD		0x0F00
#define AM335X_PRM_RTC_MOD		0x1000
#define AM335X_PRM_GFX_MOD		0x1100
#define AM335X_PRM_CEFUSE_MOD		0x1200

/* OMAP4 specific register offsets */
#define AM335X_PM_PWSTCTRL		0x0000
#define AM335X_PM_PWSTST		0x0004


/* PRM */

/* PRM.OCP_SOCKET_PRM register offsets */
#define AM335X_REVISION_PRM_OFFSET		0x0000
#define AM335X_REVISION_PRM			AM335X_PRM_REGADDR(AM335X_PRM_OCP_SOCKET_MOD, 0x0000)
#define AM335X_PRM_IRQSTATUS_MPU_OFFSET		0x0004
#define AM335X_PRM_IRQSTATUS_MPU		AM335X_PRM_REGADDR(AM335X_PRM_OCP_SOCKET_MOD, 0x0004)
#define AM335X_PRM_IRQENABLE_MPU_OFFSET		0x0008
#define AM335X_PRM_IRQENABLE_MPU		AM335X_PRM_REGADDR(AM335X_PRM_OCP_SOCKET_MOD, 0x0008)
#define AM335X_PRM_IRQSTATUS_M3_OFFSET		0x000c
#define AM335X_PRM_IRQSTATUS_M3			AM335X_PRM_REGADDR(AM335X_PRM_OCP_SOCKET_MOD, 0x000c)
#define AM335X_PRM_IRQENABLE_M3_OFFSET		0x0010
#define AM335X_PRM_IRQENABLE_M3			AM335X_PRM_REGADDR(AM335X_PRM_OCP_SOCKET_MOD, 0x0010)

/* PRM.PER_PRM register offsets */
#define AM335X_RM_PER_RSTCTRL_OFFSET		0x0000
#define AM335X_RM_PER_RSTCTRL			AM335X_PRM_REGADDR(AM335X_PRM_PER_MOD, 0x0000)
#define AM335X_RM_PER_RSTST_OFFSET		0x0004
#define AM335X_RM_PER_RSTST			AM335X_PRM_REGADDR(AM335X_PRM_PER_MOD, 0x0004)
#define AM335X_PM_PER_PWRSTST_OFFSET		0x0008
#define AM335X_PM_PER_PWRSTST			AM335X_PRM_REGADDR(AM335X_PRM_PER_MOD, 0x0008)
#define AM335X_PM_PER_PWRSTCTRL_OFFSET		0x000c
#define AM335X_PM_PER_PWRSTCTRL			AM335X_PRM_REGADDR(AM335X_PRM_PER_MOD, 0x000c)

/* PRM.WKUP_PRM register offsets */
#define AM335X_RM_WKUP_RSTCTRL_OFFSET		0x0000
#define AM335X_RM_WKUP_RSTCTRL			AM335X_PRM_REGADDR(AM335X_PRM_WKUP_MOD, 0x0000)
#define AM335X_PM_WKUP_PWRSTCTRL_OFFSET		0x0004
#define AM335X_PM_WKUP_PWRSTCTRL		AM335X_PRM_REGADDR(AM335X_PRM_WKUP_MOD, 0x0004)
#define AM335X_PM_WKUP_PWRSTST_OFFSET		0x0008
#define AM335X_PM_WKUP_PWRSTST			AM335X_PRM_REGADDR(AM335X_PRM_WKUP_MOD, 0x0008)
#define AM335X_RM_WKUP_RSTST_OFFSET		0x000c
#define AM335X_RM_WKUP_RSTST			AM335X_PRM_REGADDR(AM335X_PRM_WKUP_MOD, 0x000c)

/* PRM.MPU_PRM register offsets */
#define AM335X_PM_MPU_PWRSTCTRL_OFFSET		0x0000
#define AM335X_PM_MPU_PWRSTCTRL			AM335X_PRM_REGADDR(AM335X_PRM_MPU_MOD, 0x0000)
#define AM335X_PM_MPU_PWRSTST_OFFSET		0x0004
#define AM335X_PM_MPU_PWRSTST			AM335X_PRM_REGADDR(AM335X_PRM_MPU_MOD, 0x0004)
#define AM335X_RM_MPU_RSTST_OFFSET		0x0008
#define AM335X_RM_MPU_RSTST			AM335X_PRM_REGADDR(AM335X_PRM_MPU_MOD, 0x0008)

/* PRM.DEVICE_PRM register offsets */
#define AM335X_PRM_RSTCTRL_OFFSET		0x0000
#define AM335X_PRM_RSTCTRL			AM335X_PRM_REGADDR(AM335X_PRM_DEVICE_MOD, 0x0000)
#define AM335X_PRM_RSTTIME_OFFSET		0x0004
#define AM335X_PRM_RSTTIME			AM335X_PRM_REGADDR(AM335X_PRM_DEVICE_MOD, 0x0004)
#define AM335X_PRM_RSTST_OFFSET			0x0008
#define AM335X_PRM_RSTST			AM335X_PRM_REGADDR(AM335X_PRM_DEVICE_MOD, 0x0008)
#define AM335X_PRM_SRAM_COUNT_OFFSET		0x000c
#define AM335X_PRM_SRAM_COUNT			AM335X_PRM_REGADDR(AM335X_PRM_DEVICE_MOD, 0x000c)
#define AM335X_PRM_LDO_SRAM_CORE_SETUP_OFFSET	0x0010
#define AM335X_PRM_LDO_SRAM_CORE_SETUP		AM335X_PRM_REGADDR(AM335X_PRM_DEVICE_MOD, 0x0010)
#define AM335X_PRM_LDO_SRAM_CORE_CTRL_OFFSET	0x0014
#define AM335X_PRM_LDO_SRAM_CORE_CTRL		AM335X_PRM_REGADDR(AM335X_PRM_DEVICE_MOD, 0x0014)
#define AM335X_PRM_LDO_SRAM_MPU_SETUP_OFFSET	0x0018
#define AM335X_PRM_LDO_SRAM_MPU_SETUP		AM335X_PRM_REGADDR(AM335X_PRM_DEVICE_MOD, 0x0018)
#define AM335X_PRM_LDO_SRAM_MPU_CTRL_OFFSET	0x001c
#define AM335X_PRM_LDO_SRAM_MPU_CTRL		AM335X_PRM_REGADDR(AM335X_PRM_DEVICE_MOD, 0x001c)

/* PRM.RTC_PRM register offsets */
#define AM335X_PM_RTC_PWRSTCTRL_OFFSET		0x0000
#define AM335X_PM_RTC_PWRSTCTRL			AM335X_PRM_REGADDR(AM335X_PRM_RTC_MOD, 0x0000)
#define AM335X_PM_RTC_PWRSTST_OFFSET		0x0004
#define AM335X_PM_RTC_PWRSTST			AM335X_PRM_REGADDR(AM335X_PRM_RTC_MOD, 0x0004)

/* PRM.GFX_PRM register offsets */
#define AM335X_PM_GFX_PWRSTCTRL_OFFSET		0x0000
#define AM335X_PM_GFX_PWRSTCTRL			AM335X_PRM_REGADDR(AM335X_PRM_GFX_MOD, 0x0000)
#define AM335X_RM_GFX_RSTCTRL_OFFSET		0x0004
#define AM335X_RM_GFX_RSTCTRL			AM335X_PRM_REGADDR(AM335X_PRM_GFX_MOD, 0x0004)
#define AM335X_PM_GFX_PWRSTST_OFFSET		0x0010
#define AM335X_PM_GFX_PWRSTST			AM335X_PRM_REGADDR(AM335X_PRM_GFX_MOD, 0x0010)
#define AM335X_RM_GFX_RSTST_OFFSET		0x0014
#define AM335X_RM_GFX_RSTST			AM335X_PRM_REGADDR(AM335X_PRM_GFX_MOD, 0x0014)

/* PRM.CEFUSE_PRM register offsets */
#define AM335X_PM_CEFUSE_PWRSTCTRL_OFFSET	0x0000
#define AM335X_PM_CEFUSE_PWRSTCTRL		AM335X_PRM_REGADDR(AM335X_PRM_CEFUSE_MOD, 0x0000)
#define AM335X_PM_CEFUSE_PWRSTST_OFFSET		0x0004
#define AM335X_PM_CEFUSE_PWRSTST		AM335X_PRM_REGADDR(AM335X_PRM_CEFUSE_MOD, 0x0004)

#endif
