/* vim: set expandtab ts=4 sw=4: */
/*
 * You may redistribute this program and/or modify it under the terms of
 * the GNU General Public License as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "exception/WinFail.h"

#include <windows.h>
#include <ntstatus.h>

char* WinFail_strerror(long status)
{
    switch (status) {
        case ERROR_SUCCESS:
            return "ERROR_SUCCESS";
        case ERROR_INVALID_FUNCTION:
            return "ERROR_INVALID_FUNCTION";
        case ERROR_FILE_NOT_FOUND:
            return "ERROR_FILE_NOT_FOUND";
        case ERROR_PATH_NOT_FOUND:
            return "ERROR_PATH_NOT_FOUND";
        case ERROR_TOO_MANY_OPEN_FILES:
            return "ERROR_TOO_MANY_OPEN_FILES";
        case ERROR_ACCESS_DENIED:
            return "ERROR_ACCESS_DENIED";
        case ERROR_INVALID_HANDLE:
            return "ERROR_INVALID_HANDLE";
        case ERROR_ARENA_TRASHED:
            return "ERROR_ARENA_TRASHED";
        case ERROR_NOT_ENOUGH_MEMORY:
            return "ERROR_NOT_ENOUGH_MEMORY";
        case ERROR_INVALID_BLOCK:
            return "ERROR_INVALID_BLOCK";
        case ERROR_BAD_ENVIRONMENT:
            return "ERROR_BAD_ENVIRONMENT";
        case ERROR_BAD_FORMAT:
            return "ERROR_BAD_FORMAT";
        case ERROR_INVALID_ACCESS:
            return "ERROR_INVALID_ACCESS";
        case ERROR_INVALID_DATA:
            return "ERROR_INVALID_DATA";
        case ERROR_OUTOFMEMORY:
            return "ERROR_OUTOFMEMORY";
        case ERROR_INVALID_DRIVE:
            return "ERROR_INVALID_DRIVE";
        case ERROR_CURRENT_DIRECTORY:
            return "ERROR_CURRENT_DIRECTORY";
        case ERROR_NOT_SAME_DEVICE:
            return "ERROR_NOT_SAME_DEVICE";
        case ERROR_NO_MORE_FILES:
            return "ERROR_NO_MORE_FILES";
        case ERROR_WRITE_PROTECT:
            return "ERROR_WRITE_PROTECT";
        case ERROR_BAD_UNIT:
            return "ERROR_BAD_UNIT";
        case ERROR_NOT_READY:
            return "ERROR_NOT_READY";
        case ERROR_BAD_COMMAND:
            return "ERROR_BAD_COMMAND";
        case ERROR_CRC:
            return "ERROR_CRC";
        case ERROR_BAD_LENGTH:
            return "ERROR_BAD_LENGTH";
        case ERROR_SEEK:
            return "ERROR_SEEK";
        case ERROR_NOT_DOS_DISK:
            return "ERROR_NOT_DOS_DISK";
        case ERROR_SECTOR_NOT_FOUND:
            return "ERROR_SECTOR_NOT_FOUND";
        case ERROR_OUT_OF_PAPER:
            return "ERROR_OUT_OF_PAPER";
        case ERROR_WRITE_FAULT:
            return "ERROR_WRITE_FAULT";
        case ERROR_READ_FAULT:
            return "ERROR_READ_FAULT";
        case ERROR_GEN_FAILURE:
            return "ERROR_GEN_FAILURE";
        case ERROR_SHARING_VIOLATION:
            return "ERROR_SHARING_VIOLATION";
        case ERROR_LOCK_VIOLATION:
            return "ERROR_LOCK_VIOLATION";
        case ERROR_WRONG_DISK:
            return "ERROR_WRONG_DISK";
        case ERROR_SHARING_BUFFER_EXCEEDED:
            return "ERROR_SHARING_BUFFER_EXCEEDED";
        case ERROR_HANDLE_EOF:
            return "ERROR_HANDLE_EOF";
        case ERROR_HANDLE_DISK_FULL:
            return "ERROR_HANDLE_DISK_FULL";
        case ERROR_NOT_SUPPORTED:
            return "ERROR_NOT_SUPPORTED";
        case ERROR_REM_NOT_LIST:
            return "ERROR_REM_NOT_LIST";
        case ERROR_DUP_NAME:
            return "ERROR_DUP_NAME";
        case ERROR_BAD_NETPATH:
            return "ERROR_BAD_NETPATH";
        case ERROR_NETWORK_BUSY:
            return "ERROR_NETWORK_BUSY";
        case ERROR_DEV_NOT_EXIST:
            return "ERROR_DEV_NOT_EXIST";
        case ERROR_TOO_MANY_CMDS:
            return "ERROR_TOO_MANY_CMDS";
        case ERROR_ADAP_HDW_ERR:
            return "ERROR_ADAP_HDW_ERR";
        case ERROR_BAD_NET_RESP:
            return "ERROR_BAD_NET_RESP";
        case ERROR_UNEXP_NET_ERR:
            return "ERROR_UNEXP_NET_ERR";
        case ERROR_BAD_REM_ADAP:
            return "ERROR_BAD_REM_ADAP";
        case ERROR_PRINTQ_FULL:
            return "ERROR_PRINTQ_FULL";
        case ERROR_NO_SPOOL_SPACE:
            return "ERROR_NO_SPOOL_SPACE";
        case ERROR_PRINT_CANCELLED:
            return "ERROR_PRINT_CANCELLED";
        case ERROR_NETNAME_DELETED:
            return "ERROR_NETNAME_DELETED";
        case ERROR_NETWORK_ACCESS_DENIED:
            return "ERROR_NETWORK_ACCESS_DENIED";
        case ERROR_BAD_DEV_TYPE:
            return "ERROR_BAD_DEV_TYPE";
        case ERROR_BAD_NET_NAME:
            return "ERROR_BAD_NET_NAME";
        case ERROR_TOO_MANY_NAMES:
            return "ERROR_TOO_MANY_NAMES";
        case ERROR_TOO_MANY_SESS:
            return "ERROR_TOO_MANY_SESS";
        case ERROR_SHARING_PAUSED:
            return "ERROR_SHARING_PAUSED";
        case ERROR_REQ_NOT_ACCEP:
            return "ERROR_REQ_NOT_ACCEP";
        case ERROR_REDIR_PAUSED:
            return "ERROR_REDIR_PAUSED";
        case ERROR_FILE_EXISTS:
            return "ERROR_FILE_EXISTS";
        case ERROR_CANNOT_MAKE:
            return "ERROR_CANNOT_MAKE";
        case ERROR_FAIL_I24:
            return "ERROR_FAIL_I24";
        case ERROR_OUT_OF_STRUCTURES:
            return "ERROR_OUT_OF_STRUCTURES";
        case ERROR_ALREADY_ASSIGNED:
            return "ERROR_ALREADY_ASSIGNED";
        case ERROR_INVALID_PASSWORD:
            return "ERROR_INVALID_PASSWORD";
        case ERROR_INVALID_PARAMETER:
            return "ERROR_INVALID_PARAMETER";
        case ERROR_NET_WRITE_FAULT:
            return "ERROR_NET_WRITE_FAULT";
        case ERROR_NO_PROC_SLOTS:
            return "ERROR_NO_PROC_SLOTS";
        case ERROR_TOO_MANY_SEMAPHORES:
            return "ERROR_TOO_MANY_SEMAPHORES";
        case ERROR_EXCL_SEM_ALREADY_OWNED:
            return "ERROR_EXCL_SEM_ALREADY_OWNED";
        case ERROR_SEM_IS_SET:
            return "ERROR_SEM_IS_SET";
        case ERROR_TOO_MANY_SEM_REQUESTS:
            return "ERROR_TOO_MANY_SEM_REQUESTS";
        case ERROR_INVALID_AT_INTERRUPT_TIME:
            return "ERROR_INVALID_AT_INTERRUPT_TIME";
        case ERROR_SEM_OWNER_DIED:
            return "ERROR_SEM_OWNER_DIED";
        case ERROR_SEM_USER_LIMIT:
            return "ERROR_SEM_USER_LIMIT";
        case ERROR_DISK_CHANGE:
            return "ERROR_DISK_CHANGE";
        case ERROR_DRIVE_LOCKED:
            return "ERROR_DRIVE_LOCKED";
        case ERROR_BROKEN_PIPE:
            return "ERROR_BROKEN_PIPE";
        case ERROR_OPEN_FAILED:
            return "ERROR_OPEN_FAILED";
        case ERROR_BUFFER_OVERFLOW:
            return "ERROR_BUFFER_OVERFLOW";
        case ERROR_DISK_FULL:
            return "ERROR_DISK_FULL";
        case ERROR_NO_MORE_SEARCH_HANDLES:
            return "ERROR_NO_MORE_SEARCH_HANDLES";
        case ERROR_INVALID_TARGET_HANDLE:
            return "ERROR_INVALID_TARGET_HANDLE";
        case ERROR_INVALID_CATEGORY:
            return "ERROR_INVALID_CATEGORY";
        case ERROR_INVALID_VERIFY_SWITCH:
            return "ERROR_INVALID_VERIFY_SWITCH";
        case ERROR_BAD_DRIVER_LEVEL:
            return "ERROR_BAD_DRIVER_LEVEL";
        case ERROR_CALL_NOT_IMPLEMENTED:
            return "ERROR_CALL_NOT_IMPLEMENTED";
        case ERROR_SEM_TIMEOUT:
            return "ERROR_SEM_TIMEOUT";
        case ERROR_INSUFFICIENT_BUFFER:
            return "ERROR_INSUFFICIENT_BUFFER";
        case ERROR_INVALID_NAME:
            return "ERROR_INVALID_NAME";
        case ERROR_INVALID_LEVEL:
            return "ERROR_INVALID_LEVEL";
        case ERROR_NO_VOLUME_LABEL:
            return "ERROR_NO_VOLUME_LABEL";
        case ERROR_MOD_NOT_FOUND:
            return "ERROR_MOD_NOT_FOUND";
        case ERROR_PROC_NOT_FOUND:
            return "ERROR_PROC_NOT_FOUND";
        case ERROR_WAIT_NO_CHILDREN:
            return "ERROR_WAIT_NO_CHILDREN";
        case ERROR_CHILD_NOT_COMPLETE:
            return "ERROR_CHILD_NOT_COMPLETE";
        case ERROR_DIRECT_ACCESS_HANDLE:
            return "ERROR_DIRECT_ACCESS_HANDLE";
        case ERROR_NEGATIVE_SEEK:
            return "ERROR_NEGATIVE_SEEK";
        case ERROR_SEEK_ON_DEVICE:
            return "ERROR_SEEK_ON_DEVICE";
        case ERROR_IS_JOIN_TARGET:
            return "ERROR_IS_JOIN_TARGET";
        case ERROR_IS_JOINED:
            return "ERROR_IS_JOINED";
        case ERROR_IS_SUBSTED:
            return "ERROR_IS_SUBSTED";
        case ERROR_NOT_JOINED:
            return "ERROR_NOT_JOINED";
        case ERROR_NOT_SUBSTED:
            return "ERROR_NOT_SUBSTED";
        case ERROR_JOIN_TO_JOIN:
            return "ERROR_JOIN_TO_JOIN";
        case ERROR_SUBST_TO_SUBST:
            return "ERROR_SUBST_TO_SUBST";
        case ERROR_JOIN_TO_SUBST:
            return "ERROR_JOIN_TO_SUBST";
        case ERROR_SUBST_TO_JOIN:
            return "ERROR_SUBST_TO_JOIN";
        case ERROR_BUSY_DRIVE:
            return "ERROR_BUSY_DRIVE";
        case ERROR_SAME_DRIVE:
            return "ERROR_SAME_DRIVE";
        case ERROR_DIR_NOT_ROOT:
            return "ERROR_DIR_NOT_ROOT";
        case ERROR_DIR_NOT_EMPTY:
            return "ERROR_DIR_NOT_EMPTY";
        case ERROR_IS_SUBST_PATH:
            return "ERROR_IS_SUBST_PATH";
        case ERROR_IS_JOIN_PATH:
            return "ERROR_IS_JOIN_PATH";
        case ERROR_PATH_BUSY:
            return "ERROR_PATH_BUSY";
        case ERROR_IS_SUBST_TARGET:
            return "ERROR_IS_SUBST_TARGET";
        case ERROR_SYSTEM_TRACE:
            return "ERROR_SYSTEM_TRACE";
        case ERROR_INVALID_EVENT_COUNT:
            return "ERROR_INVALID_EVENT_COUNT";
        case ERROR_TOO_MANY_MUXWAITERS:
            return "ERROR_TOO_MANY_MUXWAITERS";
        case ERROR_INVALID_LIST_FORMAT:
            return "ERROR_INVALID_LIST_FORMAT";
        case ERROR_LABEL_TOO_LONG:
            return "ERROR_LABEL_TOO_LONG";
        case ERROR_TOO_MANY_TCBS:
            return "ERROR_TOO_MANY_TCBS";
        case ERROR_SIGNAL_REFUSED:
            return "ERROR_SIGNAL_REFUSED";
        case ERROR_DISCARDED:
            return "ERROR_DISCARDED";
        case ERROR_NOT_LOCKED:
            return "ERROR_NOT_LOCKED";
        case ERROR_BAD_THREADID_ADDR:
            return "ERROR_BAD_THREADID_ADDR";
        case ERROR_BAD_ARGUMENTS:
            return "ERROR_BAD_ARGUMENTS";
        case ERROR_BAD_PATHNAME:
            return "ERROR_BAD_PATHNAME";
        case ERROR_SIGNAL_PENDING:
            return "ERROR_SIGNAL_PENDING";
        case ERROR_MAX_THRDS_REACHED:
            return "ERROR_MAX_THRDS_REACHED";
        case ERROR_LOCK_FAILED:
            return "ERROR_LOCK_FAILED";
        case ERROR_BUSY:
            return "ERROR_BUSY";
        case ERROR_CANCEL_VIOLATION:
            return "ERROR_CANCEL_VIOLATION";
        case ERROR_ATOMIC_LOCKS_NOT_SUPPORTED:
            return "ERROR_ATOMIC_LOCKS_NOT_SUPPORTED";
        case ERROR_INVALID_SEGMENT_NUMBER:
            return "ERROR_INVALID_SEGMENT_NUMBER";
        case ERROR_INVALID_ORDINAL:
            return "ERROR_INVALID_ORDINAL";
        case ERROR_ALREADY_EXISTS:
            return "ERROR_ALREADY_EXISTS";
        case ERROR_INVALID_FLAG_NUMBER:
            return "ERROR_INVALID_FLAG_NUMBER";
        case ERROR_SEM_NOT_FOUND:
            return "ERROR_SEM_NOT_FOUND";
        case ERROR_INVALID_STARTING_CODESEG:
            return "ERROR_INVALID_STARTING_CODESEG";
        case ERROR_INVALID_STACKSEG:
            return "ERROR_INVALID_STACKSEG";
        case ERROR_INVALID_MODULETYPE:
            return "ERROR_INVALID_MODULETYPE";
        case ERROR_INVALID_EXE_SIGNATURE:
            return "ERROR_INVALID_EXE_SIGNATURE";
        case ERROR_EXE_MARKED_INVALID:
            return "ERROR_EXE_MARKED_INVALID";
        case ERROR_BAD_EXE_FORMAT:
            return "ERROR_BAD_EXE_FORMAT";
        case ERROR_ITERATED_DATA_EXCEEDS_64k:
            return "ERROR_ITERATED_DATA_EXCEEDS_64k";
        case ERROR_INVALID_MINALLOCSIZE:
            return "ERROR_INVALID_MINALLOCSIZE";
        case ERROR_DYNLINK_FROM_INVALID_RING:
            return "ERROR_DYNLINK_FROM_INVALID_RING";
        case ERROR_IOPL_NOT_ENABLED:
            return "ERROR_IOPL_NOT_ENABLED";
        case ERROR_INVALID_SEGDPL:
            return "ERROR_INVALID_SEGDPL";
        case ERROR_AUTODATASEG_EXCEEDS_64k:
            return "ERROR_AUTODATASEG_EXCEEDS_64k";
        case ERROR_RING2SEG_MUST_BE_MOVABLE:
            return "ERROR_RING2SEG_MUST_BE_MOVABLE";
        case ERROR_RELOC_CHAIN_XEEDS_SEGLIM:
            return "ERROR_RELOC_CHAIN_XEEDS_SEGLIM";
        case ERROR_INFLOOP_IN_RELOC_CHAIN:
            return "ERROR_INFLOOP_IN_RELOC_CHAIN";
        case ERROR_ENVVAR_NOT_FOUND:
            return "ERROR_ENVVAR_NOT_FOUND";
        case ERROR_NO_SIGNAL_SENT:
            return "ERROR_NO_SIGNAL_SENT";
        case ERROR_FILENAME_EXCED_RANGE:
            return "ERROR_FILENAME_EXCED_RANGE";
        case ERROR_RING2_STACK_IN_USE:
            return "ERROR_RING2_STACK_IN_USE";
        case ERROR_META_EXPANSION_TOO_LONG:
            return "ERROR_META_EXPANSION_TOO_LONG";
        case ERROR_INVALID_SIGNAL_NUMBER:
            return "ERROR_INVALID_SIGNAL_NUMBER";
        case ERROR_THREAD_1_INACTIVE:
            return "ERROR_THREAD_1_INACTIVE";
        case ERROR_LOCKED:
            return "ERROR_LOCKED";
        case ERROR_TOO_MANY_MODULES:
            return "ERROR_TOO_MANY_MODULES";
        case ERROR_NESTING_NOT_ALLOWED:
            return "ERROR_NESTING_NOT_ALLOWED";
        case ERROR_EXE_MACHINE_TYPE_MISMATCH:
            return "ERROR_EXE_MACHINE_TYPE_MISMATCH";
        case ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY:
            return "ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY";
        case ERROR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY:
            return "ERROR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY";
        case ERROR_BAD_PIPE:
            return "ERROR_BAD_PIPE";
        case ERROR_PIPE_BUSY:
            return "ERROR_PIPE_BUSY";
        case ERROR_NO_DATA:
            return "ERROR_NO_DATA";
        case ERROR_PIPE_NOT_CONNECTED:
            return "ERROR_PIPE_NOT_CONNECTED";
        case ERROR_MORE_DATA:
            return "ERROR_MORE_DATA";
        case ERROR_VC_DISCONNECTED:
            return "ERROR_VC_DISCONNECTED";
        case ERROR_INVALID_EA_NAME:
            return "ERROR_INVALID_EA_NAME";
        case ERROR_EA_LIST_INCONSISTENT:
            return "ERROR_EA_LIST_INCONSISTENT";
        case ERROR_NO_MORE_ITEMS:
            return "ERROR_NO_MORE_ITEMS";
        case ERROR_CANNOT_COPY:
            return "ERROR_CANNOT_COPY";
        case ERROR_DIRECTORY:
            return "ERROR_DIRECTORY";
        case ERROR_EAS_DIDNT_FIT:
            return "ERROR_EAS_DIDNT_FIT";
        case ERROR_EA_FILE_CORRUPT:
            return "ERROR_EA_FILE_CORRUPT";
        case ERROR_EA_TABLE_FULL:
            return "ERROR_EA_TABLE_FULL";
        case ERROR_INVALID_EA_HANDLE:
            return "ERROR_INVALID_EA_HANDLE";
        case ERROR_EAS_NOT_SUPPORTED:
            return "ERROR_EAS_NOT_SUPPORTED";
        case ERROR_NOT_OWNER:
            return "ERROR_NOT_OWNER";
        case ERROR_TOO_MANY_POSTS:
            return "ERROR_TOO_MANY_POSTS";
        case ERROR_PARTIAL_COPY:
            return "ERROR_PARTIAL_COPY";
        case ERROR_OPLOCK_NOT_GRANTED:
            return "ERROR_OPLOCK_NOT_GRANTED";
        case ERROR_INVALID_OPLOCK_PROTOCOL:
            return "ERROR_INVALID_OPLOCK_PROTOCOL";
        case ERROR_DISK_TOO_FRAGMENTED:
            return "ERROR_DISK_TOO_FRAGMENTED";
        case ERROR_DELETE_PENDING:
            return "ERROR_DELETE_PENDING";
        case ERROR_MR_MID_NOT_FOUND:
            return "ERROR_MR_MID_NOT_FOUND";
        case ERROR_SCOPE_NOT_FOUND:
            return "ERROR_SCOPE_NOT_FOUND";
        case ERROR_INVALID_ADDRESS:
            return "ERROR_INVALID_ADDRESS";
        case ERROR_ARITHMETIC_OVERFLOW:
            return "ERROR_ARITHMETIC_OVERFLOW";
        case ERROR_PIPE_CONNECTED:
            return "ERROR_PIPE_CONNECTED";
        case ERROR_PIPE_LISTENING:
            return "ERROR_PIPE_LISTENING";
        case ERROR_EA_ACCESS_DENIED:
            return "ERROR_EA_ACCESS_DENIED";
        case ERROR_OPERATION_ABORTED:
            return "ERROR_OPERATION_ABORTED";
        case ERROR_IO_INCOMPLETE:
            return "ERROR_IO_INCOMPLETE";
        case ERROR_IO_PENDING:
            return "ERROR_IO_PENDING";
        case ERROR_NOACCESS:
            return "ERROR_NOACCESS";
        case ERROR_SWAPERROR:
            return "ERROR_SWAPERROR";
        case ERROR_STACK_OVERFLOW:
            return "ERROR_STACK_OVERFLOW";
        case ERROR_INVALID_MESSAGE:
            return "ERROR_INVALID_MESSAGE";
        case ERROR_CAN_NOT_COMPLETE:
            return "ERROR_CAN_NOT_COMPLETE";
        case ERROR_INVALID_FLAGS:
            return "ERROR_INVALID_FLAGS";
        case ERROR_UNRECOGNIZED_VOLUME:
            return "ERROR_UNRECOGNIZED_VOLUME";
        case ERROR_FILE_INVALID:
            return "ERROR_FILE_INVALID";
        case ERROR_FULLSCREEN_MODE:
            return "ERROR_FULLSCREEN_MODE";
        case ERROR_NO_TOKEN:
            return "ERROR_NO_TOKEN";
        case ERROR_BADDB:
            return "ERROR_BADDB";
        case ERROR_BADKEY:
            return "ERROR_BADKEY";
        case ERROR_CANTOPEN:
            return "ERROR_CANTOPEN";
        case ERROR_CANTREAD:
            return "ERROR_CANTREAD";
        case ERROR_CANTWRITE:
            return "ERROR_CANTWRITE";
        case ERROR_REGISTRY_RECOVERED:
            return "ERROR_REGISTRY_RECOVERED";
        case ERROR_REGISTRY_CORRUPT:
            return "ERROR_REGISTRY_CORRUPT";
        case ERROR_REGISTRY_IO_FAILED:
            return "ERROR_REGISTRY_IO_FAILED";
        case ERROR_NOT_REGISTRY_FILE:
            return "ERROR_NOT_REGISTRY_FILE";
        case ERROR_KEY_DELETED:
            return "ERROR_KEY_DELETED";
        case ERROR_NO_LOG_SPACE:
            return "ERROR_NO_LOG_SPACE";
        case ERROR_KEY_HAS_CHILDREN:
            return "ERROR_KEY_HAS_CHILDREN";
        case ERROR_CHILD_MUST_BE_VOLATILE:
            return "ERROR_CHILD_MUST_BE_VOLATILE";
        case ERROR_NOTIFY_ENUM_DIR:
            return "ERROR_NOTIFY_ENUM_DIR";
        case ERROR_DEPENDENT_SERVICES_RUNNING:
            return "ERROR_DEPENDENT_SERVICES_RUNNING";
        case ERROR_INVALID_SERVICE_CONTROL:
            return "ERROR_INVALID_SERVICE_CONTROL";
        case ERROR_SERVICE_REQUEST_TIMEOUT:
            return "ERROR_SERVICE_REQUEST_TIMEOUT";
        case ERROR_SERVICE_NO_THREAD:
            return "ERROR_SERVICE_NO_THREAD";
        case ERROR_SERVICE_DATABASE_LOCKED:
            return "ERROR_SERVICE_DATABASE_LOCKED";
        case ERROR_SERVICE_ALREADY_RUNNING:
            return "ERROR_SERVICE_ALREADY_RUNNING";
        case ERROR_INVALID_SERVICE_ACCOUNT:
            return "ERROR_INVALID_SERVICE_ACCOUNT";
        case ERROR_SERVICE_DISABLED:
            return "ERROR_SERVICE_DISABLED";
        case ERROR_CIRCULAR_DEPENDENCY:
            return "ERROR_CIRCULAR_DEPENDENCY";
        case ERROR_SERVICE_DOES_NOT_EXIST:
            return "ERROR_SERVICE_DOES_NOT_EXIST";
        case ERROR_SERVICE_CANNOT_ACCEPT_CTRL:
            return "ERROR_SERVICE_CANNOT_ACCEPT_CTRL";
        case ERROR_SERVICE_NOT_ACTIVE:
            return "ERROR_SERVICE_NOT_ACTIVE";
        case ERROR_FAILED_SERVICE_CONTROLLER_CONNECT:
            return "ERROR_FAILED_SERVICE_CONTROLLER_CONNECT";
        case ERROR_EXCEPTION_IN_SERVICE:
            return "ERROR_EXCEPTION_IN_SERVICE";
        case ERROR_DATABASE_DOES_NOT_EXIST:
            return "ERROR_DATABASE_DOES_NOT_EXIST";
        case ERROR_SERVICE_SPECIFIC_ERROR:
            return "ERROR_SERVICE_SPECIFIC_ERROR";
        case ERROR_PROCESS_ABORTED:
            return "ERROR_PROCESS_ABORTED";
        case ERROR_SERVICE_DEPENDENCY_FAIL:
            return "ERROR_SERVICE_DEPENDENCY_FAIL";
        case ERROR_SERVICE_LOGON_FAILED:
            return "ERROR_SERVICE_LOGON_FAILED";
        case ERROR_SERVICE_START_HANG:
            return "ERROR_SERVICE_START_HANG";
        case ERROR_INVALID_SERVICE_LOCK:
            return "ERROR_INVALID_SERVICE_LOCK";
        case ERROR_SERVICE_MARKED_FOR_DELETE:
            return "ERROR_SERVICE_MARKED_FOR_DELETE";
        case ERROR_SERVICE_EXISTS:
            return "ERROR_SERVICE_EXISTS";
        case ERROR_ALREADY_RUNNING_LKG:
            return "ERROR_ALREADY_RUNNING_LKG";
        case ERROR_SERVICE_DEPENDENCY_DELETED:
            return "ERROR_SERVICE_DEPENDENCY_DELETED";
        case ERROR_BOOT_ALREADY_ACCEPTED:
            return "ERROR_BOOT_ALREADY_ACCEPTED";
        case ERROR_SERVICE_NEVER_STARTED:
            return "ERROR_SERVICE_NEVER_STARTED";
        case ERROR_DUPLICATE_SERVICE_NAME:
            return "ERROR_DUPLICATE_SERVICE_NAME";
        case ERROR_DIFFERENT_SERVICE_ACCOUNT:
            return "ERROR_DIFFERENT_SERVICE_ACCOUNT";
        case ERROR_CANNOT_DETECT_DRIVER_FAILURE:
            return "ERROR_CANNOT_DETECT_DRIVER_FAILURE";
        case ERROR_CANNOT_DETECT_PROCESS_ABORT:
            return "ERROR_CANNOT_DETECT_PROCESS_ABORT";
        case ERROR_NO_RECOVERY_PROGRAM:
            return "ERROR_NO_RECOVERY_PROGRAM";
        case ERROR_SERVICE_NOT_IN_EXE:
            return "ERROR_SERVICE_NOT_IN_EXE";
        case ERROR_NOT_SAFEBOOT_SERVICE:
            return "ERROR_NOT_SAFEBOOT_SERVICE";
        case ERROR_END_OF_MEDIA:
            return "ERROR_END_OF_MEDIA";
        case ERROR_FILEMARK_DETECTED:
            return "ERROR_FILEMARK_DETECTED";
        case ERROR_BEGINNING_OF_MEDIA:
            return "ERROR_BEGINNING_OF_MEDIA";
        case ERROR_SETMARK_DETECTED:
            return "ERROR_SETMARK_DETECTED";
        case ERROR_NO_DATA_DETECTED:
            return "ERROR_NO_DATA_DETECTED";
        case ERROR_PARTITION_FAILURE:
            return "ERROR_PARTITION_FAILURE";
        case ERROR_INVALID_BLOCK_LENGTH:
            return "ERROR_INVALID_BLOCK_LENGTH";
        case ERROR_DEVICE_NOT_PARTITIONED:
            return "ERROR_DEVICE_NOT_PARTITIONED";
        case ERROR_UNABLE_TO_LOCK_MEDIA:
            return "ERROR_UNABLE_TO_LOCK_MEDIA";
        case ERROR_UNABLE_TO_UNLOAD_MEDIA:
            return "ERROR_UNABLE_TO_UNLOAD_MEDIA";
        case ERROR_MEDIA_CHANGED:
            return "ERROR_MEDIA_CHANGED";
        case ERROR_BUS_RESET:
            return "ERROR_BUS_RESET";
        case ERROR_NO_MEDIA_IN_DRIVE:
            return "ERROR_NO_MEDIA_IN_DRIVE";
        case ERROR_NO_UNICODE_TRANSLATION:
            return "ERROR_NO_UNICODE_TRANSLATION";
        case ERROR_DLL_INIT_FAILED:
            return "ERROR_DLL_INIT_FAILED";
        case ERROR_SHUTDOWN_IN_PROGRESS:
            return "ERROR_SHUTDOWN_IN_PROGRESS";
        case ERROR_NO_SHUTDOWN_IN_PROGRESS:
            return "ERROR_NO_SHUTDOWN_IN_PROGRESS";
        case ERROR_IO_DEVICE:
            return "ERROR_IO_DEVICE";
        case ERROR_SERIAL_NO_DEVICE:
            return "ERROR_SERIAL_NO_DEVICE";
        case ERROR_IRQ_BUSY:
            return "ERROR_IRQ_BUSY";
        case ERROR_MORE_WRITES:
            return "ERROR_MORE_WRITES";
        case ERROR_COUNTER_TIMEOUT:
            return "ERROR_COUNTER_TIMEOUT";
        case ERROR_FLOPPY_ID_MARK_NOT_FOUND:
            return "ERROR_FLOPPY_ID_MARK_NOT_FOUND";
        case ERROR_FLOPPY_WRONG_CYLINDER:
            return "ERROR_FLOPPY_WRONG_CYLINDER";
        case ERROR_FLOPPY_UNKNOWN_ERROR:
            return "ERROR_FLOPPY_UNKNOWN_ERROR";
        case ERROR_FLOPPY_BAD_REGISTERS:
            return "ERROR_FLOPPY_BAD_REGISTERS";
        case ERROR_DISK_RECALIBRATE_FAILED:
            return "ERROR_DISK_RECALIBRATE_FAILED";
        case ERROR_DISK_OPERATION_FAILED:
            return "ERROR_DISK_OPERATION_FAILED";
        case ERROR_DISK_RESET_FAILED:
            return "ERROR_DISK_RESET_FAILED";
        case ERROR_EOM_OVERFLOW:
            return "ERROR_EOM_OVERFLOW";
        case ERROR_NOT_ENOUGH_SERVER_MEMORY:
            return "ERROR_NOT_ENOUGH_SERVER_MEMORY";
        case ERROR_POSSIBLE_DEADLOCK:
            return "ERROR_POSSIBLE_DEADLOCK";
        case ERROR_MAPPED_ALIGNMENT:
            return "ERROR_MAPPED_ALIGNMENT";
        case ERROR_SET_POWER_STATE_VETOED:
            return "ERROR_SET_POWER_STATE_VETOED";
        case ERROR_SET_POWER_STATE_FAILED:
            return "ERROR_SET_POWER_STATE_FAILED";
        case ERROR_TOO_MANY_LINKS:
            return "ERROR_TOO_MANY_LINKS";
        case ERROR_OLD_WIN_VERSION:
            return "ERROR_OLD_WIN_VERSION";
        case ERROR_APP_WRONG_OS:
            return "ERROR_APP_WRONG_OS";
        case ERROR_SINGLE_INSTANCE_APP:
            return "ERROR_SINGLE_INSTANCE_APP";
        case ERROR_RMODE_APP:
            return "ERROR_RMODE_APP";
        case ERROR_INVALID_DLL:
            return "ERROR_INVALID_DLL";
        case ERROR_NO_ASSOCIATION:
            return "ERROR_NO_ASSOCIATION";
        case ERROR_DDE_FAIL:
            return "ERROR_DDE_FAIL";
        case ERROR_DLL_NOT_FOUND:
            return "ERROR_DLL_NOT_FOUND";
        case ERROR_NO_MORE_USER_HANDLES:
            return "ERROR_NO_MORE_USER_HANDLES";
        case ERROR_MESSAGE_SYNC_ONLY:
            return "ERROR_MESSAGE_SYNC_ONLY";
        case ERROR_SOURCE_ELEMENT_EMPTY:
            return "ERROR_SOURCE_ELEMENT_EMPTY";
        case ERROR_DESTINATION_ELEMENT_FULL:
            return "ERROR_DESTINATION_ELEMENT_FULL";
        case ERROR_ILLEGAL_ELEMENT_ADDRESS:
            return "ERROR_ILLEGAL_ELEMENT_ADDRESS";
        case ERROR_MAGAZINE_NOT_PRESENT:
            return "ERROR_MAGAZINE_NOT_PRESENT";
        case ERROR_DEVICE_REINITIALIZATION_NEEDED:
            return "ERROR_DEVICE_REINITIALIZATION_NEEDED";
        case ERROR_DEVICE_REQUIRES_CLEANING:
            return "ERROR_DEVICE_REQUIRES_CLEANING";
        case ERROR_DEVICE_DOOR_OPEN:
            return "ERROR_DEVICE_DOOR_OPEN";
        case ERROR_DEVICE_NOT_CONNECTED:
            return "ERROR_DEVICE_NOT_CONNECTED";
        case ERROR_NOT_FOUND:
            return "ERROR_NOT_FOUND";
        case ERROR_NO_MATCH:
            return "ERROR_NO_MATCH";
        case ERROR_SET_NOT_FOUND:
            return "ERROR_SET_NOT_FOUND";
        case ERROR_POINT_NOT_FOUND:
            return "ERROR_POINT_NOT_FOUND";
        case ERROR_NO_TRACKING_SERVICE:
            return "ERROR_NO_TRACKING_SERVICE";
        case ERROR_NO_VOLUME_ID:
            return "ERROR_NO_VOLUME_ID";
        case ERROR_UNABLE_TO_REMOVE_REPLACED:
            return "ERROR_UNABLE_TO_REMOVE_REPLACED";
        case ERROR_UNABLE_TO_MOVE_REPLACEMENT:
            return "ERROR_UNABLE_TO_MOVE_REPLACEMENT";
        case ERROR_UNABLE_TO_MOVE_REPLACEMENT_2:
            return "ERROR_UNABLE_TO_MOVE_REPLACEMENT_2";
        case ERROR_JOURNAL_DELETE_IN_PROGRESS:
            return "ERROR_JOURNAL_DELETE_IN_PROGRESS";
        case ERROR_JOURNAL_NOT_ACTIVE:
            return "ERROR_JOURNAL_NOT_ACTIVE";
        case ERROR_POTENTIAL_FILE_FOUND:
            return "ERROR_POTENTIAL_FILE_FOUND";
        case ERROR_JOURNAL_ENTRY_DELETED:
            return "ERROR_JOURNAL_ENTRY_DELETED";
        case ERROR_BAD_DEVICE:
            return "ERROR_BAD_DEVICE";
        case ERROR_CONNECTION_UNAVAIL:
            return "ERROR_CONNECTION_UNAVAIL";
        case ERROR_DEVICE_ALREADY_REMEMBERED:
            return "ERROR_DEVICE_ALREADY_REMEMBERED";
        case ERROR_NO_NET_OR_BAD_PATH:
            return "ERROR_NO_NET_OR_BAD_PATH";
        case ERROR_BAD_PROVIDER:
            return "ERROR_BAD_PROVIDER";
        case ERROR_CANNOT_OPEN_PROFILE:
            return "ERROR_CANNOT_OPEN_PROFILE";
        case ERROR_BAD_PROFILE:
            return "ERROR_BAD_PROFILE";
        case ERROR_NOT_CONTAINER:
            return "ERROR_NOT_CONTAINER";
        case ERROR_EXTENDED_ERROR:
            return "ERROR_EXTENDED_ERROR";
        case ERROR_INVALID_GROUPNAME:
            return "ERROR_INVALID_GROUPNAME";
        case ERROR_INVALID_COMPUTERNAME:
            return "ERROR_INVALID_COMPUTERNAME";
        case ERROR_INVALID_EVENTNAME:
            return "ERROR_INVALID_EVENTNAME";
        case ERROR_INVALID_DOMAINNAME:
            return "ERROR_INVALID_DOMAINNAME";
        case ERROR_INVALID_SERVICENAME:
            return "ERROR_INVALID_SERVICENAME";
        case ERROR_INVALID_NETNAME:
            return "ERROR_INVALID_NETNAME";
        case ERROR_INVALID_SHARENAME:
            return "ERROR_INVALID_SHARENAME";
        case ERROR_INVALID_PASSWORDNAME:
            return "ERROR_INVALID_PASSWORDNAME";
        case ERROR_INVALID_MESSAGENAME:
            return "ERROR_INVALID_MESSAGENAME";
        case ERROR_INVALID_MESSAGEDEST:
            return "ERROR_INVALID_MESSAGEDEST";
        case ERROR_SESSION_CREDENTIAL_CONFLICT:
            return "ERROR_SESSION_CREDENTIAL_CONFLICT";
        case ERROR_REMOTE_SESSION_LIMIT_EXCEEDED:
            return "ERROR_REMOTE_SESSION_LIMIT_EXCEEDED";
        case ERROR_DUP_DOMAINNAME:
            return "ERROR_DUP_DOMAINNAME";
        case ERROR_NO_NETWORK:
            return "ERROR_NO_NETWORK";
        case ERROR_CANCELLED:
            return "ERROR_CANCELLED";
        case ERROR_USER_MAPPED_FILE:
            return "ERROR_USER_MAPPED_FILE";
        case ERROR_CONNECTION_REFUSED:
            return "ERROR_CONNECTION_REFUSED";
        case ERROR_GRACEFUL_DISCONNECT:
            return "ERROR_GRACEFUL_DISCONNECT";
        case ERROR_ADDRESS_ALREADY_ASSOCIATED:
            return "ERROR_ADDRESS_ALREADY_ASSOCIATED";
        case ERROR_ADDRESS_NOT_ASSOCIATED:
            return "ERROR_ADDRESS_NOT_ASSOCIATED";
        case ERROR_CONNECTION_INVALID:
            return "ERROR_CONNECTION_INVALID";
        case ERROR_CONNECTION_ACTIVE:
            return "ERROR_CONNECTION_ACTIVE";
        case ERROR_NETWORK_UNREACHABLE:
            return "ERROR_NETWORK_UNREACHABLE";
        case ERROR_HOST_UNREACHABLE:
            return "ERROR_HOST_UNREACHABLE";
        case ERROR_PROTOCOL_UNREACHABLE:
            return "ERROR_PROTOCOL_UNREACHABLE";
        case ERROR_PORT_UNREACHABLE:
            return "ERROR_PORT_UNREACHABLE";
        case ERROR_REQUEST_ABORTED:
            return "ERROR_REQUEST_ABORTED";
        case ERROR_CONNECTION_ABORTED:
            return "ERROR_CONNECTION_ABORTED";
        case ERROR_RETRY:
            return "ERROR_RETRY";
        case ERROR_CONNECTION_COUNT_LIMIT:
            return "ERROR_CONNECTION_COUNT_LIMIT";
        case ERROR_LOGIN_TIME_RESTRICTION:
            return "ERROR_LOGIN_TIME_RESTRICTION";
        case ERROR_LOGIN_WKSTA_RESTRICTION:
            return "ERROR_LOGIN_WKSTA_RESTRICTION";
        case ERROR_INCORRECT_ADDRESS:
            return "ERROR_INCORRECT_ADDRESS";
        case ERROR_ALREADY_REGISTERED:
            return "ERROR_ALREADY_REGISTERED";
        case ERROR_SERVICE_NOT_FOUND:
            return "ERROR_SERVICE_NOT_FOUND";
        case ERROR_NOT_AUTHENTICATED:
            return "ERROR_NOT_AUTHENTICATED";
        case ERROR_NOT_LOGGED_ON:
            return "ERROR_NOT_LOGGED_ON";
        case ERROR_CONTINUE:
            return "ERROR_CONTINUE";
        case ERROR_ALREADY_INITIALIZED:
            return "ERROR_ALREADY_INITIALIZED";
        case ERROR_NO_MORE_DEVICES:
            return "ERROR_NO_MORE_DEVICES";
        case ERROR_NO_SUCH_SITE:
            return "ERROR_NO_SUCH_SITE";
        case ERROR_DOMAIN_CONTROLLER_EXISTS:
            return "ERROR_DOMAIN_CONTROLLER_EXISTS";
        case ERROR_ONLY_IF_CONNECTED:
            return "ERROR_ONLY_IF_CONNECTED";
        case ERROR_OVERRIDE_NOCHANGES:
            return "ERROR_OVERRIDE_NOCHANGES";
        case ERROR_BAD_USER_PROFILE:
            return "ERROR_BAD_USER_PROFILE";
        case ERROR_NOT_SUPPORTED_ON_SBS:
            return "ERROR_NOT_SUPPORTED_ON_SBS";
        case ERROR_SERVER_SHUTDOWN_IN_PROGRESS:
            return "ERROR_SERVER_SHUTDOWN_IN_PROGRESS";
        case ERROR_HOST_DOWN:
            return "ERROR_HOST_DOWN";
        case ERROR_NON_ACCOUNT_SID:
            return "ERROR_NON_ACCOUNT_SID";
        case ERROR_NON_DOMAIN_SID:
            return "ERROR_NON_DOMAIN_SID";
        case ERROR_APPHELP_BLOCK:
            return "ERROR_APPHELP_BLOCK";
        case ERROR_ACCESS_DISABLED_BY_POLICY:
            return "ERROR_ACCESS_DISABLED_BY_POLICY";
        case ERROR_REG_NAT_CONSUMPTION:
            return "ERROR_REG_NAT_CONSUMPTION";
        case ERROR_CSCSHARE_OFFLINE:
            return "ERROR_CSCSHARE_OFFLINE";
        case ERROR_PKINIT_FAILURE:
            return "ERROR_PKINIT_FAILURE";
        case ERROR_SMARTCARD_SUBSYSTEM_FAILURE:
            return "ERROR_SMARTCARD_SUBSYSTEM_FAILURE";
        case ERROR_DOWNGRADE_DETECTED:
            return "ERROR_DOWNGRADE_DETECTED";
        case ERROR_MACHINE_LOCKED:
            return "ERROR_MACHINE_LOCKED";
        case ERROR_CALLBACK_SUPPLIED_INVALID_DATA:
            return "ERROR_CALLBACK_SUPPLIED_INVALID_DATA";
        case ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED:
            return "ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED";
        case ERROR_DRIVER_BLOCKED:
            return "ERROR_DRIVER_BLOCKED";
        case ERROR_INVALID_IMPORT_OF_NON_DLL:
            return "ERROR_INVALID_IMPORT_OF_NON_DLL";
        case ERROR_ACCESS_DISABLED_WEBBLADE:
            return "ERROR_ACCESS_DISABLED_WEBBLADE";
        case ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER:
            return "ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER";
        case ERROR_RECOVERY_FAILURE:
            return "ERROR_RECOVERY_FAILURE";
        case ERROR_ALREADY_FIBER:
            return "ERROR_ALREADY_FIBER";
        case ERROR_ALREADY_THREAD:
            return "ERROR_ALREADY_THREAD";
        case ERROR_STACK_BUFFER_OVERRUN:
            return "ERROR_STACK_BUFFER_OVERRUN";
        case ERROR_PARAMETER_QUOTA_EXCEEDED:
            return "ERROR_PARAMETER_QUOTA_EXCEEDED";
        case ERROR_DEBUGGER_INACTIVE:
            return "ERROR_DEBUGGER_INACTIVE";
        case ERROR_DELAY_LOAD_FAILED:
            return "ERROR_DELAY_LOAD_FAILED";
        case ERROR_VDM_DISALLOWED:
            return "ERROR_VDM_DISALLOWED";
        case ERROR_UNIDENTIFIED_ERROR:
            return "ERROR_UNIDENTIFIED_ERROR";
        case ERROR_NOT_ALL_ASSIGNED:
            return "ERROR_NOT_ALL_ASSIGNED";
        case ERROR_SOME_NOT_MAPPED:
            return "ERROR_SOME_NOT_MAPPED";
        case ERROR_NO_QUOTAS_FOR_ACCOUNT:
            return "ERROR_NO_QUOTAS_FOR_ACCOUNT";
        case ERROR_LOCAL_USER_SESSION_KEY:
            return "ERROR_LOCAL_USER_SESSION_KEY";
        case ERROR_NULL_LM_PASSWORD:
            return "ERROR_NULL_LM_PASSWORD";
        case ERROR_UNKNOWN_REVISION:
            return "ERROR_UNKNOWN_REVISION";
        case ERROR_REVISION_MISMATCH:
            return "ERROR_REVISION_MISMATCH";
        case ERROR_INVALID_OWNER:
            return "ERROR_INVALID_OWNER";
        case ERROR_INVALID_PRIMARY_GROUP:
            return "ERROR_INVALID_PRIMARY_GROUP";
        case ERROR_NO_IMPERSONATION_TOKEN:
            return "ERROR_NO_IMPERSONATION_TOKEN";
        case ERROR_CANT_DISABLE_MANDATORY:
            return "ERROR_CANT_DISABLE_MANDATORY";
        case ERROR_NO_LOGON_SERVERS:
            return "ERROR_NO_LOGON_SERVERS";
        case ERROR_NO_SUCH_LOGON_SESSION:
            return "ERROR_NO_SUCH_LOGON_SESSION";
        case ERROR_NO_SUCH_PRIVILEGE:
            return "ERROR_NO_SUCH_PRIVILEGE";
        case ERROR_PRIVILEGE_NOT_HELD:
            return "ERROR_PRIVILEGE_NOT_HELD";
        case ERROR_INVALID_ACCOUNT_NAME:
            return "ERROR_INVALID_ACCOUNT_NAME";
        case ERROR_USER_EXISTS:
            return "ERROR_USER_EXISTS";
        case ERROR_NO_SUCH_USER:
            return "ERROR_NO_SUCH_USER";
        case ERROR_GROUP_EXISTS:
            return "ERROR_GROUP_EXISTS";
        case ERROR_NO_SUCH_GROUP:
            return "ERROR_NO_SUCH_GROUP";
        case ERROR_MEMBER_IN_GROUP:
            return "ERROR_MEMBER_IN_GROUP";
        case ERROR_MEMBER_NOT_IN_GROUP:
            return "ERROR_MEMBER_NOT_IN_GROUP";
        case ERROR_LAST_ADMIN:
            return "ERROR_LAST_ADMIN";
        case ERROR_WRONG_PASSWORD:
            return "ERROR_WRONG_PASSWORD";
        case ERROR_ILL_FORMED_PASSWORD:
            return "ERROR_ILL_FORMED_PASSWORD";
        case ERROR_PASSWORD_RESTRICTION:
            return "ERROR_PASSWORD_RESTRICTION";
        case ERROR_LOGON_FAILURE:
            return "ERROR_LOGON_FAILURE";
        case ERROR_ACCOUNT_RESTRICTION:
            return "ERROR_ACCOUNT_RESTRICTION";
        case ERROR_INVALID_LOGON_HOURS:
            return "ERROR_INVALID_LOGON_HOURS";
        case ERROR_INVALID_WORKSTATION:
            return "ERROR_INVALID_WORKSTATION";
        case ERROR_PASSWORD_EXPIRED:
            return "ERROR_PASSWORD_EXPIRED";
        case ERROR_ACCOUNT_DISABLED:
            return "ERROR_ACCOUNT_DISABLED";
        case ERROR_NONE_MAPPED:
            return "ERROR_NONE_MAPPED";
        case ERROR_TOO_MANY_LUIDS_REQUESTED:
            return "ERROR_TOO_MANY_LUIDS_REQUESTED";
        case ERROR_LUIDS_EXHAUSTED:
            return "ERROR_LUIDS_EXHAUSTED";
        case ERROR_INVALID_SUB_AUTHORITY:
            return "ERROR_INVALID_SUB_AUTHORITY";
        case ERROR_INVALID_ACL:
            return "ERROR_INVALID_ACL";
        case ERROR_INVALID_SID:
            return "ERROR_INVALID_SID";
        case ERROR_INVALID_SECURITY_DESCR:
            return "ERROR_INVALID_SECURITY_DESCR";
        case ERROR_BAD_INHERITANCE_ACL:
            return "ERROR_BAD_INHERITANCE_ACL";
        case ERROR_SERVER_DISABLED:
            return "ERROR_SERVER_DISABLED";
        case ERROR_SERVER_NOT_DISABLED:
            return "ERROR_SERVER_NOT_DISABLED";
        case ERROR_INVALID_ID_AUTHORITY:
            return "ERROR_INVALID_ID_AUTHORITY";
        case ERROR_ALLOTTED_SPACE_EXCEEDED:
            return "ERROR_ALLOTTED_SPACE_EXCEEDED";
        case ERROR_INVALID_GROUP_ATTRIBUTES:
            return "ERROR_INVALID_GROUP_ATTRIBUTES";
        case ERROR_BAD_IMPERSONATION_LEVEL:
            return "ERROR_BAD_IMPERSONATION_LEVEL";
        case ERROR_CANT_OPEN_ANONYMOUS:
            return "ERROR_CANT_OPEN_ANONYMOUS";
        case ERROR_BAD_VALIDATION_CLASS:
            return "ERROR_BAD_VALIDATION_CLASS";
        case ERROR_BAD_TOKEN_TYPE:
            return "ERROR_BAD_TOKEN_TYPE";
        case ERROR_NO_SECURITY_ON_OBJECT:
            return "ERROR_NO_SECURITY_ON_OBJECT";
        case ERROR_CANT_ACCESS_DOMAIN_INFO:
            return "ERROR_CANT_ACCESS_DOMAIN_INFO";
        case ERROR_INVALID_SERVER_STATE:
            return "ERROR_INVALID_SERVER_STATE";
        case ERROR_INVALID_DOMAIN_STATE:
            return "ERROR_INVALID_DOMAIN_STATE";
        case ERROR_INVALID_DOMAIN_ROLE:
            return "ERROR_INVALID_DOMAIN_ROLE";
        case ERROR_NO_SUCH_DOMAIN:
            return "ERROR_NO_SUCH_DOMAIN";
        case ERROR_DOMAIN_EXISTS:
            return "ERROR_DOMAIN_EXISTS";
        case ERROR_DOMAIN_LIMIT_EXCEEDED:
            return "ERROR_DOMAIN_LIMIT_EXCEEDED";
        case ERROR_INTERNAL_DB_CORRUPTION:
            return "ERROR_INTERNAL_DB_CORRUPTION";
        case ERROR_INTERNAL_ERROR:
            return "ERROR_INTERNAL_ERROR";
        case ERROR_GENERIC_NOT_MAPPED:
            return "ERROR_GENERIC_NOT_MAPPED";
        case ERROR_BAD_DESCRIPTOR_FORMAT:
            return "ERROR_BAD_DESCRIPTOR_FORMAT";
        case ERROR_NOT_LOGON_PROCESS:
            return "ERROR_NOT_LOGON_PROCESS";
        case ERROR_LOGON_SESSION_EXISTS:
            return "ERROR_LOGON_SESSION_EXISTS";
        case ERROR_NO_SUCH_PACKAGE:
            return "ERROR_NO_SUCH_PACKAGE";
        case ERROR_BAD_LOGON_SESSION_STATE:
            return "ERROR_BAD_LOGON_SESSION_STATE";
        case ERROR_LOGON_SESSION_COLLISION:
            return "ERROR_LOGON_SESSION_COLLISION";
        case ERROR_INVALID_LOGON_TYPE:
            return "ERROR_INVALID_LOGON_TYPE";
        case ERROR_CANNOT_IMPERSONATE:
            return "ERROR_CANNOT_IMPERSONATE";
        case ERROR_RXACT_INVALID_STATE:
            return "ERROR_RXACT_INVALID_STATE";
        case ERROR_RXACT_COMMIT_FAILURE:
            return "ERROR_RXACT_COMMIT_FAILURE";
        case ERROR_SPECIAL_ACCOUNT:
            return "ERROR_SPECIAL_ACCOUNT";
        case ERROR_SPECIAL_GROUP:
            return "ERROR_SPECIAL_GROUP";
        case ERROR_SPECIAL_USER:
            return "ERROR_SPECIAL_USER";
        case ERROR_MEMBERS_PRIMARY_GROUP:
            return "ERROR_MEMBERS_PRIMARY_GROUP";
        case ERROR_TOKEN_ALREADY_IN_USE:
            return "ERROR_TOKEN_ALREADY_IN_USE";
        case ERROR_NO_SUCH_ALIAS:
            return "ERROR_NO_SUCH_ALIAS";
        case ERROR_MEMBER_NOT_IN_ALIAS:
            return "ERROR_MEMBER_NOT_IN_ALIAS";
        case ERROR_MEMBER_IN_ALIAS:
            return "ERROR_MEMBER_IN_ALIAS";
        case ERROR_ALIAS_EXISTS:
            return "ERROR_ALIAS_EXISTS";
        case ERROR_LOGON_NOT_GRANTED:
            return "ERROR_LOGON_NOT_GRANTED";
        case ERROR_TOO_MANY_SECRETS:
            return "ERROR_TOO_MANY_SECRETS";
        case ERROR_SECRET_TOO_LONG:
            return "ERROR_SECRET_TOO_LONG";
        case ERROR_INTERNAL_DB_ERROR:
            return "ERROR_INTERNAL_DB_ERROR";
        case ERROR_TOO_MANY_CONTEXT_IDS:
            return "ERROR_TOO_MANY_CONTEXT_IDS";
        case ERROR_LOGON_TYPE_NOT_GRANTED:
            return "ERROR_LOGON_TYPE_NOT_GRANTED";
        case ERROR_NT_CROSS_ENCRYPTION_REQUIRED:
            return "ERROR_NT_CROSS_ENCRYPTION_REQUIRED";
        case ERROR_NO_SUCH_MEMBER:
            return "ERROR_NO_SUCH_MEMBER";
        case ERROR_INVALID_MEMBER:
            return "ERROR_INVALID_MEMBER";
        case ERROR_TOO_MANY_SIDS:
            return "ERROR_TOO_MANY_SIDS";
        case ERROR_LM_CROSS_ENCRYPTION_REQUIRED:
            return "ERROR_LM_CROSS_ENCRYPTION_REQUIRED";
        case ERROR_NO_INHERITANCE:
            return "ERROR_NO_INHERITANCE";
        case ERROR_FILE_CORRUPT:
            return "ERROR_FILE_CORRUPT";
        case ERROR_DISK_CORRUPT:
            return "ERROR_DISK_CORRUPT";
        case ERROR_NO_USER_SESSION_KEY:
            return "ERROR_NO_USER_SESSION_KEY";
        case ERROR_LICENSE_QUOTA_EXCEEDED:
            return "ERROR_LICENSE_QUOTA_EXCEEDED";
        case ERROR_WRONG_TARGET_NAME:
            return "ERROR_WRONG_TARGET_NAME";
        case ERROR_MUTUAL_AUTH_FAILED:
            return "ERROR_MUTUAL_AUTH_FAILED";
        case ERROR_TIME_SKEW:
            return "ERROR_TIME_SKEW";
        case ERROR_CURRENT_DOMAIN_NOT_ALLOWED:
            return "ERROR_CURRENT_DOMAIN_NOT_ALLOWED";
        case ERROR_INVALID_WINDOW_HANDLE:
            return "ERROR_INVALID_WINDOW_HANDLE";
        case ERROR_INVALID_MENU_HANDLE:
            return "ERROR_INVALID_MENU_HANDLE";
        case ERROR_INVALID_CURSOR_HANDLE:
            return "ERROR_INVALID_CURSOR_HANDLE";
        case ERROR_INVALID_ACCEL_HANDLE:
            return "ERROR_INVALID_ACCEL_HANDLE";
        case ERROR_INVALID_HOOK_HANDLE:
            return "ERROR_INVALID_HOOK_HANDLE";
        case ERROR_INVALID_DWP_HANDLE:
            return "ERROR_INVALID_DWP_HANDLE";
        case ERROR_TLW_WITH_WSCHILD:
            return "ERROR_TLW_WITH_WSCHILD";
        case ERROR_CANNOT_FIND_WND_CLASS:
            return "ERROR_CANNOT_FIND_WND_CLASS";
        case ERROR_WINDOW_OF_OTHER_THREAD:
            return "ERROR_WINDOW_OF_OTHER_THREAD";
        case ERROR_HOTKEY_ALREADY_REGISTERED:
            return "ERROR_HOTKEY_ALREADY_REGISTERED";
        case ERROR_CLASS_ALREADY_EXISTS:
            return "ERROR_CLASS_ALREADY_EXISTS";
        case ERROR_CLASS_DOES_NOT_EXIST:
            return "ERROR_CLASS_DOES_NOT_EXIST";
        case ERROR_CLASS_HAS_WINDOWS:
            return "ERROR_CLASS_HAS_WINDOWS";
        case ERROR_INVALID_INDEX:
            return "ERROR_INVALID_INDEX";
        case ERROR_INVALID_ICON_HANDLE:
            return "ERROR_INVALID_ICON_HANDLE";
        case ERROR_PRIVATE_DIALOG_INDEX:
            return "ERROR_PRIVATE_DIALOG_INDEX";
        case ERROR_LISTBOX_ID_NOT_FOUND:
            return "ERROR_LISTBOX_ID_NOT_FOUND";
        case ERROR_NO_WILDCARD_CHARACTERS:
            return "ERROR_NO_WILDCARD_CHARACTERS";
        case ERROR_CLIPBOARD_NOT_OPEN:
            return "ERROR_CLIPBOARD_NOT_OPEN";
        case ERROR_HOTKEY_NOT_REGISTERED:
            return "ERROR_HOTKEY_NOT_REGISTERED";
        case ERROR_WINDOW_NOT_DIALOG:
            return "ERROR_WINDOW_NOT_DIALOG";
        case ERROR_CONTROL_ID_NOT_FOUND:
            return "ERROR_CONTROL_ID_NOT_FOUND";
        case ERROR_INVALID_COMBOBOX_MESSAGE:
            return "ERROR_INVALID_COMBOBOX_MESSAGE";
        case ERROR_WINDOW_NOT_COMBOBOX:
            return "ERROR_WINDOW_NOT_COMBOBOX";
        case ERROR_INVALID_EDIT_HEIGHT:
            return "ERROR_INVALID_EDIT_HEIGHT";
        case ERROR_DC_NOT_FOUND:
            return "ERROR_DC_NOT_FOUND";
        case ERROR_INVALID_HOOK_FILTER:
            return "ERROR_INVALID_HOOK_FILTER";
        case ERROR_INVALID_FILTER_PROC:
            return "ERROR_INVALID_FILTER_PROC";
        case ERROR_HOOK_NEEDS_HMOD:
            return "ERROR_HOOK_NEEDS_HMOD";
        case ERROR_GLOBAL_ONLY_HOOK:
            return "ERROR_GLOBAL_ONLY_HOOK";
        case ERROR_JOURNAL_HOOK_SET:
            return "ERROR_JOURNAL_HOOK_SET";
        case ERROR_HOOK_NOT_INSTALLED:
            return "ERROR_HOOK_NOT_INSTALLED";
        case ERROR_INVALID_LB_MESSAGE:
            return "ERROR_INVALID_LB_MESSAGE";
        case ERROR_SETCOUNT_ON_BAD_LB:
            return "ERROR_SETCOUNT_ON_BAD_LB";
        case ERROR_LB_WITHOUT_TABSTOPS:
            return "ERROR_LB_WITHOUT_TABSTOPS";
        case ERROR_DESTROY_OBJECT_OF_OTHER_THREAD:
            return "ERROR_DESTROY_OBJECT_OF_OTHER_THREAD";
        case ERROR_CHILD_WINDOW_MENU:
            return "ERROR_CHILD_WINDOW_MENU";
        case ERROR_NO_SYSTEM_MENU:
            return "ERROR_NO_SYSTEM_MENU";
        case ERROR_INVALID_MSGBOX_STYLE:
            return "ERROR_INVALID_MSGBOX_STYLE";
        case ERROR_INVALID_SPI_VALUE:
            return "ERROR_INVALID_SPI_VALUE";
        case ERROR_SCREEN_ALREADY_LOCKED:
            return "ERROR_SCREEN_ALREADY_LOCKED";
        case ERROR_HWNDS_HAVE_DIFF_PARENT:
            return "ERROR_HWNDS_HAVE_DIFF_PARENT";
        case ERROR_NOT_CHILD_WINDOW:
            return "ERROR_NOT_CHILD_WINDOW";
        case ERROR_INVALID_GW_COMMAND:
            return "ERROR_INVALID_GW_COMMAND";
        case ERROR_INVALID_THREAD_ID:
            return "ERROR_INVALID_THREAD_ID";
        case ERROR_NON_MDICHILD_WINDOW:
            return "ERROR_NON_MDICHILD_WINDOW";
        case ERROR_POPUP_ALREADY_ACTIVE:
            return "ERROR_POPUP_ALREADY_ACTIVE";
        case ERROR_NO_SCROLLBARS:
            return "ERROR_NO_SCROLLBARS";
        case ERROR_INVALID_SCROLLBAR_RANGE:
            return "ERROR_INVALID_SCROLLBAR_RANGE";
        case ERROR_INVALID_SHOWWIN_COMMAND:
            return "ERROR_INVALID_SHOWWIN_COMMAND";
        case ERROR_NO_SYSTEM_RESOURCES:
            return "ERROR_NO_SYSTEM_RESOURCES";
        case ERROR_NONPAGED_SYSTEM_RESOURCES:
            return "ERROR_NONPAGED_SYSTEM_RESOURCES";
        case ERROR_PAGED_SYSTEM_RESOURCES:
            return "ERROR_PAGED_SYSTEM_RESOURCES";
        case ERROR_WORKING_SET_QUOTA:
            return "ERROR_WORKING_SET_QUOTA";
        case ERROR_PAGEFILE_QUOTA:
            return "ERROR_PAGEFILE_QUOTA";
        case ERROR_COMMITMENT_LIMIT:
            return "ERROR_COMMITMENT_LIMIT";
        case ERROR_MENU_ITEM_NOT_FOUND:
            return "ERROR_MENU_ITEM_NOT_FOUND";
        case ERROR_INVALID_KEYBOARD_HANDLE:
            return "ERROR_INVALID_KEYBOARD_HANDLE";
        case ERROR_HOOK_TYPE_NOT_ALLOWED:
            return "ERROR_HOOK_TYPE_NOT_ALLOWED";
        case ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION:
            return "ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION";
        case ERROR_TIMEOUT:
            return "ERROR_TIMEOUT";
        case ERROR_INVALID_MONITOR_HANDLE:
            return "ERROR_INVALID_MONITOR_HANDLE";
        case ERROR_INCORRECT_SIZE:
            return "ERROR_INCORRECT_SIZE";
        case ERROR_EVENTLOG_FILE_CORRUPT:
            return "ERROR_EVENTLOG_FILE_CORRUPT";
        case ERROR_EVENTLOG_CANT_START:
            return "ERROR_EVENTLOG_CANT_START";
        case ERROR_LOG_FILE_FULL:
            return "ERROR_LOG_FILE_FULL";
        case ERROR_EVENTLOG_FILE_CHANGED:
            return "ERROR_EVENTLOG_FILE_CHANGED";
        case ERROR_INSTALL_SERVICE_FAILURE:
            return "ERROR_INSTALL_SERVICE_FAILURE";
        case ERROR_INSTALL_USEREXIT:
            return "ERROR_INSTALL_USEREXIT";
        case ERROR_INSTALL_FAILURE:
            return "ERROR_INSTALL_FAILURE";
        case ERROR_INSTALL_SUSPEND:
            return "ERROR_INSTALL_SUSPEND";
        case ERROR_UNKNOWN_PRODUCT:
            return "ERROR_UNKNOWN_PRODUCT";
        case ERROR_UNKNOWN_FEATURE:
            return "ERROR_UNKNOWN_FEATURE";
        case ERROR_UNKNOWN_COMPONENT:
            return "ERROR_UNKNOWN_COMPONENT";
        case ERROR_UNKNOWN_PROPERTY:
            return "ERROR_UNKNOWN_PROPERTY";
        case ERROR_INVALID_HANDLE_STATE:
            return "ERROR_INVALID_HANDLE_STATE";
        case ERROR_BAD_CONFIGURATION:
            return "ERROR_BAD_CONFIGURATION";
        case ERROR_INDEX_ABSENT:
            return "ERROR_INDEX_ABSENT";
        case ERROR_INSTALL_SOURCE_ABSENT:
            return "ERROR_INSTALL_SOURCE_ABSENT";
        case ERROR_INSTALL_PACKAGE_VERSION:
            return "ERROR_INSTALL_PACKAGE_VERSION";
        case ERROR_PRODUCT_UNINSTALLED:
            return "ERROR_PRODUCT_UNINSTALLED";
        case ERROR_BAD_QUERY_SYNTAX:
            return "ERROR_BAD_QUERY_SYNTAX";
        case ERROR_INVALID_FIELD:
            return "ERROR_INVALID_FIELD";
        case ERROR_DEVICE_REMOVED:
            return "ERROR_DEVICE_REMOVED";
        case ERROR_INSTALL_ALREADY_RUNNING:
            return "ERROR_INSTALL_ALREADY_RUNNING";
        case ERROR_INSTALL_PACKAGE_OPEN_FAILED:
            return "ERROR_INSTALL_PACKAGE_OPEN_FAILED";
        case ERROR_INSTALL_PACKAGE_INVALID:
            return "ERROR_INSTALL_PACKAGE_INVALID";
        case ERROR_INSTALL_UI_FAILURE:
            return "ERROR_INSTALL_UI_FAILURE";
        case ERROR_INSTALL_LOG_FAILURE:
            return "ERROR_INSTALL_LOG_FAILURE";
        case ERROR_INSTALL_LANGUAGE_UNSUPPORTED:
            return "ERROR_INSTALL_LANGUAGE_UNSUPPORTED";
        case ERROR_INSTALL_TRANSFORM_FAILURE:
            return "ERROR_INSTALL_TRANSFORM_FAILURE";
        case ERROR_INSTALL_PACKAGE_REJECTED:
            return "ERROR_INSTALL_PACKAGE_REJECTED";
        case ERROR_FUNCTION_NOT_CALLED:
            return "ERROR_FUNCTION_NOT_CALLED";
        case ERROR_FUNCTION_FAILED:
            return "ERROR_FUNCTION_FAILED";
        case ERROR_INVALID_TABLE:
            return "ERROR_INVALID_TABLE";
        case ERROR_DATATYPE_MISMATCH:
            return "ERROR_DATATYPE_MISMATCH";
        case ERROR_UNSUPPORTED_TYPE:
            return "ERROR_UNSUPPORTED_TYPE";
        case ERROR_CREATE_FAILED:
            return "ERROR_CREATE_FAILED";
        case ERROR_INSTALL_TEMP_UNWRITABLE:
            return "ERROR_INSTALL_TEMP_UNWRITABLE";
        case ERROR_INSTALL_PLATFORM_UNSUPPORTED:
            return "ERROR_INSTALL_PLATFORM_UNSUPPORTED";
        case ERROR_INSTALL_NOTUSED:
            return "ERROR_INSTALL_NOTUSED";
        case ERROR_PATCH_PACKAGE_OPEN_FAILED:
            return "ERROR_PATCH_PACKAGE_OPEN_FAILED";
        case ERROR_PATCH_PACKAGE_INVALID:
            return "ERROR_PATCH_PACKAGE_INVALID";
        case ERROR_PATCH_PACKAGE_UNSUPPORTED:
            return "ERROR_PATCH_PACKAGE_UNSUPPORTED";
        case ERROR_PRODUCT_VERSION:
            return "ERROR_PRODUCT_VERSION";
        case ERROR_INVALID_COMMAND_LINE:
            return "ERROR_INVALID_COMMAND_LINE";
        case ERROR_INSTALL_REMOTE_DISALLOWED:
            return "ERROR_INSTALL_REMOTE_DISALLOWED";
        case ERROR_SUCCESS_REBOOT_INITIATED:
            return "ERROR_SUCCESS_REBOOT_INITIATED";
        case ERROR_PATCH_TARGET_NOT_FOUND:
            return "ERROR_PATCH_TARGET_NOT_FOUND";
        case ERROR_PATCH_PACKAGE_REJECTED:
            return "ERROR_PATCH_PACKAGE_REJECTED";
        case ERROR_INSTALL_TRANSFORM_REJECTED:
            return "ERROR_INSTALL_TRANSFORM_REJECTED";
        case ERROR_INSTALL_REMOTE_PROHIBITED:
            return "ERROR_INSTALL_REMOTE_PROHIBITED";
        case ERROR_INVALID_USER_BUFFER:
            return "ERROR_INVALID_USER_BUFFER";
        case ERROR_UNRECOGNIZED_MEDIA:
            return "ERROR_UNRECOGNIZED_MEDIA";
        case ERROR_NO_TRUST_LSA_SECRET:
            return "ERROR_NO_TRUST_LSA_SECRET";
        case ERROR_NO_TRUST_SAM_ACCOUNT:
            return "ERROR_NO_TRUST_SAM_ACCOUNT";
        case ERROR_TRUSTED_DOMAIN_FAILURE:
            return "ERROR_TRUSTED_DOMAIN_FAILURE";
        case ERROR_TRUSTED_RELATIONSHIP_FAILURE:
            return "ERROR_TRUSTED_RELATIONSHIP_FAILURE";
        case ERROR_TRUST_FAILURE:
            return "ERROR_TRUST_FAILURE";
        case ERROR_NETLOGON_NOT_STARTED:
            return "ERROR_NETLOGON_NOT_STARTED";
        case ERROR_ACCOUNT_EXPIRED:
            return "ERROR_ACCOUNT_EXPIRED";
        case ERROR_REDIRECTOR_HAS_OPEN_HANDLES:
            return "ERROR_REDIRECTOR_HAS_OPEN_HANDLES";
        case ERROR_PRINTER_DRIVER_ALREADY_INSTALLED:
            return "ERROR_PRINTER_DRIVER_ALREADY_INSTALLED";
        case ERROR_UNKNOWN_PORT:
            return "ERROR_UNKNOWN_PORT";
        case ERROR_UNKNOWN_PRINTER_DRIVER:
            return "ERROR_UNKNOWN_PRINTER_DRIVER";
        case ERROR_UNKNOWN_PRINTPROCESSOR:
            return "ERROR_UNKNOWN_PRINTPROCESSOR";
        case ERROR_INVALID_SEPARATOR_FILE:
            return "ERROR_INVALID_SEPARATOR_FILE";
        case ERROR_INVALID_PRIORITY:
            return "ERROR_INVALID_PRIORITY";
        case ERROR_INVALID_PRINTER_NAME:
            return "ERROR_INVALID_PRINTER_NAME";
        case ERROR_PRINTER_ALREADY_EXISTS:
            return "ERROR_PRINTER_ALREADY_EXISTS";
        case ERROR_INVALID_PRINTER_COMMAND:
            return "ERROR_INVALID_PRINTER_COMMAND";
        case ERROR_INVALID_DATATYPE:
            return "ERROR_INVALID_DATATYPE";
        case ERROR_INVALID_ENVIRONMENT:
            return "ERROR_INVALID_ENVIRONMENT";
        case ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT:
            return "ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT";
        case ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT:
            return "ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT";
        case ERROR_NOLOGON_SERVER_TRUST_ACCOUNT:
            return "ERROR_NOLOGON_SERVER_TRUST_ACCOUNT";
        case ERROR_DOMAIN_TRUST_INCONSISTENT:
            return "ERROR_DOMAIN_TRUST_INCONSISTENT";
        case ERROR_SERVER_HAS_OPEN_HANDLES:
            return "ERROR_SERVER_HAS_OPEN_HANDLES";
        case ERROR_RESOURCE_DATA_NOT_FOUND:
            return "ERROR_RESOURCE_DATA_NOT_FOUND";
        case ERROR_RESOURCE_TYPE_NOT_FOUND:
            return "ERROR_RESOURCE_TYPE_NOT_FOUND";
        case ERROR_RESOURCE_NAME_NOT_FOUND:
            return "ERROR_RESOURCE_NAME_NOT_FOUND";
        case ERROR_RESOURCE_LANG_NOT_FOUND:
            return "ERROR_RESOURCE_LANG_NOT_FOUND";
        case ERROR_NOT_ENOUGH_QUOTA:
            return "ERROR_NOT_ENOUGH_QUOTA";
        case ERROR_INVALID_TIME:
            return "ERROR_INVALID_TIME";
        case ERROR_INVALID_FORM_NAME:
            return "ERROR_INVALID_FORM_NAME";
        case ERROR_INVALID_FORM_SIZE:
            return "ERROR_INVALID_FORM_SIZE";
        case ERROR_ALREADY_WAITING:
            return "ERROR_ALREADY_WAITING";
        case ERROR_PRINTER_DELETED:
            return "ERROR_PRINTER_DELETED";
        case ERROR_INVALID_PRINTER_STATE:
            return "ERROR_INVALID_PRINTER_STATE";
        case ERROR_PASSWORD_MUST_CHANGE:
            return "ERROR_PASSWORD_MUST_CHANGE";
        case ERROR_DOMAIN_CONTROLLER_NOT_FOUND:
            return "ERROR_DOMAIN_CONTROLLER_NOT_FOUND";
        case ERROR_ACCOUNT_LOCKED_OUT:
            return "ERROR_ACCOUNT_LOCKED_OUT";
        case ERROR_NO_SITENAME:
            return "ERROR_NO_SITENAME";
        case ERROR_CANT_ACCESS_FILE:
            return "ERROR_CANT_ACCESS_FILE";
        case ERROR_CANT_RESOLVE_FILENAME:
            return "ERROR_CANT_RESOLVE_FILENAME";
        case ERROR_KM_DRIVER_BLOCKED:
            return "ERROR_KM_DRIVER_BLOCKED";
        case ERROR_CONTEXT_EXPIRED:
            return "ERROR_CONTEXT_EXPIRED";
        case ERROR_PER_USER_TRUST_QUOTA_EXCEEDED:
            return "ERROR_PER_USER_TRUST_QUOTA_EXCEEDED";
        case ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED:
            return "ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED";
        case ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED:
            return "ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED";
        case ERROR_AUTHENTICATION_FIREWALL_FAILED:
            return "ERROR_AUTHENTICATION_FIREWALL_FAILED";
        case ERROR_REMOTE_PRINT_CONNECTIONS_BLOCKED:
            return "ERROR_REMOTE_PRINT_CONNECTIONS_BLOCKED";
        case ERROR_INVALID_PIXEL_FORMAT:
            return "ERROR_INVALID_PIXEL_FORMAT";
        case ERROR_BAD_DRIVER:
            return "ERROR_BAD_DRIVER";
        case ERROR_INVALID_WINDOW_STYLE:
            return "ERROR_INVALID_WINDOW_STYLE";
        case ERROR_METAFILE_NOT_SUPPORTED:
            return "ERROR_METAFILE_NOT_SUPPORTED";
        case ERROR_TRANSFORM_NOT_SUPPORTED:
            return "ERROR_TRANSFORM_NOT_SUPPORTED";
        case ERROR_CLIPPING_NOT_SUPPORTED:
            return "ERROR_CLIPPING_NOT_SUPPORTED";
        case ERROR_INVALID_CMM:
            return "ERROR_INVALID_CMM";
        case ERROR_INVALID_PROFILE:
            return "ERROR_INVALID_PROFILE";
        case ERROR_TAG_NOT_FOUND:
            return "ERROR_TAG_NOT_FOUND";
        case ERROR_TAG_NOT_PRESENT:
            return "ERROR_TAG_NOT_PRESENT";
        case ERROR_DUPLICATE_TAG:
            return "ERROR_DUPLICATE_TAG";
        case ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE:
            return "ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE";
        case ERROR_PROFILE_NOT_FOUND:
            return "ERROR_PROFILE_NOT_FOUND";
        case ERROR_INVALID_COLORSPACE:
            return "ERROR_INVALID_COLORSPACE";
        case ERROR_ICM_NOT_ENABLED:
            return "ERROR_ICM_NOT_ENABLED";
        case ERROR_DELETING_ICM_XFORM:
            return "ERROR_DELETING_ICM_XFORM";
        case ERROR_INVALID_TRANSFORM:
            return "ERROR_INVALID_TRANSFORM";
        case ERROR_COLORSPACE_MISMATCH:
            return "ERROR_COLORSPACE_MISMATCH";
        case ERROR_INVALID_COLORINDEX:
            return "ERROR_INVALID_COLORINDEX";
        case ERROR_CONNECTED_OTHER_PASSWORD:
            return "ERROR_CONNECTED_OTHER_PASSWORD";
        case ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT:
            return "ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT";
        case ERROR_BAD_USERNAME:
            return "ERROR_BAD_USERNAME";
        case ERROR_NOT_CONNECTED:
            return "ERROR_NOT_CONNECTED";
        case ERROR_OPEN_FILES:
            return "ERROR_OPEN_FILES";
        case ERROR_ACTIVE_CONNECTIONS:
            return "ERROR_ACTIVE_CONNECTIONS";
        case ERROR_DEVICE_IN_USE:
            return "ERROR_DEVICE_IN_USE";
        case ERROR_UNKNOWN_PRINT_MONITOR:
            return "ERROR_UNKNOWN_PRINT_MONITOR";
        case ERROR_PRINTER_DRIVER_IN_USE:
            return "ERROR_PRINTER_DRIVER_IN_USE";
        case ERROR_SPOOL_FILE_NOT_FOUND:
            return "ERROR_SPOOL_FILE_NOT_FOUND";
        case ERROR_SPL_NO_STARTDOC:
            return "ERROR_SPL_NO_STARTDOC";
        case ERROR_SPL_NO_ADDJOB:
            return "ERROR_SPL_NO_ADDJOB";
        case ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED:
            return "ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED";
        case ERROR_PRINT_MONITOR_ALREADY_INSTALLED:
            return "ERROR_PRINT_MONITOR_ALREADY_INSTALLED";
        case ERROR_INVALID_PRINT_MONITOR:
            return "ERROR_INVALID_PRINT_MONITOR";
        case ERROR_PRINT_MONITOR_IN_USE:
            return "ERROR_PRINT_MONITOR_IN_USE";
        case ERROR_PRINTER_HAS_JOBS_QUEUED:
            return "ERROR_PRINTER_HAS_JOBS_QUEUED";
        case ERROR_SUCCESS_REBOOT_REQUIRED:
            return "ERROR_SUCCESS_REBOOT_REQUIRED";
        case ERROR_SUCCESS_RESTART_REQUIRED:
            return "ERROR_SUCCESS_RESTART_REQUIRED";
        case ERROR_PRINTER_NOT_FOUND:
            return "ERROR_PRINTER_NOT_FOUND";
        case ERROR_PRINTER_DRIVER_WARNED:
            return "ERROR_PRINTER_DRIVER_WARNED";
        case ERROR_PRINTER_DRIVER_BLOCKED:
            return "ERROR_PRINTER_DRIVER_BLOCKED";
        case ERROR_WINS_INTERNAL:
            return "ERROR_WINS_INTERNAL";
        case ERROR_CAN_NOT_DEL_LOCAL_WINS:
            return "ERROR_CAN_NOT_DEL_LOCAL_WINS";
        case ERROR_STATIC_INIT:
            return "ERROR_STATIC_INIT";
        case ERROR_INC_BACKUP:
            return "ERROR_INC_BACKUP";
        case ERROR_FULL_BACKUP:
            return "ERROR_FULL_BACKUP";
        case ERROR_REC_NON_EXISTENT:
            return "ERROR_REC_NON_EXISTENT";
        case ERROR_RPL_NOT_ALLOWED:
            return "ERROR_RPL_NOT_ALLOWED";
        case ERROR_DHCP_ADDRESS_CONFLICT:
            return "ERROR_DHCP_ADDRESS_CONFLICT";
        case ERROR_WMI_GUID_NOT_FOUND:
            return "ERROR_WMI_GUID_NOT_FOUND";
        case ERROR_WMI_INSTANCE_NOT_FOUND:
            return "ERROR_WMI_INSTANCE_NOT_FOUND";
        case ERROR_WMI_ITEMID_NOT_FOUND:
            return "ERROR_WMI_ITEMID_NOT_FOUND";
        case ERROR_WMI_TRY_AGAIN:
            return "ERROR_WMI_TRY_AGAIN";
        case ERROR_WMI_DP_NOT_FOUND:
            return "ERROR_WMI_DP_NOT_FOUND";
        case ERROR_WMI_UNRESOLVED_INSTANCE_REF:
            return "ERROR_WMI_UNRESOLVED_INSTANCE_REF";
        case ERROR_WMI_ALREADY_ENABLED:
            return "ERROR_WMI_ALREADY_ENABLED";
        case ERROR_WMI_GUID_DISCONNECTED:
            return "ERROR_WMI_GUID_DISCONNECTED";
        case ERROR_WMI_SERVER_UNAVAILABLE:
            return "ERROR_WMI_SERVER_UNAVAILABLE";
        case ERROR_WMI_DP_FAILED:
            return "ERROR_WMI_DP_FAILED";
        case ERROR_WMI_INVALID_MOF:
            return "ERROR_WMI_INVALID_MOF";
        case ERROR_WMI_INVALID_REGINFO:
            return "ERROR_WMI_INVALID_REGINFO";
        case ERROR_WMI_ALREADY_DISABLED:
            return "ERROR_WMI_ALREADY_DISABLED";
        case ERROR_WMI_READ_ONLY:
            return "ERROR_WMI_READ_ONLY";
        case ERROR_WMI_SET_FAILURE:
            return "ERROR_WMI_SET_FAILURE";
        case ERROR_INVALID_MEDIA:
            return "ERROR_INVALID_MEDIA";
        case ERROR_INVALID_LIBRARY:
            return "ERROR_INVALID_LIBRARY";
        case ERROR_INVALID_MEDIA_POOL:
            return "ERROR_INVALID_MEDIA_POOL";
        case ERROR_DRIVE_MEDIA_MISMATCH:
            return "ERROR_DRIVE_MEDIA_MISMATCH";
        case ERROR_MEDIA_OFFLINE:
            return "ERROR_MEDIA_OFFLINE";
        case ERROR_LIBRARY_OFFLINE:
            return "ERROR_LIBRARY_OFFLINE";
        case ERROR_EMPTY:
            return "ERROR_EMPTY";
        case ERROR_NOT_EMPTY:
            return "ERROR_NOT_EMPTY";
        case ERROR_MEDIA_UNAVAILABLE:
            return "ERROR_MEDIA_UNAVAILABLE";
        case ERROR_RESOURCE_DISABLED:
            return "ERROR_RESOURCE_DISABLED";
        case ERROR_INVALID_CLEANER:
            return "ERROR_INVALID_CLEANER";
        case ERROR_UNABLE_TO_CLEAN:
            return "ERROR_UNABLE_TO_CLEAN";
        case ERROR_OBJECT_NOT_FOUND:
            return "ERROR_OBJECT_NOT_FOUND";
        case ERROR_DATABASE_FAILURE:
            return "ERROR_DATABASE_FAILURE";
        case ERROR_DATABASE_FULL:
            return "ERROR_DATABASE_FULL";
        case ERROR_MEDIA_INCOMPATIBLE:
            return "ERROR_MEDIA_INCOMPATIBLE";
        case ERROR_RESOURCE_NOT_PRESENT:
            return "ERROR_RESOURCE_NOT_PRESENT";
        case ERROR_INVALID_OPERATION:
            return "ERROR_INVALID_OPERATION";
        case ERROR_MEDIA_NOT_AVAILABLE:
            return "ERROR_MEDIA_NOT_AVAILABLE";
        case ERROR_DEVICE_NOT_AVAILABLE:
            return "ERROR_DEVICE_NOT_AVAILABLE";
        case ERROR_REQUEST_REFUSED:
            return "ERROR_REQUEST_REFUSED";
        case ERROR_INVALID_DRIVE_OBJECT:
            return "ERROR_INVALID_DRIVE_OBJECT";
        case ERROR_LIBRARY_FULL:
            return "ERROR_LIBRARY_FULL";
        case ERROR_MEDIUM_NOT_ACCESSIBLE:
            return "ERROR_MEDIUM_NOT_ACCESSIBLE";
        case ERROR_UNABLE_TO_LOAD_MEDIUM:
            return "ERROR_UNABLE_TO_LOAD_MEDIUM";
        case ERROR_UNABLE_TO_INVENTORY_DRIVE:
            return "ERROR_UNABLE_TO_INVENTORY_DRIVE";
        case ERROR_UNABLE_TO_INVENTORY_SLOT:
            return "ERROR_UNABLE_TO_INVENTORY_SLOT";
        case ERROR_UNABLE_TO_INVENTORY_TRANSPORT:
            return "ERROR_UNABLE_TO_INVENTORY_TRANSPORT";
        case ERROR_TRANSPORT_FULL:
            return "ERROR_TRANSPORT_FULL";
        case ERROR_CONTROLLING_IEPORT:
            return "ERROR_CONTROLLING_IEPORT";
        case ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA:
            return "ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA";
        case ERROR_CLEANER_SLOT_SET:
            return "ERROR_CLEANER_SLOT_SET";
        case ERROR_CLEANER_SLOT_NOT_SET:
            return "ERROR_CLEANER_SLOT_NOT_SET";
        case ERROR_CLEANER_CARTRIDGE_SPENT:
            return "ERROR_CLEANER_CARTRIDGE_SPENT";
        case ERROR_UNEXPECTED_OMID:
            return "ERROR_UNEXPECTED_OMID";
        case ERROR_CANT_DELETE_LAST_ITEM:
            return "ERROR_CANT_DELETE_LAST_ITEM";
        case ERROR_MESSAGE_EXCEEDS_MAX_SIZE:
            return "ERROR_MESSAGE_EXCEEDS_MAX_SIZE";
        case ERROR_VOLUME_CONTAINS_SYS_FILES:
            return "ERROR_VOLUME_CONTAINS_SYS_FILES";
        case ERROR_INDIGENOUS_TYPE:
            return "ERROR_INDIGENOUS_TYPE";
        case ERROR_NO_SUPPORTING_DRIVES:
            return "ERROR_NO_SUPPORTING_DRIVES";
        case ERROR_CLEANER_CARTRIDGE_INSTALLED:
            return "ERROR_CLEANER_CARTRIDGE_INSTALLED";
        case ERROR_IEPORT_FULL:
            return "ERROR_IEPORT_FULL";
        case ERROR_FILE_OFFLINE:
            return "ERROR_FILE_OFFLINE";
        case ERROR_REMOTE_STORAGE_NOT_ACTIVE:
            return "ERROR_REMOTE_STORAGE_NOT_ACTIVE";
        case ERROR_REMOTE_STORAGE_MEDIA_ERROR:
            return "ERROR_REMOTE_STORAGE_MEDIA_ERROR";
        case ERROR_NOT_A_REPARSE_POINT:
            return "ERROR_NOT_A_REPARSE_POINT";
        case ERROR_REPARSE_ATTRIBUTE_CONFLICT:
            return "ERROR_REPARSE_ATTRIBUTE_CONFLICT";
        case ERROR_INVALID_REPARSE_DATA:
            return "ERROR_INVALID_REPARSE_DATA";
        case ERROR_REPARSE_TAG_INVALID:
            return "ERROR_REPARSE_TAG_INVALID";
        case ERROR_REPARSE_TAG_MISMATCH:
            return "ERROR_REPARSE_TAG_MISMATCH";
        case ERROR_VOLUME_NOT_SIS_ENABLED:
            return "ERROR_VOLUME_NOT_SIS_ENABLED";
        case ERROR_DEPENDENT_RESOURCE_EXISTS:
            return "ERROR_DEPENDENT_RESOURCE_EXISTS";
        case ERROR_DEPENDENCY_NOT_FOUND:
            return "ERROR_DEPENDENCY_NOT_FOUND";
        case ERROR_DEPENDENCY_ALREADY_EXISTS:
            return "ERROR_DEPENDENCY_ALREADY_EXISTS";
        case ERROR_RESOURCE_NOT_ONLINE:
            return "ERROR_RESOURCE_NOT_ONLINE";
        case ERROR_HOST_NODE_NOT_AVAILABLE:
            return "ERROR_HOST_NODE_NOT_AVAILABLE";
        case ERROR_RESOURCE_NOT_AVAILABLE:
            return "ERROR_RESOURCE_NOT_AVAILABLE";
        case ERROR_RESOURCE_NOT_FOUND:
            return "ERROR_RESOURCE_NOT_FOUND";
        case ERROR_SHUTDOWN_CLUSTER:
            return "ERROR_SHUTDOWN_CLUSTER";
        case ERROR_CANT_EVICT_ACTIVE_NODE:
            return "ERROR_CANT_EVICT_ACTIVE_NODE";
        case ERROR_OBJECT_ALREADY_EXISTS:
            return "ERROR_OBJECT_ALREADY_EXISTS";
        case ERROR_OBJECT_IN_LIST:
            return "ERROR_OBJECT_IN_LIST";
        case ERROR_GROUP_NOT_AVAILABLE:
            return "ERROR_GROUP_NOT_AVAILABLE";
        case ERROR_GROUP_NOT_FOUND:
            return "ERROR_GROUP_NOT_FOUND";
        case ERROR_GROUP_NOT_ONLINE:
            return "ERROR_GROUP_NOT_ONLINE";
        case ERROR_HOST_NODE_NOT_RESOURCE_OWNER:
            return "ERROR_HOST_NODE_NOT_RESOURCE_OWNER";
        case ERROR_HOST_NODE_NOT_GROUP_OWNER:
            return "ERROR_HOST_NODE_NOT_GROUP_OWNER";
        case ERROR_RESMON_CREATE_FAILED:
            return "ERROR_RESMON_CREATE_FAILED";
        case ERROR_RESMON_ONLINE_FAILED:
            return "ERROR_RESMON_ONLINE_FAILED";
        case ERROR_RESOURCE_ONLINE:
            return "ERROR_RESOURCE_ONLINE";
        case ERROR_QUORUM_RESOURCE:
            return "ERROR_QUORUM_RESOURCE";
        case ERROR_NOT_QUORUM_CAPABLE:
            return "ERROR_NOT_QUORUM_CAPABLE";
        case ERROR_CLUSTER_SHUTTING_DOWN:
            return "ERROR_CLUSTER_SHUTTING_DOWN";
        case ERROR_INVALID_STATE:
            return "ERROR_INVALID_STATE";
        case ERROR_RESOURCE_PROPERTIES_STORED:
            return "ERROR_RESOURCE_PROPERTIES_STORED";
        case ERROR_NOT_QUORUM_CLASS:
            return "ERROR_NOT_QUORUM_CLASS";
        case ERROR_CORE_RESOURCE:
            return "ERROR_CORE_RESOURCE";
        case ERROR_QUORUM_RESOURCE_ONLINE_FAILED:
            return "ERROR_QUORUM_RESOURCE_ONLINE_FAILED";
        case ERROR_QUORUMLOG_OPEN_FAILED:
            return "ERROR_QUORUMLOG_OPEN_FAILED";
        case ERROR_CLUSTERLOG_CORRUPT:
            return "ERROR_CLUSTERLOG_CORRUPT";
        case ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE:
            return "ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE";
        case ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE:
            return "ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE";
        case ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND:
            return "ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND";
        case ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE:
            return "ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE";
        case ERROR_QUORUM_OWNER_ALIVE:
            return "ERROR_QUORUM_OWNER_ALIVE";
        case ERROR_NETWORK_NOT_AVAILABLE:
            return "ERROR_NETWORK_NOT_AVAILABLE";
        case ERROR_NODE_NOT_AVAILABLE:
            return "ERROR_NODE_NOT_AVAILABLE";
        case ERROR_ALL_NODES_NOT_AVAILABLE:
            return "ERROR_ALL_NODES_NOT_AVAILABLE";
        case ERROR_RESOURCE_FAILED:
            return "ERROR_RESOURCE_FAILED";
        case ERROR_CLUSTER_INVALID_NODE:
            return "ERROR_CLUSTER_INVALID_NODE";
        case ERROR_CLUSTER_NODE_EXISTS:
            return "ERROR_CLUSTER_NODE_EXISTS";
        case ERROR_CLUSTER_JOIN_IN_PROGRESS:
            return "ERROR_CLUSTER_JOIN_IN_PROGRESS";
        case ERROR_CLUSTER_NODE_NOT_FOUND:
            return "ERROR_CLUSTER_NODE_NOT_FOUND";
        case ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND:
            return "ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND";
        case ERROR_CLUSTER_NETWORK_EXISTS:
            return "ERROR_CLUSTER_NETWORK_EXISTS";
        case ERROR_CLUSTER_NETWORK_NOT_FOUND:
            return "ERROR_CLUSTER_NETWORK_NOT_FOUND";
        case ERROR_CLUSTER_NETINTERFACE_EXISTS:
            return "ERROR_CLUSTER_NETINTERFACE_EXISTS";
        case ERROR_CLUSTER_NETINTERFACE_NOT_FOUND:
            return "ERROR_CLUSTER_NETINTERFACE_NOT_FOUND";
        case ERROR_CLUSTER_INVALID_REQUEST:
            return "ERROR_CLUSTER_INVALID_REQUEST";
        case ERROR_CLUSTER_INVALID_NETWORK_PROVIDER:
            return "ERROR_CLUSTER_INVALID_NETWORK_PROVIDER";
        case ERROR_CLUSTER_NODE_DOWN:
            return "ERROR_CLUSTER_NODE_DOWN";
        case ERROR_CLUSTER_NODE_UNREACHABLE:
            return "ERROR_CLUSTER_NODE_UNREACHABLE";
        case ERROR_CLUSTER_NODE_NOT_MEMBER:
            return "ERROR_CLUSTER_NODE_NOT_MEMBER";
        case ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS:
            return "ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS";
        case ERROR_CLUSTER_INVALID_NETWORK:
            return "ERROR_CLUSTER_INVALID_NETWORK";
        case ERROR_CLUSTER_NODE_UP:
            return "ERROR_CLUSTER_NODE_UP";
        case ERROR_CLUSTER_IPADDR_IN_USE:
            return "ERROR_CLUSTER_IPADDR_IN_USE";
        case ERROR_CLUSTER_NODE_NOT_PAUSED:
            return "ERROR_CLUSTER_NODE_NOT_PAUSED";
        case ERROR_CLUSTER_NO_SECURITY_CONTEXT:
            return "ERROR_CLUSTER_NO_SECURITY_CONTEXT";
        case ERROR_CLUSTER_NETWORK_NOT_INTERNAL:
            return "ERROR_CLUSTER_NETWORK_NOT_INTERNAL";
        case ERROR_CLUSTER_NODE_ALREADY_UP:
            return "ERROR_CLUSTER_NODE_ALREADY_UP";
        case ERROR_CLUSTER_NODE_ALREADY_DOWN:
            return "ERROR_CLUSTER_NODE_ALREADY_DOWN";
        case ERROR_CLUSTER_NETWORK_ALREADY_ONLINE:
            return "ERROR_CLUSTER_NETWORK_ALREADY_ONLINE";
        case ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE:
            return "ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE";
        case ERROR_CLUSTER_NODE_ALREADY_MEMBER:
            return "ERROR_CLUSTER_NODE_ALREADY_MEMBER";
        case ERROR_CLUSTER_LAST_INTERNAL_NETWORK:
            return "ERROR_CLUSTER_LAST_INTERNAL_NETWORK";
        case ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS:
            return "ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS";
        case ERROR_INVALID_OPERATION_ON_QUORUM:
            return "ERROR_INVALID_OPERATION_ON_QUORUM";
        case ERROR_DEPENDENCY_NOT_ALLOWED:
            return "ERROR_DEPENDENCY_NOT_ALLOWED";
        case ERROR_CLUSTER_NODE_PAUSED:
            return "ERROR_CLUSTER_NODE_PAUSED";
        case ERROR_NODE_CANT_HOST_RESOURCE:
            return "ERROR_NODE_CANT_HOST_RESOURCE";
        case ERROR_CLUSTER_NODE_NOT_READY:
            return "ERROR_CLUSTER_NODE_NOT_READY";
        case ERROR_CLUSTER_NODE_SHUTTING_DOWN:
            return "ERROR_CLUSTER_NODE_SHUTTING_DOWN";
        case ERROR_CLUSTER_JOIN_ABORTED:
            return "ERROR_CLUSTER_JOIN_ABORTED";
        case ERROR_CLUSTER_INCOMPATIBLE_VERSIONS:
            return "ERROR_CLUSTER_INCOMPATIBLE_VERSIONS";
        case ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED:
            return "ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED";
        case ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED:
            return "ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED";
        case ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND:
            return "ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND";
        case ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED:
            return "ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED";
        case ERROR_CLUSTER_RESNAME_NOT_FOUND:
            return "ERROR_CLUSTER_RESNAME_NOT_FOUND";
        case ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED:
            return "ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED";
        case ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST:
            return "ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST";
        case ERROR_CLUSTER_DATABASE_SEQMISMATCH:
            return "ERROR_CLUSTER_DATABASE_SEQMISMATCH";
        case ERROR_RESMON_INVALID_STATE:
            return "ERROR_RESMON_INVALID_STATE";
        case ERROR_CLUSTER_GUM_NOT_LOCKER:
            return "ERROR_CLUSTER_GUM_NOT_LOCKER";
        case ERROR_QUORUM_DISK_NOT_FOUND:
            return "ERROR_QUORUM_DISK_NOT_FOUND";
        case ERROR_DATABASE_BACKUP_CORRUPT:
            return "ERROR_DATABASE_BACKUP_CORRUPT";
        case ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT:
            return "ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT";
        case ERROR_RESOURCE_PROPERTY_UNCHANGEABLE:
            return "ERROR_RESOURCE_PROPERTY_UNCHANGEABLE";
        case ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE:
            return "ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE";
        case ERROR_CLUSTER_QUORUMLOG_NOT_FOUND:
            return "ERROR_CLUSTER_QUORUMLOG_NOT_FOUND";
        case ERROR_CLUSTER_MEMBERSHIP_HALT:
            return "ERROR_CLUSTER_MEMBERSHIP_HALT";
        case ERROR_CLUSTER_INSTANCE_ID_MISMATCH:
            return "ERROR_CLUSTER_INSTANCE_ID_MISMATCH";
        case ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP:
            return "ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP";
        case ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH:
            return "ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH";
        case ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP:
            return "ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP";
        case ERROR_CLUSTER_PARAMETER_MISMATCH:
            return "ERROR_CLUSTER_PARAMETER_MISMATCH";
        case ERROR_NODE_CANNOT_BE_CLUSTERED:
            return "ERROR_NODE_CANNOT_BE_CLUSTERED";
        case ERROR_CLUSTER_WRONG_OS_VERSION:
            return "ERROR_CLUSTER_WRONG_OS_VERSION";
        case ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME:
            return "ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME";
        case ERROR_CLUSCFG_ALREADY_COMMITTED:
            return "ERROR_CLUSCFG_ALREADY_COMMITTED";
        case ERROR_CLUSCFG_ROLLBACK_FAILED:
            return "ERROR_CLUSCFG_ROLLBACK_FAILED";
        case ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT:
            return "ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT";
        case ERROR_CLUSTER_OLD_VERSION:
            return "ERROR_CLUSTER_OLD_VERSION";
        case ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME:
            return "ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME";
        case ERROR_ENCRYPTION_FAILED:
            return "ERROR_ENCRYPTION_FAILED";
        case ERROR_DECRYPTION_FAILED:
            return "ERROR_DECRYPTION_FAILED";
        case ERROR_FILE_ENCRYPTED:
            return "ERROR_FILE_ENCRYPTED";
        case ERROR_NO_RECOVERY_POLICY:
            return "ERROR_NO_RECOVERY_POLICY";
        case ERROR_NO_EFS:
            return "ERROR_NO_EFS";
        case ERROR_WRONG_EFS:
            return "ERROR_WRONG_EFS";
        case ERROR_NO_USER_KEYS:
            return "ERROR_NO_USER_KEYS";
        case ERROR_FILE_NOT_ENCRYPTED:
            return "ERROR_FILE_NOT_ENCRYPTED";
        case ERROR_NOT_EXPORT_FORMAT:
            return "ERROR_NOT_EXPORT_FORMAT";
        case ERROR_FILE_READ_ONLY:
            return "ERROR_FILE_READ_ONLY";
        case ERROR_DIR_EFS_DISALLOWED:
            return "ERROR_DIR_EFS_DISALLOWED";
        case ERROR_EFS_SERVER_NOT_TRUSTED:
            return "ERROR_EFS_SERVER_NOT_TRUSTED";
        case ERROR_BAD_RECOVERY_POLICY:
            return "ERROR_BAD_RECOVERY_POLICY";
        case ERROR_EFS_ALG_BLOB_TOO_BIG:
            return "ERROR_EFS_ALG_BLOB_TOO_BIG";
        case ERROR_VOLUME_NOT_SUPPORT_EFS:
            return "ERROR_VOLUME_NOT_SUPPORT_EFS";
        case ERROR_EFS_DISABLED:
            return "ERROR_EFS_DISABLED";
        case ERROR_EFS_VERSION_NOT_SUPPORT:
            return "ERROR_EFS_VERSION_NOT_SUPPORT";
        case ERROR_NO_BROWSER_SERVERS_FOUND:
            return "ERROR_NO_BROWSER_SERVERS_FOUND";
        case ERROR_CTX_WINSTATION_NAME_INVALID:
            return "ERROR_CTX_WINSTATION_NAME_INVALID";
        case ERROR_CTX_INVALID_PD:
            return "ERROR_CTX_INVALID_PD";
        case ERROR_CTX_PD_NOT_FOUND:
            return "ERROR_CTX_PD_NOT_FOUND";
        case ERROR_CTX_WD_NOT_FOUND:
            return "ERROR_CTX_WD_NOT_FOUND";
        case ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY:
            return "ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY";
        case ERROR_CTX_SERVICE_NAME_COLLISION:
            return "ERROR_CTX_SERVICE_NAME_COLLISION";
        case ERROR_CTX_CLOSE_PENDING:
            return "ERROR_CTX_CLOSE_PENDING";
        case ERROR_CTX_NO_OUTBUF:
            return "ERROR_CTX_NO_OUTBUF";
        case ERROR_CTX_MODEM_INF_NOT_FOUND:
            return "ERROR_CTX_MODEM_INF_NOT_FOUND";
        case ERROR_CTX_INVALID_MODEMNAME:
            return "ERROR_CTX_INVALID_MODEMNAME";
        case ERROR_CTX_MODEM_RESPONSE_ERROR:
            return "ERROR_CTX_MODEM_RESPONSE_ERROR";
        case ERROR_CTX_MODEM_RESPONSE_TIMEOUT:
            return "ERROR_CTX_MODEM_RESPONSE_TIMEOUT";
        case ERROR_CTX_MODEM_RESPONSE_NO_CARRIER:
            return "ERROR_CTX_MODEM_RESPONSE_NO_CARRIER";
        case ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE:
            return "ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE";
        case ERROR_CTX_MODEM_RESPONSE_BUSY:
            return "ERROR_CTX_MODEM_RESPONSE_BUSY";
        case ERROR_CTX_MODEM_RESPONSE_VOICE:
            return "ERROR_CTX_MODEM_RESPONSE_VOICE";
        case ERROR_CTX_TD_ERROR:
            return "ERROR_CTX_TD_ERROR";
        case ERROR_CTX_WINSTATION_NOT_FOUND:
            return "ERROR_CTX_WINSTATION_NOT_FOUND";
        case ERROR_CTX_WINSTATION_ALREADY_EXISTS:
            return "ERROR_CTX_WINSTATION_ALREADY_EXISTS";
        case ERROR_CTX_WINSTATION_BUSY:
            return "ERROR_CTX_WINSTATION_BUSY";
        case ERROR_CTX_BAD_VIDEO_MODE:
            return "ERROR_CTX_BAD_VIDEO_MODE";
        case ERROR_CTX_GRAPHICS_INVALID:
            return "ERROR_CTX_GRAPHICS_INVALID";
        case ERROR_CTX_LOGON_DISABLED:
            return "ERROR_CTX_LOGON_DISABLED";
        case ERROR_CTX_NOT_CONSOLE:
            return "ERROR_CTX_NOT_CONSOLE";
        case ERROR_CTX_CLIENT_QUERY_TIMEOUT:
            return "ERROR_CTX_CLIENT_QUERY_TIMEOUT";
        case ERROR_CTX_CONSOLE_DISCONNECT:
            return "ERROR_CTX_CONSOLE_DISCONNECT";
        case ERROR_CTX_CONSOLE_CONNECT:
            return "ERROR_CTX_CONSOLE_CONNECT";
        case ERROR_CTX_SHADOW_DENIED:
            return "ERROR_CTX_SHADOW_DENIED";
        case ERROR_CTX_WINSTATION_ACCESS_DENIED:
            return "ERROR_CTX_WINSTATION_ACCESS_DENIED";
        case ERROR_CTX_INVALID_WD:
            return "ERROR_CTX_INVALID_WD";
        case ERROR_CTX_SHADOW_INVALID:
            return "ERROR_CTX_SHADOW_INVALID";
        case ERROR_CTX_SHADOW_DISABLED:
            return "ERROR_CTX_SHADOW_DISABLED";
        case ERROR_CTX_CLIENT_LICENSE_IN_USE:
            return "ERROR_CTX_CLIENT_LICENSE_IN_USE";
        case ERROR_CTX_CLIENT_LICENSE_NOT_SET:
            return "ERROR_CTX_CLIENT_LICENSE_NOT_SET";
        case ERROR_CTX_LICENSE_NOT_AVAILABLE:
            return "ERROR_CTX_LICENSE_NOT_AVAILABLE";
        case ERROR_CTX_LICENSE_CLIENT_INVALID:
            return "ERROR_CTX_LICENSE_CLIENT_INVALID";
        case ERROR_CTX_LICENSE_EXPIRED:
            return "ERROR_CTX_LICENSE_EXPIRED";
        case ERROR_CTX_SHADOW_NOT_RUNNING:
            return "ERROR_CTX_SHADOW_NOT_RUNNING";
        case ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE:
            return "ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE";
        case ERROR_ACTIVATION_COUNT_EXCEEDED:
            return "ERROR_ACTIVATION_COUNT_EXCEEDED";
        case ERROR_DS_NOT_INSTALLED:
            return "ERROR_DS_NOT_INSTALLED";
        case ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY:
            return "ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY";
        case ERROR_DS_NO_ATTRIBUTE_OR_VALUE:
            return "ERROR_DS_NO_ATTRIBUTE_OR_VALUE";
        case ERROR_DS_INVALID_ATTRIBUTE_SYNTAX:
            return "ERROR_DS_INVALID_ATTRIBUTE_SYNTAX";
        case ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED:
            return "ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED";
        case ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS:
            return "ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS";
        case ERROR_DS_BUSY:
            return "ERROR_DS_BUSY";
        case ERROR_DS_UNAVAILABLE:
            return "ERROR_DS_UNAVAILABLE";
        case ERROR_DS_NO_RIDS_ALLOCATED:
            return "ERROR_DS_NO_RIDS_ALLOCATED";
        case ERROR_DS_NO_MORE_RIDS:
            return "ERROR_DS_NO_MORE_RIDS";
        case ERROR_DS_INCORRECT_ROLE_OWNER:
            return "ERROR_DS_INCORRECT_ROLE_OWNER";
        case ERROR_DS_RIDMGR_INIT_ERROR:
            return "ERROR_DS_RIDMGR_INIT_ERROR";
        case ERROR_DS_OBJ_CLASS_VIOLATION:
            return "ERROR_DS_OBJ_CLASS_VIOLATION";
        case ERROR_DS_CANT_ON_NON_LEAF:
            return "ERROR_DS_CANT_ON_NON_LEAF";
        case ERROR_DS_CANT_ON_RDN:
            return "ERROR_DS_CANT_ON_RDN";
        case ERROR_DS_CANT_MOD_OBJ_CLASS:
            return "ERROR_DS_CANT_MOD_OBJ_CLASS";
        case ERROR_DS_CROSS_DOM_MOVE_ERROR:
            return "ERROR_DS_CROSS_DOM_MOVE_ERROR";
        case ERROR_DS_GC_NOT_AVAILABLE:
            return "ERROR_DS_GC_NOT_AVAILABLE";
        case ERROR_SHARED_POLICY:
            return "ERROR_SHARED_POLICY";
        case ERROR_POLICY_OBJECT_NOT_FOUND:
            return "ERROR_POLICY_OBJECT_NOT_FOUND";
        case ERROR_POLICY_ONLY_IN_DS:
            return "ERROR_POLICY_ONLY_IN_DS";
        case ERROR_PROMOTION_ACTIVE:
            return "ERROR_PROMOTION_ACTIVE";
        case ERROR_NO_PROMOTION_ACTIVE:
            return "ERROR_NO_PROMOTION_ACTIVE";
        case ERROR_DS_OPERATIONS_ERROR:
            return "ERROR_DS_OPERATIONS_ERROR";
        case ERROR_DS_PROTOCOL_ERROR:
            return "ERROR_DS_PROTOCOL_ERROR";
        case ERROR_DS_TIMELIMIT_EXCEEDED:
            return "ERROR_DS_TIMELIMIT_EXCEEDED";
        case ERROR_DS_SIZELIMIT_EXCEEDED:
            return "ERROR_DS_SIZELIMIT_EXCEEDED";
        case ERROR_DS_ADMIN_LIMIT_EXCEEDED:
            return "ERROR_DS_ADMIN_LIMIT_EXCEEDED";
        case ERROR_DS_COMPARE_FALSE:
            return "ERROR_DS_COMPARE_FALSE";
        case ERROR_DS_COMPARE_TRUE:
            return "ERROR_DS_COMPARE_TRUE";
        case ERROR_DS_AUTH_METHOD_NOT_SUPPORTED:
            return "ERROR_DS_AUTH_METHOD_NOT_SUPPORTED";
        case ERROR_DS_STRONG_AUTH_REQUIRED:
            return "ERROR_DS_STRONG_AUTH_REQUIRED";
        case ERROR_DS_INAPPROPRIATE_AUTH:
            return "ERROR_DS_INAPPROPRIATE_AUTH";
        case ERROR_DS_AUTH_UNKNOWN:
            return "ERROR_DS_AUTH_UNKNOWN";
        case ERROR_DS_REFERRAL:
            return "ERROR_DS_REFERRAL";
        case ERROR_DS_UNAVAILABLE_CRIT_EXTENSION:
            return "ERROR_DS_UNAVAILABLE_CRIT_EXTENSION";
        case ERROR_DS_CONFIDENTIALITY_REQUIRED:
            return "ERROR_DS_CONFIDENTIALITY_REQUIRED";
        case ERROR_DS_INAPPROPRIATE_MATCHING:
            return "ERROR_DS_INAPPROPRIATE_MATCHING";
        case ERROR_DS_CONSTRAINT_VIOLATION:
            return "ERROR_DS_CONSTRAINT_VIOLATION";
        case ERROR_DS_NO_SUCH_OBJECT:
            return "ERROR_DS_NO_SUCH_OBJECT";
        case ERROR_DS_ALIAS_PROBLEM:
            return "ERROR_DS_ALIAS_PROBLEM";
        case ERROR_DS_INVALID_DN_SYNTAX:
            return "ERROR_DS_INVALID_DN_SYNTAX";
        case ERROR_DS_IS_LEAF:
            return "ERROR_DS_IS_LEAF";
        case ERROR_DS_ALIAS_DEREF_PROBLEM:
            return "ERROR_DS_ALIAS_DEREF_PROBLEM";
        case ERROR_DS_UNWILLING_TO_PERFORM:
            return "ERROR_DS_UNWILLING_TO_PERFORM";
        case ERROR_DS_LOOP_DETECT:
            return "ERROR_DS_LOOP_DETECT";
        case ERROR_DS_NAMING_VIOLATION:
            return "ERROR_DS_NAMING_VIOLATION";
        case ERROR_DS_OBJECT_RESULTS_TOO_LARGE:
            return "ERROR_DS_OBJECT_RESULTS_TOO_LARGE";
        case ERROR_DS_AFFECTS_MULTIPLE_DSAS:
            return "ERROR_DS_AFFECTS_MULTIPLE_DSAS";
        case ERROR_DS_SERVER_DOWN:
            return "ERROR_DS_SERVER_DOWN";
        case ERROR_DS_LOCAL_ERROR:
            return "ERROR_DS_LOCAL_ERROR";
        case ERROR_DS_ENCODING_ERROR:
            return "ERROR_DS_ENCODING_ERROR";
        case ERROR_DS_DECODING_ERROR:
            return "ERROR_DS_DECODING_ERROR";
        case ERROR_DS_FILTER_UNKNOWN:
            return "ERROR_DS_FILTER_UNKNOWN";
        case ERROR_DS_PARAM_ERROR:
            return "ERROR_DS_PARAM_ERROR";
        case ERROR_DS_NOT_SUPPORTED:
            return "ERROR_DS_NOT_SUPPORTED";
        case ERROR_DS_NO_RESULTS_RETURNED:
            return "ERROR_DS_NO_RESULTS_RETURNED";
        case ERROR_DS_CONTROL_NOT_FOUND:
            return "ERROR_DS_CONTROL_NOT_FOUND";
        case ERROR_DS_CLIENT_LOOP:
            return "ERROR_DS_CLIENT_LOOP";
        case ERROR_DS_REFERRAL_LIMIT_EXCEEDED:
            return "ERROR_DS_REFERRAL_LIMIT_EXCEEDED";
        case ERROR_DS_SORT_CONTROL_MISSING:
            return "ERROR_DS_SORT_CONTROL_MISSING";
        case ERROR_DS_OFFSET_RANGE_ERROR:
            return "ERROR_DS_OFFSET_RANGE_ERROR";
        case ERROR_DS_ROOT_MUST_BE_NC:
            return "ERROR_DS_ROOT_MUST_BE_NC";
        case ERROR_DS_ADD_REPLICA_INHIBITED:
            return "ERROR_DS_ADD_REPLICA_INHIBITED";
        case ERROR_DS_ATT_NOT_DEF_IN_SCHEMA:
            return "ERROR_DS_ATT_NOT_DEF_IN_SCHEMA";
        case ERROR_DS_MAX_OBJ_SIZE_EXCEEDED:
            return "ERROR_DS_MAX_OBJ_SIZE_EXCEEDED";
        case ERROR_DS_OBJ_STRING_NAME_EXISTS:
            return "ERROR_DS_OBJ_STRING_NAME_EXISTS";
        case ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA:
            return "ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA";
        case ERROR_DS_RDN_DOESNT_MATCH_SCHEMA:
            return "ERROR_DS_RDN_DOESNT_MATCH_SCHEMA";
        case ERROR_DS_NO_REQUESTED_ATTS_FOUND:
            return "ERROR_DS_NO_REQUESTED_ATTS_FOUND";
        case ERROR_DS_USER_BUFFER_TO_SMALL:
            return "ERROR_DS_USER_BUFFER_TO_SMALL";
        case ERROR_DS_ATT_IS_NOT_ON_OBJ:
            return "ERROR_DS_ATT_IS_NOT_ON_OBJ";
        case ERROR_DS_ILLEGAL_MOD_OPERATION:
            return "ERROR_DS_ILLEGAL_MOD_OPERATION";
        case ERROR_DS_OBJ_TOO_LARGE:
            return "ERROR_DS_OBJ_TOO_LARGE";
        case ERROR_DS_BAD_INSTANCE_TYPE:
            return "ERROR_DS_BAD_INSTANCE_TYPE";
        case ERROR_DS_MASTERDSA_REQUIRED:
            return "ERROR_DS_MASTERDSA_REQUIRED";
        case ERROR_DS_OBJECT_CLASS_REQUIRED:
            return "ERROR_DS_OBJECT_CLASS_REQUIRED";
        case ERROR_DS_MISSING_REQUIRED_ATT:
            return "ERROR_DS_MISSING_REQUIRED_ATT";
        case ERROR_DS_ATT_NOT_DEF_FOR_CLASS:
            return "ERROR_DS_ATT_NOT_DEF_FOR_CLASS";
        case ERROR_DS_ATT_ALREADY_EXISTS:
            return "ERROR_DS_ATT_ALREADY_EXISTS";
        case ERROR_DS_CANT_ADD_ATT_VALUES:
            return "ERROR_DS_CANT_ADD_ATT_VALUES";
        case ERROR_DS_SINGLE_VALUE_CONSTRAINT:
            return "ERROR_DS_SINGLE_VALUE_CONSTRAINT";
        case ERROR_DS_RANGE_CONSTRAINT:
            return "ERROR_DS_RANGE_CONSTRAINT";
        case ERROR_DS_ATT_VAL_ALREADY_EXISTS:
            return "ERROR_DS_ATT_VAL_ALREADY_EXISTS";
        case ERROR_DS_CANT_REM_MISSING_ATT:
            return "ERROR_DS_CANT_REM_MISSING_ATT";
        case ERROR_DS_CANT_REM_MISSING_ATT_VAL:
            return "ERROR_DS_CANT_REM_MISSING_ATT_VAL";
        case ERROR_DS_ROOT_CANT_BE_SUBREF:
            return "ERROR_DS_ROOT_CANT_BE_SUBREF";
        case ERROR_DS_NO_CHAINING:
            return "ERROR_DS_NO_CHAINING";
        case ERROR_DS_NO_CHAINED_EVAL:
            return "ERROR_DS_NO_CHAINED_EVAL";
        case ERROR_DS_NO_PARENT_OBJECT:
            return "ERROR_DS_NO_PARENT_OBJECT";
        case ERROR_DS_PARENT_IS_AN_ALIAS:
            return "ERROR_DS_PARENT_IS_AN_ALIAS";
        case ERROR_DS_CANT_MIX_MASTER_AND_REPS:
            return "ERROR_DS_CANT_MIX_MASTER_AND_REPS";
        case ERROR_DS_CHILDREN_EXIST:
            return "ERROR_DS_CHILDREN_EXIST";
        case ERROR_DS_OBJ_NOT_FOUND:
            return "ERROR_DS_OBJ_NOT_FOUND";
        case ERROR_DS_ALIASED_OBJ_MISSING:
            return "ERROR_DS_ALIASED_OBJ_MISSING";
        case ERROR_DS_BAD_NAME_SYNTAX:
            return "ERROR_DS_BAD_NAME_SYNTAX";
        case ERROR_DS_ALIAS_POINTS_TO_ALIAS:
            return "ERROR_DS_ALIAS_POINTS_TO_ALIAS";
        case ERROR_DS_CANT_DEREF_ALIAS:
            return "ERROR_DS_CANT_DEREF_ALIAS";
        case ERROR_DS_OUT_OF_SCOPE:
            return "ERROR_DS_OUT_OF_SCOPE";
        case ERROR_DS_OBJECT_BEING_REMOVED:
            return "ERROR_DS_OBJECT_BEING_REMOVED";
        case ERROR_DS_CANT_DELETE_DSA_OBJ:
            return "ERROR_DS_CANT_DELETE_DSA_OBJ";
        case ERROR_DS_GENERIC_ERROR:
            return "ERROR_DS_GENERIC_ERROR";
        case ERROR_DS_DSA_MUST_BE_INT_MASTER:
            return "ERROR_DS_DSA_MUST_BE_INT_MASTER";
        case ERROR_DS_CLASS_NOT_DSA:
            return "ERROR_DS_CLASS_NOT_DSA";
        case ERROR_DS_INSUFF_ACCESS_RIGHTS:
            return "ERROR_DS_INSUFF_ACCESS_RIGHTS";
        case ERROR_DS_ILLEGAL_SUPERIOR:
            return "ERROR_DS_ILLEGAL_SUPERIOR";
        case ERROR_DS_ATTRIBUTE_OWNED_BY_SAM:
            return "ERROR_DS_ATTRIBUTE_OWNED_BY_SAM";
        case ERROR_DS_NAME_TOO_MANY_PARTS:
            return "ERROR_DS_NAME_TOO_MANY_PARTS";
        case ERROR_DS_NAME_TOO_LONG:
            return "ERROR_DS_NAME_TOO_LONG";
        case ERROR_DS_NAME_VALUE_TOO_LONG:
            return "ERROR_DS_NAME_VALUE_TOO_LONG";
        case ERROR_DS_NAME_UNPARSEABLE:
            return "ERROR_DS_NAME_UNPARSEABLE";
        case ERROR_DS_NAME_TYPE_UNKNOWN:
            return "ERROR_DS_NAME_TYPE_UNKNOWN";
        case ERROR_DS_NOT_AN_OBJECT:
            return "ERROR_DS_NOT_AN_OBJECT";
        case ERROR_DS_SEC_DESC_TOO_SHORT:
            return "ERROR_DS_SEC_DESC_TOO_SHORT";
        case ERROR_DS_SEC_DESC_INVALID:
            return "ERROR_DS_SEC_DESC_INVALID";
        case ERROR_DS_NO_DELETED_NAME:
            return "ERROR_DS_NO_DELETED_NAME";
        case ERROR_DS_SUBREF_MUST_HAVE_PARENT:
            return "ERROR_DS_SUBREF_MUST_HAVE_PARENT";
        case ERROR_DS_NCNAME_MUST_BE_NC:
            return "ERROR_DS_NCNAME_MUST_BE_NC";
        case ERROR_DS_CANT_ADD_SYSTEM_ONLY:
            return "ERROR_DS_CANT_ADD_SYSTEM_ONLY";
        case ERROR_DS_CLASS_MUST_BE_CONCRETE:
            return "ERROR_DS_CLASS_MUST_BE_CONCRETE";
        case ERROR_DS_INVALID_DMD:
            return "ERROR_DS_INVALID_DMD";
        case ERROR_DS_OBJ_GUID_EXISTS:
            return "ERROR_DS_OBJ_GUID_EXISTS";
        case ERROR_DS_NOT_ON_BACKLINK:
            return "ERROR_DS_NOT_ON_BACKLINK";
        case ERROR_DS_NO_CROSSREF_FOR_NC:
            return "ERROR_DS_NO_CROSSREF_FOR_NC";
        case ERROR_DS_SHUTTING_DOWN:
            return "ERROR_DS_SHUTTING_DOWN";
        case ERROR_DS_UNKNOWN_OPERATION:
            return "ERROR_DS_UNKNOWN_OPERATION";
        case ERROR_DS_INVALID_ROLE_OWNER:
            return "ERROR_DS_INVALID_ROLE_OWNER";
        case ERROR_DS_COULDNT_CONTACT_FSMO:
            return "ERROR_DS_COULDNT_CONTACT_FSMO";
        case ERROR_DS_CROSS_NC_DN_RENAME:
            return "ERROR_DS_CROSS_NC_DN_RENAME";
        case ERROR_DS_CANT_MOD_SYSTEM_ONLY:
            return "ERROR_DS_CANT_MOD_SYSTEM_ONLY";
        case ERROR_DS_REPLICATOR_ONLY:
            return "ERROR_DS_REPLICATOR_ONLY";
        case ERROR_DS_OBJ_CLASS_NOT_DEFINED:
            return "ERROR_DS_OBJ_CLASS_NOT_DEFINED";
        case ERROR_DS_OBJ_CLASS_NOT_SUBCLASS:
            return "ERROR_DS_OBJ_CLASS_NOT_SUBCLASS";
        case ERROR_DS_NAME_REFERENCE_INVALID:
            return "ERROR_DS_NAME_REFERENCE_INVALID";
        case ERROR_DS_CROSS_REF_EXISTS:
            return "ERROR_DS_CROSS_REF_EXISTS";
        case ERROR_DS_CANT_DEL_MASTER_CROSSREF:
            return "ERROR_DS_CANT_DEL_MASTER_CROSSREF";
        case ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD:
            return "ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD";
        case ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX:
            return "ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX";
        case ERROR_DS_DUP_RDN:
            return "ERROR_DS_DUP_RDN";
        case ERROR_DS_DUP_OID:
            return "ERROR_DS_DUP_OID";
        case ERROR_DS_DUP_MAPI_ID:
            return "ERROR_DS_DUP_MAPI_ID";
        case ERROR_DS_DUP_SCHEMA_ID_GUID:
            return "ERROR_DS_DUP_SCHEMA_ID_GUID";
        case ERROR_DS_DUP_LDAP_DISPLAY_NAME:
            return "ERROR_DS_DUP_LDAP_DISPLAY_NAME";
        case ERROR_DS_SEMANTIC_ATT_TEST:
            return "ERROR_DS_SEMANTIC_ATT_TEST";
        case ERROR_DS_SYNTAX_MISMATCH:
            return "ERROR_DS_SYNTAX_MISMATCH";
        case ERROR_DS_EXISTS_IN_MUST_HAVE:
            return "ERROR_DS_EXISTS_IN_MUST_HAVE";
        case ERROR_DS_EXISTS_IN_MAY_HAVE:
            return "ERROR_DS_EXISTS_IN_MAY_HAVE";
        case ERROR_DS_NONEXISTENT_MAY_HAVE:
            return "ERROR_DS_NONEXISTENT_MAY_HAVE";
        case ERROR_DS_NONEXISTENT_MUST_HAVE:
            return "ERROR_DS_NONEXISTENT_MUST_HAVE";
        case ERROR_DS_AUX_CLS_TEST_FAIL:
            return "ERROR_DS_AUX_CLS_TEST_FAIL";
        case ERROR_DS_NONEXISTENT_POSS_SUP:
            return "ERROR_DS_NONEXISTENT_POSS_SUP";
        case ERROR_DS_SUB_CLS_TEST_FAIL:
            return "ERROR_DS_SUB_CLS_TEST_FAIL";
        case ERROR_DS_BAD_RDN_ATT_ID_SYNTAX:
            return "ERROR_DS_BAD_RDN_ATT_ID_SYNTAX";
        case ERROR_DS_EXISTS_IN_AUX_CLS:
            return "ERROR_DS_EXISTS_IN_AUX_CLS";
        case ERROR_DS_EXISTS_IN_SUB_CLS:
            return "ERROR_DS_EXISTS_IN_SUB_CLS";
        case ERROR_DS_EXISTS_IN_POSS_SUP:
            return "ERROR_DS_EXISTS_IN_POSS_SUP";
        case ERROR_DS_RECALCSCHEMA_FAILED:
            return "ERROR_DS_RECALCSCHEMA_FAILED";
        case ERROR_DS_TREE_DELETE_NOT_FINISHED:
            return "ERROR_DS_TREE_DELETE_NOT_FINISHED";
        case ERROR_DS_CANT_DELETE:
            return "ERROR_DS_CANT_DELETE";
        case ERROR_DS_ATT_SCHEMA_REQ_ID:
            return "ERROR_DS_ATT_SCHEMA_REQ_ID";
        case ERROR_DS_BAD_ATT_SCHEMA_SYNTAX:
            return "ERROR_DS_BAD_ATT_SCHEMA_SYNTAX";
        case ERROR_DS_CANT_CACHE_ATT:
            return "ERROR_DS_CANT_CACHE_ATT";
        case ERROR_DS_CANT_CACHE_CLASS:
            return "ERROR_DS_CANT_CACHE_CLASS";
        case ERROR_DS_CANT_REMOVE_ATT_CACHE:
            return "ERROR_DS_CANT_REMOVE_ATT_CACHE";
        case ERROR_DS_CANT_REMOVE_CLASS_CACHE:
            return "ERROR_DS_CANT_REMOVE_CLASS_CACHE";
        case ERROR_DS_CANT_RETRIEVE_DN:
            return "ERROR_DS_CANT_RETRIEVE_DN";
        case ERROR_DS_MISSING_SUPREF:
            return "ERROR_DS_MISSING_SUPREF";
        case ERROR_DS_CANT_RETRIEVE_INSTANCE:
            return "ERROR_DS_CANT_RETRIEVE_INSTANCE";
        case ERROR_DS_CODE_INCONSISTENCY:
            return "ERROR_DS_CODE_INCONSISTENCY";
        case ERROR_DS_DATABASE_ERROR:
            return "ERROR_DS_DATABASE_ERROR";
        case ERROR_DS_GOVERNSID_MISSING:
            return "ERROR_DS_GOVERNSID_MISSING";
        case ERROR_DS_MISSING_EXPECTED_ATT:
            return "ERROR_DS_MISSING_EXPECTED_ATT";
        case ERROR_DS_NCNAME_MISSING_CR_REF:
            return "ERROR_DS_NCNAME_MISSING_CR_REF";
        case ERROR_DS_SECURITY_CHECKING_ERROR:
            return "ERROR_DS_SECURITY_CHECKING_ERROR";
        case ERROR_DS_SCHEMA_NOT_LOADED:
            return "ERROR_DS_SCHEMA_NOT_LOADED";
        case ERROR_DS_SCHEMA_ALLOC_FAILED:
            return "ERROR_DS_SCHEMA_ALLOC_FAILED";
        case ERROR_DS_ATT_SCHEMA_REQ_SYNTAX:
            return "ERROR_DS_ATT_SCHEMA_REQ_SYNTAX";
        case ERROR_DS_GCVERIFY_ERROR:
            return "ERROR_DS_GCVERIFY_ERROR";
        case ERROR_DS_DRA_SCHEMA_MISMATCH:
            return "ERROR_DS_DRA_SCHEMA_MISMATCH";
        case ERROR_DS_CANT_FIND_DSA_OBJ:
            return "ERROR_DS_CANT_FIND_DSA_OBJ";
        case ERROR_DS_CANT_FIND_EXPECTED_NC:
            return "ERROR_DS_CANT_FIND_EXPECTED_NC";
        case ERROR_DS_CANT_FIND_NC_IN_CACHE:
            return "ERROR_DS_CANT_FIND_NC_IN_CACHE";
        case ERROR_DS_CANT_RETRIEVE_CHILD:
            return "ERROR_DS_CANT_RETRIEVE_CHILD";
        case ERROR_DS_SECURITY_ILLEGAL_MODIFY:
            return "ERROR_DS_SECURITY_ILLEGAL_MODIFY";
        case ERROR_DS_CANT_REPLACE_HIDDEN_REC:
            return "ERROR_DS_CANT_REPLACE_HIDDEN_REC";
        case ERROR_DS_BAD_HIERARCHY_FILE:
            return "ERROR_DS_BAD_HIERARCHY_FILE";
        case ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED:
            return "ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED";
        case ERROR_DS_CONFIG_PARAM_MISSING:
            return "ERROR_DS_CONFIG_PARAM_MISSING";
        case ERROR_DS_COUNTING_AB_INDICES_FAILED:
            return "ERROR_DS_COUNTING_AB_INDICES_FAILED";
        case ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED:
            return "ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED";
        case ERROR_DS_INTERNAL_FAILURE:
            return "ERROR_DS_INTERNAL_FAILURE";
        case ERROR_DS_UNKNOWN_ERROR:
            return "ERROR_DS_UNKNOWN_ERROR";
        case ERROR_DS_ROOT_REQUIRES_CLASS_TOP:
            return "ERROR_DS_ROOT_REQUIRES_CLASS_TOP";
        case ERROR_DS_REFUSING_FSMO_ROLES:
            return "ERROR_DS_REFUSING_FSMO_ROLES";
        case ERROR_DS_MISSING_FSMO_SETTINGS:
            return "ERROR_DS_MISSING_FSMO_SETTINGS";
        case ERROR_DS_UNABLE_TO_SURRENDER_ROLES:
            return "ERROR_DS_UNABLE_TO_SURRENDER_ROLES";
        case ERROR_DS_DRA_GENERIC:
            return "ERROR_DS_DRA_GENERIC";
        case ERROR_DS_DRA_INVALID_PARAMETER:
            return "ERROR_DS_DRA_INVALID_PARAMETER";
        case ERROR_DS_DRA_BUSY:
            return "ERROR_DS_DRA_BUSY";
        case ERROR_DS_DRA_BAD_DN:
            return "ERROR_DS_DRA_BAD_DN";
        case ERROR_DS_DRA_BAD_NC:
            return "ERROR_DS_DRA_BAD_NC";
        case ERROR_DS_DRA_DN_EXISTS:
            return "ERROR_DS_DRA_DN_EXISTS";
        case ERROR_DS_DRA_INTERNAL_ERROR:
            return "ERROR_DS_DRA_INTERNAL_ERROR";
        case ERROR_DS_DRA_INCONSISTENT_DIT:
            return "ERROR_DS_DRA_INCONSISTENT_DIT";
        case ERROR_DS_DRA_CONNECTION_FAILED:
            return "ERROR_DS_DRA_CONNECTION_FAILED";
        case ERROR_DS_DRA_BAD_INSTANCE_TYPE:
            return "ERROR_DS_DRA_BAD_INSTANCE_TYPE";
        case ERROR_DS_DRA_OUT_OF_MEM:
            return "ERROR_DS_DRA_OUT_OF_MEM";
        case ERROR_DS_DRA_MAIL_PROBLEM:
            return "ERROR_DS_DRA_MAIL_PROBLEM";
        case ERROR_DS_DRA_REF_ALREADY_EXISTS:
            return "ERROR_DS_DRA_REF_ALREADY_EXISTS";
        case ERROR_DS_DRA_REF_NOT_FOUND:
            return "ERROR_DS_DRA_REF_NOT_FOUND";
        case ERROR_DS_DRA_OBJ_IS_REP_SOURCE:
            return "ERROR_DS_DRA_OBJ_IS_REP_SOURCE";
        case ERROR_DS_DRA_DB_ERROR:
            return "ERROR_DS_DRA_DB_ERROR";
        case ERROR_DS_DRA_NO_REPLICA:
            return "ERROR_DS_DRA_NO_REPLICA";
        case ERROR_DS_DRA_ACCESS_DENIED:
            return "ERROR_DS_DRA_ACCESS_DENIED";
        case ERROR_DS_DRA_NOT_SUPPORTED:
            return "ERROR_DS_DRA_NOT_SUPPORTED";
        case ERROR_DS_DRA_RPC_CANCELLED:
            return "ERROR_DS_DRA_RPC_CANCELLED";
        case ERROR_DS_DRA_SOURCE_DISABLED:
            return "ERROR_DS_DRA_SOURCE_DISABLED";
        case ERROR_DS_DRA_SINK_DISABLED:
            return "ERROR_DS_DRA_SINK_DISABLED";
        case ERROR_DS_DRA_NAME_COLLISION:
            return "ERROR_DS_DRA_NAME_COLLISION";
        case ERROR_DS_DRA_SOURCE_REINSTALLED:
            return "ERROR_DS_DRA_SOURCE_REINSTALLED";
        case ERROR_DS_DRA_MISSING_PARENT:
            return "ERROR_DS_DRA_MISSING_PARENT";
        case ERROR_DS_DRA_PREEMPTED:
            return "ERROR_DS_DRA_PREEMPTED";
        case ERROR_DS_DRA_ABANDON_SYNC:
            return "ERROR_DS_DRA_ABANDON_SYNC";
        case ERROR_DS_DRA_SHUTDOWN:
            return "ERROR_DS_DRA_SHUTDOWN";
        case ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET:
            return "ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET";
        case ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA:
            return "ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA";
        case ERROR_DS_DRA_EXTN_CONNECTION_FAILED:
            return "ERROR_DS_DRA_EXTN_CONNECTION_FAILED";
        case ERROR_DS_INSTALL_SCHEMA_MISMATCH:
            return "ERROR_DS_INSTALL_SCHEMA_MISMATCH";
        case ERROR_DS_DUP_LINK_ID:
            return "ERROR_DS_DUP_LINK_ID";
        case ERROR_DS_NAME_ERROR_RESOLVING:
            return "ERROR_DS_NAME_ERROR_RESOLVING";
        case ERROR_DS_NAME_ERROR_NOT_FOUND:
            return "ERROR_DS_NAME_ERROR_NOT_FOUND";
        case ERROR_DS_NAME_ERROR_NOT_UNIQUE:
            return "ERROR_DS_NAME_ERROR_NOT_UNIQUE";
        case ERROR_DS_NAME_ERROR_NO_MAPPING:
            return "ERROR_DS_NAME_ERROR_NO_MAPPING";
        case ERROR_DS_NAME_ERROR_DOMAIN_ONLY:
            return "ERROR_DS_NAME_ERROR_DOMAIN_ONLY";
        case ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING:
            return "ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING";
        case ERROR_DS_CONSTRUCTED_ATT_MOD:
            return "ERROR_DS_CONSTRUCTED_ATT_MOD";
        case ERROR_DS_WRONG_OM_OBJ_CLASS:
            return "ERROR_DS_WRONG_OM_OBJ_CLASS";
        case ERROR_DS_DRA_REPL_PENDING:
            return "ERROR_DS_DRA_REPL_PENDING";
        case ERROR_DS_DS_REQUIRED:
            return "ERROR_DS_DS_REQUIRED";
        case ERROR_DS_INVALID_LDAP_DISPLAY_NAME:
            return "ERROR_DS_INVALID_LDAP_DISPLAY_NAME";
        case ERROR_DS_NON_BASE_SEARCH:
            return "ERROR_DS_NON_BASE_SEARCH";
        case ERROR_DS_CANT_RETRIEVE_ATTS:
            return "ERROR_DS_CANT_RETRIEVE_ATTS";
        case ERROR_DS_BACKLINK_WITHOUT_LINK:
            return "ERROR_DS_BACKLINK_WITHOUT_LINK";
        case ERROR_DS_EPOCH_MISMATCH:
            return "ERROR_DS_EPOCH_MISMATCH";
        case ERROR_DS_SRC_NAME_MISMATCH:
            return "ERROR_DS_SRC_NAME_MISMATCH";
        case ERROR_DS_SRC_AND_DST_NC_IDENTICAL:
            return "ERROR_DS_SRC_AND_DST_NC_IDENTICAL";
        case ERROR_DS_DST_NC_MISMATCH:
            return "ERROR_DS_DST_NC_MISMATCH";
        case ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC:
            return "ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC";
        case ERROR_DS_SRC_GUID_MISMATCH:
            return "ERROR_DS_SRC_GUID_MISMATCH";
        case ERROR_DS_CANT_MOVE_DELETED_OBJECT:
            return "ERROR_DS_CANT_MOVE_DELETED_OBJECT";
        case ERROR_DS_PDC_OPERATION_IN_PROGRESS:
            return "ERROR_DS_PDC_OPERATION_IN_PROGRESS";
        case ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD:
            return "ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD";
        case ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION:
            return "ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION";
        case ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS:
            return "ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS";
        case ERROR_DS_NC_MUST_HAVE_NC_PARENT:
            return "ERROR_DS_NC_MUST_HAVE_NC_PARENT";
        case ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE:
            return "ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE";
        case ERROR_DS_DST_DOMAIN_NOT_NATIVE:
            return "ERROR_DS_DST_DOMAIN_NOT_NATIVE";
        case ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER:
            return "ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER";
        case ERROR_DS_CANT_MOVE_ACCOUNT_GROUP:
            return "ERROR_DS_CANT_MOVE_ACCOUNT_GROUP";
        case ERROR_DS_CANT_MOVE_RESOURCE_GROUP:
            return "ERROR_DS_CANT_MOVE_RESOURCE_GROUP";
        case ERROR_DS_INVALID_SEARCH_FLAG:
            return "ERROR_DS_INVALID_SEARCH_FLAG";
        case ERROR_DS_NO_TREE_DELETE_ABOVE_NC:
            return "ERROR_DS_NO_TREE_DELETE_ABOVE_NC";
        case ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE:
            return "ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE";
        case ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE:
            return "ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE";
        case ERROR_DS_SAM_INIT_FAILURE:
            return "ERROR_DS_SAM_INIT_FAILURE";
        case ERROR_DS_SENSITIVE_GROUP_VIOLATION:
            return "ERROR_DS_SENSITIVE_GROUP_VIOLATION";
        case ERROR_DS_CANT_MOD_PRIMARYGROUPID:
            return "ERROR_DS_CANT_MOD_PRIMARYGROUPID";
        case ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD:
            return "ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD";
        case ERROR_DS_NONSAFE_SCHEMA_CHANGE:
            return "ERROR_DS_NONSAFE_SCHEMA_CHANGE";
        case ERROR_DS_SCHEMA_UPDATE_DISALLOWED:
            return "ERROR_DS_SCHEMA_UPDATE_DISALLOWED";
        case ERROR_DS_CANT_CREATE_UNDER_SCHEMA:
            return "ERROR_DS_CANT_CREATE_UNDER_SCHEMA";
        case ERROR_DS_INSTALL_NO_SRC_SCH_VERSION:
            return "ERROR_DS_INSTALL_NO_SRC_SCH_VERSION";
        case ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE:
            return "ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE";
        case ERROR_DS_INVALID_GROUP_TYPE:
            return "ERROR_DS_INVALID_GROUP_TYPE";
        case ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN:
            return "ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN";
        case ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN:
            return "ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN";
        case ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER:
            return "ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER";
        case ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER:
            return "ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER";
        case ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER:
            return "ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER";
        case ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER:
            return "ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER";
        case ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER:
            return "ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER";
        case ERROR_DS_HAVE_PRIMARY_MEMBERS:
            return "ERROR_DS_HAVE_PRIMARY_MEMBERS";
        case ERROR_DS_STRING_SD_CONVERSION_FAILED:
            return "ERROR_DS_STRING_SD_CONVERSION_FAILED";
        case ERROR_DS_NAMING_MASTER_GC:
            return "ERROR_DS_NAMING_MASTER_GC";
        case ERROR_DS_DNS_LOOKUP_FAILURE:
            return "ERROR_DS_DNS_LOOKUP_FAILURE";
        case ERROR_DS_COULDNT_UPDATE_SPNS:
            return "ERROR_DS_COULDNT_UPDATE_SPNS";
        case ERROR_DS_CANT_RETRIEVE_SD:
            return "ERROR_DS_CANT_RETRIEVE_SD";
        case ERROR_DS_KEY_NOT_UNIQUE:
            return "ERROR_DS_KEY_NOT_UNIQUE";
        case ERROR_DS_WRONG_LINKED_ATT_SYNTAX:
            return "ERROR_DS_WRONG_LINKED_ATT_SYNTAX";
        case ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD:
            return "ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD";
        case ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY:
            return "ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY";
        case ERROR_DS_CANT_START:
            return "ERROR_DS_CANT_START";
        case ERROR_DS_INIT_FAILURE:
            return "ERROR_DS_INIT_FAILURE";
        case ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION:
            return "ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION";
        case ERROR_DS_SOURCE_DOMAIN_IN_FOREST:
            return "ERROR_DS_SOURCE_DOMAIN_IN_FOREST";
        case ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST:
            return "ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST";
        case ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED:
            return "ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED";
        case ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN:
            return "ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN";
        case ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER:
            return "ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER";
        case ERROR_DS_SRC_SID_EXISTS_IN_FOREST:
            return "ERROR_DS_SRC_SID_EXISTS_IN_FOREST";
        case ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH:
            return "ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH";
        case ERROR_SAM_INIT_FAILURE:
            return "ERROR_SAM_INIT_FAILURE";
        case ERROR_DS_DRA_SCHEMA_INFO_SHIP:
            return "ERROR_DS_DRA_SCHEMA_INFO_SHIP";
        case ERROR_DS_DRA_SCHEMA_CONFLICT:
            return "ERROR_DS_DRA_SCHEMA_CONFLICT";
        case ERROR_DS_DRA_EARLIER_SCHEMA_CONFLICT:
            return "ERROR_DS_DRA_EARLIER_SCHEMA_CONFLICT";
        case ERROR_DS_DRA_OBJ_NC_MISMATCH:
            return "ERROR_DS_DRA_OBJ_NC_MISMATCH";
        case ERROR_DS_NC_STILL_HAS_DSAS:
            return "ERROR_DS_NC_STILL_HAS_DSAS";
        case ERROR_DS_GC_REQUIRED:
            return "ERROR_DS_GC_REQUIRED";
        case ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY:
            return "ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY";
        case ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS:
            return "ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS";
        case ERROR_DS_CANT_ADD_TO_GC:
            return "ERROR_DS_CANT_ADD_TO_GC";
        case ERROR_DS_NO_CHECKPOINT_WITH_PDC:
            return "ERROR_DS_NO_CHECKPOINT_WITH_PDC";
        case ERROR_DS_SOURCE_AUDITING_NOT_ENABLED:
            return "ERROR_DS_SOURCE_AUDITING_NOT_ENABLED";
        case ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC:
            return "ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC";
        case ERROR_DS_INVALID_NAME_FOR_SPN:
            return "ERROR_DS_INVALID_NAME_FOR_SPN";
        case ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS:
            return "ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS";
        case ERROR_DS_UNICODEPWD_NOT_IN_QUOTES:
            return "ERROR_DS_UNICODEPWD_NOT_IN_QUOTES";
        case ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED:
            return "ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED";
        case ERROR_DS_MUST_BE_RUN_ON_DST_DC:
            return "ERROR_DS_MUST_BE_RUN_ON_DST_DC";
        case ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER:
            return "ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER";
        case ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ:
            return "ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ";
        case ERROR_DS_INIT_FAILURE_CONSOLE:
            return "ERROR_DS_INIT_FAILURE_CONSOLE";
        case ERROR_DS_SAM_INIT_FAILURE_CONSOLE:
            return "ERROR_DS_SAM_INIT_FAILURE_CONSOLE";
        case ERROR_DS_FOREST_VERSION_TOO_HIGH:
            return "ERROR_DS_FOREST_VERSION_TOO_HIGH";
        case ERROR_DS_DOMAIN_VERSION_TOO_HIGH:
            return "ERROR_DS_DOMAIN_VERSION_TOO_HIGH";
        case ERROR_DS_FOREST_VERSION_TOO_LOW:
            return "ERROR_DS_FOREST_VERSION_TOO_LOW";
        case ERROR_DS_DOMAIN_VERSION_TOO_LOW:
            return "ERROR_DS_DOMAIN_VERSION_TOO_LOW";
        case ERROR_DS_INCOMPATIBLE_VERSION:
            return "ERROR_DS_INCOMPATIBLE_VERSION";
        case ERROR_DS_LOW_DSA_VERSION:
            return "ERROR_DS_LOW_DSA_VERSION";
        case ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN:
            return "ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN";
        case ERROR_DS_NOT_SUPPORTED_SORT_ORDER:
            return "ERROR_DS_NOT_SUPPORTED_SORT_ORDER";
        case ERROR_DS_NAME_NOT_UNIQUE:
            return "ERROR_DS_NAME_NOT_UNIQUE";
        case ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4:
            return "ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4";
        case ERROR_DS_OUT_OF_VERSION_STORE:
            return "ERROR_DS_OUT_OF_VERSION_STORE";
        case ERROR_DS_INCOMPATIBLE_CONTROLS_USED:
            return "ERROR_DS_INCOMPATIBLE_CONTROLS_USED";
        case ERROR_DS_NO_REF_DOMAIN:
            return "ERROR_DS_NO_REF_DOMAIN";
        case ERROR_DS_RESERVED_LINK_ID:
            return "ERROR_DS_RESERVED_LINK_ID";
        case ERROR_DS_LINK_ID_NOT_AVAILABLE:
            return "ERROR_DS_LINK_ID_NOT_AVAILABLE";
        case ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER:
            return "ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER";
        case ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE:
            return "ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE";
        case ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC:
            return "ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC";
        case ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG:
            return "ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG";
        case ERROR_DS_MODIFYDN_WRONG_GRANDPARENT:
            return "ERROR_DS_MODIFYDN_WRONG_GRANDPARENT";
        case ERROR_DS_NAME_ERROR_TRUST_REFERRAL:
            return "ERROR_DS_NAME_ERROR_TRUST_REFERRAL";
        case ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER:
            return "ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER";
        case ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD:
            return "ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD";
        case ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2:
            return "ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2";
        case ERROR_DS_THREAD_LIMIT_EXCEEDED:
            return "ERROR_DS_THREAD_LIMIT_EXCEEDED";
        case ERROR_DS_NOT_CLOSEST:
            return "ERROR_DS_NOT_CLOSEST";
        case ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF:
            return "ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF";
        case ERROR_DS_SINGLE_USER_MODE_FAILED:
            return "ERROR_DS_SINGLE_USER_MODE_FAILED";
        case ERROR_DS_NTDSCRIPT_SYNTAX_ERROR:
            return "ERROR_DS_NTDSCRIPT_SYNTAX_ERROR";
        case ERROR_DS_NTDSCRIPT_PROCESS_ERROR:
            return "ERROR_DS_NTDSCRIPT_PROCESS_ERROR";
        case ERROR_DS_DIFFERENT_REPL_EPOCHS:
            return "ERROR_DS_DIFFERENT_REPL_EPOCHS";
        case ERROR_DS_DRS_EXTENSIONS_CHANGED:
            return "ERROR_DS_DRS_EXTENSIONS_CHANGED";
        case ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR:
            return "ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR";
        case ERROR_DS_NO_MSDS_INTID:
            return "ERROR_DS_NO_MSDS_INTID";
        case ERROR_DS_DUP_MSDS_INTID:
            return "ERROR_DS_DUP_MSDS_INTID";
        case ERROR_DS_EXISTS_IN_RDNATTID:
            return "ERROR_DS_EXISTS_IN_RDNATTID";
        case ERROR_DS_AUTHORIZATION_FAILED:
            return "ERROR_DS_AUTHORIZATION_FAILED";
        case ERROR_DS_INVALID_SCRIPT:
            return "ERROR_DS_INVALID_SCRIPT";
        case ERROR_DS_REMOTE_CROSSREF_OP_FAILED:
            return "ERROR_DS_REMOTE_CROSSREF_OP_FAILED";
        case ERROR_DS_CROSS_REF_BUSY:
            return "ERROR_DS_CROSS_REF_BUSY";
        case ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN:
            return "ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN";
        case ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC:
            return "ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC";
        case ERROR_DS_DUPLICATE_ID_FOUND:
            return "ERROR_DS_DUPLICATE_ID_FOUND";
        case ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT:
            return "ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT";
        case ERROR_DS_GROUP_CONVERSION_ERROR:
            return "ERROR_DS_GROUP_CONVERSION_ERROR";
        case ERROR_DS_CANT_MOVE_APP_BASIC_GROUP:
            return "ERROR_DS_CANT_MOVE_APP_BASIC_GROUP";
        case ERROR_DS_CANT_MOVE_APP_QUERY_GROUP:
            return "ERROR_DS_CANT_MOVE_APP_QUERY_GROUP";
        case ERROR_DS_ROLE_NOT_VERIFIED:
            return "ERROR_DS_ROLE_NOT_VERIFIED";
        case ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL:
            return "ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL";
        case ERROR_DS_DOMAIN_RENAME_IN_PROGRESS:
            return "ERROR_DS_DOMAIN_RENAME_IN_PROGRESS";
        case ERROR_DS_EXISTING_AD_CHILD_NC:
            return "ERROR_DS_EXISTING_AD_CHILD_NC";
        case ERROR_DS_REPL_LIFETIME_EXCEEDED:
            return "ERROR_DS_REPL_LIFETIME_EXCEEDED";
        case ERROR_DS_DISALLOWED_IN_SYSTEM_CONTAINER:
            return "ERROR_DS_DISALLOWED_IN_SYSTEM_CONTAINER";
        case ERROR_DS_LDAP_SEND_QUEUE_FULL:
            return "ERROR_DS_LDAP_SEND_QUEUE_FULL";
        case ERROR_DS_DRA_OUT_SCHEDULE_WINDOW:
            return "ERROR_DS_DRA_OUT_SCHEDULE_WINDOW";
        case ERROR_SXS_SECTION_NOT_FOUND:
            return "ERROR_SXS_SECTION_NOT_FOUND";
        case ERROR_SXS_CANT_GEN_ACTCTX:
            return "ERROR_SXS_CANT_GEN_ACTCTX";
        case ERROR_SXS_INVALID_ACTCTXDATA_FORMAT:
            return "ERROR_SXS_INVALID_ACTCTXDATA_FORMAT";
        case ERROR_SXS_ASSEMBLY_NOT_FOUND:
            return "ERROR_SXS_ASSEMBLY_NOT_FOUND";
        case ERROR_SXS_MANIFEST_FORMAT_ERROR:
            return "ERROR_SXS_MANIFEST_FORMAT_ERROR";
        case ERROR_SXS_MANIFEST_PARSE_ERROR:
            return "ERROR_SXS_MANIFEST_PARSE_ERROR";
        case ERROR_SXS_ACTIVATION_CONTEXT_DISABLED:
            return "ERROR_SXS_ACTIVATION_CONTEXT_DISABLED";
        case ERROR_SXS_KEY_NOT_FOUND:
            return "ERROR_SXS_KEY_NOT_FOUND";
        case ERROR_SXS_VERSION_CONFLICT:
            return "ERROR_SXS_VERSION_CONFLICT";
        case ERROR_SXS_WRONG_SECTION_TYPE:
            return "ERROR_SXS_WRONG_SECTION_TYPE";
        case ERROR_SXS_THREAD_QUERIES_DISABLED:
            return "ERROR_SXS_THREAD_QUERIES_DISABLED";
        case ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET:
            return "ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET";
        case ERROR_SXS_UNKNOWN_ENCODING_GROUP:
            return "ERROR_SXS_UNKNOWN_ENCODING_GROUP";
        case ERROR_SXS_UNKNOWN_ENCODING:
            return "ERROR_SXS_UNKNOWN_ENCODING";
        case ERROR_SXS_INVALID_XML_NAMESPACE_URI:
            return "ERROR_SXS_INVALID_XML_NAMESPACE_URI";
        case ERROR_SXS_ROOT_MANIFEST_DEPENDENCY_NOT_INSTALLED:
            return "ERROR_SXS_ROOT_MANIFEST_DEPENDENCY_NOT_INSTALLED";
        case ERROR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED:
            return "ERROR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED";
        case ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE:
            return "ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE";
        case ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE:
            return "ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE";
        case ERROR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE:
            return "ERROR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE";
        case ERROR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT:
            return "ERROR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT";
        case ERROR_SXS_DUPLICATE_DLL_NAME:
            return "ERROR_SXS_DUPLICATE_DLL_NAME";
        case ERROR_SXS_DUPLICATE_WINDOWCLASS_NAME:
            return "ERROR_SXS_DUPLICATE_WINDOWCLASS_NAME";
        case ERROR_SXS_DUPLICATE_CLSID:
            return "ERROR_SXS_DUPLICATE_CLSID";
        case ERROR_SXS_DUPLICATE_IID:
            return "ERROR_SXS_DUPLICATE_IID";
        case ERROR_SXS_DUPLICATE_TLBID:
            return "ERROR_SXS_DUPLICATE_TLBID";
        case ERROR_SXS_DUPLICATE_PROGID:
            return "ERROR_SXS_DUPLICATE_PROGID";
        case ERROR_SXS_DUPLICATE_ASSEMBLY_NAME:
            return "ERROR_SXS_DUPLICATE_ASSEMBLY_NAME";
        case ERROR_SXS_FILE_HASH_MISMATCH:
            return "ERROR_SXS_FILE_HASH_MISMATCH";
        case ERROR_SXS_POLICY_PARSE_ERROR:
            return "ERROR_SXS_POLICY_PARSE_ERROR";
        case ERROR_SXS_XML_E_MISSINGQUOTE:
            return "ERROR_SXS_XML_E_MISSINGQUOTE";
        case ERROR_SXS_XML_E_COMMENTSYNTAX:
            return "ERROR_SXS_XML_E_COMMENTSYNTAX";
        case ERROR_SXS_XML_E_BADSTARTNAMECHAR:
            return "ERROR_SXS_XML_E_BADSTARTNAMECHAR";
        case ERROR_SXS_XML_E_BADNAMECHAR:
            return "ERROR_SXS_XML_E_BADNAMECHAR";
        case ERROR_SXS_XML_E_BADCHARINSTRING:
            return "ERROR_SXS_XML_E_BADCHARINSTRING";
        case ERROR_SXS_XML_E_XMLDECLSYNTAX:
            return "ERROR_SXS_XML_E_XMLDECLSYNTAX";
        case ERROR_SXS_XML_E_BADCHARDATA:
            return "ERROR_SXS_XML_E_BADCHARDATA";
        case ERROR_SXS_XML_E_MISSINGWHITESPACE:
            return "ERROR_SXS_XML_E_MISSINGWHITESPACE";
        case ERROR_SXS_XML_E_EXPECTINGTAGEND:
            return "ERROR_SXS_XML_E_EXPECTINGTAGEND";
        case ERROR_SXS_XML_E_MISSINGSEMICOLON:
            return "ERROR_SXS_XML_E_MISSINGSEMICOLON";
        case ERROR_SXS_XML_E_UNBALANCEDPAREN:
            return "ERROR_SXS_XML_E_UNBALANCEDPAREN";
        case ERROR_SXS_XML_E_INTERNALERROR:
            return "ERROR_SXS_XML_E_INTERNALERROR";
        case ERROR_SXS_XML_E_UNEXPECTED_WHITESPACE:
            return "ERROR_SXS_XML_E_UNEXPECTED_WHITESPACE";
        case ERROR_SXS_XML_E_INCOMPLETE_ENCODING:
            return "ERROR_SXS_XML_E_INCOMPLETE_ENCODING";
        case ERROR_SXS_XML_E_MISSING_PAREN:
            return "ERROR_SXS_XML_E_MISSING_PAREN";
        case ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE:
            return "ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE";
        case ERROR_SXS_XML_E_MULTIPLE_COLONS:
            return "ERROR_SXS_XML_E_MULTIPLE_COLONS";
        case ERROR_SXS_XML_E_INVALID_DECIMAL:
            return "ERROR_SXS_XML_E_INVALID_DECIMAL";
        case ERROR_SXS_XML_E_INVALID_HEXIDECIMAL:
            return "ERROR_SXS_XML_E_INVALID_HEXIDECIMAL";
        case ERROR_SXS_XML_E_INVALID_UNICODE:
            return "ERROR_SXS_XML_E_INVALID_UNICODE";
        case ERROR_SXS_XML_E_WHITESPACEORQUESTIONMARK:
            return "ERROR_SXS_XML_E_WHITESPACEORQUESTIONMARK";
        case ERROR_SXS_XML_E_UNEXPECTEDENDTAG:
            return "ERROR_SXS_XML_E_UNEXPECTEDENDTAG";
        case ERROR_SXS_XML_E_UNCLOSEDTAG:
            return "ERROR_SXS_XML_E_UNCLOSEDTAG";
        case ERROR_SXS_XML_E_DUPLICATEATTRIBUTE:
            return "ERROR_SXS_XML_E_DUPLICATEATTRIBUTE";
        case ERROR_SXS_XML_E_MULTIPLEROOTS:
            return "ERROR_SXS_XML_E_MULTIPLEROOTS";
        case ERROR_SXS_XML_E_INVALIDATROOTLEVEL:
            return "ERROR_SXS_XML_E_INVALIDATROOTLEVEL";
        case ERROR_SXS_XML_E_BADXMLDECL:
            return "ERROR_SXS_XML_E_BADXMLDECL";
        case ERROR_SXS_XML_E_MISSINGROOT:
            return "ERROR_SXS_XML_E_MISSINGROOT";
        case ERROR_SXS_XML_E_UNEXPECTEDEOF:
            return "ERROR_SXS_XML_E_UNEXPECTEDEOF";
        case ERROR_SXS_XML_E_BADPEREFINSUBSET:
            return "ERROR_SXS_XML_E_BADPEREFINSUBSET";
        case ERROR_SXS_XML_E_UNCLOSEDSTARTTAG:
            return "ERROR_SXS_XML_E_UNCLOSEDSTARTTAG";
        case ERROR_SXS_XML_E_UNCLOSEDENDTAG:
            return "ERROR_SXS_XML_E_UNCLOSEDENDTAG";
        case ERROR_SXS_XML_E_UNCLOSEDSTRING:
            return "ERROR_SXS_XML_E_UNCLOSEDSTRING";
        case ERROR_SXS_XML_E_UNCLOSEDCOMMENT:
            return "ERROR_SXS_XML_E_UNCLOSEDCOMMENT";
        case ERROR_SXS_XML_E_UNCLOSEDDECL:
            return "ERROR_SXS_XML_E_UNCLOSEDDECL";
        case ERROR_SXS_XML_E_UNCLOSEDCDATA:
            return "ERROR_SXS_XML_E_UNCLOSEDCDATA";
        case ERROR_SXS_XML_E_RESERVEDNAMESPACE:
            return "ERROR_SXS_XML_E_RESERVEDNAMESPACE";
        case ERROR_SXS_XML_E_INVALIDENCODING:
            return "ERROR_SXS_XML_E_INVALIDENCODING";
        case ERROR_SXS_XML_E_INVALIDSWITCH:
            return "ERROR_SXS_XML_E_INVALIDSWITCH";
        case ERROR_SXS_XML_E_BADXMLCASE:
            return "ERROR_SXS_XML_E_BADXMLCASE";
        case ERROR_SXS_XML_E_INVALID_STANDALONE:
            return "ERROR_SXS_XML_E_INVALID_STANDALONE";
        case ERROR_SXS_XML_E_UNEXPECTED_STANDALONE:
            return "ERROR_SXS_XML_E_UNEXPECTED_STANDALONE";
        case ERROR_SXS_XML_E_INVALID_VERSION:
            return "ERROR_SXS_XML_E_INVALID_VERSION";
        case ERROR_SXS_XML_E_MISSINGEQUALS:
            return "ERROR_SXS_XML_E_MISSINGEQUALS";
        case ERROR_SXS_PROTECTION_RECOVERY_FAILED:
            return "ERROR_SXS_PROTECTION_RECOVERY_FAILED";
        case ERROR_SXS_PROTECTION_PUBLIC_KEY_TOO_SHORT:
            return "ERROR_SXS_PROTECTION_PUBLIC_KEY_TOO_SHORT";
        case ERROR_SXS_PROTECTION_CATALOG_NOT_VALID:
            return "ERROR_SXS_PROTECTION_CATALOG_NOT_VALID";
        case ERROR_SXS_UNTRANSLATABLE_HRESULT:
            return "ERROR_SXS_UNTRANSLATABLE_HRESULT";
        case ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING:
            return "ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING";
        case ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE:
            return "ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE";
        case ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME:
            return "ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME";
        case ERROR_IPSEC_QM_POLICY_EXISTS:
            return "ERROR_IPSEC_QM_POLICY_EXISTS";
        case ERROR_IPSEC_QM_POLICY_NOT_FOUND:
            return "ERROR_IPSEC_QM_POLICY_NOT_FOUND";
        case ERROR_IPSEC_QM_POLICY_IN_USE:
            return "ERROR_IPSEC_QM_POLICY_IN_USE";
        case ERROR_IPSEC_MM_POLICY_EXISTS:
            return "ERROR_IPSEC_MM_POLICY_EXISTS";
        case ERROR_IPSEC_MM_POLICY_NOT_FOUND:
            return "ERROR_IPSEC_MM_POLICY_NOT_FOUND";
        case ERROR_IPSEC_MM_POLICY_IN_USE:
            return "ERROR_IPSEC_MM_POLICY_IN_USE";
        case ERROR_IPSEC_MM_FILTER_EXISTS:
            return "ERROR_IPSEC_MM_FILTER_EXISTS";
        case ERROR_IPSEC_MM_FILTER_NOT_FOUND:
            return "ERROR_IPSEC_MM_FILTER_NOT_FOUND";
        case ERROR_IPSEC_TRANSPORT_FILTER_EXISTS:
            return "ERROR_IPSEC_TRANSPORT_FILTER_EXISTS";
        case ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND:
            return "ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND";
        case ERROR_IPSEC_MM_AUTH_EXISTS:
            return "ERROR_IPSEC_MM_AUTH_EXISTS";
        case ERROR_IPSEC_MM_AUTH_NOT_FOUND:
            return "ERROR_IPSEC_MM_AUTH_NOT_FOUND";
        case ERROR_IPSEC_MM_AUTH_IN_USE:
            return "ERROR_IPSEC_MM_AUTH_IN_USE";
        case ERROR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND:
            return "ERROR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND";
        case ERROR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND:
            return "ERROR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND";
        case ERROR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND:
            return "ERROR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND";
        case ERROR_IPSEC_TUNNEL_FILTER_EXISTS:
            return "ERROR_IPSEC_TUNNEL_FILTER_EXISTS";
        case ERROR_IPSEC_TUNNEL_FILTER_NOT_FOUND:
            return "ERROR_IPSEC_TUNNEL_FILTER_NOT_FOUND";
        case ERROR_IPSEC_MM_FILTER_PENDING_DELETION:
            return "ERROR_IPSEC_MM_FILTER_PENDING_DELETION";
        case ERROR_IPSEC_TRANSPORT_FILTER_PENDING_DELETION:
            return "ERROR_IPSEC_TRANSPORT_FILTER_PENDING_DELETION";
        case ERROR_IPSEC_TUNNEL_FILTER_PENDING_DELETION:
            return "ERROR_IPSEC_TUNNEL_FILTER_PENDING_DELETION";
        case ERROR_IPSEC_MM_POLICY_PENDING_DELETION:
            return "ERROR_IPSEC_MM_POLICY_PENDING_DELETION";
        case ERROR_IPSEC_MM_AUTH_PENDING_DELETION:
            return "ERROR_IPSEC_MM_AUTH_PENDING_DELETION";
        case ERROR_IPSEC_QM_POLICY_PENDING_DELETION:
            return "ERROR_IPSEC_QM_POLICY_PENDING_DELETION";
        case ERROR_IPSEC_IKE_NEG_STATUS_BEGIN:
            return "ERROR_IPSEC_IKE_NEG_STATUS_BEGIN";
        case ERROR_IPSEC_IKE_AUTH_FAIL:
            return "ERROR_IPSEC_IKE_AUTH_FAIL";
        case ERROR_IPSEC_IKE_ATTRIB_FAIL:
            return "ERROR_IPSEC_IKE_ATTRIB_FAIL";
        case ERROR_IPSEC_IKE_NEGOTIATION_PENDING:
            return "ERROR_IPSEC_IKE_NEGOTIATION_PENDING";
        case ERROR_IPSEC_IKE_GENERAL_PROCESSING_ERROR:
            return "ERROR_IPSEC_IKE_GENERAL_PROCESSING_ERROR";
        case ERROR_IPSEC_IKE_TIMED_OUT:
            return "ERROR_IPSEC_IKE_TIMED_OUT";
        case ERROR_IPSEC_IKE_NO_CERT:
            return "ERROR_IPSEC_IKE_NO_CERT";
        case ERROR_IPSEC_IKE_SA_DELETED:
            return "ERROR_IPSEC_IKE_SA_DELETED";
        case ERROR_IPSEC_IKE_SA_REAPED:
            return "ERROR_IPSEC_IKE_SA_REAPED";
        case ERROR_IPSEC_IKE_MM_ACQUIRE_DROP:
            return "ERROR_IPSEC_IKE_MM_ACQUIRE_DROP";
        case ERROR_IPSEC_IKE_QM_ACQUIRE_DROP:
            return "ERROR_IPSEC_IKE_QM_ACQUIRE_DROP";
        case ERROR_IPSEC_IKE_QUEUE_DROP_MM:
            return "ERROR_IPSEC_IKE_QUEUE_DROP_MM";
        case ERROR_IPSEC_IKE_QUEUE_DROP_NO_MM:
            return "ERROR_IPSEC_IKE_QUEUE_DROP_NO_MM";
        case ERROR_IPSEC_IKE_DROP_NO_RESPONSE:
            return "ERROR_IPSEC_IKE_DROP_NO_RESPONSE";
        case ERROR_IPSEC_IKE_MM_DELAY_DROP:
            return "ERROR_IPSEC_IKE_MM_DELAY_DROP";
        case ERROR_IPSEC_IKE_QM_DELAY_DROP:
            return "ERROR_IPSEC_IKE_QM_DELAY_DROP";
        case ERROR_IPSEC_IKE_ERROR:
            return "ERROR_IPSEC_IKE_ERROR";
        case ERROR_IPSEC_IKE_CRL_FAILED:
            return "ERROR_IPSEC_IKE_CRL_FAILED";
        case ERROR_IPSEC_IKE_INVALID_KEY_USAGE:
            return "ERROR_IPSEC_IKE_INVALID_KEY_USAGE";
        case ERROR_IPSEC_IKE_INVALID_CERT_TYPE:
            return "ERROR_IPSEC_IKE_INVALID_CERT_TYPE";
        case ERROR_IPSEC_IKE_NO_PRIVATE_KEY:
            return "ERROR_IPSEC_IKE_NO_PRIVATE_KEY";
        case ERROR_IPSEC_IKE_DH_FAIL:
            return "ERROR_IPSEC_IKE_DH_FAIL";
        case ERROR_IPSEC_IKE_INVALID_HEADER:
            return "ERROR_IPSEC_IKE_INVALID_HEADER";
        case ERROR_IPSEC_IKE_NO_POLICY:
            return "ERROR_IPSEC_IKE_NO_POLICY";
        case ERROR_IPSEC_IKE_INVALID_SIGNATURE:
            return "ERROR_IPSEC_IKE_INVALID_SIGNATURE";
        case ERROR_IPSEC_IKE_KERBEROS_ERROR:
            return "ERROR_IPSEC_IKE_KERBEROS_ERROR";
        case ERROR_IPSEC_IKE_NO_PUBLIC_KEY:
            return "ERROR_IPSEC_IKE_NO_PUBLIC_KEY";
        case ERROR_IPSEC_IKE_PROCESS_ERR:
            return "ERROR_IPSEC_IKE_PROCESS_ERR";
        case ERROR_IPSEC_IKE_PROCESS_ERR_SA:
            return "ERROR_IPSEC_IKE_PROCESS_ERR_SA";
        case ERROR_IPSEC_IKE_PROCESS_ERR_PROP:
            return "ERROR_IPSEC_IKE_PROCESS_ERR_PROP";
        case ERROR_IPSEC_IKE_PROCESS_ERR_TRANS:
            return "ERROR_IPSEC_IKE_PROCESS_ERR_TRANS";
        case ERROR_IPSEC_IKE_PROCESS_ERR_KE:
            return "ERROR_IPSEC_IKE_PROCESS_ERR_KE";
        case ERROR_IPSEC_IKE_PROCESS_ERR_ID:
            return "ERROR_IPSEC_IKE_PROCESS_ERR_ID";
        case ERROR_IPSEC_IKE_PROCESS_ERR_CERT:
            return "ERROR_IPSEC_IKE_PROCESS_ERR_CERT";
        case ERROR_IPSEC_IKE_PROCESS_ERR_CERT_REQ:
            return "ERROR_IPSEC_IKE_PROCESS_ERR_CERT_REQ";
        case ERROR_IPSEC_IKE_PROCESS_ERR_HASH:
            return "ERROR_IPSEC_IKE_PROCESS_ERR_HASH";
        case ERROR_IPSEC_IKE_PROCESS_ERR_SIG:
            return "ERROR_IPSEC_IKE_PROCESS_ERR_SIG";
        case ERROR_IPSEC_IKE_PROCESS_ERR_NONCE:
            return "ERROR_IPSEC_IKE_PROCESS_ERR_NONCE";
        case ERROR_IPSEC_IKE_PROCESS_ERR_NOTIFY:
            return "ERROR_IPSEC_IKE_PROCESS_ERR_NOTIFY";
        case ERROR_IPSEC_IKE_PROCESS_ERR_DELETE:
            return "ERROR_IPSEC_IKE_PROCESS_ERR_DELETE";
        case ERROR_IPSEC_IKE_PROCESS_ERR_VENDOR:
            return "ERROR_IPSEC_IKE_PROCESS_ERR_VENDOR";
        case ERROR_IPSEC_IKE_INVALID_PAYLOAD:
            return "ERROR_IPSEC_IKE_INVALID_PAYLOAD";
        case ERROR_IPSEC_IKE_LOAD_SOFT_SA:
            return "ERROR_IPSEC_IKE_LOAD_SOFT_SA";
        case ERROR_IPSEC_IKE_SOFT_SA_TORN_DOWN:
            return "ERROR_IPSEC_IKE_SOFT_SA_TORN_DOWN";
        case ERROR_IPSEC_IKE_INVALID_COOKIE:
            return "ERROR_IPSEC_IKE_INVALID_COOKIE";
        case ERROR_IPSEC_IKE_NO_PEER_CERT:
            return "ERROR_IPSEC_IKE_NO_PEER_CERT";
        case ERROR_IPSEC_IKE_PEER_CRL_FAILED:
            return "ERROR_IPSEC_IKE_PEER_CRL_FAILED";
        case ERROR_IPSEC_IKE_POLICY_CHANGE:
            return "ERROR_IPSEC_IKE_POLICY_CHANGE";
        case ERROR_IPSEC_IKE_NO_MM_POLICY:
            return "ERROR_IPSEC_IKE_NO_MM_POLICY";
        case ERROR_IPSEC_IKE_NOTCBPRIV:
            return "ERROR_IPSEC_IKE_NOTCBPRIV";
        case ERROR_IPSEC_IKE_SECLOADFAIL:
            return "ERROR_IPSEC_IKE_SECLOADFAIL";
        case ERROR_IPSEC_IKE_FAILSSPINIT:
            return "ERROR_IPSEC_IKE_FAILSSPINIT";
        case ERROR_IPSEC_IKE_FAILQUERYSSP:
            return "ERROR_IPSEC_IKE_FAILQUERYSSP";
        case ERROR_IPSEC_IKE_SRVACQFAIL:
            return "ERROR_IPSEC_IKE_SRVACQFAIL";
        case ERROR_IPSEC_IKE_SRVQUERYCRED:
            return "ERROR_IPSEC_IKE_SRVQUERYCRED";
        case ERROR_IPSEC_IKE_GETSPIFAIL:
            return "ERROR_IPSEC_IKE_GETSPIFAIL";
        case ERROR_IPSEC_IKE_INVALID_FILTER:
            return "ERROR_IPSEC_IKE_INVALID_FILTER";
        case ERROR_IPSEC_IKE_OUT_OF_MEMORY:
            return "ERROR_IPSEC_IKE_OUT_OF_MEMORY";
        case ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED:
            return "ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED";
        case ERROR_IPSEC_IKE_INVALID_POLICY:
            return "ERROR_IPSEC_IKE_INVALID_POLICY";
        case ERROR_IPSEC_IKE_UNKNOWN_DOI:
            return "ERROR_IPSEC_IKE_UNKNOWN_DOI";
        case ERROR_IPSEC_IKE_INVALID_SITUATION:
            return "ERROR_IPSEC_IKE_INVALID_SITUATION";
        case ERROR_IPSEC_IKE_DH_FAILURE:
            return "ERROR_IPSEC_IKE_DH_FAILURE";
        case ERROR_IPSEC_IKE_INVALID_GROUP:
            return "ERROR_IPSEC_IKE_INVALID_GROUP";
        case ERROR_IPSEC_IKE_ENCRYPT:
            return "ERROR_IPSEC_IKE_ENCRYPT";
        case ERROR_IPSEC_IKE_DECRYPT:
            return "ERROR_IPSEC_IKE_DECRYPT";
        case ERROR_IPSEC_IKE_POLICY_MATCH:
            return "ERROR_IPSEC_IKE_POLICY_MATCH";
        case ERROR_IPSEC_IKE_UNSUPPORTED_ID:
            return "ERROR_IPSEC_IKE_UNSUPPORTED_ID";
        case ERROR_IPSEC_IKE_INVALID_HASH:
            return "ERROR_IPSEC_IKE_INVALID_HASH";
        case ERROR_IPSEC_IKE_INVALID_HASH_ALG:
            return "ERROR_IPSEC_IKE_INVALID_HASH_ALG";
        case ERROR_IPSEC_IKE_INVALID_HASH_SIZE:
            return "ERROR_IPSEC_IKE_INVALID_HASH_SIZE";
        case ERROR_IPSEC_IKE_INVALID_ENCRYPT_ALG:
            return "ERROR_IPSEC_IKE_INVALID_ENCRYPT_ALG";
        case ERROR_IPSEC_IKE_INVALID_AUTH_ALG:
            return "ERROR_IPSEC_IKE_INVALID_AUTH_ALG";
        case ERROR_IPSEC_IKE_INVALID_SIG:
            return "ERROR_IPSEC_IKE_INVALID_SIG";
        case ERROR_IPSEC_IKE_LOAD_FAILED:
            return "ERROR_IPSEC_IKE_LOAD_FAILED";
        case ERROR_IPSEC_IKE_RPC_DELETE:
            return "ERROR_IPSEC_IKE_RPC_DELETE";
        case ERROR_IPSEC_IKE_BENIGN_REINIT:
            return "ERROR_IPSEC_IKE_BENIGN_REINIT";
        case ERROR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY:
            return "ERROR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY";
        case ERROR_IPSEC_IKE_INVALID_CERT_KEYLEN:
            return "ERROR_IPSEC_IKE_INVALID_CERT_KEYLEN";
        case ERROR_IPSEC_IKE_MM_LIMIT:
            return "ERROR_IPSEC_IKE_MM_LIMIT";
        case ERROR_IPSEC_IKE_NEGOTIATION_DISABLED:
            return "ERROR_IPSEC_IKE_NEGOTIATION_DISABLED";
        case ERROR_IPSEC_IKE_NEG_STATUS_END:
            return "ERROR_IPSEC_IKE_NEG_STATUS_END";
        case ERROR_AUDITING_DISABLED:
            return "ERROR_AUDITING_DISABLED";
        case ERROR_ALL_SIDS_FILTERED:
            return "ERROR_ALL_SIDS_FILTERED";
        default:
            return "__UNKNOWN__";
    }
}

void WinFail_fail(struct Except* eh, const char* msg, LONG status)
{
    Except_throw(eh, "%s [%s]", msg, WinFail_strerror(status));
}

void WinFail_failWithLastError(struct Except* eh, const char* msg)
{
    Except_throw(eh, "%s [%s]", msg, WinFail_strerror(GetLastError()));
}
