customhandlers=
{
	application=
	{
		initCompleted=function() print("App initialization completed"); return true; end,
		outboundConnectionFailed=crtmpserver.handlers.application.outboundConnectionFailed,
		preRegisterProtocol=function(protocolId) print ("registering protocol PID "..protocolId.." to application"); return true; end,
		postRegisterProtocol=function(protocolId) print ("protocol PID "..protocolId.." registered to application"); return true; end,
		preUnRegisterProtocol=function(protocolId) print ("unregistering protocol PID "..protocolId.." from application"); return true; end,
		postUnRegisterProtocol=function(protocolId) print ("protocol PID "..protocolId.." unregistered from application"); return true; end,
		signalStreamRegistered=function(uniqueStreamId) print ("stream UID "..uniqueStreamId.." registered to application"); return true; end,
		signalStreamUnRegistered=function(uniqueStreamId) print ("stream UID "..uniqueStreamId.." unregistered from application"); return true; end,
		pullExternalStream=crtmpserver.handlers.application.pullExternalStream,
		pushLocalStream=crtmpserver.handlers.application.pushLocalStream,
	},
	rtmp=
	{
		preRegisterProtocol=function(protocolId) print ("registering protocol PID "..protocolId.." to rtmp handler"); return true; end,
		postRegisterProtocol=function(protocolId) print ("protocol PID "..protocolId.." registered to rtmp handler"); return true; end,
		preUnRegisterProtocol=function(protocolId) print ("unregistering protocol PID "..protocolId.." from rtmp handler"); return true; end,
		postUnRegisterProtocol=function(protocolId) print ("protocol PID "..protocolId.." unregistered from rtmp handler"); return true; end,
		pullExternalStream=crtmpserver.handlers.rtmp.pullExternalStream,
		pushLocalStream=crtmpserver.handlers.rtmp.pushLocalStream,
		outboundConnectionEstablished=crtmpserver.handlers.rtmp.outboundConnectionEstablished,
		authenticateInbound=crtmpserver.handlers.rtmp.authenticateInbound,
		inboundMessageAvailable=crtmpserver.handlers.rtmp.inboundMessageAvailable,
		processWinAckSize=crtmpserver.handlers.rtmp.processWinAckSize,
		processPeerBW=crtmpserver.handlers.rtmp.processPeerBW,
		processAck=crtmpserver.handlers.rtmp.processAck,
		processChunkSize=crtmpserver.handlers.rtmp.processChunkSize,
		processUsrCtrl=crtmpserver.handlers.rtmp.processUsrCtrl,
		processNotify=crtmpserver.handlers.rtmp.processNotify,
		processFlexStreamSend=crtmpserver.handlers.rtmp.processFlexStreamSend,
		processSharedObject=crtmpserver.handlers.rtmp.processSharedObject,
		processInvoke=crtmpserver.handlers.rtmp.processInvoke,
		processInvokeConnect=crtmpserver.handlers.rtmp.processInvokeConnect,
		processInvokeCreateStream=crtmpserver.handlers.rtmp.processInvokeCreateStream,
		processInvokePublish=crtmpserver.handlers.rtmp.processInvokePublish,
		processInvokeSeek=crtmpserver.handlers.rtmp.processInvokeSeek,
		processInvokePlay=crtmpserver.handlers.rtmp.processInvokePlay,
		processInvokePauseRaw=crtmpserver.handlers.rtmp.processInvokePauseRaw,
		processInvokePause=crtmpserver.handlers.rtmp.processInvokePause,
		processInvokeCloseStream=crtmpserver.handlers.rtmp.processInvokeCloseStream,
		processInvokeReleaseStream=crtmpserver.handlers.rtmp.processInvokeReleaseStream,
		processInvokeDeleteStream=crtmpserver.handlers.rtmp.processInvokeDeleteStream,
		processInvokeOnStatus=crtmpserver.handlers.rtmp.processInvokeOnStatus,
		processInvokeFCPublish=crtmpserver.handlers.rtmp.processInvokeFCPublish,
		processInvokeGetStreamLength=crtmpserver.handlers.rtmp.processInvokeGetStreamLength,
		processInvokeOnBWDone=crtmpserver.handlers.rtmp.processInvokeOnBWDone,
		processInvokeGeneric=crtmpserver.handlers.rtmp.processInvokeGeneric,
		processInvokeResultWithoutRequest=crtmpserver.handlers.rtmp.processInvokeResultWithoutRequest,
		processInvokeResultWithRequest=crtmpserver.handlers.rtmp.processInvokeResultWithRequest,
		processInvokeConnectResult=crtmpserver.handlers.rtmp.processInvokeConnectResult,
		processInvokeCreateStreamResult=crtmpserver.handlers.rtmp.processInvokeCreateStreamResult,
		processInvokeFCSubscribeResult=crtmpserver.handlers.rtmp.processInvokeFCSubscribeResult,
		processInvokeGenericResult=crtmpserver.handlers.rtmp.processInvokeGenericResult,
	},
	mpegts=
	{
		preRegisterProtocol=function(protocolId) print ("registering protocol PID "..protocolId.." to mpegts handler"); return true; end,
		postRegisterProtocol=function(protocolId) print ("protocol PID "..protocolId.." registered to mpegts handler"); return true; end,
		preUnRegisterProtocol=function(protocolId) print ("unregistering protocol PID "..protocolId.." from mpegts handler"); return true; end,
		postUnRegisterProtocol=function(protocolId) print ("protocol PID "..protocolId.." unregistered from mpegts handler"); return true; end,
		programSetupCompleted=function(uniqueStreamId) print ("program setup completed: UID "..uniqueStreamId); return true; end,
	}
}

