#ifndef _DRV_VMMC_ALM_PRIV_H
#define _DRV_VMMC_ALM_PRIV_H
/******************************************************************************

                              Copyright (c) 2009
                            Lantiq Deutschland GmbH
                     Am Campeon 3; 85579 Neubiberg, Germany

  For licensing information, see the file 'LICENSE' in the root folder of
  this software module.

******************************************************************************
   Module      : drv_vmmc_alm_priv.h
   Description : This file contains the defines, the structures declarations
                 for ALM module.
*******************************************************************************/

/* includes */
#include "drv_vmmc_fw_commands.h"
#include "drv_vmmc_res.h"

/******************************************************************************
** Firmware Analog Line Interface Channel Cmd
**
*******************************************************************************/

#ifdef SYSTEM_DANUBE
/* structure to store NB and WB coefficients, note commands must start at
   32bit boundaries, i.e. block1 and 2 must be multiple of 2 16bit words. */
typedef struct
{
   IFX_uint16_t block0[6];
   IFX_uint16_t block1[4];
   IFX_uint16_t block2[4];
} VMMC_ALM_NB_WB_COEF_t;
#endif /* SYSTEM_DANUBE */

/** Structure for the analog line module channel
    including firmware message cache */
struct VMMC_ALMCH
{
   ALI_CHAN_t                    fw_ali_ch;
   OPMODE_CMD_t                  dc_opmode;
   /* Cached FW message for calibration */
   VMMC_SDD_Calibrate_t          fw_sdd_calibrate,
   /* Cache for the last calibration results */
                                 calibrationLastResults;
#ifdef SYSTEM_DANUBE
   /* store two sets of coefficients related to the sampling rate -
      one set for NB and one set for WB mode.
      The order of storage is derived from OPMODE_SMPL. */
   VMMC_ALM_NB_WB_COEF_t         smpl_coef[2];
#endif /* SYSTEM_DANUBE */
   /* the current NB/WB mode */
   OPMODE_SMPL                   module_mode;
   /* line type configured to FXS == IFX_TRUE or FXO == IFX_FALSE */
   IFX_boolean_t                 line_type_fxs;
   /* the storage of battery, apoh, polarity and ring status for FXO line */
   volatile IFX_uint32_t         fxo_flags;
   /* The echo suppressor resource id */
   VMMC_RES_ID_t                 nEsResId;
   /* The line echo canceller resource id */
   VMMC_RES_ID_t                 nLecResId;
#if (VMMC_CFG_FEATURES & VMMC_FEAT_GR909)
   /* IFX_TRUE if ring config stored for this channel */
   IFX_boolean_t                 b_ring_cfg;
   /* Previous ring frequency */
   IFX_uint16_t                  ring_freq_prev;
   /* Ring configuration */
   RING_CONFIG_CMD_t             ring_cfg;
   /* IFX_TRUE: GR909 limits are set / IFX_FALSE: GR909 limits
      aren't set, so set defaults */
   IFX_boolean_t                 b_GR909_limits;
   /* GR909 linetesting control */
   GR909_Linetesting_Control_t   gr909_ctrl;
   /* GR909 Pass/Fail Results */
   GR909_Result_Pass_Fail_t      gr909_result;
   /* GR909 HPT Results */
   GR909_Result_HPT_t            gr909_hpt;
   /* GR909 FEFM Results */
   GR909_Result_FEMF_t           gr909_femf;
   /* GR909 RFT Results */
   GR909_Result_RFT_t            gr909_rft;
   /* GR909 ROH Results */
   GR909_Result_ROH_t            gr909_roh;
   /* GR909 RIT Results */
   GR909_Result_RIT_t            gr909_rit;
#endif /* VMMC_CFG_FEATURES & VMMC_FEAT_GR909 */
   /* State of the calibration */
   IFX_TAPI_CALIBRATION_STATE_t  nCalibrationState;
   /* Indicates the current state of the FW */
   IFX_boolean_t                 bCalibrationRunning;
   /* Cached FW message for SDD_BasicConfig */
   VMMC_SDD_BasicConfig_t        fw_sdd_basic_config;
   /* IdleExt bit of SDD_BasicConfig restoration indicator */
   IFX_boolean_t                 bIdleExtNeedRestore;
#if (VMMC_CFG_FEATURES & VMMC_FEAT_CONT_MEASUREMENT)
   /* Cached FW message for SDD_ContMeasRead */
   VMMC_SDD_ContMeasRead_t       fw_sdd_contMeasRead;
   /* Cached FW message for SDD_ContMeasClear */
   VMMC_SDD_ContMeasClear_t      fw_sdd_contMearClear;
#endif /* VMMC_CFG_FEATURES & VMMC_FEAT_CONT_MEASUREMENT */
   /* Cached FW message for SDD_FxoConfig */
   VMMC_SDD_FxoConfig_t          fw_sdd_fxoConfig;
   /* Cached FW message for SDD_FxoHookSwitch */
   VMMC_SDD_FxoHookSwitch_t      fw_sdd_fxoHookSwitch;
#if (VMMC_CFG_FEATURES & VMMC_FEAT_PHONE_DETECTION)
   /* Cached FW message for SDD_GR909Config */
   VMMC_SDD_GR909Config_t        fw_sdd_GR909Config;
   /* Cached FW message for SDD_Opmode */
   VMMC_SDD_Opmode_t             fw_sdd_opmode;
   /* Cached FW message for SDD_GR909PhoneDetection */
   VMMC_SDD_GR909PhoneDetection_t fw_sdd_phone_detection;
   /* State of capacitance measurement */
   volatile IFX_boolean_t        bCapMeasInProgress;
#endif /* (VMMC_CFG_FEATURES & VMMC_FEAT_PHONE_DETECTION) */

#ifdef EVALUATION
   IFX_void_t                    *pEval;
#endif /* #ifdef EVALUATION */

};


#endif /* _DRV_VMMC_ALM_PRIV_H */
