/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sun Jan 15 07:30:28 EST 2017 */

#include "codelet-dft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_twiddle_c.native -fma -reorder-insns -schedule-for-pipeline -simd -compact -variables 4 -pipeline-latency 8 -twiddle-log3 -precompute-twiddles -no-generate-bytw -n 25 -name t3fv_25 -include t3f.h */

/*
 * This function contains 268 FP additions, 281 FP multiplications,
 * (or, 87 additions, 100 multiplications, 181 fused multiply/add),
 * 223 stack variables, 67 constants, and 50 memory accesses
 */
#include "t3f.h"

static void t3fv_25(R *ri, R *ii, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DVK(KP792626838, +0.792626838241819413632131824093538848057784557);
     DVK(KP876091699, +0.876091699473550838204498029706869638173524346);
     DVK(KP617882369, +0.617882369114440893914546919006756321695042882);
     DVK(KP803003575, +0.803003575438660414833440593570376004635464850);
     DVK(KP242145790, +0.242145790282157779872542093866183953459003101);
     DVK(KP968583161, +0.968583161128631119490168375464735813836012403);
     DVK(KP999544308, +0.999544308746292983948881682379742149196758193);
     DVK(KP916574801, +0.916574801383451584742370439148878693530976769);
     DVK(KP904730450, +0.904730450839922351881287709692877908104763647);
     DVK(KP809385824, +0.809385824416008241660603814668679683846476688);
     DVK(KP447417479, +0.447417479732227551498980015410057305749330693);
     DVK(KP894834959, +0.894834959464455102997960030820114611498661386);
     DVK(KP867381224, +0.867381224396525206773171885031575671309956167);
     DVK(KP683113946, +0.683113946453479238701949862233725244439656928);
     DVK(KP559154169, +0.559154169276087864842202529084232643714075927);
     DVK(KP958953096, +0.958953096729998668045963838399037225970891871);
     DVK(KP831864738, +0.831864738706457140726048799369896829771167132);
     DVK(KP829049696, +0.829049696159252993975487806364305442437946767);
     DVK(KP860541664, +0.860541664367944677098261680920518816412804187);
     DVK(KP897376177, +0.897376177523557693138608077137219684419427330);
     DVK(KP876306680, +0.876306680043863587308115903922062583399064238);
     DVK(KP681693190, +0.681693190061530575150324149145440022633095390);
     DVK(KP560319534, +0.560319534973832390111614715371676131169633784);
     DVK(KP855719849, +0.855719849902058969314654733608091555096772472);
     DVK(KP237294955, +0.237294955877110315393888866460840817927895961);
     DVK(KP949179823, +0.949179823508441261575555465843363271711583843);
     DVK(KP904508497, +0.904508497187473712051146708591409529430077295);
     DVK(KP997675361, +0.997675361079556513670859573984492383596555031);
     DVK(KP763932022, +0.763932022500210303590826331268723764559381640);
     DVK(KP690983005, +0.690983005625052575897706582817180941139845410);
     DVK(KP992114701, +0.992114701314477831049793042785778521453036709);
     DVK(KP952936919, +0.952936919628306576880750665357914584765951388);
     DVK(KP998026728, +0.998026728428271561952336806863450553336905220);
     DVK(KP262346850, +0.262346850930607871785420028382979691334784273);
     DVK(KP570584518, +0.570584518783621657366766175430996792655723863);
     DVK(KP669429328, +0.669429328479476605641803240971985825917022098);
     DVK(KP923225144, +0.923225144846402650453449441572664695995209956);
     DVK(KP945422727, +0.945422727388575946270360266328811958657216298);
     DVK(KP522616830, +0.522616830205754336872861364785224694908468440);
     DVK(KP956723877, +0.956723877038460305821989399535483155872969262);
     DVK(KP906616052, +0.906616052148196230441134447086066874408359177);
     DVK(KP772036680, +0.772036680810363904029489473607579825330539880);
     DVK(KP845997307, +0.845997307939530944175097360758058292389769300);
     DVK(KP951056516, +0.951056516295153572116439333379382143405698634);
     DVK(KP912575812, +0.912575812670962425556968549836277086778922727);
     DVK(KP921078979, +0.921078979742360627699756128143719920817673854);
     DVK(KP982009705, +0.982009705009746369461829878184175962711969869);
     DVK(KP734762448, +0.734762448793050413546343770063151342619912334);
     DVK(KP494780565, +0.494780565770515410344588413655324772219443730);
     DVK(KP447533225, +0.447533225982656890041886979663652563063114397);
     DVK(KP603558818, +0.603558818296015001454675132653458027918768137);
     DVK(KP667278218, +0.667278218140296670899089292254759909713898805);
     DVK(KP244189809, +0.244189809627953270309879511234821255780225091);
     DVK(KP269969613, +0.269969613759572083574752974412347470060951301);
     DVK(KP578046249, +0.578046249379945007321754579646815604023525655);
     DVK(KP522847744, +0.522847744331509716623755382187077770911012542);
     DVK(KP132830569, +0.132830569247582714407653942074819768844536507);
     DVK(KP120146378, +0.120146378570687701782758537356596213647956445);
     DVK(KP893101515, +0.893101515366181661711202267938416198338079437);
     DVK(KP987388751, +0.987388751065621252324603216482382109400433949);
     DVK(KP059835404, +0.059835404262124915169548397419498386427871950);
     DVK(KP066152395, +0.066152395967733048213034281011006031460903353);
     DVK(KP786782374, +0.786782374965295178365099601674911834788448471);
     DVK(KP869845200, +0.869845200362138853122720822420327157933056305);
     DVK(KP559016994, +0.559016994374947424102293417182819058860154590);
     DVK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DVK(KP618033988, +0.618033988749894848204586834365638117720309180);
     {
	  INT m;
	  R *x;
	  x = ri;
	  for (m = mb, W = W + (mb * ((TWVL / VL) * 8)); m < me; m = m + VL, x = x + (VL * ms), W = W + (TWVL * 8), MAKE_VOLATILE_STRIDE(25, rs)) {
	       V T2t, T1Z, T2W, T28, T2Q, T2r, T2g, T2u, T2o, T2l;
	       {
		    V T2, T5, T3, T9;
		    T2 = LDW(&(W[0]));
		    T5 = LDW(&(W[TWVL * 4]));
		    T3 = LDW(&(W[TWVL * 2]));
		    T9 = LDW(&(W[TWVL * 6]));
		    {
			 V T2c, T3l, Tn, T49, Tm, T4e, TN, T32, T1d, T3a, T3f, T3z, T3H, T25, T1W;
			 V T2v, T2D, T4a, T1g, T18, T2Z, T11, T31, TK, T1q, T1j, T1n, T4b, T17;
			 {
			      V T1, T1l, Tr, T4, Ty, T1E, Tu, TX, TD, T1h, Tz, T1e, T1I, T1o, TU;
			      V Tk, T2b, T1B, T1D, T1N, T1F, Td, T2a, T1J;
			      {
				   V T7, Tb, TC, Tg, T1L, Ta, T6, Tj, T1A;
				   T1 = LD(&(x[0]), ms, &(x[0]));
				   {
					V Tf, Ti, Te, Th;
					Tf = LD(&(x[WS(rs, 10)]), ms, &(x[0]));
					Ti = LD(&(x[WS(rs, 15)]), ms, &(x[WS(rs, 1)]));
					T7 = LD(&(x[WS(rs, 5)]), ms, &(x[WS(rs, 1)]));
					Tb = LD(&(x[WS(rs, 20)]), ms, &(x[0]));
					Te = VZMUL(T2, T5);
					TC = VZMULJ(T2, T5);
					T1l = VZMUL(T3, T5);
					Tr = VZMULJ(T3, T5);
					T4 = VZMUL(T2, T3);
					Ty = VZMULJ(T2, T3);
					T1E = VZMULJ(T2, T9);
					Th = VZMULJ(T5, T9);
					Tu = VZMULJ(T3, T9);
					Tg = VZMULJ(Te, Tf);
					TX = VZMULJ(Te, T9);
					TD = VZMULJ(TC, T9);
					T1h = VZMULJ(Ty, T9);
					Tz = VZMUL(Ty, T5);
					T1e = VZMULJ(Ty, T5);
					T1L = VZMULJ(Tr, T9);
					Ta = VZMULJ(T4, T9);
					T1I = VZMUL(T4, T5);
					T6 = VZMULJ(T4, T5);
					Tj = VZMULJ(Th, Ti);
				   }
				   T1A = LD(&(x[WS(rs, 3)]), ms, &(x[WS(rs, 1)]));
				   T1o = VZMULJ(T1e, T9);
				   {
					V Tc, T8, T1C, T1M;
					T1C = LD(&(x[WS(rs, 8)]), ms, &(x[0]));
					T1M = LD(&(x[WS(rs, 18)]), ms, &(x[0]));
					Tc = VZMULJ(Ta, Tb);
					T8 = VZMULJ(T6, T7);
					TU = VZMULJ(T6, T9);
					Tk = VADD(Tg, Tj);
					T2b = VSUB(Tg, Tj);
					T1B = VZMULJ(T3, T1A);
					T1D = VZMULJ(TC, T1C);
					T1N = VZMULJ(T1L, T1M);
					T1F = LD(&(x[WS(rs, 23)]), ms, &(x[WS(rs, 1)]));
					Td = VADD(T8, Tc);
					T2a = VSUB(T8, Tc);
					T1J = LD(&(x[WS(rs, 13)]), ms, &(x[WS(rs, 1)]));
				   }
			      }
			      {
				   V Tq, Tt, TF, T1T, T1H, Tw, T1U, T1O, TA, Tp, Ts, TE;
				   Tp = LD(&(x[WS(rs, 1)]), ms, &(x[WS(rs, 1)]));
				   Ts = LD(&(x[WS(rs, 6)]), ms, &(x[0]));
				   TE = LD(&(x[WS(rs, 16)]), ms, &(x[0]));
				   {
					V T1K, Tv, T1G, Tl;
					Tv = LD(&(x[WS(rs, 21)]), ms, &(x[WS(rs, 1)]));
					T1G = VZMULJ(T1E, T1F);
					T2c = VFMA(LDK(KP618033988), T2b, T2a);
					T3l = VFNMS(LDK(KP618033988), T2a, T2b);
					Tn = VSUB(Td, Tk);
					Tl = VADD(Td, Tk);
					T1K = VZMULJ(T1I, T1J);
					Tq = VZMULJ(T2, Tp);
					Tt = VZMULJ(Tr, Ts);
					TF = VZMULJ(TD, TE);
					T1T = VSUB(T1D, T1G);
					T1H = VADD(T1D, T1G);
					T49 = VADD(T1, Tl);
					Tm = VFNMS(LDK(KP250000000), Tl, T1);
					Tw = VZMULJ(Tu, Tv);
					T1U = VSUB(T1K, T1N);
					T1O = VADD(T1K, T1N);
					TA = LD(&(x[WS(rs, 11)]), ms, &(x[WS(rs, 1)]));
				   }
				   {
					V Tx, TL, T1R, T38, T1V, T13, TQ, TZ, TS, T1Q, TV, TG, TM, T12, T1c;
					V T16;
					T12 = LD(&(x[WS(rs, 4)]), ms, &(x[0]));
					{
					     V TP, TY, T1P, TB, TR;
					     TP = LD(&(x[WS(rs, 24)]), ms, &(x[0]));
					     TY = LD(&(x[WS(rs, 14)]), ms, &(x[0]));
					     TR = LD(&(x[WS(rs, 9)]), ms, &(x[WS(rs, 1)]));
					     Tx = VADD(Tt, Tw);
					     TL = VSUB(Tt, Tw);
					     T1R = VSUB(T1O, T1H);
					     T1P = VADD(T1H, T1O);
					     T38 = VFNMS(LDK(KP618033988), T1T, T1U);
					     T1V = VFMA(LDK(KP618033988), T1U, T1T);
					     TB = VZMULJ(Tz, TA);
					     T13 = VZMULJ(T4, T12);
					     TQ = VZMULJ(T9, TP);
					     TZ = VZMULJ(TX, TY);
					     TS = VZMULJ(T5, TR);
					     T4e = VADD(T1B, T1P);
					     T1Q = VFNMS(LDK(KP250000000), T1P, T1B);
					     TV = LD(&(x[WS(rs, 19)]), ms, &(x[WS(rs, 1)]));
					     TG = VADD(TB, TF);
					     TM = VSUB(TF, TB);
					}
					T1c = LD(&(x[WS(rs, 2)]), ms, &(x[0]));
					{
					     V T14, TT, TJ, T15, T10, TI, T1p, T1f, T1i, T1m;
					     T1f = LD(&(x[WS(rs, 7)]), ms, &(x[WS(rs, 1)]));
					     T14 = VADD(TS, TQ);
					     TT = VSUB(TQ, TS);
					     {
						  V T39, T1S, TW, TH;
						  T39 = VFMA(LDK(KP559016994), T1R, T1Q);
						  T1S = VFNMS(LDK(KP559016994), T1R, T1Q);
						  TW = VZMULJ(TU, TV);
						  TH = VADD(Tx, TG);
						  TJ = VSUB(Tx, TG);
						  TN = VFNMS(LDK(KP618033988), TM, TL);
						  T32 = VFMA(LDK(KP618033988), TL, TM);
						  T1d = VZMULJ(Ty, T1c);
						  T3a = VFMA(LDK(KP869845200), T39, T38);
						  T3f = VFNMS(LDK(KP786782374), T38, T39);
						  T3z = VFMA(LDK(KP066152395), T39, T38);
						  T3H = VFNMS(LDK(KP059835404), T38, T39);
						  T25 = VFMA(LDK(KP987388751), T1S, T1V);
						  T1W = VFNMS(LDK(KP893101515), T1V, T1S);
						  T2v = VFNMS(LDK(KP120146378), T1V, T1S);
						  T2D = VFMA(LDK(KP132830569), T1S, T1V);
						  T15 = VADD(TZ, TW);
						  T10 = VSUB(TW, TZ);
						  TI = VFNMS(LDK(KP250000000), TH, Tq);
						  T4a = VADD(Tq, TH);
						  T1g = VZMULJ(T1e, T1f);
					     }
					     T1p = LD(&(x[WS(rs, 17)]), ms, &(x[WS(rs, 1)]));
					     T1i = LD(&(x[WS(rs, 22)]), ms, &(x[0]));
					     T1m = LD(&(x[WS(rs, 12)]), ms, &(x[0]));
					     T18 = VSUB(T14, T15);
					     T16 = VADD(T14, T15);
					     T2Z = VFNMS(LDK(KP618033988), TT, T10);
					     T11 = VFMA(LDK(KP618033988), T10, TT);
					     T31 = VFNMS(LDK(KP559016994), TJ, TI);
					     TK = VFMA(LDK(KP559016994), TJ, TI);
					     T1q = VZMULJ(T1o, T1p);
					     T1j = VZMULJ(T1h, T1i);
					     T1n = VZMULJ(T1l, T1m);
					}
					T4b = VADD(T13, T16);
					T17 = VFMS(LDK(KP250000000), T16, T13);
				   }
			      }
			 }
			 {
			      V T33, T3i, T3C, T3L, T20, TO, T2y, T2G, T1k, T1w, T1r, T1x, T2Y, T19, T4k;
			      V T4c;
			      T33 = VFMA(LDK(KP893101515), T32, T31);
			      T3i = VFNMS(LDK(KP987388751), T31, T32);
			      T3C = VFNMS(LDK(KP522847744), T32, T31);
			      T3L = VFMA(LDK(KP578046249), T31, T32);
			      T20 = VFMA(LDK(KP269969613), TK, TN);
			      TO = VFNMS(LDK(KP244189809), TN, TK);
			      T2y = VFMA(LDK(KP667278218), TK, TN);
			      T2G = VFNMS(LDK(KP603558818), TN, TK);
			      T1k = VADD(T1g, T1j);
			      T1w = VSUB(T1g, T1j);
			      T1r = VADD(T1n, T1q);
			      T1x = VSUB(T1q, T1n);
			      T2Y = VFMA(LDK(KP559016994), T18, T17);
			      T19 = VFNMS(LDK(KP559016994), T18, T17);
			      T4k = VSUB(T4a, T4b);
			      T4c = VADD(T4a, T4b);
			      {
				   V T2X, To, T35, T1y, T2H, T2z, T1a, T21, T3t, T34, T3n, T3j, T3E, T3Y, T3M;
				   V T3R, T1v, T36, T4l, T4f, T1u, T1s;
				   T2X = VFNMS(LDK(KP559016994), Tn, Tm);
				   To = VFMA(LDK(KP559016994), Tn, Tm);
				   T1u = VSUB(T1r, T1k);
				   T1s = VADD(T1k, T1r);
				   T35 = VFMA(LDK(KP618033988), T1w, T1x);
				   T1y = VFNMS(LDK(KP618033988), T1x, T1w);
				   {
					V T3K, T30, T3h, T3D, T4d, T1t;
					T3K = VFMA(LDK(KP447533225), T2Z, T2Y);
					T30 = VFMA(LDK(KP120146378), T2Z, T2Y);
					T3h = VFNMS(LDK(KP132830569), T2Y, T2Z);
					T3D = VFNMS(LDK(KP494780565), T2Y, T2Z);
					T2H = VFNMS(LDK(KP786782374), T11, T19);
					T2z = VFMA(LDK(KP869845200), T19, T11);
					T1a = VFNMS(LDK(KP667278218), T19, T11);
					T21 = VFMA(LDK(KP603558818), T11, T19);
					T4d = VADD(T1d, T1s);
					T1t = VFNMS(LDK(KP250000000), T1s, T1d);
					T3t = VFNMS(LDK(KP734762448), T33, T30);
					T34 = VFMA(LDK(KP734762448), T33, T30);
					T3n = VFMA(LDK(KP734762448), T3i, T3h);
					T3j = VFNMS(LDK(KP734762448), T3i, T3h);
					T3E = VFNMS(LDK(KP982009705), T3D, T3C);
					T3Y = VFMA(LDK(KP982009705), T3D, T3C);
					T3M = VFNMS(LDK(KP921078979), T3L, T3K);
					T3R = VFMA(LDK(KP921078979), T3L, T3K);
					T1v = VFNMS(LDK(KP559016994), T1u, T1t);
					T36 = VFMA(LDK(KP559016994), T1u, T1t);
					T4l = VSUB(T4d, T4e);
					T4f = VADD(T4d, T4e);
				   }
				   {
					V T2L, T2R, T2j, T2q, T2J, T2B, T2e, T26, T2U, T1Y, T23, T2O;
					{
					     V T2I, T24, T2w, T2E, T48, T42, T3y, T3s, T3V, T45, T2A, T1b, T2h, T2i, T1X;
					     T2L = VFNMS(LDK(KP912575812), T2H, T2G);
					     T2I = VFMA(LDK(KP912575812), T2H, T2G);
					     {
						  V T3A, T3e, T37, T3I, T1z;
						  T3A = VFNMS(LDK(KP667278218), T36, T35);
						  T3e = VFNMS(LDK(KP059835404), T35, T36);
						  T37 = VFMA(LDK(KP066152395), T36, T35);
						  T3I = VFMA(LDK(KP603558818), T35, T36);
						  T24 = VFMA(LDK(KP578046249), T1v, T1y);
						  T1z = VFNMS(LDK(KP522847744), T1y, T1v);
						  T2w = VFNMS(LDK(KP494780565), T1v, T1y);
						  T2E = VFMA(LDK(KP447533225), T1y, T1v);
						  {
						       V T4i, T4g, T4o, T4m;
						       T4i = VSUB(T4c, T4f);
						       T4g = VADD(T4c, T4f);
						       T4o = VMUL(LDK(KP951056516), VFNMS(LDK(KP618033988), T4k, T4l));
						       T4m = VMUL(LDK(KP951056516), VFMA(LDK(KP618033988), T4l, T4k));
						       {
							    V T3Q, T3J, T3b, T3u;
							    T3Q = VFNMS(LDK(KP845997307), T3I, T3H);
							    T3J = VFMA(LDK(KP845997307), T3I, T3H);
							    T3b = VFNMS(LDK(KP772036680), T3a, T37);
							    T3u = VFMA(LDK(KP772036680), T3a, T37);
							    {
								 V T3o, T3g, T3B, T3X, T4h;
								 T3o = VFNMS(LDK(KP772036680), T3f, T3e);
								 T3g = VFMA(LDK(KP772036680), T3f, T3e);
								 T3B = VFNMS(LDK(KP845997307), T3A, T3z);
								 T3X = VFMA(LDK(KP845997307), T3A, T3z);
								 ST(&(x[0]), VADD(T4g, T49), ms, &(x[0]));
								 T4h = VFNMS(LDK(KP250000000), T4g, T49);
								 {
								      V T40, T3N, T3c, T3v;
								      T40 = VFMA(LDK(KP906616052), T3M, T3J);
								      T3N = VFNMS(LDK(KP906616052), T3M, T3J);
								      T3c = VFMA(LDK(KP956723877), T3b, T34);
								      T3v = VFMA(LDK(KP522616830), T3j, T3u);
								      {
									   V T3p, T3k, T3S, T3F;
									   T3p = VFNMS(LDK(KP522616830), T34, T3o);
									   T3k = VFMA(LDK(KP945422727), T3j, T3g);
									   T3S = VFNMS(LDK(KP923225144), T3E, T3B);
									   T3F = VFMA(LDK(KP923225144), T3E, T3B);
									   {
										V T46, T3Z, T4j, T4n;
										T46 = VFNMS(LDK(KP669429328), T3X, T3Y);
										T3Z = VFMA(LDK(KP570584518), T3Y, T3X);
										T4j = VFMA(LDK(KP559016994), T4i, T4h);
										T4n = VFNMS(LDK(KP559016994), T4i, T4h);
										{
										     V T3W, T3O, T3d, T3w;
										     T3W = VFMA(LDK(KP262346850), T3N, T3l);
										     T3O = VMUL(LDK(KP998026728), VFNMS(LDK(KP952936919), T3l, T3N));
										     T3d = VFMA(LDK(KP992114701), T3c, T2X);
										     T3w = VFNMS(LDK(KP690983005), T3v, T3g);
										     {
											  V T3q, T3m, T3T, T43;
											  T3q = VFMA(LDK(KP763932022), T3p, T3b);
											  T3m = VMUL(LDK(KP998026728), VFMA(LDK(KP952936919), T3l, T3k));
											  T3T = VFNMS(LDK(KP997675361), T3S, T3R);
											  T43 = VFNMS(LDK(KP904508497), T3S, T3Q);
											  {
											       V T3G, T3P, T47, T41;
											       T3G = VFMA(LDK(KP949179823), T3F, T2X);
											       T3P = VFNMS(LDK(KP237294955), T3F, T2X);
											       T47 = VFNMS(LDK(KP669429328), T40, T46);
											       T41 = VFMA(LDK(KP618033988), T40, T3Z);
											       ST(&(x[WS(rs, 20)]), VFMAI(T4m, T4j), ms, &(x[0]));
											       ST(&(x[WS(rs, 5)]), VFNMSI(T4m, T4j), ms, &(x[WS(rs, 1)]));
											       ST(&(x[WS(rs, 15)]), VFNMSI(T4o, T4n), ms, &(x[WS(rs, 1)]));
											       ST(&(x[WS(rs, 10)]), VFMAI(T4o, T4n), ms, &(x[0]));
											       {
												    V T3x, T3r, T3U, T44;
												    T3x = VFMA(LDK(KP855719849), T3w, T3t);
												    T3r = VFNMS(LDK(KP855719849), T3q, T3n);
												    ST(&(x[WS(rs, 22)]), VFMAI(T3m, T3d), ms, &(x[0]));
												    ST(&(x[WS(rs, 3)]), VFNMSI(T3m, T3d), ms, &(x[WS(rs, 1)]));
												    T3U = VFMA(LDK(KP560319534), T3T, T3Q);
												    T44 = VFNMS(LDK(KP681693190), T43, T3R);
												    ST(&(x[WS(rs, 23)]), VFMAI(T3O, T3G), ms, &(x[WS(rs, 1)]));
												    ST(&(x[WS(rs, 2)]), VFNMSI(T3O, T3G), ms, &(x[0]));
												    T48 = VMUL(LDK(KP951056516), VFNMS(LDK(KP876306680), T47, T3W));
												    T42 = VMUL(LDK(KP951056516), VFNMS(LDK(KP949179823), T41, T3W));
												    T3y = VMUL(LDK(KP951056516), VFNMS(LDK(KP992114701), T3x, T3l));
												    T3s = VFMA(LDK(KP897376177), T3r, T2X);
												    T3V = VFNMS(LDK(KP949179823), T3U, T3P);
												    T45 = VFNMS(LDK(KP860541664), T44, T3P);
												    T2R = VFNMS(LDK(KP912575812), T2z, T2y);
												    T2A = VFMA(LDK(KP912575812), T2z, T2y);
												    T1b = VFMA(LDK(KP829049696), T1a, TO);
												    T2h = VFNMS(LDK(KP829049696), T1a, TO);
												    T2i = VFNMS(LDK(KP831864738), T1W, T1z);
												    T1X = VFMA(LDK(KP831864738), T1W, T1z);
											       }
											  }
										     }
										}
									   }
								      }
								 }
							    }
						       }
						  }
					     }
					     {
						  V T2M, T2F, T2x, T2S, T2T, T2N;
						  T2M = VFNMS(LDK(KP958953096), T2E, T2D);
						  T2F = VFMA(LDK(KP958953096), T2E, T2D);
						  ST(&(x[WS(rs, 17)]), VFMAI(T3y, T3s), ms, &(x[WS(rs, 1)]));
						  ST(&(x[WS(rs, 8)]), VFNMSI(T3y, T3s), ms, &(x[0]));
						  ST(&(x[WS(rs, 12)]), VFMAI(T42, T3V), ms, &(x[0]));
						  ST(&(x[WS(rs, 13)]), VFNMSI(T42, T3V), ms, &(x[WS(rs, 1)]));
						  ST(&(x[WS(rs, 18)]), VFNMSI(T48, T45), ms, &(x[0]));
						  ST(&(x[WS(rs, 7)]), VFMAI(T48, T45), ms, &(x[WS(rs, 1)]));
						  T2j = VFMA(LDK(KP559154169), T2i, T2h);
						  T2q = VFNMS(LDK(KP683113946), T2h, T2i);
						  T2x = VFNMS(LDK(KP867381224), T2w, T2v);
						  T2S = VFMA(LDK(KP867381224), T2w, T2v);
						  T2J = VFMA(LDK(KP894834959), T2I, T2F);
						  T2T = VFMA(LDK(KP447417479), T2I, T2S);
						  T2B = VFNMS(LDK(KP809385824), T2A, T2x);
						  T2N = VFMA(LDK(KP447417479), T2A, T2M);
						  T2e = VFMA(LDK(KP831864738), T25, T24);
						  T26 = VFNMS(LDK(KP831864738), T25, T24);
						  T2U = VFNMS(LDK(KP763932022), T2T, T2F);
						  T1Y = VFMA(LDK(KP904730450), T1X, T1b);
						  T23 = VFNMS(LDK(KP904730450), T1X, T1b);
						  T2O = VFMA(LDK(KP690983005), T2N, T2x);
					     }
					}
					{
					     V T2C, T22, T2d, T2K;
					     T2C = VFNMS(LDK(KP992114701), T2B, To);
					     T22 = VFMA(LDK(KP916574801), T21, T20);
					     T2d = VFNMS(LDK(KP916574801), T21, T20);
					     T2K = VMUL(LDK(KP951056516), VFNMS(LDK(KP992114701), T2J, T2c));
					     {
						  V T27, T2P, T2f, T2k, T2n, T2V;
						  T2V = VFNMS(LDK(KP999544308), T2U, T2R);
						  T27 = VFNMS(LDK(KP904730450), T26, T23);
						  T2t = VFMA(LDK(KP968583161), T1Y, To);
						  T1Z = VFNMS(LDK(KP242145790), T1Y, To);
						  T2P = VFNMS(LDK(KP999544308), T2O, T2L);
						  T2f = VFMA(LDK(KP904730450), T2e, T2d);
						  T2k = VFNMS(LDK(KP904730450), T2e, T2d);
						  T2n = VADD(T22, T23);
						  ST(&(x[WS(rs, 21)]), VFNMSI(T2K, T2C), ms, &(x[WS(rs, 1)]));
						  ST(&(x[WS(rs, 4)]), VFMAI(T2K, T2C), ms, &(x[0]));
						  T2W = VMUL(LDK(KP951056516), VFNMS(LDK(KP803003575), T2V, T2c));
						  T28 = VFNMS(LDK(KP618033988), T27, T22);
						  T2Q = VFNMS(LDK(KP803003575), T2P, To);
						  T2r = VFMA(LDK(KP617882369), T2k, T2q);
						  T2g = VFNMS(LDK(KP242145790), T2f, T2c);
						  T2u = VMUL(LDK(KP951056516), VFMA(LDK(KP968583161), T2f, T2c));
						  T2o = VFNMS(LDK(KP683113946), T2n, T26);
						  T2l = VFMA(LDK(KP559016994), T2k, T2j);
					     }
					}
				   }
			      }
			 }
		    }
	       }
	       {
		    V T29, T2s, T2p, T2m;
		    T29 = VFNMS(LDK(KP876091699), T28, T1Z);
		    ST(&(x[WS(rs, 9)]), VFMAI(T2W, T2Q), ms, &(x[WS(rs, 1)]));
		    ST(&(x[WS(rs, 16)]), VFNMSI(T2W, T2Q), ms, &(x[0]));
		    T2s = VMUL(LDK(KP951056516), VFNMS(LDK(KP876306680), T2r, T2g));
		    ST(&(x[WS(rs, 24)]), VFMAI(T2u, T2t), ms, &(x[0]));
		    ST(&(x[WS(rs, 1)]), VFNMSI(T2u, T2t), ms, &(x[WS(rs, 1)]));
		    T2p = VFMA(LDK(KP792626838), T2o, T1Z);
		    T2m = VMUL(LDK(KP951056516), VFMA(LDK(KP968583161), T2l, T2g));
		    ST(&(x[WS(rs, 11)]), VFNMSI(T2s, T2p), ms, &(x[WS(rs, 1)]));
		    ST(&(x[WS(rs, 14)]), VFMAI(T2s, T2p), ms, &(x[0]));
		    ST(&(x[WS(rs, 19)]), VFMAI(T2m, T29), ms, &(x[WS(rs, 1)]));
		    ST(&(x[WS(rs, 6)]), VFNMSI(T2m, T29), ms, &(x[0]));
	       }
	  }
     }
     VLEAVE();
}

static const tw_instr twinstr[] = {
     VTW(0, 1),
     VTW(0, 3),
     VTW(0, 9),
     VTW(0, 24),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 25, XSIMD_STRING("t3fv_25"), twinstr, &GENUS, {87, 100, 181, 0}, 0, 0, 0 };

void XSIMD(codelet_t3fv_25) (planner *p) {
     X(kdft_dit_register) (p, t3fv_25, &desc);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_twiddle_c.native -simd -compact -variables 4 -pipeline-latency 8 -twiddle-log3 -precompute-twiddles -no-generate-bytw -n 25 -name t3fv_25 -include t3f.h */

/*
 * This function contains 268 FP additions, 228 FP multiplications,
 * (or, 190 additions, 150 multiplications, 78 fused multiply/add),
 * 123 stack variables, 40 constants, and 50 memory accesses
 */
#include "t3f.h"

static void t3fv_25(R *ri, R *ii, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DVK(KP998026728, +0.998026728428271561952336806863450553336905220);
     DVK(KP125581039, +0.125581039058626752152356449131262266244969664);
     DVK(KP1_996053456, +1.996053456856543123904673613726901106673810439);
     DVK(KP062790519, +0.062790519529313376076178224565631133122484832);
     DVK(KP809016994, +0.809016994374947424102293417182819058860154590);
     DVK(KP309016994, +0.309016994374947424102293417182819058860154590);
     DVK(KP1_369094211, +1.369094211857377347464566715242418539779038465);
     DVK(KP728968627, +0.728968627421411523146730319055259111372571664);
     DVK(KP963507348, +0.963507348203430549974383005744259307057084020);
     DVK(KP876306680, +0.876306680043863587308115903922062583399064238);
     DVK(KP497379774, +0.497379774329709576484567492012895936835134813);
     DVK(KP968583161, +0.968583161128631119490168375464735813836012403);
     DVK(KP684547105, +0.684547105928688673732283357621209269889519233);
     DVK(KP1_457937254, +1.457937254842823046293460638110518222745143328);
     DVK(KP481753674, +0.481753674101715274987191502872129653528542010);
     DVK(KP1_752613360, +1.752613360087727174616231807844125166798128477);
     DVK(KP248689887, +0.248689887164854788242283746006447968417567406);
     DVK(KP1_937166322, +1.937166322257262238980336750929471627672024806);
     DVK(KP992114701, +0.992114701314477831049793042785778521453036709);
     DVK(KP250666467, +0.250666467128608490746237519633017587885836494);
     DVK(KP425779291, +0.425779291565072648862502445744251703979973042);
     DVK(KP1_809654104, +1.809654104932039055427337295865395187940827822);
     DVK(KP1_274847979, +1.274847979497379420353425623352032390869834596);
     DVK(KP770513242, +0.770513242775789230803009636396177847271667672);
     DVK(KP844327925, +0.844327925502015078548558063966681505381659241);
     DVK(KP1_071653589, +1.071653589957993236542617535735279956127150691);
     DVK(KP125333233, +0.125333233564304245373118759816508793942918247);
     DVK(KP1_984229402, +1.984229402628955662099586085571557042906073418);
     DVK(KP904827052, +0.904827052466019527713668647932697593970413911);
     DVK(KP851558583, +0.851558583130145297725004891488503407959946084);
     DVK(KP637423989, +0.637423989748689710176712811676016195434917298);
     DVK(KP1_541026485, +1.541026485551578461606019272792355694543335344);
     DVK(KP535826794, +0.535826794978996618271308767867639978063575346);
     DVK(KP1_688655851, +1.688655851004030157097116127933363010763318483);
     DVK(KP293892626, +0.293892626146236564584352977319536384298826219);
     DVK(KP475528258, +0.475528258147576786058219666689691071702849317);
     DVK(KP587785252, +0.587785252292473129168705954639072768597652438);
     DVK(KP951056516, +0.951056516295153572116439333379382143405698634);
     DVK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DVK(KP559016994, +0.559016994374947424102293417182819058860154590);
     {
	  INT m;
	  R *x;
	  x = ri;
	  for (m = mb, W = W + (mb * ((TWVL / VL) * 8)); m < me; m = m + VL, x = x + (VL * ms), W = W + (TWVL * 8), MAKE_VOLATILE_STRIDE(25, rs)) {
	       V T1, T4, T2, T3, TA, Td, Tp, Tw, Tx, T1G, T1j, T5, T1c, T8, T9;
	       V Ts, T1J, Tg, T1C, T1m, TX, TB, T1f, TU;
	       T1 = LDW(&(W[0]));
	       T4 = LDW(&(W[TWVL * 4]));
	       T2 = LDW(&(W[TWVL * 2]));
	       T3 = VZMUL(T1, T2);
	       TA = VZMULJ(T1, T4);
	       Td = VZMUL(T1, T4);
	       Tp = VZMULJ(T2, T4);
	       Tw = VZMULJ(T1, T2);
	       Tx = VZMUL(Tw, T4);
	       T1G = VZMUL(T3, T4);
	       T1j = VZMUL(T2, T4);
	       T5 = VZMULJ(T3, T4);
	       T1c = VZMULJ(Tw, T4);
	       T8 = LDW(&(W[TWVL * 6]));
	       T9 = VZMULJ(T3, T8);
	       Ts = VZMULJ(T2, T8);
	       T1J = VZMULJ(Tp, T8);
	       Tg = VZMULJ(T4, T8);
	       T1C = VZMULJ(T1, T8);
	       T1m = VZMULJ(T1c, T8);
	       TX = VZMULJ(T5, T8);
	       TB = VZMULJ(TA, T8);
	       T1f = VZMULJ(Tw, T8);
	       TU = VZMULJ(Td, T8);
	       {
		    V Tl, Tk, Tm, Tn, T20, T2R, T22, T1V, T2K, T1S, T3A, T2L, TN, T2G, TK;
		    V T3w, T2H, T19, T2D, T16, T3x, T2E, T1y, T2N, T1v, T3z, T2O;
		    {
			 V Tf, Ti, Tj, T7, Tb, Tc, T21;
			 Tl = LD(&(x[0]), ms, &(x[0]));
			 {
			      V Te, Th, T6, Ta;
			      Te = LD(&(x[WS(rs, 10)]), ms, &(x[0]));
			      Tf = VZMULJ(Td, Te);
			      Th = LD(&(x[WS(rs, 15)]), ms, &(x[WS(rs, 1)]));
			      Ti = VZMULJ(Tg, Th);
			      Tj = VADD(Tf, Ti);
			      T6 = LD(&(x[WS(rs, 5)]), ms, &(x[WS(rs, 1)]));
			      T7 = VZMULJ(T5, T6);
			      Ta = LD(&(x[WS(rs, 20)]), ms, &(x[0]));
			      Tb = VZMULJ(T9, Ta);
			      Tc = VADD(T7, Tb);
			 }
			 Tk = VMUL(LDK(KP559016994), VSUB(Tc, Tj));
			 Tm = VADD(Tc, Tj);
			 Tn = VFNMS(LDK(KP250000000), Tm, Tl);
			 T20 = VSUB(T7, Tb);
			 T21 = VSUB(Tf, Ti);
			 T2R = VMUL(LDK(KP951056516), T21);
			 T22 = VFMA(LDK(KP951056516), T20, VMUL(LDK(KP587785252), T21));
		    }
		    {
			 V T1P, T1I, T1L, T1M, T1B, T1E, T1F, T1O;
			 T1O = LD(&(x[WS(rs, 3)]), ms, &(x[WS(rs, 1)]));
			 T1P = VZMULJ(T2, T1O);
			 {
			      V T1H, T1K, T1A, T1D;
			      T1H = LD(&(x[WS(rs, 13)]), ms, &(x[WS(rs, 1)]));
			      T1I = VZMULJ(T1G, T1H);
			      T1K = LD(&(x[WS(rs, 18)]), ms, &(x[0]));
			      T1L = VZMULJ(T1J, T1K);
			      T1M = VADD(T1I, T1L);
			      T1A = LD(&(x[WS(rs, 8)]), ms, &(x[0]));
			      T1B = VZMULJ(TA, T1A);
			      T1D = LD(&(x[WS(rs, 23)]), ms, &(x[WS(rs, 1)]));
			      T1E = VZMULJ(T1C, T1D);
			      T1F = VADD(T1B, T1E);
			 }
			 {
			      V T1T, T1U, T1N, T1Q, T1R;
			      T1T = VSUB(T1B, T1E);
			      T1U = VSUB(T1I, T1L);
			      T1V = VFMA(LDK(KP475528258), T1T, VMUL(LDK(KP293892626), T1U));
			      T2K = VFNMS(LDK(KP293892626), T1T, VMUL(LDK(KP475528258), T1U));
			      T1N = VMUL(LDK(KP559016994), VSUB(T1F, T1M));
			      T1Q = VADD(T1F, T1M);
			      T1R = VFNMS(LDK(KP250000000), T1Q, T1P);
			      T1S = VADD(T1N, T1R);
			      T3A = VADD(T1P, T1Q);
			      T2L = VSUB(T1R, T1N);
			 }
		    }
		    {
			 V TH, Tz, TD, TE, Tr, Tu, Tv, TG;
			 TG = LD(&(x[WS(rs, 1)]), ms, &(x[WS(rs, 1)]));
			 TH = VZMULJ(T1, TG);
			 {
			      V Ty, TC, Tq, Tt;
			      Ty = LD(&(x[WS(rs, 11)]), ms, &(x[WS(rs, 1)]));
			      Tz = VZMULJ(Tx, Ty);
			      TC = LD(&(x[WS(rs, 16)]), ms, &(x[0]));
			      TD = VZMULJ(TB, TC);
			      TE = VADD(Tz, TD);
			      Tq = LD(&(x[WS(rs, 6)]), ms, &(x[0]));
			      Tr = VZMULJ(Tp, Tq);
			      Tt = LD(&(x[WS(rs, 21)]), ms, &(x[WS(rs, 1)]));
			      Tu = VZMULJ(Ts, Tt);
			      Tv = VADD(Tr, Tu);
			 }
			 {
			      V TL, TM, TF, TI, TJ;
			      TL = VSUB(Tr, Tu);
			      TM = VSUB(Tz, TD);
			      TN = VFMA(LDK(KP475528258), TL, VMUL(LDK(KP293892626), TM));
			      T2G = VFNMS(LDK(KP293892626), TL, VMUL(LDK(KP475528258), TM));
			      TF = VMUL(LDK(KP559016994), VSUB(Tv, TE));
			      TI = VADD(Tv, TE);
			      TJ = VFNMS(LDK(KP250000000), TI, TH);
			      TK = VADD(TF, TJ);
			      T3w = VADD(TH, TI);
			      T2H = VSUB(TJ, TF);
			 }
		    }
		    {
			 V T13, TW, TZ, T10, TQ, TS, TT, T12;
			 T12 = LD(&(x[WS(rs, 4)]), ms, &(x[0]));
			 T13 = VZMULJ(T3, T12);
			 {
			      V TV, TY, TP, TR;
			      TV = LD(&(x[WS(rs, 14)]), ms, &(x[0]));
			      TW = VZMULJ(TU, TV);
			      TY = LD(&(x[WS(rs, 19)]), ms, &(x[WS(rs, 1)]));
			      TZ = VZMULJ(TX, TY);
			      T10 = VADD(TW, TZ);
			      TP = LD(&(x[WS(rs, 9)]), ms, &(x[WS(rs, 1)]));
			      TQ = VZMULJ(T4, TP);
			      TR = LD(&(x[WS(rs, 24)]), ms, &(x[0]));
			      TS = VZMULJ(T8, TR);
			      TT = VADD(TQ, TS);
			 }
			 {
			      V T17, T18, T11, T14, T15;
			      T17 = VSUB(TQ, TS);
			      T18 = VSUB(TW, TZ);
			      T19 = VFMA(LDK(KP475528258), T17, VMUL(LDK(KP293892626), T18));
			      T2D = VFNMS(LDK(KP293892626), T17, VMUL(LDK(KP475528258), T18));
			      T11 = VMUL(LDK(KP559016994), VSUB(TT, T10));
			      T14 = VADD(TT, T10);
			      T15 = VFNMS(LDK(KP250000000), T14, T13);
			      T16 = VADD(T11, T15);
			      T3x = VADD(T13, T14);
			      T2E = VSUB(T15, T11);
			 }
		    }
		    {
			 V T1s, T1l, T1o, T1p, T1e, T1h, T1i, T1r;
			 T1r = LD(&(x[WS(rs, 2)]), ms, &(x[0]));
			 T1s = VZMULJ(Tw, T1r);
			 {
			      V T1k, T1n, T1d, T1g;
			      T1k = LD(&(x[WS(rs, 12)]), ms, &(x[0]));
			      T1l = VZMULJ(T1j, T1k);
			      T1n = LD(&(x[WS(rs, 17)]), ms, &(x[WS(rs, 1)]));
			      T1o = VZMULJ(T1m, T1n);
			      T1p = VADD(T1l, T1o);
			      T1d = LD(&(x[WS(rs, 7)]), ms, &(x[WS(rs, 1)]));
			      T1e = VZMULJ(T1c, T1d);
			      T1g = LD(&(x[WS(rs, 22)]), ms, &(x[0]));
			      T1h = VZMULJ(T1f, T1g);
			      T1i = VADD(T1e, T1h);
			 }
			 {
			      V T1w, T1x, T1q, T1t, T1u;
			      T1w = VSUB(T1e, T1h);
			      T1x = VSUB(T1l, T1o);
			      T1y = VFMA(LDK(KP475528258), T1w, VMUL(LDK(KP293892626), T1x));
			      T2N = VFNMS(LDK(KP293892626), T1w, VMUL(LDK(KP475528258), T1x));
			      T1q = VMUL(LDK(KP559016994), VSUB(T1i, T1p));
			      T1t = VADD(T1i, T1p);
			      T1u = VFNMS(LDK(KP250000000), T1t, T1s);
			      T1v = VADD(T1q, T1u);
			      T3z = VADD(T1s, T1t);
			      T2O = VSUB(T1u, T1q);
			 }
		    }
		    {
			 V T3J, T3K, T3D, T3E, T3C, T3F, T3L, T3G;
			 {
			      V T3H, T3I, T3y, T3B;
			      T3H = VSUB(T3w, T3x);
			      T3I = VSUB(T3z, T3A);
			      T3J = VBYI(VFMA(LDK(KP951056516), T3H, VMUL(LDK(KP587785252), T3I)));
			      T3K = VBYI(VFNMS(LDK(KP587785252), T3H, VMUL(LDK(KP951056516), T3I)));
			      T3D = VADD(Tl, Tm);
			      T3y = VADD(T3w, T3x);
			      T3B = VADD(T3z, T3A);
			      T3E = VADD(T3y, T3B);
			      T3C = VMUL(LDK(KP559016994), VSUB(T3y, T3B));
			      T3F = VFNMS(LDK(KP250000000), T3E, T3D);
			 }
			 ST(&(x[0]), VADD(T3D, T3E), ms, &(x[0]));
			 T3L = VSUB(T3F, T3C);
			 ST(&(x[WS(rs, 10)]), VADD(T3K, T3L), ms, &(x[0]));
			 ST(&(x[WS(rs, 15)]), VSUB(T3L, T3K), ms, &(x[WS(rs, 1)]));
			 T3G = VADD(T3C, T3F);
			 ST(&(x[WS(rs, 5)]), VSUB(T3G, T3J), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 20)]), VADD(T3J, T3G), ms, &(x[0]));
		    }
		    {
			 V To, T2n, T2o, T2p, T2x, T2y, T2z, T2u, T2v, T2w, T2q, T2r, T2s, T29, T2i;
			 V T2e, T2g, T1Y, T2j, T2b, T2c, T2B, T2C;
			 To = VADD(Tk, Tn);
			 T2n = VFMA(LDK(KP1_688655851), TN, VMUL(LDK(KP535826794), TK));
			 T2o = VFMA(LDK(KP1_541026485), T19, VMUL(LDK(KP637423989), T16));
			 T2p = VSUB(T2n, T2o);
			 T2x = VFMA(LDK(KP851558583), T1y, VMUL(LDK(KP904827052), T1v));
			 T2y = VFMA(LDK(KP1_984229402), T1V, VMUL(LDK(KP125333233), T1S));
			 T2z = VADD(T2x, T2y);
			 T2u = VFNMS(LDK(KP844327925), TK, VMUL(LDK(KP1_071653589), TN));
			 T2v = VFNMS(LDK(KP1_274847979), T19, VMUL(LDK(KP770513242), T16));
			 T2w = VADD(T2u, T2v);
			 T2q = VFNMS(LDK(KP425779291), T1v, VMUL(LDK(KP1_809654104), T1y));
			 T2r = VFNMS(LDK(KP992114701), T1S, VMUL(LDK(KP250666467), T1V));
			 T2s = VADD(T2q, T2r);
			 {
			      V T23, T24, T25, T26, T27, T28;
			      T23 = VFMA(LDK(KP1_937166322), TN, VMUL(LDK(KP248689887), TK));
			      T24 = VFMA(LDK(KP1_071653589), T19, VMUL(LDK(KP844327925), T16));
			      T25 = VADD(T23, T24);
			      T26 = VFMA(LDK(KP1_752613360), T1y, VMUL(LDK(KP481753674), T1v));
			      T27 = VFMA(LDK(KP1_457937254), T1V, VMUL(LDK(KP684547105), T1S));
			      T28 = VADD(T26, T27);
			      T29 = VADD(T25, T28);
			      T2i = VSUB(T27, T26);
			      T2e = VMUL(LDK(KP559016994), VSUB(T28, T25));
			      T2g = VSUB(T24, T23);
			 }
			 {
			      V TO, T1a, T1b, T1z, T1W, T1X;
			      TO = VFNMS(LDK(KP497379774), TN, VMUL(LDK(KP968583161), TK));
			      T1a = VFNMS(LDK(KP1_688655851), T19, VMUL(LDK(KP535826794), T16));
			      T1b = VADD(TO, T1a);
			      T1z = VFNMS(LDK(KP963507348), T1y, VMUL(LDK(KP876306680), T1v));
			      T1W = VFNMS(LDK(KP1_369094211), T1V, VMUL(LDK(KP728968627), T1S));
			      T1X = VADD(T1z, T1W);
			      T1Y = VADD(T1b, T1X);
			      T2j = VMUL(LDK(KP559016994), VSUB(T1b, T1X));
			      T2b = VSUB(T1a, TO);
			      T2c = VSUB(T1z, T1W);
			 }
			 {
			      V T1Z, T2a, T2t, T2A;
			      T1Z = VADD(To, T1Y);
			      T2a = VBYI(VADD(T22, T29));
			      ST(&(x[WS(rs, 1)]), VSUB(T1Z, T2a), ms, &(x[WS(rs, 1)]));
			      ST(&(x[WS(rs, 24)]), VADD(T1Z, T2a), ms, &(x[0]));
			      T2t = VADD(To, VADD(T2p, T2s));
			      T2A = VBYI(VADD(T22, VSUB(T2w, T2z)));
			      ST(&(x[WS(rs, 21)]), VSUB(T2t, T2A), ms, &(x[WS(rs, 1)]));
			      ST(&(x[WS(rs, 4)]), VADD(T2t, T2A), ms, &(x[0]));
			 }
			 T2B = VBYI(VADD(T22, VFMA(LDK(KP309016994), T2w, VFMA(LDK(KP587785252), VSUB(T2r, T2q), VFNMS(LDK(KP951056516), VADD(T2n, T2o), VMUL(LDK(KP809016994), T2z))))));
			 T2C = VFMA(LDK(KP309016994), T2p, VFMA(LDK(KP951056516), VSUB(T2u, T2v), VFMA(LDK(KP587785252), VSUB(T2y, T2x), VFNMS(LDK(KP809016994), T2s, To))));
			 ST(&(x[WS(rs, 9)]), VADD(T2B, T2C), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 16)]), VSUB(T2C, T2B), ms, &(x[0]));
			 {
			      V T2f, T2l, T2k, T2m, T2d, T2h;
			      T2d = VFMS(LDK(KP250000000), T29, T22);
			      T2f = VBYI(VADD(VFMA(LDK(KP587785252), T2b, VMUL(LDK(KP951056516), T2c)), VSUB(T2d, T2e)));
			      T2l = VBYI(VADD(VFNMS(LDK(KP587785252), T2c, VMUL(LDK(KP951056516), T2b)), VADD(T2d, T2e)));
			      T2h = VFNMS(LDK(KP250000000), T1Y, To);
			      T2k = VFMA(LDK(KP587785252), T2g, VFNMS(LDK(KP951056516), T2i, VSUB(T2h, T2j)));
			      T2m = VFMA(LDK(KP951056516), T2g, VADD(T2j, VFMA(LDK(KP587785252), T2i, T2h)));
			      ST(&(x[WS(rs, 11)]), VADD(T2f, T2k), ms, &(x[WS(rs, 1)]));
			      ST(&(x[WS(rs, 19)]), VSUB(T2m, T2l), ms, &(x[WS(rs, 1)]));
			      ST(&(x[WS(rs, 14)]), VSUB(T2k, T2f), ms, &(x[0]));
			      ST(&(x[WS(rs, 6)]), VADD(T2l, T2m), ms, &(x[0]));
			 }
		    }
		    {
			 V T2S, T2U, T2F, T2I, T2J, T2Y, T2Z, T30, T2M, T2P, T2Q, T2V, T2W, T2X, T3a;
			 V T3l, T3b, T3k, T3f, T3p, T3i, T3o, T32, T33;
			 T2S = VFNMS(LDK(KP587785252), T20, T2R);
			 T2U = VSUB(Tn, Tk);
			 T2F = VFNMS(LDK(KP125333233), T2E, VMUL(LDK(KP1_984229402), T2D));
			 T2I = VFMA(LDK(KP1_457937254), T2G, VMUL(LDK(KP684547105), T2H));
			 T2J = VSUB(T2F, T2I);
			 T2Y = VFNMS(LDK(KP1_996053456), T2N, VMUL(LDK(KP062790519), T2O));
			 T2Z = VFMA(LDK(KP1_541026485), T2K, VMUL(LDK(KP637423989), T2L));
			 T30 = VSUB(T2Y, T2Z);
			 T2M = VFNMS(LDK(KP770513242), T2L, VMUL(LDK(KP1_274847979), T2K));
			 T2P = VFMA(LDK(KP125581039), T2N, VMUL(LDK(KP998026728), T2O));
			 T2Q = VSUB(T2M, T2P);
			 T2V = VFNMS(LDK(KP1_369094211), T2G, VMUL(LDK(KP728968627), T2H));
			 T2W = VFMA(LDK(KP250666467), T2D, VMUL(LDK(KP992114701), T2E));
			 T2X = VSUB(T2V, T2W);
			 {
			      V T34, T35, T36, T37, T38, T39;
			      T34 = VFNMS(LDK(KP481753674), T2H, VMUL(LDK(KP1_752613360), T2G));
			      T35 = VFMA(LDK(KP851558583), T2D, VMUL(LDK(KP904827052), T2E));
			      T36 = VSUB(T34, T35);
			      T37 = VFNMS(LDK(KP844327925), T2O, VMUL(LDK(KP1_071653589), T2N));
			      T38 = VFNMS(LDK(KP998026728), T2L, VMUL(LDK(KP125581039), T2K));
			      T39 = VADD(T37, T38);
			      T3a = VMUL(LDK(KP559016994), VSUB(T36, T39));
			      T3l = VSUB(T37, T38);
			      T3b = VADD(T36, T39);
			      T3k = VADD(T34, T35);
			 }
			 {
			      V T3d, T3e, T3m, T3g, T3h, T3n;
			      T3d = VFNMS(LDK(KP425779291), T2E, VMUL(LDK(KP1_809654104), T2D));
			      T3e = VFMA(LDK(KP963507348), T2G, VMUL(LDK(KP876306680), T2H));
			      T3m = VADD(T3e, T3d);
			      T3g = VFMA(LDK(KP1_688655851), T2N, VMUL(LDK(KP535826794), T2O));
			      T3h = VFMA(LDK(KP1_996053456), T2K, VMUL(LDK(KP062790519), T2L));
			      T3n = VADD(T3g, T3h);
			      T3f = VSUB(T3d, T3e);
			      T3p = VADD(T3m, T3n);
			      T3i = VSUB(T3g, T3h);
			      T3o = VMUL(LDK(KP559016994), VSUB(T3m, T3n));
			 }
			 {
			      V T3u, T3v, T2T, T31;
			      T3u = VBYI(VADD(T2S, T3b));
			      T3v = VADD(T2U, T3p);
			      ST(&(x[WS(rs, 2)]), VADD(T3u, T3v), ms, &(x[0]));
			      ST(&(x[WS(rs, 23)]), VSUB(T3v, T3u), ms, &(x[WS(rs, 1)]));
			      T2T = VBYI(VSUB(VADD(T2J, T2Q), T2S));
			      T31 = VADD(T2U, VADD(T2X, T30));
			      ST(&(x[WS(rs, 3)]), VADD(T2T, T31), ms, &(x[WS(rs, 1)]));
			      ST(&(x[WS(rs, 22)]), VSUB(T31, T2T), ms, &(x[0]));
			 }
			 T32 = VFMA(LDK(KP309016994), T2X, VFNMS(LDK(KP809016994), T30, VFNMS(LDK(KP587785252), VADD(T2P, T2M), VFNMS(LDK(KP951056516), VADD(T2I, T2F), T2U))));
			 T33 = VBYI(VSUB(VFNMS(LDK(KP587785252), VADD(T2Y, T2Z), VFNMS(LDK(KP809016994), T2Q, VFNMS(LDK(KP951056516), VADD(T2V, T2W), VMUL(LDK(KP309016994), T2J)))), T2S));
			 ST(&(x[WS(rs, 17)]), VSUB(T32, T33), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 8)]), VADD(T32, T33), ms, &(x[0]));
			 {
			      V T3j, T3s, T3r, T3t, T3c, T3q;
			      T3c = VFNMS(LDK(KP250000000), T3b, T2S);
			      T3j = VBYI(VADD(T3a, VADD(T3c, VFNMS(LDK(KP587785252), T3i, VMUL(LDK(KP951056516), T3f)))));
			      T3s = VBYI(VADD(T3c, VSUB(VFMA(LDK(KP587785252), T3f, VMUL(LDK(KP951056516), T3i)), T3a)));
			      T3q = VFNMS(LDK(KP250000000), T3p, T2U);
			      T3r = VFMA(LDK(KP951056516), T3k, VFMA(LDK(KP587785252), T3l, VADD(T3o, T3q)));
			      T3t = VFMA(LDK(KP587785252), T3k, VSUB(VFNMS(LDK(KP951056516), T3l, T3q), T3o));
			      ST(&(x[WS(rs, 7)]), VADD(T3j, T3r), ms, &(x[WS(rs, 1)]));
			      ST(&(x[WS(rs, 13)]), VSUB(T3t, T3s), ms, &(x[WS(rs, 1)]));
			      ST(&(x[WS(rs, 18)]), VSUB(T3r, T3j), ms, &(x[0]));
			      ST(&(x[WS(rs, 12)]), VADD(T3s, T3t), ms, &(x[0]));
			 }
		    }
	       }
	  }
     }
     VLEAVE();
}

static const tw_instr twinstr[] = {
     VTW(0, 1),
     VTW(0, 3),
     VTW(0, 9),
     VTW(0, 24),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 25, XSIMD_STRING("t3fv_25"), twinstr, &GENUS, {190, 150, 78, 0}, 0, 0, 0 };

void XSIMD(codelet_t3fv_25) (planner *p) {
     X(kdft_dit_register) (p, t3fv_25, &desc);
}
#endif				/* HAVE_FMA */
