/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.impl.bundle.bindex.ant;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.osgi.impl.bundle.bindex.Indexer;

public class BindexTask
extends Task {
    private Indexer indexer = new Indexer();
    private List<FileSet> filesets = new LinkedList<FileSet>();

    public void setName(String name) {
        this.indexer.setRepositoryName(name);
    }

    public void setVerbose(boolean verbose) {
        this.indexer.setVerbose(verbose);
    }

    public void setUrlTemplate(String urlTemplate) {
        this.indexer.setUrlTemplate(urlTemplate);
    }

    public void setLicenseURL(String license) throws MalformedURLException {
        this.indexer.setLicenseURL(license);
    }

    public void setStylesheet(String stylesheet) {
        this.indexer.setStylesheet(stylesheet);
    }

    public void setRootURL(String root) throws MalformedURLException {
        this.indexer.setRootURL(root);
    }

    public void setRepositoryFile(String repositoryFile) {
        this.indexer.setRepositoryFile(new File(repositoryFile));
    }

    public void addFileset(FileSet fs) {
        this.filesets.add(fs);
    }

    public void execute() throws BuildException {
        this.indexer.printCopyright(System.err);
        ArrayList<File> fileList = new ArrayList<File>();
        for (FileSet fs : this.filesets) {
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File basedir = ds.getBasedir();
            String[] files = ds.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                fileList.add(new File(basedir, files[i]));
            }
        }
        try {
            this.indexer.run(fileList);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }
}

