/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.impl.bundle.bindex.cli;

import java.io.File;
import java.util.ArrayList;
import org.osgi.impl.bundle.bindex.Indexer;

public class Index {
    public static void main(String[] args) throws Exception {
        Indexer index = new Indexer();
        index.setRepositoryFile(new File("repository.xml"));
        boolean verbose = false;
        ArrayList<File> fileList = new ArrayList<File>();
        for (int i = 0; i < args.length; ++i) {
            try {
                if (args[i].startsWith("-n")) {
                    index.setRepositoryName(args[++i]);
                    continue;
                }
                if (args[i].equals("-stylesheet")) {
                    index.setStylesheet(args[++i]);
                    continue;
                }
                if (args[i].startsWith("-r")) {
                    index.setRepositoryFile(new File(args[++i]));
                    continue;
                }
                if (args[i].startsWith("-v")) {
                    index.setVerbose(true);
                    verbose = true;
                    continue;
                }
                if (args[i].startsWith("-d")) {
                    index.setRootURL(args[++i]);
                    continue;
                }
                if (args[i].startsWith("-t")) {
                    index.setUrlTemplate(args[++i]);
                    continue;
                }
                if (args[i].startsWith("-l")) {
                    index.setLicenseURL(args[++i]);
                    continue;
                }
                if (args[i].startsWith("-h")) {
                    System.err.println("bindex [-t \"%s\" symbolic name \"%v\" version \"%f\" filename \"%p\" dirpath ]\n[-d rootFile]\n[-r repository.(xml|zip)]\n[-h]\n[-l file:license.html]\n[-v]\n[-stylesheet http://www.osgi.org/www/obr2html.xsl]\n<jar file>*");
                    continue;
                }
                fileList.add(new File(args[i]));
                continue;
            }
            catch (Exception e) {
                System.err.println("Error in " + args[i] + " : " + e.getMessage());
                System.exit(1);
            }
        }
        if (verbose) {
            index.printCopyright(System.err);
        }
        index.run(fileList);
    }
}

