/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.bindex.impl;

import aQute.bnd.annotation.component.Component;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.impl.bundle.bindex.Indexer;
import org.osgi.impl.bundle.obr.resource.RepositoryImpl;
import org.osgi.impl.bundle.obr.resource.ResourceImpl;
import org.osgi.impl.bundle.obr.resource.ResourceImplComparator;
import org.osgi.impl.bundle.obr.resource.Tag;
import org.osgi.service.bindex.BundleIndexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class BundleIndexerImpl
implements BundleIndexer {
    private Indexer indexer = new Indexer();
    OutputStream out;

    public BundleIndexerImpl() {
        this.indexer.setRepositoryFile(new File("repository.xml"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void index(Set<File> jarFiles, OutputStream out, Map<String, String> config) throws Exception {
        if (jarFiles == null || jarFiles.isEmpty()) {
            throw new IllegalArgumentException("No input jar provided");
        }
        if (out == null) {
            throw new IllegalArgumentException("No output stream provided");
        }
        this.out = out;
        if (config != null) {
            String v = null;
            v = config.get("repository.name");
            if (v != null) {
                this.indexer.setRepositoryName(v);
            }
            if ((v = config.get("stylesheet")) != null) {
                this.indexer.setStylesheet(v);
            }
            if ((v = config.get("url.template")) != null) {
                this.indexer.setUrlTemplate(v);
            }
            if ((v = config.get("root.url")) != null) {
                this.indexer.setRootURL(v);
            }
            if ((v = config.get("license.url")) != null) {
                this.indexer.setLicenseURL(v);
            }
        }
        if (this.indexer.getRootURL() == null) {
            this.indexer.setRootURL(new File("").getAbsoluteFile().toURI().toURL());
        }
        this.indexer.setRepository(new RepositoryImpl(this.indexer.getRootURL()));
        HashSet<ResourceImpl> resources = new HashSet<ResourceImpl>();
        for (File f : jarFiles) {
            this.indexer.recurse(resources, f);
        }
        ArrayList<ResourceImpl> sorted = new ArrayList<ResourceImpl>(resources);
        Collections.sort(sorted, new ResourceImplComparator());
        Tag tag = this.indexer.doIndex(sorted);
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(out, "UTF-8"));
        try {
            this.indexer.printXmlHeader(pw);
            tag.print(0, pw);
            pw.print("\n");
        }
        finally {
            pw.close();
        }
    }
}

