/*
 * Decompiled with CFR 0.152.
 */
package org.olsr.v1.info.api.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.InetAddress;
import org.olsr.v1.info.api.util.CompareUtils;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class JsonInfoSgwBandwidth
implements Comparable<JsonInfoSgwBandwidth> {
    private boolean requireNetwork = true;
    private boolean requireGateway = true;
    private long egressUk = 0L;
    private long egressDk = 0L;
    private double pathCost = Double.POSITIVE_INFINITY;
    private String network = "";
    private int networkLength = 0;
    private String gateway = "";
    private boolean networkSet = false;
    private boolean gatewaySet = false;
    private double costs = Double.POSITIVE_INFINITY;

    public boolean getRequireNetwork() {
        return this.requireNetwork;
    }

    @JsonProperty(value="requireNetwork")
    public void setRequireNetwork(boolean requireNetwork) {
        this.requireNetwork = requireNetwork;
    }

    public boolean getRequireGateway() {
        return this.requireGateway;
    }

    @JsonProperty(value="requireGateway")
    public void setRequireGateway(boolean requireGateway) {
        this.requireGateway = requireGateway;
    }

    public long getEgressUk() {
        return this.egressUk;
    }

    @JsonProperty(value="egressUk")
    public void setEgressUk(long egressUk) {
        this.egressUk = egressUk;
    }

    public long getEgressDk() {
        return this.egressDk;
    }

    @JsonProperty(value="egressDk")
    public void setEgressDk(long egressDk) {
        this.egressDk = egressDk;
    }

    public double getPathCost() {
        return this.pathCost;
    }

    @JsonProperty(value="pathCost")
    public void setPathCost(double pathCost) {
        this.pathCost = Double.compare(pathCost, 4.294967295E9) >= 0 ? Double.POSITIVE_INFINITY : pathCost;
    }

    public String getNetwork() {
        return this.network;
    }

    @JsonProperty(value="network")
    public void setNetwork(InetAddress network) {
        this.network = network == null ? "" : network.getHostAddress();
    }

    public int getNetworkLength() {
        return this.networkLength;
    }

    @JsonProperty(value="networkLength")
    public void setNetworkLength(int networkLength) {
        this.networkLength = networkLength;
    }

    public String getGateway() {
        return this.gateway;
    }

    @JsonProperty(value="gateway")
    public void setGateway(InetAddress gateway) {
        this.gateway = gateway == null ? "" : gateway.getHostAddress();
    }

    public boolean getNetworkSet() {
        return this.networkSet;
    }

    @JsonProperty(value="networkSet")
    public void setNetworkSet(boolean networkSet) {
        this.networkSet = networkSet;
    }

    public boolean getGatewaySet() {
        return this.gatewaySet;
    }

    @JsonProperty(value="gatewaySet")
    public void setGatewaySet(boolean gatewaySet) {
        this.gatewaySet = gatewaySet;
    }

    public double getCosts() {
        return this.costs;
    }

    @JsonProperty(value="costs")
    public void setCosts(double costs) {
        this.costs = Double.compare(costs, 9.223372036854776E18) >= 0 ? Double.POSITIVE_INFINITY : costs;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.requireNetwork ? 1231 : 1237);
        result = 31 * result + (this.requireGateway ? 1231 : 1237);
        result = 31 * result + (int)(this.egressUk ^ this.egressUk >>> 32);
        result = 31 * result + (int)(this.egressDk ^ this.egressDk >>> 32);
        long temp = Double.doubleToLongBits(this.pathCost);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.network.hashCode();
        result = 31 * result + this.networkLength;
        result = 31 * result + this.gateway.hashCode();
        result = 31 * result + (this.networkSet ? 1231 : 1237);
        result = 31 * result + (this.gatewaySet ? 1231 : 1237);
        temp = Double.doubleToLongBits(this.costs);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.compareTo((JsonInfoSgwBandwidth)other) == 0;
    }

    @Override
    public int compareTo(JsonInfoSgwBandwidth other) {
        if (other == null) {
            return -1;
        }
        int result = Double.compare(this.costs, other.costs);
        if (result != 0) {
            return result;
        }
        result = this.gateway.compareTo(other.gateway);
        if (result != 0) {
            return CompareUtils.clip(result);
        }
        result = this.network.compareTo(other.network);
        if (result != 0) {
            return CompareUtils.clip(result);
        }
        result = Integer.compare(this.networkLength, other.networkLength);
        if (result != 0) {
            return result;
        }
        result = Long.compare(this.egressUk, other.egressUk);
        if (result != 0) {
            return result;
        }
        result = Long.compare(this.egressDk, other.egressDk);
        if (result != 0) {
            return result;
        }
        result = Double.compare(this.pathCost, other.pathCost);
        if (result != 0) {
            return result;
        }
        result = Boolean.compare(this.requireNetwork, other.requireNetwork);
        if (result != 0) {
            return result;
        }
        result = Boolean.compare(this.requireGateway, other.requireGateway);
        if (result != 0) {
            return result;
        }
        result = Boolean.compare(this.networkSet, other.networkSet);
        if (result != 0) {
            return result;
        }
        result = Boolean.compare(this.gatewaySet, other.gatewaySet);
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JsonInfoSgwBandwidth [requireNetwork=");
        builder.append(this.requireNetwork);
        builder.append(", requireGateway=");
        builder.append(this.requireGateway);
        builder.append(", egressUk=");
        builder.append(this.egressUk);
        builder.append(", egressDk=");
        builder.append(this.egressDk);
        builder.append(", pathCost=");
        builder.append(this.pathCost);
        builder.append(", network=");
        builder.append(this.network);
        builder.append(", networkLength=");
        builder.append(this.networkLength);
        builder.append(", gateway=");
        builder.append(this.gateway);
        builder.append(", networkSet=");
        builder.append(this.networkSet);
        builder.append(", gatewaySet=");
        builder.append(this.gatewaySet);
        builder.append(", costs=");
        builder.append(this.costs);
        builder.append("]");
        return builder.toString();
    }
}

