/******************************************************************************
 *
 * config.h - part of smap
 *
 * $Id: config.h,v 1.34 2007-11-03 18:14:52 hscholz Exp $
 *****************************************************************************/
#ifndef _CONFIG_H
#define _CONFIG_H

#ifdef __linux__
#define _GNU_SOURCE
#endif

#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdarg.h>
#include <stddef.h>     /* offsetof() */
#include <getopt.h>
#include <unistd.h>
#include <string.h>
#include <sys/select.h>
#include <math.h>
#ifdef HAVE_IFADDRS
#include <ifaddrs.h>    /* local IP */
#endif
#ifdef __linux__
#include <linux/sockios.h>
#else
#include <sys/sockio.h> /* SIOCGIFCONF on FreeBSD */
#endif
#include <sys/time.h>	/* gettimeofday() */
#include <time.h>
#include <signal.h>
#include <errno.h>      /* EINPROGRESS */

#include <netdb.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/uio.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include <net/if.h>
#include <netinet/udp.h>
#include <arpa/inet.h>

#include <assert.h>
#include <pthread.h>

#define SMAP_VERSION "0.6.0"
#define STUN_SERVER_IP	"194.97.96.186"

/* thread related ************************************************************/

pthread_t pth_worker;	/* worker thread setting up new tasks */
pthread_t pth_listener;	/* socket listener thread */

enum { MODE_NONE = 0, MODE_IP, MODE_HOST, MODE_NET }; /* scan modes */

/* general config ************************************************************/

struct config_t {
	unsigned int debug;
#define FLAG_EMPTY              0x0000
#define FLAG_NOICMPPING         0x0001
#define FLAG_FINGERPRINT        0x0002
#define FLAG_FINGERPRINT_SMALL  0x0004
#define FP_ENABLED  (config.flags & FLAG_FINGERPRINT)
#define FLAG_FPLEARNING         0x0008
#define IS_LEARNING (config.flags & FLAG_FPLEARNING)
#define FLAG_NOROOT             0x0010  /* don't have root, so don't try
                                         * ICMP ping or rawsocket
                                         */
#define HAVE_ROOT (!(config.flags & FLAG_NOROOT))
#define FLAG_SIPPORTBUSY        0x0020  /* port 5060 in use
                                         * flag set, if error reported
                                         */
#define FLAG_UDP_TRANSPORT      0x0040
#define FLAG_TCP_TRANSPORT      0x0080
#define FLAG_TLS_TRANSPORT      0x0100  /* not used yet */

    int flags;
	unsigned int ratelimit;		/* messages/sec limit */

	char *sip_domain;			/* domain to use in SIP messages */
	char *localip;				/* local IP as ASCII */
	unsigned int timeout;		/* default timeout in ms */
	unsigned int sip_port;		/* destination port to scan */

	/* target(s) to scan */
	unsigned int mode;
	char *target_host;
	struct in_addr net_ip;
	struct in_addr net_base;
	unsigned int net_mask;
} config;

/* error() related ***********************************************************/

enum { ERR_DEBUG, ERR_NOTICE, ERR_FUNC, ERR_ERROR, ERR_FATAL };
#define ERRBUF  1024
#define DEBUG (config.debug > 0)
#define FUNCTION(x,y) { if (config.debug > 1) { fprintf(stderr, "%s:%s() invoked\n", x,y );}}

/* transport related *********************************************************/

enum { TRANSPORT_UDP = 1, TRANSPORT_TCP };
#define TRANSPORT_STRING(x) ((x == TRANSPORT_UDP) ? "UDP" : "TCP" )

#define DEFAULT_SIP_PORT	5060
#define DEFAULT_TIMEOUT		500		/* in ms */

/* randomizer related ********************************************************/
enum { RAND_CALLID = 1, RAND_TAG, RAND_CSEQ, RAND_BRANCH };
#define CALLID_LEN  64
#define TAG_LEN     64

/* fingerprint related *******************************************************/

struct fingerprint_t {
    char            *name;  /* name of the UA identified */

    int             options;
    int             newmethod;
    int             brokenfromto;
    int             prack;
    int             invite;
    int             ping;
    int             tmp;            /* temporary scratchpad */

    int             accept_class;
    int             allow_class;
    int             supported_class;
    int             via_class;
    int             hoe_class;      /* header order/existance */

    char            *header_ua;     /* pointers to useful headers */
    char            *header_server;

    struct fingerprint_t    *next;  /* next fingerprint */
};
typedef struct fingerprint_t fingerprint;

/* we have three fingerprint identicators */
#define FP_PERFECTMATCH 4
#define NO_RESPONSE -1
#define NO_RELEVANCE -2

/* task related **************************************************************/

struct _task_t {
	unsigned int tid; /* task ID */
	unsigned int state; /* task state */

	/* IP+SIP related */
	unsigned int scan_type;
	unsigned int results;
#define RES_EMPTY		0x0000
#define RES_SIP_ENABLED	0x0001
#define RES_ICMP_REACH	0x0002

	struct in_addr target;
	fingerprint *fp;
	unsigned int test;
	unsigned int transport;

	struct timeval lastmod;		/* last modified */

	struct _task_t *prev;		/* previous task */
	struct _task_t *next;		/* next task */
};
typedef struct _task_t task_t;

task_t *tasks;
int last_task_id;
unsigned int active_tasks;

/* task states */
enum {	S_START = 0,	/* nothing done yet, just about to start */
		S_PING,			/* 'ping'ing the destination if needed */
	 	S_PROCESSING,	/* doing SIP stuff */
		S_COLLECT,		/* done with stuff, waiting for replies */
		S_DONE			/* all over, print results */
	 };

/* 'Call' states *************************************************************/

struct _state_t {

	unsigned int callid;	/* call id */
	task_t *task;			/* pointer to task */
	unsigned int test;		/* test this callid belongs to */

	struct _state_t *prev;
	struct _state_t *next;
};
typedef struct _state_t state_t;

state_t *states;

/* ICMP related **************************************************************/
/* payload len is based on what FreeBSD sends by default */
#define ICMP_PAYLOAD_LEN    60

/* SIP related ***************************************************************/

enum { SCAN_UNKNOWN = 0, SCAN_ENABLED, SCAN_FINGERPRINT };
#define SIPLEN      4096    /* based on RFC */
#define SIPMINLEN   64      /* minimum size to fit a SIP message in */
enum { SIP_OPTIONS = 1, SIP_BROKENFROMTO, SIP_NEWMETHOD, SIP_PRACK, \
        SIP_INVITE, SIP_PING, SIP_TMP };
/* used SIP methods */
enum { METH_INVITE = 1, METH_OPTIONS, METH_NEWMETHOD, METH_PRACK, METH_PING };

/* Scan related **************************************************************/

struct scan_test_t {
    int requesttype;
    int offset;
    char name[256];
};

/* stats related *************************************************************/

struct stats_t {
	unsigned int scanned;		/* hosts scanned */
	unsigned int up;			/* hosts up (ICMP) */
	unsigned int sip;			/* SIP stack */
} stats;

#include "prototypes.h"
#endif /* _CONFIG_H */
