/******************************************************************************
 *
 * test_accept.c - part of smap
 * 
 * $Id: test_accept.c,v 1.3 2007-05-24 19:34:53 hscholz Exp $
 *****************************************************************************/
#ifndef _TEST_ACCEPT_C
#define _TEST_ACCEPT_C

#include "config.h"

/******************************************************************************
 *
 * Accept header fingerprint meta database
 *
 * this list contains all different types of Accept header combinations
 * found in live-traffic.
 *
 * How to add more?
 * - extend accept_headers[], don't forget new int (third param)
 * - add third param to fingerprint database where appropriate
 *
 *****************************************************************************/

#define ACCEPT_LEN		256
#define ACCEPT_DESCR	256
struct accept_header_t {
	char header[ACCEPT_LEN];
	unsigned int class;
};

struct accept_header_t accept_headers[] = {
	/* Siemens C450 IP */
	{"Accept: application/sdp,application/dtmf-relay", 1},
	/* Asterisk PBX */
	{"Accept: application/sdp", 2},
	/* PA168V PA1688 series phones */
	{"Accept: application/sdp, message/sipfrag, application/dtmf-relay", 3},
	/* Arcor Twintel D910 series */
	{"Accept: SDP", 4},
	/* Cisco 79x0 Phone */
	{"Accept: application/sdp,multipart/mixed,multipart/alternative", 5},
	/* do not remove! */
	{"", 0}
};

/******************************************************************************
 *
 * test_accept()
 *
 * Locate and analyze the Accept-Header inside the passed SIP message
 *
 *****************************************************************************/

int test_accept(int *res, char *buf) {

	char *p, *n;
	struct accept_header_t hdr;
	int line, end;
	FUNCTION(__FILE__, __FUNCTION__);

	p = strcasestr(buf, "\r\nAccept:");
	if (p == NULL) {
		*res = NO_RESPONSE;
		error(DEBUG, "message does not contain an Accept header");
		return 0;
	}
	p += 2; /* skip leading \r\n */
	n = strstr(p, "\r\n");
	if (n == NULL) {
		*res = NO_RESPONSE;
		error(ERR_ERROR, "cannot locate end of Accept header");
		return 0;
	}
	if (IS_LEARNING || DEBUG)
		error(ERR_NOTICE, "%s: \"%.*s\"", __FUNCTION__,
			(int) (n-p), p);
	line = 0;
	end = 0;
	hdr = accept_headers[line];
	while ((hdr.header[0] != 0) && !end) {
		if (!strncmp(hdr.header, p, (n-p)) && (strlen(hdr.header) == (n-p))) {
			end++;	/* correct line found */
			*res = hdr.class;
		}
		hdr = accept_headers[++line];
	}
	if (!end && IS_LEARNING)
		error(ERR_NOTICE, "%s: Please add Accept: header", __FUNCTION__);
	return end ? 1 : 0;
}

#endif /* _TEST_ACCEPT_C */
