/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions;

import junit.extensions.TestDecorator;
import junit.framework.Test;
import junit.framework.TestResult;

public class RepeatedTest
extends TestDecorator {
    private int fTimesRepeat;

    public RepeatedTest(Test test, int n) {
        super(test);
        if (n < 0) {
            throw new IllegalArgumentException("Repetition count must be >= 0");
        }
        this.fTimesRepeat = n;
    }

    @Override
    public int countTestCases() {
        return super.countTestCases() * this.fTimesRepeat;
    }

    @Override
    public void run(TestResult testResult) {
        for (int i = 0; i < this.fTimesRepeat && !testResult.shouldStop(); ++i) {
            super.run(testResult);
        }
    }

    @Override
    public String toString() {
        return super.toString() + "(repeated)";
    }
}

