/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental.categories;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.junit.experimental.categories.Category;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class Categories
extends Suite {
    public Categories(Class<?> clazz, RunnerBuilder runnerBuilder) throws InitializationError {
        super(clazz, runnerBuilder);
        try {
            Set<Class<?>> set = Categories.getIncludedCategory(clazz);
            Set<Class<?>> set2 = Categories.getExcludedCategory(clazz);
            boolean bl = Categories.isAnyIncluded(clazz);
            boolean bl2 = Categories.isAnyExcluded(clazz);
            this.filter(CategoryFilter.categoryFilter(bl, set, bl2, set2));
        }
        catch (NoTestsRemainException noTestsRemainException) {
            throw new InitializationError(noTestsRemainException);
        }
        Categories.assertNoCategorizedDescendentsOfUncategorizeableParents(this.getDescription());
    }

    private static Set<Class<?>> getIncludedCategory(Class<?> clazz) {
        IncludeCategory includeCategory = clazz.getAnnotation(IncludeCategory.class);
        return Categories.createSet(includeCategory == null ? null : includeCategory.value());
    }

    private static boolean isAnyIncluded(Class<?> clazz) {
        IncludeCategory includeCategory = clazz.getAnnotation(IncludeCategory.class);
        return includeCategory == null || includeCategory.matchAny();
    }

    private static Set<Class<?>> getExcludedCategory(Class<?> clazz) {
        ExcludeCategory excludeCategory = clazz.getAnnotation(ExcludeCategory.class);
        return Categories.createSet(excludeCategory == null ? null : excludeCategory.value());
    }

    private static boolean isAnyExcluded(Class<?> clazz) {
        ExcludeCategory excludeCategory = clazz.getAnnotation(ExcludeCategory.class);
        return excludeCategory == null || excludeCategory.matchAny();
    }

    private static void assertNoCategorizedDescendentsOfUncategorizeableParents(Description description) throws InitializationError {
        if (!Categories.canHaveCategorizedChildren(description)) {
            Categories.assertNoDescendantsHaveCategoryAnnotations(description);
        }
        for (Description description2 : description.getChildren()) {
            Categories.assertNoCategorizedDescendentsOfUncategorizeableParents(description2);
        }
    }

    private static void assertNoDescendantsHaveCategoryAnnotations(Description description) throws InitializationError {
        for (Description description2 : description.getChildren()) {
            if (description2.getAnnotation(Category.class) != null) {
                throw new InitializationError("Category annotations on Parameterized classes are not supported on individual methods.");
            }
            Categories.assertNoDescendantsHaveCategoryAnnotations(description2);
        }
    }

    private static boolean canHaveCategorizedChildren(Description description) {
        for (Description description2 : description.getChildren()) {
            if (description2.getTestClass() != null) continue;
            return false;
        }
        return true;
    }

    private static boolean hasAssignableTo(Set<Class<?>> set, Class<?> clazz) {
        for (Class<?> clazz2 : set) {
            if (!clazz.isAssignableFrom(clazz2)) continue;
            return true;
        }
        return false;
    }

    private static Set<Class<?>> createSet(Class<?> ... classArray) {
        HashSet hashSet = new HashSet();
        if (classArray != null) {
            Collections.addAll(hashSet, classArray);
        }
        return hashSet;
    }

    public static class CategoryFilter
    extends Filter {
        private final Set<Class<?>> included;
        private final Set<Class<?>> excluded;
        private final boolean includedAny;
        private final boolean excludedAny;

        public static CategoryFilter include(boolean bl, Class<?> ... classArray) {
            if (CategoryFilter.hasNull(classArray)) {
                throw new NullPointerException("has null category");
            }
            return CategoryFilter.categoryFilter(bl, Categories.createSet(classArray), true, null);
        }

        public static CategoryFilter include(Class<?> clazz) {
            return CategoryFilter.include(true, clazz);
        }

        public static CategoryFilter include(Class<?> ... classArray) {
            return CategoryFilter.include(true, classArray);
        }

        public static CategoryFilter exclude(boolean bl, Class<?> ... classArray) {
            if (CategoryFilter.hasNull(classArray)) {
                throw new NullPointerException("has null category");
            }
            return CategoryFilter.categoryFilter(true, null, bl, Categories.createSet(classArray));
        }

        public static CategoryFilter exclude(Class<?> clazz) {
            return CategoryFilter.exclude(true, clazz);
        }

        public static CategoryFilter exclude(Class<?> ... classArray) {
            return CategoryFilter.exclude(true, classArray);
        }

        public static CategoryFilter categoryFilter(boolean bl, Set<Class<?>> set, boolean bl2, Set<Class<?>> set2) {
            return new CategoryFilter(bl, set, bl2, set2);
        }

        protected CategoryFilter(boolean bl, Set<Class<?>> set, boolean bl2, Set<Class<?>> set2) {
            this.includedAny = bl;
            this.excludedAny = bl2;
            this.included = CategoryFilter.copyAndRefine(set);
            this.excluded = CategoryFilter.copyAndRefine(set2);
        }

        @Override
        public String describe() {
            return this.toString();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("categories ").append(this.included.isEmpty() ? "[all]" : this.included);
            if (!this.excluded.isEmpty()) {
                stringBuilder.append(" - ").append(this.excluded);
            }
            return stringBuilder.toString();
        }

        @Override
        public boolean shouldRun(Description description) {
            if (this.hasCorrectCategoryAnnotation(description)) {
                return true;
            }
            for (Description description2 : description.getChildren()) {
                if (!this.shouldRun(description2)) continue;
                return true;
            }
            return false;
        }

        private boolean hasCorrectCategoryAnnotation(Description description) {
            Set<Class<?>> set = CategoryFilter.categories(description);
            if (set.isEmpty()) {
                return this.included.isEmpty();
            }
            if (!this.excluded.isEmpty() && (this.excludedAny ? this.matchesAnyParentCategories(set, this.excluded) : this.matchesAllParentCategories(set, this.excluded))) {
                return false;
            }
            if (this.included.isEmpty()) {
                return true;
            }
            if (this.includedAny) {
                return this.matchesAnyParentCategories(set, this.included);
            }
            return this.matchesAllParentCategories(set, this.included);
        }

        private boolean matchesAnyParentCategories(Set<Class<?>> set, Set<Class<?>> set2) {
            for (Class<?> clazz : set2) {
                if (!Categories.hasAssignableTo(set, clazz)) continue;
                return true;
            }
            return false;
        }

        private boolean matchesAllParentCategories(Set<Class<?>> set, Set<Class<?>> set2) {
            for (Class<?> clazz : set2) {
                if (Categories.hasAssignableTo(set, clazz)) continue;
                return false;
            }
            return true;
        }

        private static Set<Class<?>> categories(Description description) {
            HashSet hashSet = new HashSet();
            Collections.addAll(hashSet, CategoryFilter.directCategories(description));
            Collections.addAll(hashSet, CategoryFilter.directCategories(CategoryFilter.parentDescription(description)));
            return hashSet;
        }

        private static Description parentDescription(Description description) {
            Class<?> clazz = description.getTestClass();
            return clazz == null ? null : Description.createSuiteDescription(clazz);
        }

        private static Class<?>[] directCategories(Description description) {
            if (description == null) {
                return new Class[0];
            }
            Category category = description.getAnnotation(Category.class);
            return category == null ? new Class[]{} : category.value();
        }

        private static Set<Class<?>> copyAndRefine(Set<Class<?>> set) {
            HashSet hashSet = new HashSet();
            if (set != null) {
                hashSet.addAll(set);
            }
            hashSet.remove(null);
            return hashSet;
        }

        private static boolean hasNull(Class<?> ... classArray) {
            if (classArray == null) {
                return false;
            }
            for (Class<?> clazz : classArray) {
                if (clazz != null) continue;
                return true;
            }
            return false;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ExcludeCategory {
        public Class<?>[] value() default {};

        public boolean matchAny() default true;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface IncludeCategory {
        public Class<?>[] value() default {};

        public boolean matchAny() default true;
    }
}

