/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental.theories;

public abstract class PotentialAssignment {
    public static PotentialAssignment forValue(final String string, final Object object) {
        return new PotentialAssignment(){

            @Override
            public Object getValue() {
                return object;
            }

            public String toString() {
                return String.format("[%s]", object);
            }

            @Override
            public String getDescription() {
                String string2;
                if (object == null) {
                    string2 = "null";
                } else {
                    try {
                        string2 = String.format("\"%s\"", object);
                    }
                    catch (Throwable throwable) {
                        string2 = String.format("[toString() threw %s: %s]", throwable.getClass().getSimpleName(), throwable.getMessage());
                    }
                }
                return String.format("%s <from %s>", string2, string);
            }
        };
    }

    public abstract Object getValue() throws CouldNotGenerateValueException;

    public abstract String getDescription() throws CouldNotGenerateValueException;

    public static class CouldNotGenerateValueException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public CouldNotGenerateValueException() {
        }

        public CouldNotGenerateValueException(Throwable throwable) {
            super(throwable);
        }
    }
}

