/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.junit.internal.runners.ClassRoadie;
import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.MethodRoadie;
import org.junit.internal.runners.MethodValidator;
import org.junit.internal.runners.TestClass;
import org.junit.internal.runners.TestMethod;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

@Deprecated
public class JUnit4ClassRunner
extends Runner
implements Filterable,
Sortable {
    private final List<Method> testMethods;
    private TestClass testClass;

    public JUnit4ClassRunner(Class<?> clazz) throws InitializationError {
        this.testClass = new TestClass(clazz);
        this.testMethods = this.getTestMethods();
        this.validate();
    }

    protected List<Method> getTestMethods() {
        return this.testClass.getTestMethods();
    }

    protected void validate() throws InitializationError {
        MethodValidator methodValidator = new MethodValidator(this.testClass);
        methodValidator.validateMethodsForDefaultRunner();
        methodValidator.assertValid();
    }

    @Override
    public void run(final RunNotifier runNotifier) {
        new ClassRoadie(runNotifier, this.testClass, this.getDescription(), new Runnable(){

            @Override
            public void run() {
                JUnit4ClassRunner.this.runMethods(runNotifier);
            }
        }).runProtected();
    }

    protected void runMethods(RunNotifier runNotifier) {
        for (Method method : this.testMethods) {
            this.invokeTestMethod(method, runNotifier);
        }
    }

    @Override
    public Description getDescription() {
        Description description = Description.createSuiteDescription(this.getName(), this.classAnnotations());
        List<Method> list = this.testMethods;
        for (Method method : list) {
            description.addChild(this.methodDescription(method));
        }
        return description;
    }

    protected Annotation[] classAnnotations() {
        return this.testClass.getJavaClass().getAnnotations();
    }

    protected String getName() {
        return this.getTestClass().getName();
    }

    protected Object createTest() throws Exception {
        return this.getTestClass().getConstructor().newInstance(new Object[0]);
    }

    protected void invokeTestMethod(Method method, RunNotifier runNotifier) {
        Object object;
        Description description = this.methodDescription(method);
        try {
            object = this.createTest();
        }
        catch (InvocationTargetException invocationTargetException) {
            this.testAborted(runNotifier, description, invocationTargetException.getCause());
            return;
        }
        catch (Exception exception) {
            this.testAborted(runNotifier, description, exception);
            return;
        }
        TestMethod testMethod = this.wrapMethod(method);
        new MethodRoadie(object, testMethod, runNotifier, description).run();
    }

    private void testAborted(RunNotifier runNotifier, Description description, Throwable throwable) {
        runNotifier.fireTestStarted(description);
        runNotifier.fireTestFailure(new Failure(description, throwable));
        runNotifier.fireTestFinished(description);
    }

    protected TestMethod wrapMethod(Method method) {
        return new TestMethod(method, this.testClass);
    }

    protected String testName(Method method) {
        return method.getName();
    }

    protected Description methodDescription(Method method) {
        return Description.createTestDescription(this.getTestClass().getJavaClass(), this.testName(method), this.testAnnotations(method));
    }

    protected Annotation[] testAnnotations(Method method) {
        return method.getAnnotations();
    }

    @Override
    public void filter(Filter filter) throws NoTestsRemainException {
        Iterator<Method> iterator = this.testMethods.iterator();
        while (iterator.hasNext()) {
            Method method = iterator.next();
            if (filter.shouldRun(this.methodDescription(method))) continue;
            iterator.remove();
        }
        if (this.testMethods.isEmpty()) {
            throw new NoTestsRemainException();
        }
    }

    @Override
    public void sort(final Sorter sorter) {
        Collections.sort(this.testMethods, new Comparator<Method>(){

            @Override
            public int compare(Method method, Method method2) {
                return sorter.compare(JUnit4ClassRunner.this.methodDescription(method), JUnit4ClassRunner.this.methodDescription(method2));
            }
        });
    }

    protected TestClass getTestClass() {
        return this.testClass;
    }
}

