/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.internal.Classes;
import org.junit.runner.Computer;
import org.junit.runner.FilterFactories;
import org.junit.runner.FilterFactory;
import org.junit.runner.Request;
import org.junit.runner.manipulation.Filter;
import org.junit.runners.model.InitializationError;

class JUnitCommandLineParseResult {
    private final List<String> filterSpecs = new ArrayList<String>();
    private final List<Class<?>> classes = new ArrayList();
    private final List<Throwable> parserErrors = new ArrayList<Throwable>();

    JUnitCommandLineParseResult() {
    }

    public List<String> getFilterSpecs() {
        return Collections.unmodifiableList(this.filterSpecs);
    }

    public List<Class<?>> getClasses() {
        return Collections.unmodifiableList(this.classes);
    }

    public static JUnitCommandLineParseResult parse(String[] stringArray) {
        JUnitCommandLineParseResult jUnitCommandLineParseResult = new JUnitCommandLineParseResult();
        jUnitCommandLineParseResult.parseArgs(stringArray);
        return jUnitCommandLineParseResult;
    }

    private void parseArgs(String[] stringArray) {
        this.parseParameters(this.parseOptions(stringArray));
    }

    /*
     * Enabled aggressive block sorting
     */
    String[] parseOptions(String ... stringArray) {
        int n = 0;
        while (n != stringArray.length) {
            String string = stringArray[n];
            if (string.equals("--")) {
                return this.copyArray(stringArray, n + 1, stringArray.length);
            }
            if (!string.startsWith("--")) return this.copyArray(stringArray, n, stringArray.length);
            if (string.startsWith("--filter=") || string.equals("--filter")) {
                String string2;
                if (string.equals("--filter")) {
                    if (++n >= stringArray.length) {
                        this.parserErrors.add(new CommandLineParserError(string + " value not specified"));
                        return new String[0];
                    }
                    string2 = stringArray[n];
                } else {
                    string2 = string.substring(string.indexOf(61) + 1);
                }
                this.filterSpecs.add(string2);
            } else {
                this.parserErrors.add(new CommandLineParserError("JUnit knows nothing about the " + string + " option"));
            }
            ++n;
        }
        return new String[0];
    }

    private String[] copyArray(String[] stringArray, int n, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = n; i != n2; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    void parseParameters(String[] stringArray) {
        for (String string : stringArray) {
            try {
                this.classes.add(Classes.getClass(string));
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.parserErrors.add(new IllegalArgumentException("Could not find class [" + string + "]", classNotFoundException));
            }
        }
    }

    private Request errorReport(Throwable throwable) {
        return Request.errorReport(JUnitCommandLineParseResult.class, throwable);
    }

    public Request createRequest(Computer computer) {
        if (this.parserErrors.isEmpty()) {
            Request request = Request.classes(computer, this.classes.toArray(new Class[this.classes.size()]));
            return this.applyFilterSpecs(request);
        }
        return this.errorReport(new InitializationError(this.parserErrors));
    }

    private Request applyFilterSpecs(Request request) {
        try {
            for (String string : this.filterSpecs) {
                Filter filter = FilterFactories.createFilterFromFilterSpec(request, string);
                request = request.filterWith(filter);
            }
            return request;
        }
        catch (FilterFactory.FilterNotCreatedException filterNotCreatedException) {
            return this.errorReport(filterNotCreatedException);
        }
    }

    public static class CommandLineParserError
    extends Exception {
        private static final long serialVersionUID = 1L;

        public CommandLineParserError(String string) {
            super(string);
        }
    }
}

