/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runner.notification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.StoppedByUserException;
import org.junit.runner.notification.SynchronizedRunListener;

public class RunNotifier {
    private final List<RunListener> listeners = new CopyOnWriteArrayList<RunListener>();
    private volatile boolean pleaseStop = false;

    public void addListener(RunListener runListener) {
        if (runListener == null) {
            throw new NullPointerException("Cannot add a null listener");
        }
        this.listeners.add(this.wrapIfNotThreadSafe(runListener));
    }

    public void removeListener(RunListener runListener) {
        if (runListener == null) {
            throw new NullPointerException("Cannot remove a null listener");
        }
        this.listeners.remove(this.wrapIfNotThreadSafe(runListener));
    }

    RunListener wrapIfNotThreadSafe(RunListener runListener) {
        return runListener.getClass().isAnnotationPresent(RunListener.ThreadSafe.class) ? runListener : new SynchronizedRunListener(runListener, this);
    }

    public void fireTestRunStarted(final Description description) {
        new SafeNotifier(){

            @Override
            protected void notifyListener(RunListener runListener) throws Exception {
                runListener.testRunStarted(description);
            }
        }.run();
    }

    public void fireTestRunFinished(final Result result) {
        new SafeNotifier(){

            @Override
            protected void notifyListener(RunListener runListener) throws Exception {
                runListener.testRunFinished(result);
            }
        }.run();
    }

    public void fireTestStarted(final Description description) throws StoppedByUserException {
        if (this.pleaseStop) {
            throw new StoppedByUserException();
        }
        new SafeNotifier(){

            @Override
            protected void notifyListener(RunListener runListener) throws Exception {
                runListener.testStarted(description);
            }
        }.run();
    }

    public void fireTestFailure(Failure failure) {
        this.fireTestFailures(this.listeners, Arrays.asList(failure));
    }

    private void fireTestFailures(List<RunListener> list, final List<Failure> list2) {
        if (!list2.isEmpty()) {
            new SafeNotifier(list){

                @Override
                protected void notifyListener(RunListener runListener) throws Exception {
                    for (Failure failure : list2) {
                        runListener.testFailure(failure);
                    }
                }
            }.run();
        }
    }

    public void fireTestAssumptionFailed(final Failure failure) {
        new SafeNotifier(){

            @Override
            protected void notifyListener(RunListener runListener) throws Exception {
                runListener.testAssumptionFailure(failure);
            }
        }.run();
    }

    public void fireTestIgnored(final Description description) {
        new SafeNotifier(){

            @Override
            protected void notifyListener(RunListener runListener) throws Exception {
                runListener.testIgnored(description);
            }
        }.run();
    }

    public void fireTestFinished(final Description description) {
        new SafeNotifier(){

            @Override
            protected void notifyListener(RunListener runListener) throws Exception {
                runListener.testFinished(description);
            }
        }.run();
    }

    public void pleaseStop() {
        this.pleaseStop = true;
    }

    public void addFirstListener(RunListener runListener) {
        if (runListener == null) {
            throw new NullPointerException("Cannot add a null listener");
        }
        this.listeners.add(0, this.wrapIfNotThreadSafe(runListener));
    }

    private abstract class SafeNotifier {
        private final List<RunListener> currentListeners;

        SafeNotifier() {
            this(runNotifier.listeners);
        }

        SafeNotifier(List<RunListener> list) {
            this.currentListeners = list;
        }

        void run() {
            int n = this.currentListeners.size();
            ArrayList<RunListener> arrayList = new ArrayList<RunListener>(n);
            ArrayList<Failure> arrayList2 = new ArrayList<Failure>(n);
            for (RunListener runListener : this.currentListeners) {
                try {
                    this.notifyListener(runListener);
                    arrayList.add(runListener);
                }
                catch (Exception exception) {
                    arrayList2.add(new Failure(Description.TEST_MECHANISM, exception));
                }
            }
            RunNotifier.this.fireTestFailures(arrayList, arrayList2);
        }

        protected abstract void notifyListener(RunListener var1) throws Exception;
    }
}

