/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;

public class ActiveTestSuite
extends TestSuite {
    private volatile int fActiveTestDeathCount;

    public ActiveTestSuite() {
    }

    public ActiveTestSuite(Class<? extends TestCase> clazz) {
        super((Class<?>)clazz);
    }

    public ActiveTestSuite(String string) {
        super(string);
    }

    public ActiveTestSuite(Class<? extends TestCase> clazz, String string) {
        super(clazz, string);
    }

    @Override
    public void run(TestResult testResult) {
        this.fActiveTestDeathCount = 0;
        super.run(testResult);
        this.waitUntilFinished();
    }

    @Override
    public void runTest(final Test test, final TestResult testResult) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    test.run(testResult);
                }
                finally {
                    ActiveTestSuite.this.runFinished();
                }
            }
        };
        thread.start();
    }

    synchronized void waitUntilFinished() {
        while (this.fActiveTestDeathCount < this.testCount()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public synchronized void runFinished() {
        ++this.fActiveTestDeathCount;
        this.notifyAll();
    }
}

