/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.junit.internal.MethodSorter;

public class TestSuite
implements Test {
    private String fName;
    private Vector<Test> fTests = new Vector(10);

    public static Test createTest(Class<?> clazz, String string) {
        Object obj;
        Constructor<?> constructor;
        try {
            constructor = TestSuite.getTestConstructor(clazz);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return TestSuite.warning("Class " + clazz.getName() + " has no public constructor TestCase(String name) or TestCase()");
        }
        try {
            if (constructor.getParameterTypes().length == 0) {
                obj = constructor.newInstance(new Object[0]);
                if (obj instanceof TestCase) {
                    ((TestCase)obj).setName(string);
                }
            } else {
                obj = constructor.newInstance(string);
            }
        }
        catch (InstantiationException instantiationException) {
            return TestSuite.warning("Cannot instantiate test case: " + string + " (" + TestSuite.exceptionToString(instantiationException) + ")");
        }
        catch (InvocationTargetException invocationTargetException) {
            return TestSuite.warning("Exception in constructor: " + string + " (" + TestSuite.exceptionToString(invocationTargetException.getTargetException()) + ")");
        }
        catch (IllegalAccessException illegalAccessException) {
            return TestSuite.warning("Cannot access test case: " + string + " (" + TestSuite.exceptionToString(illegalAccessException) + ")");
        }
        return (Test)obj;
    }

    public static Constructor<?> getTestConstructor(Class<?> clazz) throws NoSuchMethodException {
        try {
            return clazz.getConstructor(String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return clazz.getConstructor(new Class[0]);
        }
    }

    public static Test warning(final String string) {
        return new TestCase("warning"){

            @Override
            protected void runTest() {
                1.fail(string);
            }
        };
    }

    private static String exceptionToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public TestSuite() {
    }

    public TestSuite(Class<?> clazz) {
        this.addTestsFromTestCase(clazz);
    }

    private void addTestsFromTestCase(Class<?> clazz) {
        this.fName = clazz.getName();
        try {
            TestSuite.getTestConstructor(clazz);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.addTest(TestSuite.warning("Class " + clazz.getName() + " has no public constructor TestCase(String name) or TestCase()"));
            return;
        }
        if (!Modifier.isPublic(clazz.getModifiers())) {
            this.addTest(TestSuite.warning("Class " + clazz.getName() + " is not public"));
            return;
        }
        Class<?> clazz2 = clazz;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (Test.class.isAssignableFrom(clazz2)) {
            for (Method method : MethodSorter.getDeclaredMethods(clazz2)) {
                this.addTestMethod(method, arrayList, clazz);
            }
            clazz2 = clazz2.getSuperclass();
        }
        if (this.fTests.size() == 0) {
            this.addTest(TestSuite.warning("No tests found in " + clazz.getName()));
        }
    }

    public TestSuite(Class<? extends TestCase> clazz, String string) {
        this((Class<?>)clazz);
        this.setName(string);
    }

    public TestSuite(String string) {
        this.setName(string);
    }

    public TestSuite(Class<?> ... classArray) {
        for (Class<?> clazz : classArray) {
            this.addTest(this.testCaseForClass(clazz));
        }
    }

    private Test testCaseForClass(Class<?> clazz) {
        if (TestCase.class.isAssignableFrom(clazz)) {
            return new TestSuite((Class<?>)clazz.asSubclass(TestCase.class));
        }
        return TestSuite.warning(clazz.getCanonicalName() + " does not extend TestCase");
    }

    public TestSuite(Class<? extends TestCase>[] classArray, String string) {
        this(classArray);
        this.setName(string);
    }

    public void addTest(Test test) {
        this.fTests.add(test);
    }

    public void addTestSuite(Class<? extends TestCase> clazz) {
        this.addTest(new TestSuite((Class<?>)clazz));
    }

    @Override
    public int countTestCases() {
        int n = 0;
        for (Test test : this.fTests) {
            n += test.countTestCases();
        }
        return n;
    }

    public String getName() {
        return this.fName;
    }

    @Override
    public void run(TestResult testResult) {
        for (Test test : this.fTests) {
            if (testResult.shouldStop()) break;
            this.runTest(test, testResult);
        }
    }

    public void runTest(Test test, TestResult testResult) {
        test.run(testResult);
    }

    public void setName(String string) {
        this.fName = string;
    }

    public Test testAt(int n) {
        return this.fTests.get(n);
    }

    public int testCount() {
        return this.fTests.size();
    }

    public Enumeration<Test> tests() {
        return this.fTests.elements();
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        return super.toString();
    }

    private void addTestMethod(Method method, List<String> list, Class<?> clazz) {
        String string = method.getName();
        if (list.contains(string)) {
            return;
        }
        if (!this.isPublicTestMethod(method)) {
            if (this.isTestMethod(method)) {
                this.addTest(TestSuite.warning("Test method isn't public: " + method.getName() + "(" + clazz.getCanonicalName() + ")"));
            }
            return;
        }
        list.add(string);
        this.addTest(TestSuite.createTest(clazz, string));
    }

    private boolean isPublicTestMethod(Method method) {
        return this.isTestMethod(method) && Modifier.isPublic(method.getModifiers());
    }

    private boolean isTestMethod(Method method) {
        return method.getParameterTypes().length == 0 && method.getName().startsWith("test") && method.getReturnType().equals(Void.TYPE);
    }
}

