/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental.theories.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.experimental.theories.ParameterSignature;
import org.junit.experimental.theories.ParameterSupplier;
import org.junit.experimental.theories.ParametersSuppliedBy;
import org.junit.experimental.theories.PotentialAssignment;
import org.junit.experimental.theories.internal.AllMembersSupplier;
import org.junit.experimental.theories.internal.BooleanSupplier;
import org.junit.experimental.theories.internal.EnumSupplier;
import org.junit.runners.model.TestClass;

public class Assignments {
    private final List<PotentialAssignment> assigned;
    private final List<ParameterSignature> unassigned;
    private final TestClass clazz;

    private Assignments(List<PotentialAssignment> list, List<ParameterSignature> list2, TestClass testClass) {
        this.unassigned = list2;
        this.assigned = list;
        this.clazz = testClass;
    }

    public static Assignments allUnassigned(Method method, TestClass testClass) {
        List<ParameterSignature> list = ParameterSignature.signatures(testClass.getOnlyConstructor());
        list.addAll(ParameterSignature.signatures(method));
        return new Assignments(new ArrayList<PotentialAssignment>(), list, testClass);
    }

    public boolean isComplete() {
        return this.unassigned.size() == 0;
    }

    public ParameterSignature nextUnassigned() {
        return this.unassigned.get(0);
    }

    public Assignments assignNext(PotentialAssignment potentialAssignment) {
        ArrayList<PotentialAssignment> arrayList = new ArrayList<PotentialAssignment>(this.assigned);
        arrayList.add(potentialAssignment);
        return new Assignments(arrayList, this.unassigned.subList(1, this.unassigned.size()), this.clazz);
    }

    public Object[] getActualValues(int n, int n2) throws PotentialAssignment.CouldNotGenerateValueException {
        Object[] objectArray = new Object[n2 - n];
        for (int i = n; i < n2; ++i) {
            objectArray[i - n] = this.assigned.get(i).getValue();
        }
        return objectArray;
    }

    public List<PotentialAssignment> potentialsForNextUnassigned() throws Throwable {
        ParameterSignature parameterSignature = this.nextUnassigned();
        List<PotentialAssignment> list = this.getSupplier(parameterSignature).getValueSources(parameterSignature);
        if (list.size() == 0) {
            list = this.generateAssignmentsFromTypeAlone(parameterSignature);
        }
        return list;
    }

    private List<PotentialAssignment> generateAssignmentsFromTypeAlone(ParameterSignature parameterSignature) {
        Class<?> clazz = parameterSignature.getType();
        if (clazz.isEnum()) {
            return new EnumSupplier(clazz).getValueSources(parameterSignature);
        }
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return new BooleanSupplier().getValueSources(parameterSignature);
        }
        return Collections.emptyList();
    }

    private ParameterSupplier getSupplier(ParameterSignature parameterSignature) throws Exception {
        ParametersSuppliedBy parametersSuppliedBy = parameterSignature.findDeepAnnotation(ParametersSuppliedBy.class);
        if (parametersSuppliedBy != null) {
            return this.buildParameterSupplierFromClass(parametersSuppliedBy.value());
        }
        return new AllMembersSupplier(this.clazz);
    }

    private ParameterSupplier buildParameterSupplierFromClass(Class<? extends ParameterSupplier> clazz) throws Exception {
        Constructor<?>[] constructorArray;
        for (Constructor<?> constructor : constructorArray = clazz.getConstructors()) {
            Class<?>[] classArray = constructor.getParameterTypes();
            if (classArray.length != 1 || !classArray[0].equals(TestClass.class)) continue;
            return (ParameterSupplier)constructor.newInstance(this.clazz);
        }
        return clazz.newInstance();
    }

    public Object[] getConstructorArguments() throws PotentialAssignment.CouldNotGenerateValueException {
        return this.getActualValues(0, this.getConstructorParameterCount());
    }

    public Object[] getMethodArguments() throws PotentialAssignment.CouldNotGenerateValueException {
        return this.getActualValues(this.getConstructorParameterCount(), this.assigned.size());
    }

    public Object[] getAllArguments() throws PotentialAssignment.CouldNotGenerateValueException {
        return this.getActualValues(0, this.assigned.size());
    }

    private int getConstructorParameterCount() {
        List<ParameterSignature> list = ParameterSignature.signatures(this.clazz.getOnlyConstructor());
        int n = list.size();
        return n;
    }

    public Object[] getArgumentStrings(boolean bl) throws PotentialAssignment.CouldNotGenerateValueException {
        Object[] objectArray = new Object[this.assigned.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.assigned.get(i).getDescription();
        }
        return objectArray;
    }
}

