/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import org.junit.FixMethodOrder;

public class MethodSorter {
    public static final Comparator<Method> DEFAULT = new Comparator<Method>(){

        @Override
        public int compare(Method method, Method method2) {
            int n;
            int n2 = method.getName().hashCode();
            if (n2 != (n = method2.getName().hashCode())) {
                return n2 < n ? -1 : 1;
            }
            return NAME_ASCENDING.compare(method, method2);
        }
    };
    public static final Comparator<Method> NAME_ASCENDING = new Comparator<Method>(){

        @Override
        public int compare(Method method, Method method2) {
            int n = method.getName().compareTo(method2.getName());
            if (n != 0) {
                return n;
            }
            return method.toString().compareTo(method2.toString());
        }
    };

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        Comparator<Method> comparator = MethodSorter.getSorter(clazz.getAnnotation(FixMethodOrder.class));
        Method[] methodArray = clazz.getDeclaredMethods();
        if (comparator != null) {
            Arrays.sort(methodArray, comparator);
        }
        return methodArray;
    }

    private MethodSorter() {
    }

    private static Comparator<Method> getSorter(FixMethodOrder fixMethodOrder) {
        if (fixMethodOrder == null) {
            return DEFAULT;
        }
        return fixMethodOrder.value().getComparator();
    }
}

