/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.TestClass;

@Deprecated
public class MethodValidator {
    private final List<Throwable> errors = new ArrayList<Throwable>();
    private TestClass testClass;

    public MethodValidator(TestClass testClass) {
        this.testClass = testClass;
    }

    public void validateInstanceMethods() {
        this.validateTestMethods(After.class, false);
        this.validateTestMethods(Before.class, false);
        this.validateTestMethods(Test.class, false);
        List<Method> list = this.testClass.getAnnotatedMethods(Test.class);
        if (list.size() == 0) {
            this.errors.add(new Exception("No runnable methods"));
        }
    }

    public void validateStaticMethods() {
        this.validateTestMethods(BeforeClass.class, true);
        this.validateTestMethods(AfterClass.class, true);
    }

    public List<Throwable> validateMethodsForDefaultRunner() {
        this.validateNoArgConstructor();
        this.validateStaticMethods();
        this.validateInstanceMethods();
        return this.errors;
    }

    public void assertValid() throws InitializationError {
        if (!this.errors.isEmpty()) {
            throw new InitializationError(this.errors);
        }
    }

    public void validateNoArgConstructor() {
        try {
            this.testClass.getConstructor();
        }
        catch (Exception exception) {
            this.errors.add(new Exception("Test class should have public zero-argument constructor", exception));
        }
    }

    private void validateTestMethods(Class<? extends Annotation> clazz, boolean bl) {
        List<Method> list = this.testClass.getAnnotatedMethods(clazz);
        for (Method method : list) {
            if (Modifier.isStatic(method.getModifiers()) != bl) {
                String string = bl ? "should" : "should not";
                this.errors.add(new Exception("Method " + method.getName() + "() " + string + " be static"));
            }
            if (!Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                this.errors.add(new Exception("Class " + method.getDeclaringClass().getName() + " should be public"));
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                this.errors.add(new Exception("Method " + method.getName() + " should be public"));
            }
            if (method.getReturnType() != Void.TYPE) {
                this.errors.add(new Exception("Method " + method.getName() + " should be void"));
            }
            if (method.getParameterTypes().length == 0) continue;
            this.errors.add(new Exception("Method " + method.getName() + " should have no parameters"));
        }
    }
}

