/*
 * Decompiled with CFR 0.152.
 */
package org.junit.rules;

import java.io.File;
import java.io.IOException;
import org.junit.rules.ExternalResource;

public class TemporaryFolder
extends ExternalResource {
    private final File parentFolder;
    private File folder;

    public TemporaryFolder() {
        this(null);
    }

    public TemporaryFolder(File file) {
        this.parentFolder = file;
    }

    @Override
    protected void before() throws Throwable {
        this.create();
    }

    @Override
    protected void after() {
        this.delete();
    }

    public void create() throws IOException {
        this.folder = this.createTemporaryFolderIn(this.parentFolder);
    }

    public File newFile(String string) throws IOException {
        File file = new File(this.getRoot(), string);
        if (!file.createNewFile()) {
            throw new IOException("a file with the name '" + string + "' already exists in the test folder");
        }
        return file;
    }

    public File newFile() throws IOException {
        return File.createTempFile("junit", null, this.getRoot());
    }

    public File newFolder(String string) throws IOException {
        return this.newFolder(new String[]{string});
    }

    public File newFolder(String ... stringArray) throws IOException {
        File file = this.getRoot();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.validateFolderName(string);
            file = new File(file, string);
            if (file.mkdir() || !this.isLastElementInArray(i, stringArray)) continue;
            throw new IOException("a folder with the name '" + string + "' already exists");
        }
        return file;
    }

    private void validateFolderName(String string) throws IOException {
        File file = new File(string);
        if (file.getParent() != null) {
            String string2 = "Folder name cannot consist of multiple path components separated by a file separator. Please use newFolder('MyParentFolder','MyFolder') to create hierarchies of folders";
            throw new IOException(string2);
        }
    }

    private boolean isLastElementInArray(int n, String[] stringArray) {
        return n == stringArray.length - 1;
    }

    public File newFolder() throws IOException {
        return this.createTemporaryFolderIn(this.getRoot());
    }

    private File createTemporaryFolderIn(File file) throws IOException {
        File file2 = File.createTempFile("junit", "", file);
        file2.delete();
        file2.mkdir();
        return file2;
    }

    public File getRoot() {
        if (this.folder == null) {
            throw new IllegalStateException("the temporary folder has not yet been created");
        }
        return this.folder;
    }

    public void delete() {
        if (this.folder != null) {
            this.recursiveDelete(this.folder);
        }
    }

    private void recursiveDelete(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                this.recursiveDelete(file2);
            }
        }
        file.delete();
    }
}

