/*   -*- buffer-read-only: t -*- vi: set ro:
 *
 *  DO NOT EDIT THIS FILE   (tcpbridge_opts.h)
 *
 *  It has been AutoGen-ed
 *  From the definitions    tcpbridge_opts.def
 *  and the template file   options
 *
 * Generated from AutoOpts 41:0:16 templates.
 *
 *  AutoOpts is a copyrighted work.  This header file is not encumbered
 *  by AutoOpts licensing, but is provided under the licensing terms chosen
 *  by the tcpbridge author or copyright holder.  AutoOpts is
 *  licensed under the terms of the LGPL.  The redistributable library
 *  (``libopts'') is licensed under the terms of either the LGPL or, at the
 *  users discretion, the BSD license.  See the AutoOpts and/or libopts sources
 *  for details.
 *
 * The tcpbridge program is copyrighted and licensed
 * under the following terms:
 *
 *  Copyright (C) 2000-2014 Aaron Turner and Fred Klassen, all rights reserved.
 *  This is free software. It is licensed for use, modification and
 *  redistribution under the terms of the GNU General Public License,
 *  version 3 or later <http://gnu.org/licenses/gpl.html>
 *
 *  tcpbridge is free software: you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  tcpbridge is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 *  This file contains the programmatic interface to the Automated
 *  Options generated for the tcpbridge program.
 *  These macros are documented in the AutoGen info file in the
 *  "AutoOpts" chapter.  Please refer to that doc for usage help.
 */
#ifndef AUTOOPTS_TCPBRIDGE_OPTS_H_GUARD
#define AUTOOPTS_TCPBRIDGE_OPTS_H_GUARD 1
#include "config.h"
#include <autoopts/options.h>

/**
 *  Ensure that the library used for compiling this generated header is at
 *  least as new as the version current when the header template was released
 *  (not counting patch version increments).  Also ensure that the oldest
 *  tolerable version is at least as old as what was current when the header
 *  template was released.
 */
#define AO_TEMPLATE_VERSION 167936
#if (AO_TEMPLATE_VERSION < OPTIONS_MINIMUM_VERSION) \
 || (AO_TEMPLATE_VERSION > OPTIONS_STRUCT_VERSION)
# error option template version mismatches autoopts/options.h header
  Choke Me.
#endif

/**
 *  Enumeration of each option type for tcpbridge
 */
typedef enum {
    INDEX_OPT_PORTMAP          =  1,
    INDEX_OPT_SEED             =  2,
    INDEX_OPT_PNAT             =  3,
    INDEX_OPT_SRCIPMAP         =  4,
    INDEX_OPT_DSTIPMAP         =  5,
    INDEX_OPT_ENDPOINTS        =  6,
    INDEX_OPT_SKIPBROADCAST    =  7,
    INDEX_OPT_FIXCSUM          =  8,
    INDEX_OPT_MTU              =  9,
    INDEX_OPT_MTU_TRUNC        = 10,
    INDEX_OPT_EFCS             = 11,
    INDEX_OPT_TTL              = 12,
    INDEX_OPT_TOS              = 13,
    INDEX_OPT_TCLASS           = 14,
    INDEX_OPT_FLOWLABEL        = 15,
    INDEX_OPT_FIXLEN           = 16,
    INDEX_OPT_SKIPL2BROADCAST  = 17,
    INDEX_OPT_DLT              = 18,
    INDEX_OPT_ENET_DMAC        = 19,
    INDEX_OPT_ENET_SMAC        = 20,
    INDEX_OPT_ENET_VLAN        = 21,
    INDEX_OPT_ENET_VLAN_TAG    = 22,
    INDEX_OPT_ENET_VLAN_CFI    = 23,
    INDEX_OPT_ENET_VLAN_PRI    = 24,
    INDEX_OPT_HDLC_CONTROL     = 25,
    INDEX_OPT_HDLC_ADDRESS     = 26,
    INDEX_OPT_USER_DLT         = 27,
    INDEX_OPT_USER_DLINK       = 28,
    INDEX_OPT_DBUG             = 29,
    INDEX_OPT_INTF1            = 30,
    INDEX_OPT_INTF2            = 31,
    INDEX_OPT_UNIDIR           = 32,
    INDEX_OPT_LISTNICS         = 33,
    INDEX_OPT_LIMIT            = 34,
    INDEX_OPT_MAC              = 35,
    INDEX_OPT_INCLUDE          = 36,
    INDEX_OPT_EXCLUDE          = 37,
    INDEX_OPT_PID              = 38,
    INDEX_OPT_VERBOSE          = 39,
    INDEX_OPT_DECODE           = 40,
    INDEX_OPT_VERSION          = 41,
    INDEX_OPT_LESS_HELP        = 42,
    INDEX_OPT_HELP             = 43,
    INDEX_OPT_MORE_HELP        = 44,
    INDEX_OPT_SAVE_OPTS        = 45,
    INDEX_OPT_LOAD_OPTS        = 46
} teOptIndex;
/** count of all options for tcpbridge */
#define OPTION_CT    47

/**
 *  Interface defines for all options.  Replace "n" with the UPPER_CASED
 *  option name (as in the teOptIndex enumeration above).
 *  e.g. HAVE_OPT(TCPEDIT)
 */
#define         DESC(n) (tcpbridgeOptions.pOptDesc[INDEX_OPT_## n])
/** 'true' if an option has been specified in any way */
#define     HAVE_OPT(n) (! UNUSED_OPT(& DESC(n)))
/** The string argument to an option. The argument type must be \"string\". */
#define      OPT_ARG(n) (DESC(n).optArg.argString)
/** Mask the option state revealing how an option was specified.
 *  It will be one and only one of \a OPTST_SET, \a OPTST_PRESET,
 * \a OPTST_DEFINED, \a OPTST_RESET or zero.
 */
#define    STATE_OPT(n) (DESC(n).fOptState & OPTST_SET_MASK)
/** Count of option's occurrances *on the command line*. */
#define    COUNT_OPT(n) (DESC(n).optOccCt)
/** mask of \a OPTST_SET and \a OPTST_DEFINED. */
#define    ISSEL_OPT(n) (SELECTED_OPT(&DESC(n)))
/** 'true' if \a HAVE_OPT would yield 'false'. */
#define ISUNUSED_OPT(n) (UNUSED_OPT(& DESC(n)))
/** 'true' if OPTST_DISABLED bit not set. */
#define  ENABLED_OPT(n) (! DISABLED_OPT(& DESC(n)))
/** number of stacked option arguments.
 *  Valid only for stacked option arguments. */
#define  STACKCT_OPT(n) (((tArgList*)(DESC(n).optCookie))->useCt)
/** stacked argument vector.
 *  Valid only for stacked option arguments. */
#define STACKLST_OPT(n) (((tArgList*)(DESC(n).optCookie))->apzArgs)
/** Reset an option. */
#define    CLEAR_OPT(n) STMTS( \
                DESC(n).fOptState &= OPTST_PERSISTENT_MASK;   \
                if ((DESC(n).fOptState & OPTST_INITENABLED) == 0) \
                    DESC(n).fOptState |= OPTST_DISABLED; \
                DESC(n).optCookie = NULL )
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 *  Enumeration of tcpbridge exit codes
 */
typedef enum {
    TCPBRIDGE_EXIT_SUCCESS         = 0,
    TCPBRIDGE_EXIT_FAILURE         = 1,
    TCPBRIDGE_EXIT_USAGE_ERROR     = 64,
    TCPBRIDGE_EXIT_NO_CONFIG_INPUT = 66,
    TCPBRIDGE_EXIT_LIBOPTS_FAILURE = 70
}   tcpbridge_exit_code_t;
/**
 *  Interface defines for specific options.
 * @{
 */
#define VALUE_OPT_PORTMAP        'r'
#define VALUE_OPT_SEED           's'

#define OPT_VALUE_SEED           (DESC(SEED).optArg.argInt)
#define VALUE_OPT_PNAT           'N'
#define VALUE_OPT_SRCIPMAP       'S'
#define VALUE_OPT_DSTIPMAP       'D'
#define VALUE_OPT_ENDPOINTS      'e'
#define VALUE_OPT_SKIPBROADCAST  'b'
#define VALUE_OPT_FIXCSUM        'C'
#define VALUE_OPT_MTU            'm'

#define OPT_VALUE_MTU            (DESC(MTU).optArg.argInt)
#define VALUE_OPT_MTU_TRUNC      0x1001
#define VALUE_OPT_EFCS           'E'
#define VALUE_OPT_TTL            0x1002
#define VALUE_OPT_TOS            0x1003

#define OPT_VALUE_TOS            (DESC(TOS).optArg.argInt)
#define VALUE_OPT_TCLASS         0x1004

#define OPT_VALUE_TCLASS         (DESC(TCLASS).optArg.argInt)
#define VALUE_OPT_FLOWLABEL      0x1005

#define OPT_VALUE_FLOWLABEL      (DESC(FLOWLABEL).optArg.argInt)
#define VALUE_OPT_FIXLEN         'F'
#define VALUE_OPT_SKIPL2BROADCAST 0x1006
#define VALUE_OPT_DLT            0x1007
#define VALUE_OPT_ENET_DMAC      0x1008
#define VALUE_OPT_ENET_SMAC      0x1009
#define VALUE_OPT_ENET_VLAN      0x100A
#define VALUE_OPT_ENET_VLAN_TAG  0x100B

#define OPT_VALUE_ENET_VLAN_TAG  (DESC(ENET_VLAN_TAG).optArg.argInt)
#define VALUE_OPT_ENET_VLAN_CFI  0x100C

#define OPT_VALUE_ENET_VLAN_CFI  (DESC(ENET_VLAN_CFI).optArg.argInt)
#define VALUE_OPT_ENET_VLAN_PRI  0x100D

#define OPT_VALUE_ENET_VLAN_PRI  (DESC(ENET_VLAN_PRI).optArg.argInt)
#define VALUE_OPT_HDLC_CONTROL   0x100E

#define OPT_VALUE_HDLC_CONTROL   (DESC(HDLC_CONTROL).optArg.argInt)
#define VALUE_OPT_HDLC_ADDRESS   0x100F

#define OPT_VALUE_HDLC_ADDRESS   (DESC(HDLC_ADDRESS).optArg.argInt)
#define VALUE_OPT_USER_DLT       0x1010

#define OPT_VALUE_USER_DLT       (DESC(USER_DLT).optArg.argInt)
#define VALUE_OPT_USER_DLINK     0x1011
#define VALUE_OPT_DBUG           'd'
#ifdef DEBUG
#define OPT_VALUE_DBUG           (DESC(DBUG).optArg.argInt)
#endif /* DEBUG */
#define VALUE_OPT_INTF1          'i'
#define VALUE_OPT_INTF2          'I'
#define VALUE_OPT_UNIDIR         'u'
#define VALUE_OPT_LISTNICS       0x1012
#define VALUE_OPT_LIMIT          'L'

#define OPT_VALUE_LIMIT          (DESC(LIMIT).optArg.argInt)
#define VALUE_OPT_MAC            'M'
#define VALUE_OPT_INCLUDE        'x'
#define VALUE_OPT_EXCLUDE        'X'
#define VALUE_OPT_PID            'P'
#define VALUE_OPT_VERBOSE        'v'
#ifdef ENABLE_VERBOSE
#define SET_OPT_VERBOSE   STMTS( \
        DESC(VERBOSE).optActualIndex = 39; \
        DESC(VERBOSE).optActualValue = VALUE_OPT_VERBOSE; \
        DESC(VERBOSE).fOptState &= OPTST_PERSISTENT_MASK; \
        DESC(VERBOSE).fOptState |= OPTST_SET )
#endif /* ENABLE_VERBOSE */
#define VALUE_OPT_DECODE         'A'
#define VALUE_OPT_VERSION        'V'
#define VALUE_OPT_LESS_HELP      'h'
/** option flag (value) for help-value option */
#define VALUE_OPT_HELP          'H'
/** option flag (value) for more-help-value option */
#define VALUE_OPT_MORE_HELP     '!'
/** option flag (value) for save-opts-value option */
#define VALUE_OPT_SAVE_OPTS     0x1013
/** option flag (value) for load-opts-value option */
#define VALUE_OPT_LOAD_OPTS     0x1014
#define SET_OPT_SAVE_OPTS(a)   STMTS( \
        DESC(SAVE_OPTS).fOptState &= OPTST_PERSISTENT_MASK; \
        DESC(SAVE_OPTS).fOptState |= OPTST_SET; \
        DESC(SAVE_OPTS).optArg.argString = (char const*)(a))
/*
 *  Interface defines not associated with particular options
 */
#define ERRSKIP_OPTERR  STMTS(tcpbridgeOptions.fOptSet &= ~OPTPROC_ERRSTOP)
#define ERRSTOP_OPTERR  STMTS(tcpbridgeOptions.fOptSet |= OPTPROC_ERRSTOP)
#define RESTART_OPT(n)  STMTS( \
                tcpbridgeOptions.curOptIdx = (n); \
                tcpbridgeOptions.pzCurOpt  = NULL )
#define START_OPT       RESTART_OPT(1)
#define USAGE(c)        (*tcpbridgeOptions.pUsageProc)(&tcpbridgeOptions, c)

#ifdef  __cplusplus
extern "C" {
#endif


/* * * * * *
 *
 *  Declare the tcpbridge option descriptor.
 */
extern tOptions tcpbridgeOptions;

#if defined(ENABLE_NLS)
# ifndef _
#   include <stdio.h>
#   ifndef HAVE_GETTEXT
      extern char * gettext(char const *);
#   else
#     include <libintl.h>
#   endif

# ifndef ATTRIBUTE_FORMAT_ARG
#   define ATTRIBUTE_FORMAT_ARG(_a)
# endif

static inline char* aoGetsText(char const* pz) ATTRIBUTE_FORMAT_ARG(1);
static inline char* aoGetsText(char const* pz) {
    if (pz == NULL) return NULL;
    return (char*)gettext(pz);
}
#   define _(s)  aoGetsText(s)
# endif /* _() */

# define OPT_NO_XLAT_CFG_NAMES  STMTS(tcpbridgeOptions.fOptSet |= \
                                    OPTPROC_NXLAT_OPT_CFG;)
# define OPT_NO_XLAT_OPT_NAMES  STMTS(tcpbridgeOptions.fOptSet |= \
                                    OPTPROC_NXLAT_OPT|OPTPROC_NXLAT_OPT_CFG;)

# define OPT_XLAT_CFG_NAMES     STMTS(tcpbridgeOptions.fOptSet &= \
                                  ~(OPTPROC_NXLAT_OPT|OPTPROC_NXLAT_OPT_CFG);)
# define OPT_XLAT_OPT_NAMES     STMTS(tcpbridgeOptions.fOptSet &= \
                                  ~OPTPROC_NXLAT_OPT;)

#else   /* ENABLE_NLS */
# define OPT_NO_XLAT_CFG_NAMES
# define OPT_NO_XLAT_OPT_NAMES

# define OPT_XLAT_CFG_NAMES
# define OPT_XLAT_OPT_NAMES

# ifndef _
#   define _(_s)  _s
# endif
#endif  /* ENABLE_NLS */

#ifdef  __cplusplus
}
#endif
#endif /* AUTOOPTS_TCPBRIDGE_OPTS_H_GUARD */

/* tcpbridge_opts.h ends here */
