/*   -*- buffer-read-only: t -*- vi: set ro:
 *
 *  DO NOT EDIT THIS FILE   (tcpedit_stub.h)
 *
 *  It has been AutoGen-ed
 *  From the definitions    tcpedit_stub.def
 *  and the template file   options
 *
 * Generated from AutoOpts 41:0:16 templates.
 *
 *  AutoOpts is a copyrighted work.  This header file is not encumbered
 *  by AutoOpts licensing, but is provided under the licensing terms chosen
 *  by the tcpedit_stub author or copyright holder.  AutoOpts is
 *  licensed under the terms of the LGPL.  The redistributable library
 *  (``libopts'') is licensed under the terms of either the LGPL or, at the
 *  users discretion, the BSD license.  See the AutoOpts and/or libopts sources
 *  for details.
 */
/**
 *  This file contains the programmatic interface to the Automated
 *  Options generated for the tcpedit_stub program.
 *  These macros are documented in the AutoGen info file in the
 *  "AutoOpts" chapter.  Please refer to that doc for usage help.
 */
#ifndef AUTOOPTS_TCPEDIT_STUB_H_GUARD
#define AUTOOPTS_TCPEDIT_STUB_H_GUARD 1
#include <autoopts/options.h>

/**
 *  Enumeration of each option type for tcpedit_stub
 */
typedef enum {
    INDEX_OPT_PORTMAP                   =  1,
    INDEX_OPT_SEED                      =  2,
    INDEX_OPT_PNAT                      =  3,
    INDEX_OPT_SRCIPMAP                  =  4,
    INDEX_OPT_DSTIPMAP                  =  5,
    INDEX_OPT_ENDPOINTS                 =  6,
    INDEX_OPT_SKIPBROADCAST             =  7,
    INDEX_OPT_FIXCSUM                   =  8,
    INDEX_OPT_MTU                       =  9,
    INDEX_OPT_MTU_TRUNC                 = 10,
    INDEX_OPT_EFCS                      = 11,
    INDEX_OPT_TTL                       = 12,
    INDEX_OPT_TOS                       = 13,
    INDEX_OPT_TCLASS                    = 14,
    INDEX_OPT_FLOWLABEL                 = 15,
    INDEX_OPT_FIXLEN                    = 16,
    INDEX_OPT_FUZZ_SEED                 = 17,
    INDEX_OPT_SKIPL2BROADCAST           = 18,
    INDEX_OPT_DLT                       = 19,
    INDEX_OPT_ENET_DMAC                 = 20,
    INDEX_OPT_ENET_SMAC                 = 21,
    INDEX_OPT_ENET_SUBSMAC              = 22,
    INDEX_OPT_ENET_MAC_SEED             = 23,
    INDEX_OPT_ENET_MAC_SEED_KEEP_BYTES  = 24,
    INDEX_OPT_ENET_VLAN                 = 25,
    INDEX_OPT_ENET_VLAN_TAG             = 26,
    INDEX_OPT_ENET_VLAN_CFI             = 27,
    INDEX_OPT_ENET_VLAN_PRI             = 28,
    INDEX_OPT_HDLC_CONTROL              = 29,
    INDEX_OPT_HDLC_ADDRESS              = 30,
    INDEX_OPT_USER_DLT                  = 31,
    INDEX_OPT_USER_DLINK                = 32,
        LIBRARY_OPTION_COUNT
} teOptIndex;
/** count of all options for tcpedit_stub */
#define OPTION_CT    33

/**
 *  Interface defines for all options.  Replace "n" with the UPPER_CASED
 *  option name (as in the teOptIndex enumeration above).
 *  e.g. HAVE_OPT(TCPEDIT)
 */
/** pointer to the library handling procedure. */
extern tOptDesc * const tcpedit_tcpedit_optDesc_p;
#define         DESC(n) (tcpedit_tcpedit_optDesc_p[INDEX_OPT_## n])
/** 'true' if an option has been specified in any way */
#define     HAVE_OPT(n) (! UNUSED_OPT(& DESC(n)))
/** The string argument to an option. The argument type must be \"string\". */
#define      OPT_ARG(n) (DESC(n).optArg.argString)
/** Mask the option state revealing how an option was specified.
 *  It will be one and only one of \a OPTST_SET, \a OPTST_PRESET,
 * \a OPTST_DEFINED, \a OPTST_RESET or zero.
 */
#define    STATE_OPT(n) (DESC(n).fOptState & OPTST_SET_MASK)
/** Count of option's occurrances *on the command line*. */
#define    COUNT_OPT(n) (DESC(n).optOccCt)
/** mask of \a OPTST_SET and \a OPTST_DEFINED. */
#define    ISSEL_OPT(n) (SELECTED_OPT(&DESC(n)))
/** 'true' if \a HAVE_OPT would yield 'false'. */
#define ISUNUSED_OPT(n) (UNUSED_OPT(& DESC(n)))
/** 'true' if OPTST_DISABLED bit not set. */
#define  ENABLED_OPT(n) (! DISABLED_OPT(& DESC(n)))
/** number of stacked option arguments.
 *  Valid only for stacked option arguments. */
#define  STACKCT_OPT(n) (((tArgList*)(DESC(n).optCookie))->useCt)
/** stacked argument vector.
 *  Valid only for stacked option arguments. */
#define STACKLST_OPT(n) (((tArgList*)(DESC(n).optCookie))->apzArgs)
/** Reset an option. */
#define    CLEAR_OPT(n) STMTS( \
                DESC(n).fOptState &= OPTST_PERSISTENT_MASK;   \
                if ((DESC(n).fOptState & OPTST_INITENABLED) == 0) \
                    DESC(n).fOptState |= OPTST_DISABLED; \
                DESC(n).optCookie = NULL )
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 *  Enumeration of tcpedit_stub exit codes
 */
typedef enum {
    TCPEDIT_STUB_EXIT_SUCCESS         = 0,
    TCPEDIT_STUB_EXIT_FAILURE         = 1,
    TCPEDIT_STUB_EXIT_USAGE_ERROR     = 64,
    TCPEDIT_STUB_EXIT_LIBOPTS_FAILURE = 70
}   tcpedit_stub_exit_code_t;
/**
 *  Interface defines for specific options.
 * @{
 */
#define VALUE_OPT_PORTMAP        'r'
#define VALUE_OPT_SEED           's'

#define OPT_VALUE_SEED           (DESC(SEED).optArg.argInt)
#define VALUE_OPT_PNAT           'N'
#define VALUE_OPT_SRCIPMAP       'S'
#define VALUE_OPT_DSTIPMAP       'D'
#define VALUE_OPT_ENDPOINTS      'e'
#define VALUE_OPT_SKIPBROADCAST  'b'
#define VALUE_OPT_FIXCSUM        'C'
#define VALUE_OPT_MTU            'm'

#define OPT_VALUE_MTU            (DESC(MTU).optArg.argInt)
#define VALUE_OPT_MTU_TRUNC      0x1001
#define VALUE_OPT_EFCS           'E'
#define VALUE_OPT_TTL            0x1002
#define VALUE_OPT_TOS            0x1003

#define OPT_VALUE_TOS            (DESC(TOS).optArg.argInt)
#define VALUE_OPT_TCLASS         0x1004

#define OPT_VALUE_TCLASS         (DESC(TCLASS).optArg.argInt)
#define VALUE_OPT_FLOWLABEL      0x1005

#define OPT_VALUE_FLOWLABEL      (DESC(FLOWLABEL).optArg.argInt)
#define VALUE_OPT_FIXLEN         'F'
#define VALUE_OPT_FUZZ_SEED      0x1006

#define OPT_VALUE_FUZZ_SEED      (DESC(FUZZ_SEED).optArg.argInt)
#define VALUE_OPT_SKIPL2BROADCAST 0x1007
#define VALUE_OPT_DLT            0x1008
#define VALUE_OPT_ENET_DMAC      0x1009
#define VALUE_OPT_ENET_SMAC      0x100A
#define VALUE_OPT_ENET_SUBSMAC   0x100B
#define VALUE_OPT_ENET_MAC_SEED  0x100C

#define OPT_VALUE_ENET_MAC_SEED  (DESC(ENET_MAC_SEED).optArg.argInt)
#define VALUE_OPT_ENET_MAC_SEED_KEEP_BYTES 0x100D

#define OPT_VALUE_ENET_MAC_SEED_KEEP_BYTES (DESC(ENET_MAC_SEED_KEEP_BYTES).optArg.argInt)
#define VALUE_OPT_ENET_VLAN      0x100E
#define VALUE_OPT_ENET_VLAN_TAG  0x100F

#define OPT_VALUE_ENET_VLAN_TAG  (DESC(ENET_VLAN_TAG).optArg.argInt)
#define VALUE_OPT_ENET_VLAN_CFI  0x1010

#define OPT_VALUE_ENET_VLAN_CFI  (DESC(ENET_VLAN_CFI).optArg.argInt)
#define VALUE_OPT_ENET_VLAN_PRI  0x1011

#define OPT_VALUE_ENET_VLAN_PRI  (DESC(ENET_VLAN_PRI).optArg.argInt)
#define VALUE_OPT_HDLC_CONTROL   0x1012

#define OPT_VALUE_HDLC_CONTROL   (DESC(HDLC_CONTROL).optArg.argInt)
#define VALUE_OPT_HDLC_ADDRESS   0x1013

#define OPT_VALUE_HDLC_ADDRESS   (DESC(HDLC_ADDRESS).optArg.argInt)
#define VALUE_OPT_USER_DLT       0x1014

#define OPT_VALUE_USER_DLT       (DESC(USER_DLT).optArg.argInt)
#define VALUE_OPT_USER_DLINK     0x1015
/** option flag (value) for help-value option */
#define VALUE_OPT_HELP          '?'
/** option flag (value) for more-help-value option */
#define VALUE_OPT_MORE_HELP     '!'
#endif /* AUTOOPTS_TCPEDIT_STUB_H_GUARD */

/* tcpedit_stub.h ends here */
