#! /bin/sh
max_hw_debounce_time=512
max_hw_debounce_num=16
cd /sys/bus/platform/drivers/eint/
for eint_num_exp in $(seq 16 168)
do
	for eint_deb_exp in 1000 2000 3000 4000
	do
		fail=0
		#Set eint number
		echo $eint_num_exp > ./current_eint
                eint_num="`cat ./current_eint`"
                if [ $eint_num != $eint_num_exp ]; then
                        echo "1. Not the same!! $eint_num != $eint_num_exp exp"
			fail=1
                fi
		#Set polarity
		echo 1 > ./current_eint_pol
                eint_pol_exp=1
                eint_pol="`cat ./current_eint_pol`"
		#Set sens
		echo 1 > ./current_eint_sens
                eint_sens_exp=1
                eint_sens="`cat ./current_eint_sens`"
                if [ $eint_pol != $eint_pol_exp ] || [ $eint_sens != $eint_sens_exp ]; then
                        echo "2. eint_num: $eint_num_exp"
                        echo "Not the same!! $eint_pol != $eint_pol_exp exp"
                        echo "Not the same!! $eint_sens != $eint_sens_exp exp"
			fail=1
                fi
		#Set deb time
		echo $eint_deb_exp > ./current_eint_deb
                eint_deb="`cat ./current_eint_deb`"	
        	if [ $eint_deb != $eint_deb_exp ]; then
                	echo "3. Not the same!! $eint_deb != $eint_deb_exp exp"
			fail=1
		fi
		#enable debounce
		echo 1 > ./current_eint_deb_en
                eint_deb_en_exp=1
                eint_deb_en="`cat ./current_eint_deb_en`"
		#Register soft isr
		echo 1 > ./current_eint_reg_isr
                eint_reg_isr_exp=$eint_deb_exp
                eint_reg_isr="`cat ./current_eint_reg_isr`"
                if [ $eint_reg_isr != $eint_reg_isr_exp ] || [ $eint_deb_en != $eint_deb_en_exp ]; then
                        echo "4. eint_num: $eint_num_exp"
                        echo "Not the same!! $eint_deb_en != $eint_deb_en_exp exp"
                        echo "Not the same!! $eint_reg_isr != $eint_reg_isr_exp exp"
			fail=1
                fi
		#Set soft interrupt, and cancel this soft interrupt.
		#check the isr is called or not after sleep '${eint_deb_exp}/1000' secs
		#The isr should not be called.
		echo 1 > ./current_eint_soft_set
		echo 0 > ./current_eint_soft_set
		sleeptime="`expr ${eint_deb_exp} / 1000`"
		sleep $sleeptime
                eint_soft_set_exp=0
                eint_soft_set="`cat ./current_eint_soft_set`"
                if [ $eint_soft_set != $eint_soft_set_exp ]; then
                        echo "5. eint_num: $eint_num_exp"
                        echo "Not the same!! $eint_soft_set != $eint_soft_set_exp exp, interrupt is called"
			fail=1
                fi
		#Set soft interrupt
		#check the isr is called or not after sleep '${eint_deb_exp}/1000' secs
		#The isr should be called.
		echo 1 > ./current_eint_soft_set
		sleep $sleeptime
                eint_soft_set_exp=1
                eint_soft_set="`cat ./current_eint_soft_set`"
                if [ $eint_soft_set != $eint_soft_set_exp ]; then
                        echo "6. eint_num: $eint_num_exp"
                        echo "Not the same!! $eint_soft_set != $eint_soft_set_exp exp, interrupt is not called"
			fail=1
                fi
		#UnRegister soft isr
		echo 0 > ./current_eint_reg_isr
                eint_reg_isr_exp=$eint_deb_exp
                eint_reg_isr="`cat ./current_eint_reg_isr`"
                if [ $eint_reg_isr != $eint_reg_isr_exp ]; then
                        echo "7. eint_num: $eint_num_exp"
                        echo "Not the same!! $eint_reg_isr != $eint_reg_isr_exp exp"
			fail=1
                fi
                if [ $fail == 0 ]; then
                        echo "8. eint_num: $eint_num,eint_deb_exp: $eint_deb_exp Pass!!!"
		else
                        echo "8. eint_num: $eint_num,eint_deb_exp: $eint_deb_exp Fail!!!"
                fi
	done
done
for eint_num_exp in $(seq 0 168)
do
	for eint_deb_exp in 1 16 32 64 128 256 512 600
	do
		fail=0
		#Set eint number
		echo $eint_num_exp > ./current_eint
                eint_num="`cat ./current_eint`"
                if [ $eint_num != $eint_num_exp ]; then
                        echo "1. Not the same!! $eint_num != $eint_num_exp exp"
			fail=1
                fi
		#Set polarity
		echo 0 > ./current_eint_pol
                eint_pol_exp=0
                eint_pol="`cat ./current_eint_pol`"
		#Set sens
		echo 0 > ./current_eint_sens
                eint_sens_exp=0
                eint_sens="`cat ./current_eint_sens`"
                if [ $eint_pol != $eint_pol_exp ] || [ $eint_sens != $eint_sens_exp ]; then
                        echo "2. eint_num: $eint_num_exp"
                        echo "Not the same!! $eint_pol != $eint_pol_exp exp"
                        echo "Not the same!! $eint_sens != $eint_sens_exp exp"
			fail=1
                fi
		#Set polarity
		echo 1 > ./current_eint_pol
                eint_pol_exp=1
                eint_pol="`cat ./current_eint_pol`"
		#Set sens
		echo 1 > ./current_eint_sens
                eint_sens_exp=1
                eint_sens="`cat ./current_eint_sens`"
                if [ $eint_pol != $eint_pol_exp ] || [ $eint_sens != $eint_sens_exp ]; then
                        echo "3. eint_num: $eint_num_exp"
                        echo "Not the same!! $eint_pol != $eint_pol_exp exp"
                        echo "Not the same!! $eint_sens != $eint_sens_exp exp"
			fail=1
                fi
		#Set deb time
		echo $eint_deb_exp > ./current_eint_deb
                eint_deb="`cat ./current_eint_deb`"	
		if [ $eint_num_exp -lt $max_hw_debounce_num ] && [ $eint_deb_exp -gt $max_hw_debounce_time ]; then
			eint_deb_exp=$max_hw_debounce_time
		fi
        	if [ $eint_deb != $eint_deb_exp ]; then
                	echo "4. Not the same!! $eint_deb != $eint_deb_exp exp"
			fail=1
		fi
		#enable debounce
		echo 1 > ./current_eint_deb_en
                eint_deb_en_exp=1
                eint_deb_en="`cat ./current_eint_deb_en`"
		#Register soft isr
		echo 1 > ./current_eint_reg_isr
                eint_reg_isr_exp=$eint_deb_exp
                eint_reg_isr="`cat ./current_eint_reg_isr`"
                if [ $eint_reg_isr != $eint_reg_isr_exp ] || [ $eint_deb_en != $eint_deb_en_exp ]; then
                        echo "5. eint_num: $eint_num_exp"
                        echo "Not the same!! $eint_deb_en != $eint_deb_en_exp exp"
                        echo "Not the same!! $eint_reg_isr != $eint_reg_isr_exp exp"
			fail=1
                fi
		#Set soft interrupt
		echo 1 > ./current_eint_soft_set
		sleep 1
                eint_soft_set_exp=1
                eint_soft_set="`cat ./current_eint_soft_set`"
                if [ $eint_soft_set != $eint_soft_set_exp ]; then
                        echo "6. eint_num: $eint_num_exp"
                        echo "Not the same!! $eint_soft_set != $eint_soft_set_exp exp"
			fail=1
                fi
		#UnRegister soft isr
		echo 0 > ./current_eint_reg_isr
                eint_reg_isr_exp=$eint_deb_exp
                eint_reg_isr="`cat ./current_eint_reg_isr`"
                if [ $eint_reg_isr != $eint_reg_isr_exp ]; then
                        echo "7. eint_num: $eint_num_exp"
                        echo "Not the same!! $eint_reg_isr != $eint_reg_isr_exp exp"
			fail=1
                fi
                if [ $fail == 0 ]; then
                        echo "8. eint_num: $eint_num,eint_deb_exp: $eint_deb_exp Pass!!!"
		else
                        echo "8. eint_num: $eint_num,eint_deb_exp: $eint_deb_exp Fail!!!"
                fi
	done
done
