/*
 * ZeroTier One - Network Virtualization Everywhere
 * Copyright (C) 2011-2015  ZeroTier, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * --
 *
 * ZeroTier may be used and distributed under the terms of the GPLv3, which
 * are available at: http://www.gnu.org/licenses/gpl-3.0.html
 *
 * If you would like to embed ZeroTier into a commercial application or
 * redistribute it in a modified binary form, please contact ZeroTier Networks
 * LLC. Start here: http://www.zerotier.com/
 */

package com.zerotier.sdk;

/**
 * Function return code: OK (0) or error results
 *
 * <p>Use {@link ResultCode#isFatal) to check for a fatal error. If a fatal error
 * occurs, the node should be considered to not be working correctly. These
 * indicate serious problems like an inaccessible data store or a compile
 * problem.</p>
 */
public enum ResultCode {
    /**
     * Operation completed normally
     */
	RESULT_OK(0),

    // Fatal errors (> 0, < 1000)
    /**
     * Ran out of memory
     */
	RESULT_FATAL_ERROR_OUT_OF_MEMORY(1),

    /**
     * Data store is not writable or has failed
     */
	RESULT_FATAL_ERROR_DATA_STORE_FAILED(2),

    /**
     * Internal error (e.g. unexpected exception indicating bug or build problem)
     */
	RESULT_FATAL_ERROR_INTERNAL(3),

    // non-fatal errors

    /**
     * Network ID not valid
     */
	RESULT_ERROR_NETWORK_NOT_FOUND(1000);
	
	private final int id;
    ResultCode(int id) { this.id = id; }
    public int getValue() { return id; }

    public boolean isFatal(int id) {
    	return (id > 0 && id < 1000);
    }
}