/* vim: set sw=4 ts=4 sts=4 et : */
/********************************************************************\
 * This program is free software; you can redistribute it and/or    *
 * modify it under the terms of the GNU General Public License as   *
 * published by the Free Software Foundation; either version 2 of   *
 * the License, or (at your option) any later version.              *
 *                                                                  *
 * This program is distributed in the hope that it will be useful,  *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of   *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    *
 * GNU General Public License for more details.                     *
 *                                                                  *
 * You should have received a copy of the GNU General Public License*
 * along with this program; if not, contact:                        *
 *                                                                  *
 * Free Software Foundation           Voice:  +1-617-542-5942       *
 * 59 Temple Place - Suite 330        Fax:    +1-617-542-2652       *
 * Boston, MA  02111-1307,  USA       gnu@gnu.org                   *
 *                                                                  *
\********************************************************************/

/* $Id$ */
/** @file centralserver.h
    @brief Functions to talk to the central server (auth/send stats/get rules/etc...)
    @author Copyright (C) 2004 Philippe April <papril777@yahoo.com>
    @author Copyright (C) 2016 Dengfeng Liu <liudengfeng@kunteng.org>
 */

#ifndef _CENTRALSERVER_H_
#define _CENTRALSERVER_H_

#include <json-c/json.h>

#include "auth.h"
#include "simple_http.h"

/** @brief Ask the central server to login a client */
#define REQUEST_TYPE_LOGIN     "login"
/** @brief Notify the the central server of a client logout */
#define REQUEST_TYPE_LOGOUT    "logout"
/** @brief Update the central server's traffic counters */
#define REQUEST_TYPE_COUNTERS  "counters"

/** @brief Sent when the user's token is denied by the central server */
#define GATEWAY_MESSAGE_DENIED     "denied"
/** @brief Sent when the user's token is accepted, but user is on probation  */
#define GATEWAY_MESSAGE_ACTIVATE_ACCOUNT     "activate"
/** @brief  Sent when the user's token is denied by the central server because the probation period is over */
#define GATEWAY_MESSAGE_ACCOUNT_VALIDATION_FAILED     "failed_validation"
/** @brief Sent after the user performed a manual log-out on the gateway  */
#define GATEWAY_MESSAGE_ACCOUNT_LOGGED_OUT     "logged-out"

typedef enum {
    online_client,
    trusted_client
} client_type_t;

typedef enum {
    request_type_login,
    request_type_logout,
    request_type_counters
} request_type_t;

struct auth_response_client {
    request_type_t type;
    t_client       *client;
    request        *req;
};

json_object *auth_server_roam_request(const char *mac);

/** @brief Initiates a transaction with the auth server */
t_authcode auth_server_request(t_authresponse * authresponse,
                 const char *request_type,
                 const char *ip,
                 const char *mac,
                 const char *token, unsigned long long int incoming, unsigned long long int outgoing, 
							   unsigned long long int incoming_delta, unsigned long long int outgoing_delta,
							   //>>> liudf added 20160112
							   time_t first_login, unsigned int online_time, char *name, int wired);

/** @brief Tries really hard to connect to an auth server.  Returns a connected file descriptor or -1 on error */
int connect_auth_server(void);

/** @brief Helper function called by connect_auth_server() to do the actual work including recursion - DO NOT CALL DIRECTLY */
int _connect_auth_server(int level);

/** @brief close  auth server connected socket*/
void _close_auth_server();

/** @brief thread-safe close auth server connected socket*/
void close_auth_server();

/**@brief thread-safe to decrease authserv_fd_ref, not close connection really*/
void decrease_authserv_fd_ref();

char *get_auth_uri(const char *, client_type_t , void *);

void process_auth_server_response(struct evhttp_request *, void *);

#endif                          /* _CENTRALSERVER_H_ */
