/*
 * Copyright (C) 2006 BATMAN contributors:
 * Axel Neumann
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA
 *
 */


#define MIN_UPTIME 0
#define MAX_UPTIME 2147383 /*(((TP32/1000)/2)-100) /1000 to talk about seconds and not ms, /2 to not render scheduled events outdated, -100 to be save */
#define DEF_UPTIME 0 

#define DBGT_NONE 0
#define	DBGT_INFO 1
#define	DBGT_WARN 2
#define	DBGT_ERR  3


extern int debug_level;
#define DBGL_MIN	0
#define DBGL_SYS	0
#define DBGL_ROUTES	1
#define DBGL_GATEWAYS	2
#define DBGL_CHANGES	3
#define DBGL_ALL	4
#define DBGL_PROFILE	5
#define DBGL_UNUSED	6
#define DBGL_SERVICES	7
#define DBGL_DETAILS	8
#define DBGL_HNAS	9
#define DBGL_LINKS	10
#define DBGL_TEST	11
#define DBGL_MAX 	11
#define DBGL_INVALID	12


extern int unix_sock;

extern struct list_head_first ctrl_list;

#define ARG_PEDANTIC_CMDCHECK "pedantic_cmd_check"


extern int32_t Client_mode;


#define CONNECTION_END_STR "$"
#define CONNECTION_END_CHR '$'

enum {
	CTRL_CLOSE_ERROR,
	CTRL_CLOSE_SUCCESS,
	CTRL_CLOSE_STRAIGHT,
	CTRL_CLOSE_DELAY,
	CTRL_CLEANUP,
	CTRL_PURGE_ALL
};

#define CTRL_CLOSING_TIMEOUT	5000


struct ctrl_node
{
	struct list_head list;
	int fd;
	void (*cn_fd_handler) (struct ctrl_node *);
	uint32_t closing_stamp;
	uint8_t authorized;
	int8_t dbgl;
};

extern struct list_head_first dbgl_clients[DBGL_MAX+1];

struct dbgl_node
{
	struct list_head list;
	struct ctrl_node *cn;
};



// muting does not help if a changing value like time or seqno occurs durig the first DBG_HIST_TEXT_SIZE bytes
#define DBG_HIST_TEXT_SIZE 80 
#define DBG_HIST_SIZE 20
//#define DBG_HIST_EXPIRE 100000

struct dbg_histogram {
	uint32_t print_stamp;
	uint32_t expire;
	uint16_t check_len;
	uint16_t catched;
	char text[ DBG_HIST_TEXT_SIZE ];
};


#ifndef TESTDEBUG

#define DBG_HIST_NEW	0x00
#define DBG_HIST_MUTING 0x01
#define DBG_HIST_MUTED	0x02

#ifdef  NODEBUGALL
#define dbgf_all(...) {;}
#else
#define dbgf_all( dbgt, ... ); do { if ( __dbgf_all() ) { _dbgf_all( dbgt, __FUNCTION__, __VA_ARGS__ ); } } while (0)
#endif

#ifdef EXTDEBUG
#define dbgf_ext( dbgt, ... ); do { if ( __dbgf_all() ) { _dbgf_all( dbgt, __FUNCTION__, __VA_ARGS__ ); } } while (0)
#else
#define dbgf_ext(...) {;}
#endif

#define dbgf( dbgl, dbgt, ...); _dbgf( dbgl, dbgt, __FUNCTION__, __VA_ARGS__ );
#define dbgf_cn( cn, dbgl, dbgt, ...); _dbgf_cn( cn, dbgl, dbgt, __FUNCTION__, __VA_ARGS__ );

void dbg ( int8_t dbgl, int8_t dbgt, char *last, ... );
void _dbgf ( int8_t dbgl, int8_t dbgt, char const *f, char *last, ... );
void dbg_cn ( struct ctrl_node *cn, int8_t dbgl, int8_t dbgt, char *last, ... );
void _dbgf_cn ( struct ctrl_node *cn, int8_t dbgl, int8_t dbgt, char const *f, char *last, ... );
void dbg_mute ( uint32_t check_len, int8_t dbgl, int8_t dbgt, char *last, ... );
void _dbgf_all ( int8_t dbgt, char const *f, char *last, ... );
uint8_t __dbgf_all( void );

void dbg_printf( struct ctrl_node *cn, char *last, ...  );

#else

#define dbgf( dbgl, dbgt, ...); 		printf( __VA_ARGS__ )
#define dbgf_cn( cn, dbgl, dbgt, ...); 		printf( __VA_ARGS__ )
#define dbg( dbgl, dbgt, ... )  		printf( __VA_ARGS__ )
#define dbg_cn( cn, dbgl, dbgt, ... ) 		printf( __VA_ARGS__ )
#define dbg_mute( check_len, dbgl, dbgt, ... ) 	printf( __VA_ARGS__ )
#define dbgf_all( dbgt, ... ) 			printf( __VA_ARGS__ )
#define dbgf_ext( dbgt, ... ) 			printf( __VA_ARGS__ )
#define dbg_printf( cn, ...  ) 			printf( __VA_ARGS__ )


#endif

void accept_ctrl_node( void );
void handle_ctrl_node( struct ctrl_node *cn );
void close_ctrl_node( uint8_t cmd, struct ctrl_node *cn );
struct ctrl_node *create_ctrl_node( int fd, void (*cn_fd_handler) (struct ctrl_node *), uint8_t authorized );




#define REFERENCE_KEY_WORD	"ref:"

#define EOS_DELIMITER '#'

#define MAX_UNIX_MSG_SIZE 2000

extern struct list_head_first opt_list;


/* opt_t types (Parent/Child, Single/Multiple, 0/1/N-arguments) */
#define A_PS0   0x01
#define A_PS1	0x02
#define A_PMN   0x14
#define A_CS1	0x22


/* auth_t types */
#define A_ADM	0x10
#define A_USR	0x00

/* dyn_t types: */
// can only be used on-the-fly
#define A_DYN	0x20 
// can never be used on-the-fly
#define A_INI	0x40
// can be used during init and on-the-fly
#define A_DYI	0x60

/* cfg_t types: */
// can only be set as command-line argument. NOT shows as relevant parameter
#define A_ARG	0x02
// can be set in config file and as command-line argument. Shows as relevant parameter
#define A_CFA	0x03

/* pos_t types: */
// must be given as first argument
#define A_BEG   0x01 NOT IMPLEMENTED 
// may appera anywhere in command stream
#define A_ANY	0x02
// must appear as last argument
#define A_END	0x03
// may appera anywhere in command stream but consumes remaining arguments
#define A_EAT	0x04
// must appear as last argunent and cosumes remaining arguments
#define A_ETE	0x05


extern char *opt_cmd2str[];


struct opt_child {
	
	struct list_head list;
	
	struct opt_type *c_opt; // key,  pointing to related opt_type
	struct opt_parent *parent_instance;
	
	char *c_val;
	
	uint8_t p_diff; //ADD, DEL, NOP
	
	char *c_ref;
};


struct opt_parent {
	
	struct list_head list;
	
	struct list_head_first childs_instance_list;
	
	char *p_val; //key
	
	uint8_t p_diff; //ADD, DEL, NOP
	
	char *p_ref;
	
};

#define ODI {{0},0,{0,0},{0,0},0}

struct opt_data {
	
	struct list_head list;
	
	struct opt_type *parent_opt; //REMOVE THIS and use casting instead !
	
	struct list_head_first childs_type_list; //if this opt is a section type, then further sub-opts types can be listed here
	
	struct list_head_first parents_instance_list; //
	uint16_t found_parents;
	
};

struct opt_type {
	
	struct opt_data d; //MUST be first structure in opt_type to allow casting between struct opt_data and  struct opt_type
	
	int8_t order;  // enforces an order during the init process,  (0==anytime????), 1..99: in this order. Might become removed
	
	char *parent_name;
	char *long_name;
	char short_name;
	
	uint8_t opt_t;
	
	uint8_t auth_t;
	uint8_t dyn_t;
	uint8_t cfg_t;
	uint8_t pos_t;
	
	// if != NULL call_option() will be initialize / reset(ARG_RESET) to idef
	int32_t *ival; 
	// if imin != imax call_option() will test for validity
	int32_t imin;
	int32_t imax;  
	int32_t idef;
	
	int32_t (*call_custom_option)( uint8_t cmd, uint8_t _save, struct opt_type *opt, struct opt_parent *patch, struct ctrl_node *cn );
	
#define ARG_VALUE_FORM	"<VAL>"
#define ARG_FILE_FORM	"<FILE>"
#define ARG_DIR_FORM	"<DIRECTORY>"
#define ARG_PORT_FORM	"<PORT>"
#define ARG_ADDR_FORM	"<ADDRESS>"
#define ARG_PREFIX_FORM	"<NETADDR>/<PREFIX-LENGTH>"
#define ARG_NETW_FORM	"<NETADDR>"
#define ARG_MASK_FORM	"<NETMASK>"
	
	char	*syntax;
	char	*help;
	
};


#define ARG_RESET "-" /* s-string preamble for call_option() to reset opt to default */
#define ARG_RESET_CHAR '-'


enum opt_cmd {
	// called once for each option after registration
	// Returns FAILURE or SUCCESS
	OPT_REGISTER,
		
		
		OPT_PATCH,
/* 
	if applied values need to be adjusted to unified format it must be during OPT_ADJUST
	this has the following advantages:
	tracked and applied values are equal
		-> track knows about already configured values
		-> can prevent/warn reconfiguration of already configured values
		-> can reject resetting of non-configured values
*/
	OPT_ADJUST,
		
		
	// to test opt value!
	// Returns FAILURE or n>=0 of processed bytes-1
		OPT_CHECK,
		
	// to set opt value!
	// Returns FAILURE or n>=0 of processed bytes-1
		OPT_APPLY,
		
		
		/*
	// end of A_N section (after last opt_arg )
	// Returns FAILURE or SUCCESS
		OPT_TEST_END,
		OPT_SET_END,
		*/
	
	// called ordered for each option and before next higher-order option   
	// Returns FAILURE or SUCCESS
	OPT_SET_POST,
		
	// called ordered for each option after all options were (re-)set
	// Returns FAILURE or SUCCESS
		OPT_POST,
		
	// called once before an option is unregistered
	// Returns FAILURE or SUCCESS
		OPT_UNREGISTER
		
};

// evaluates global variable: "on_the_fly"
// fd may be set (>0) or not (=0)
// cmd==OPT_SET_POST / OPT_POST: 
//	s MBZ, return value is SUCCESS or FAILURE
int32_t call_option( uint8_t del, uint8_t cmd, uint8_t _save, struct opt_type *opt, struct opt_parent *parent, char *in, struct ctrl_node *cn );

int32_t check_apply_parent_option( uint8_t del, uint8_t cmd, uint8_t _save, struct opt_type *opt, char *in, struct ctrl_node *cn );

struct opt_type *get_option( struct opt_type *parent_opt, uint8_t short_opt, char *s );



void 			set_opt_child_val ( struct opt_child *c, char *val );
struct opt_child *	get_opt_child ( struct opt_type *opt, struct opt_parent *p );


void 			del_opt_parent( struct opt_type *opt, struct opt_parent *parent );
struct opt_parent *	add_opt_parent( struct opt_type *opt );

void 			set_opt_parent_val ( struct opt_parent *p, char *val );
struct opt_parent *	get_opt_parent_val ( struct opt_type *opt, char *val );
void 			set_opt_parent_ref ( struct opt_parent *p, char *ref );
struct opt_parent *	get_opt_parent_ref ( struct opt_type *opt, char *ref );



int8_t func_for_each_opt( struct ctrl_node *cn, void *data, struct opt_type *opt_tmpl, char* func_name, 
                          int8_t (*func) ( struct ctrl_node *cn, void *data, struct opt_type *opt, struct opt_parent *p, struct opt_child *c ) );

int respect_opt_order( uint8_t test, int8_t last, int8_t next, struct opt_type *on, uint8_t load_config, uint8_t cmd, struct ctrl_node *cn );

int8_t apply_stream_opts( char *s, char *fallback_opt, uint8_t dryrun, uint8_t load_cfg, struct ctrl_node *cn );


extern int (*load_config_cb) ( uint8_t test, struct opt_type *opt, struct ctrl_node *cn );

extern int (*save_config_cb) ( uint8_t del, struct opt_type *opt, char *parent, char *val, struct ctrl_node *cn );

extern int (*derive_config) ( char *reference, char *derivation, struct ctrl_node *cn );


void register_option( struct opt_type *opt );
//void remove_option( struct opt_type *opt );
void register_options_array ( struct opt_type *fixed_options, int size );

extern int32_t Load_config;


int32_t get_tracked_network( struct opt_type *opt, struct opt_parent *patch, char *out, uint32_t *ip, int32_t *mask, struct ctrl_node *cn );
int32_t adj_patched_network( struct opt_type *opt, struct opt_parent *patch, char *out, uint32_t *ip, int32_t *mask, struct ctrl_node *cn );


void apply_init_args ( int argc, char *argv[] );

extern struct opt_type Patch_opt;


void init_control( void );
void cleanup_control( void );

void cleanup_config( void );


//char *debugWordDup( char* word, int32_t tag );
//static void strchange( char *s, char i, char o );
//char* nextword( char *s );


//usefult tools:
char *ipStr( uint32_t addr );
int8_t str2netw( char* args, uint32_t *ip, char delimiter, struct ctrl_node *cn, int32_t *val, int32_t max );
void addr_to_str( uint32_t addr, char *str );

int8_t wordsEqual ( char *a, char *b );
void wordCopy( char *out, char *in );
uint32_t wordlen ( char *s );
int32_t check_file( char *path, uint8_t write, uint8_t exec );
int32_t check_dir( char *path, uint8_t create, uint8_t write );
uint32_t validate_net_mask( uint32_t ip, uint32_t mask, struct ctrl_node *cn );
