/* 
 * Execute command when user press key over USB keyboard
 * version 0.0.3 - Copyright (C) 2002-2003 Alessandro Fausto
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *	Redistributions of source code must retain the above copyright
 *	notice, this list of conditions and the following disclaimer.
 *
 *	Redistributions in binary form must reproduce the above copyright
 *	notice, this list of conditions and the following disclaimer in the
 *	documentation and/or other materials provided with the distribution.
 *
 *	Neither the name of the author nor the names of the contributors may
 *	be used to endorse or promote products derived from this software 
 *	without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * To contact me write at:
 *             fareale@libero.it
 *   for bugs: fareale.bug@libero.it
 */

/*
 * v 0.03 :
 * 	+ modified led blink logic
 * v 0.0B1 : 28/04/2002
 */

#include <linux/input.h>
#include <linux/ioctl.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <signal.h>
#include <errno.h>
#include <string.h>
#include <time.h>

#include "debug.h"
#include "command.h"

#define DEBUGNAME         "MAIN: "

#ifndef __COPYLEFT__
#define __COPYLEFT__  "version ?.? - Copyright (C) 2001,2002 Alessandro Fausto"
#endif

#define MAX_CMD_LEN 128

#define ON_PRESS       1
#define ON_RELEASE     2
#define ON_REPEAT      4

volatile int quit = 0 ;
volatile int iLogLevel = 0 ;
char * pchProgramName = NULL ;
char * pchEventDevice = NULL ;

// Signals handlers
static void catchSignals(int sig)
{
	d1printf( "got signal #%d\n", sig) ;
  	switch( sig)
  	{
		case SIGINT : 
      			d2printf( "User Break, Exit!!\n") ;
      			quit = 1 ;
	      		break ;
    		case SIGQUIT : 
      			d2printf( "User send Quit signal, Exit!!\n") ;
      			quit = 1 ;
	      		break ;
    		default:
			d2printf( "Unhandled signal %d, continue!\n", sig) ;
  	}
}

void HookSignals( void)
{
  	struct sigaction act ;
   
  	memset( &act, 0, sizeof( act)) ;
  	sigemptyset( &act.sa_mask) ;
  	act.sa_handler = catchSignals ;
//  act.sa_flags = SA_ONESHOT ;
  	sigaction( SIGQUIT, &act, NULL) ;
  	sigaction( SIGINT, &act, NULL) ;
}

void printDeviceInfo( int fd)
{
	int version ;
	unsigned short deviceID[ 4] ;
	char deviceName[ 256] ;
	int abs[5] ;
 
	if( ioctl( fd, EVIOCGVERSION, &version)) {
		puts( "WARNING: can't get driver version") ;
	} else {
		printf( "Input driver version is %d.%d.%d\n",
			version >> 16, (version >> 8) & 0xff, version & 0xff);
	}
	
	ioctl( fd, EVIOCGID, deviceID) ;
	printf( "Input device ID: bus 0x%x vendor 0x%x product 0x%x version 0x%x\n",
		deviceID[ ID_BUS], 
		deviceID[ ID_VENDOR], 
		deviceID[ ID_PRODUCT], 
		deviceID[ ID_VERSION]) ;
 
	ioctl( fd, EVIOCGNAME( sizeof( deviceName)), deviceName) ;
	printf( "Input device name: ""%s""\n", deviceName) ;
}
	
int main( int argc, char ** argv)
{
	int count ;
	int fd ;
	
        HookSignals() ;
	
	printf( "%s - "__COPYLEFT__"\n"
               	"Build "
#ifdef __OPTIMIZE__ 
		"with code optimization"
#else
		"without code optimization"
#endif
		" at "__DATE__" "__TIME__"\n"
		"This is free software, comes with ABSOLUTELY NO WARRANTY, and\n"
		"and you are welcome to redistribute it under certain conditions.\n"
		"To view the licence use %s --copying|more \n",
		argv[ 0], argv[ 0]) ;

	if( !InitCommand() ||
            !readConfigurationFile( "/etc/cmdpad.conf") ||
            !readCommandLine( argc, argv) ||
            pchEventDevice == NULL )
		return -1 ;

//	writeConfigurationFile( "/etc/cmdpad.conf") ;

	if( (fd = open( pchEventDevice, O_RDWR)) < 0) {
		fprintf( stderr, "Error when opening %s\n", argv[ 1]) ;
		exit( 1) ;
	}

	printDeviceInfo( fd) ;
	
	ledSet( fd, 0xFF) ;
	sleep( 1) ;
	ledClear( fd, 0xFF) ;
	sleep( 1) ;
	ledSet( fd, 0xFF) ;
	sleep( 1) ;
	ledSet( fd, 4) ;

	for( count = 0 ; !quit ; ) {
		struct input_event event ;
		
		read( fd, &event, sizeof( event)) ;
		switch ( event.type) {
			case EV_KEY :
				d2printf( "KBD: code=%u,value=%u\n",
					event.code,
					event.value) ;
				
				ledBlink( fd, 1) ;	// BLINK LED #1
				if( executeCommand( event.code, event.value))
					ledSet( fd, 2) ; // SET LED #2
				else
					ledClear( fd, 2) ; // CLEAR LED #2
				count++ ;
				break ;
			case EV_LED : // IGNORE LED CHANGES
				break ;
			default :
				d2printf( "UNK: type=%u, code=%u,value=%u\n",
					event.type,
					event.code,
					event.value) ;
		} // end switch
	} /* end for */
	
	fprintf( stderr, "Received %d events.\n", count) ;
	
	ledSet( fd, 0xFF) ;
	sleep( 1) ;
	ledClear( fd, 0xFF) ;
	
	close( fd) ;
	return 0 ;
}
