/***************************************************************************
 *                                  _   _ ____  _
 *  Project                     ___| | | |  _ \| |
 *                             / __| | | | |_) | |
 *                            | (__| |_| |  _ <| |___
 *                             \___|\___/|_| \_\_____|
 *
 * Copyright (C) 2017, Daniel Stenberg, <daniel.se>, et al.
 *
 * This software is licensed as described in the file COPYING, which
 * you should have received as part of this distribution. The terms
 * are also available at https://curl.haxx.se/docs/copyright.html.
 *
 * You may opt to use, copy, modify, merge, publish, distribute and/or sell
 * copies of the Software, and permit persons to whom the Software is
 * furnished to do so, under the terms of the COPYING file.
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY
 * KIND, either express or implied.
 *
 ***************************************************************************/
#include "test.h"
#include "memdebug.h"
#include <limits.h>

/* This source code is generated by mk-lib1521.pl ! */

struct data {
    char *blaha;
};

#define LO LONG_MIN
#define HI LONG_MAX
#define OFF_VAL (curl_off_t) 3123123123
#define OFF_LO (curl_off_t) LO
#define OFF_HI (curl_off_t) HI
#define OFF_NO (curl_off_t) 0

static size_t writecb(char *buffer, size_t size, size_t nitems,
                      void *outstream)
{
  (void)buffer;
  (void)size;
  (void)nitems;
  (void)outstream;
  return 0;
}

static size_t readcb(char *buffer,
              size_t size,
              size_t nitems,
              void *instream)
{
  (void)buffer;
  (void)size;
  (void)nitems;
  (void)instream;
  return 0;
}

curl_progress_callback progresscb;
curl_write_callback headercb;
curl_debug_callback debugcb;
curl_ssl_ctx_callback ssl_ctx_cb;
curl_ioctl_callback ioctlcb;
curl_sockopt_callback sockoptcb;
curl_opensocket_callback opensocketcb;
curl_seek_callback seekcb;
curl_sshkeycallback ssh_keycb;
curl_chunk_bgn_callback chunk_bgn_cb;
curl_chunk_end_callback chunk_end_cb;
curl_fnmatch_callback fnmatch_cb;
curl_closesocket_callback closesocketcb;
curl_xferinfo_callback xferinfocb;

int test(char *URL)
{
  int res = 0;
  CURL *curl = NULL;
  CURL *dep = NULL;
  CURLSH *share = NULL;
  char errorbuffer[CURL_ERROR_SIZE];
  void *conv_from_network_cb = NULL;
  void *conv_to_network_cb = NULL;
  void *conv_from_utf8_cb = NULL;
  void *interleavecb = NULL;
  char *stringpointerextra=(char *)"moooo";
  struct curl_slist *slist=NULL;
  struct curl_httppost *httppost=NULL;
  FILE *stream = stderr;
  struct data object;
  (void)URL; /* not used */
  easy_init(dep);
  easy_init(curl);
  share = curl_share_init();
  if(!share) {
    res = CURLE_OUT_OF_MEMORY;
    goto test_cleanup;
  }

  (void)curl_easy_setopt(curl, CURLOPT_WRITEDATA, &object);
  (void)curl_easy_setopt(curl, CURLOPT_WRITEDATA, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_URL, "string");
  (void)curl_easy_setopt(curl, CURLOPT_URL, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_PORT, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_PORT, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_PORT, LO);
  (void)curl_easy_setopt(curl, CURLOPT_PORT, HI);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY, "string");
  (void)curl_easy_setopt(curl, CURLOPT_PROXY, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_USERPWD, "string");
  (void)curl_easy_setopt(curl, CURLOPT_USERPWD, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_PROXYUSERPWD, "string");
  (void)curl_easy_setopt(curl, CURLOPT_PROXYUSERPWD, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_RANGE, "string");
  (void)curl_easy_setopt(curl, CURLOPT_RANGE, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_READDATA, &object);
  (void)curl_easy_setopt(curl, CURLOPT_READDATA, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_ERRORBUFFER, errorbuffer);
  (void)curl_easy_setopt(curl, CURLOPT_ERRORBUFFER, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION,
                         writecb);
  (void)curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_READFUNCTION,
                         readcb);
  (void)curl_easy_setopt(curl, CURLOPT_READFUNCTION, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_TIMEOUT, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_TIMEOUT, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_TIMEOUT, LO);
  (void)curl_easy_setopt(curl, CURLOPT_TIMEOUT, HI);
  (void)curl_easy_setopt(curl, CURLOPT_INFILESIZE, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_INFILESIZE, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_INFILESIZE, LO);
  (void)curl_easy_setopt(curl, CURLOPT_INFILESIZE, HI);
  (void)curl_easy_setopt(curl, CURLOPT_POSTFIELDS, stringpointerextra);
  (void)curl_easy_setopt(curl, CURLOPT_POSTFIELDS, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_REFERER, "string");
  (void)curl_easy_setopt(curl, CURLOPT_REFERER, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_FTPPORT, "string");
  (void)curl_easy_setopt(curl, CURLOPT_FTPPORT, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_USERAGENT, "string");
  (void)curl_easy_setopt(curl, CURLOPT_USERAGENT, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_LOW_SPEED_LIMIT, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_LOW_SPEED_LIMIT, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_LOW_SPEED_LIMIT, LO);
  (void)curl_easy_setopt(curl, CURLOPT_LOW_SPEED_LIMIT, HI);
  (void)curl_easy_setopt(curl, CURLOPT_LOW_SPEED_TIME, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_LOW_SPEED_TIME, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_LOW_SPEED_TIME, LO);
  (void)curl_easy_setopt(curl, CURLOPT_LOW_SPEED_TIME, HI);
  (void)curl_easy_setopt(curl, CURLOPT_RESUME_FROM, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_RESUME_FROM, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_RESUME_FROM, LO);
  (void)curl_easy_setopt(curl, CURLOPT_RESUME_FROM, HI);
  (void)curl_easy_setopt(curl, CURLOPT_COOKIE, "string");
  (void)curl_easy_setopt(curl, CURLOPT_COOKIE, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_HTTPHEADER, slist);
  (void)curl_easy_setopt(curl, CURLOPT_HTTPHEADER, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_HTTPPOST, httppost);
  (void)curl_easy_setopt(curl, CURLOPT_HTTPPOST, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_SSLCERT, "string");
  (void)curl_easy_setopt(curl, CURLOPT_SSLCERT, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_KEYPASSWD, "string");
  (void)curl_easy_setopt(curl, CURLOPT_KEYPASSWD, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_CRLF, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_CRLF, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_CRLF, LO);
  (void)curl_easy_setopt(curl, CURLOPT_CRLF, HI);
  (void)curl_easy_setopt(curl, CURLOPT_QUOTE, slist);
  (void)curl_easy_setopt(curl, CURLOPT_QUOTE, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_HEADERDATA, &object);
  (void)curl_easy_setopt(curl, CURLOPT_HEADERDATA, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_COOKIEFILE, "string");
  (void)curl_easy_setopt(curl, CURLOPT_COOKIEFILE, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_SSLVERSION, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_SSLVERSION, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_SSLVERSION, LO);
  (void)curl_easy_setopt(curl, CURLOPT_SSLVERSION, HI);
  (void)curl_easy_setopt(curl, CURLOPT_TIMECONDITION, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_TIMECONDITION, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_TIMECONDITION, LO);
  (void)curl_easy_setopt(curl, CURLOPT_TIMECONDITION, HI);
  (void)curl_easy_setopt(curl, CURLOPT_TIMEVALUE, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_TIMEVALUE, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_TIMEVALUE, LO);
  (void)curl_easy_setopt(curl, CURLOPT_TIMEVALUE, HI);
  (void)curl_easy_setopt(curl, CURLOPT_CUSTOMREQUEST, "string");
  (void)curl_easy_setopt(curl, CURLOPT_CUSTOMREQUEST, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_STDERR, stream);
  (void)curl_easy_setopt(curl, CURLOPT_STDERR, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_POSTQUOTE, slist);
  (void)curl_easy_setopt(curl, CURLOPT_POSTQUOTE, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_OBSOLETE40, &object);
  (void)curl_easy_setopt(curl, CURLOPT_OBSOLETE40, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_VERBOSE, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_VERBOSE, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_VERBOSE, LO);
  (void)curl_easy_setopt(curl, CURLOPT_VERBOSE, HI);
  (void)curl_easy_setopt(curl, CURLOPT_HEADER, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_HEADER, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_HEADER, LO);
  (void)curl_easy_setopt(curl, CURLOPT_HEADER, HI);
  (void)curl_easy_setopt(curl, CURLOPT_NOPROGRESS, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_NOPROGRESS, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_NOPROGRESS, LO);
  (void)curl_easy_setopt(curl, CURLOPT_NOPROGRESS, HI);
  (void)curl_easy_setopt(curl, CURLOPT_NOBODY, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_NOBODY, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_NOBODY, LO);
  (void)curl_easy_setopt(curl, CURLOPT_NOBODY, HI);
  (void)curl_easy_setopt(curl, CURLOPT_FAILONERROR, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_FAILONERROR, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_FAILONERROR, LO);
  (void)curl_easy_setopt(curl, CURLOPT_FAILONERROR, HI);
  (void)curl_easy_setopt(curl, CURLOPT_UPLOAD, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_UPLOAD, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_UPLOAD, LO);
  (void)curl_easy_setopt(curl, CURLOPT_UPLOAD, HI);
  (void)curl_easy_setopt(curl, CURLOPT_POST, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_POST, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_POST, LO);
  (void)curl_easy_setopt(curl, CURLOPT_POST, HI);
  (void)curl_easy_setopt(curl, CURLOPT_DIRLISTONLY, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_DIRLISTONLY, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_DIRLISTONLY, LO);
  (void)curl_easy_setopt(curl, CURLOPT_DIRLISTONLY, HI);
  (void)curl_easy_setopt(curl, CURLOPT_APPEND, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_APPEND, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_APPEND, LO);
  (void)curl_easy_setopt(curl, CURLOPT_APPEND, HI);
  (void)curl_easy_setopt(curl, CURLOPT_NETRC, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_NETRC, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_NETRC, LO);
  (void)curl_easy_setopt(curl, CURLOPT_NETRC, HI);
  (void)curl_easy_setopt(curl, CURLOPT_FOLLOWLOCATION, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_FOLLOWLOCATION, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_FOLLOWLOCATION, LO);
  (void)curl_easy_setopt(curl, CURLOPT_FOLLOWLOCATION, HI);
  (void)curl_easy_setopt(curl, CURLOPT_TRANSFERTEXT, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_TRANSFERTEXT, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_TRANSFERTEXT, LO);
  (void)curl_easy_setopt(curl, CURLOPT_TRANSFERTEXT, HI);
  (void)curl_easy_setopt(curl, CURLOPT_PUT, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_PUT, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_PUT, LO);
  (void)curl_easy_setopt(curl, CURLOPT_PUT, HI);
  (void)curl_easy_setopt(curl, CURLOPT_PROGRESSFUNCTION,
                         progresscb);
  (void)curl_easy_setopt(curl, CURLOPT_PROGRESSFUNCTION, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_PROGRESSDATA, &object);
  (void)curl_easy_setopt(curl, CURLOPT_PROGRESSDATA, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_AUTOREFERER, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_AUTOREFERER, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_AUTOREFERER, LO);
  (void)curl_easy_setopt(curl, CURLOPT_AUTOREFERER, HI);
  (void)curl_easy_setopt(curl, CURLOPT_PROXYPORT, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_PROXYPORT, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_PROXYPORT, LO);
  (void)curl_easy_setopt(curl, CURLOPT_PROXYPORT, HI);
  (void)curl_easy_setopt(curl, CURLOPT_POSTFIELDSIZE, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_POSTFIELDSIZE, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_POSTFIELDSIZE, LO);
  (void)curl_easy_setopt(curl, CURLOPT_POSTFIELDSIZE, HI);
  (void)curl_easy_setopt(curl, CURLOPT_HTTPPROXYTUNNEL, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_HTTPPROXYTUNNEL, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_HTTPPROXYTUNNEL, LO);
  (void)curl_easy_setopt(curl, CURLOPT_HTTPPROXYTUNNEL, HI);
  (void)curl_easy_setopt(curl, CURLOPT_INTERFACE, "string");
  (void)curl_easy_setopt(curl, CURLOPT_INTERFACE, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_KRBLEVEL, "string");
  (void)curl_easy_setopt(curl, CURLOPT_KRBLEVEL, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_VERIFYPEER, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_VERIFYPEER, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_VERIFYPEER, LO);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_VERIFYPEER, HI);
  (void)curl_easy_setopt(curl, CURLOPT_CAINFO, "string");
  (void)curl_easy_setopt(curl, CURLOPT_CAINFO, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_MAXREDIRS, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_MAXREDIRS, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_MAXREDIRS, LO);
  (void)curl_easy_setopt(curl, CURLOPT_MAXREDIRS, HI);
  (void)curl_easy_setopt(curl, CURLOPT_FILETIME, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_FILETIME, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_FILETIME, LO);
  (void)curl_easy_setopt(curl, CURLOPT_FILETIME, HI);
  (void)curl_easy_setopt(curl, CURLOPT_TELNETOPTIONS, slist);
  (void)curl_easy_setopt(curl, CURLOPT_TELNETOPTIONS, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_MAXCONNECTS, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_MAXCONNECTS, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_MAXCONNECTS, LO);
  (void)curl_easy_setopt(curl, CURLOPT_MAXCONNECTS, HI);
  (void)curl_easy_setopt(curl, CURLOPT_OBSOLETE72, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_OBSOLETE72, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_OBSOLETE72, LO);
  (void)curl_easy_setopt(curl, CURLOPT_OBSOLETE72, HI);
  (void)curl_easy_setopt(curl, CURLOPT_FRESH_CONNECT, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_FRESH_CONNECT, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_FRESH_CONNECT, LO);
  (void)curl_easy_setopt(curl, CURLOPT_FRESH_CONNECT, HI);
  (void)curl_easy_setopt(curl, CURLOPT_FORBID_REUSE, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_FORBID_REUSE, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_FORBID_REUSE, LO);
  (void)curl_easy_setopt(curl, CURLOPT_FORBID_REUSE, HI);
  (void)curl_easy_setopt(curl, CURLOPT_RANDOM_FILE, "string");
  (void)curl_easy_setopt(curl, CURLOPT_RANDOM_FILE, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_EGDSOCKET, "string");
  (void)curl_easy_setopt(curl, CURLOPT_EGDSOCKET, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_CONNECTTIMEOUT, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_CONNECTTIMEOUT, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_CONNECTTIMEOUT, LO);
  (void)curl_easy_setopt(curl, CURLOPT_CONNECTTIMEOUT, HI);
  (void)curl_easy_setopt(curl, CURLOPT_HEADERFUNCTION,
                         headercb);
  (void)curl_easy_setopt(curl, CURLOPT_HEADERFUNCTION, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_HTTPGET, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_HTTPGET, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_HTTPGET, LO);
  (void)curl_easy_setopt(curl, CURLOPT_HTTPGET, HI);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_VERIFYHOST, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_VERIFYHOST, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_VERIFYHOST, LO);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_VERIFYHOST, HI);
  (void)curl_easy_setopt(curl, CURLOPT_COOKIEJAR, "string");
  (void)curl_easy_setopt(curl, CURLOPT_COOKIEJAR, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_CIPHER_LIST, "string");
  (void)curl_easy_setopt(curl, CURLOPT_SSL_CIPHER_LIST, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_HTTP_VERSION, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_HTTP_VERSION, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_HTTP_VERSION, LO);
  (void)curl_easy_setopt(curl, CURLOPT_HTTP_VERSION, HI);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_USE_EPSV, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_USE_EPSV, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_USE_EPSV, LO);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_USE_EPSV, HI);
  (void)curl_easy_setopt(curl, CURLOPT_SSLCERTTYPE, "string");
  (void)curl_easy_setopt(curl, CURLOPT_SSLCERTTYPE, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_SSLKEY, "string");
  (void)curl_easy_setopt(curl, CURLOPT_SSLKEY, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_SSLKEYTYPE, "string");
  (void)curl_easy_setopt(curl, CURLOPT_SSLKEYTYPE, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_SSLENGINE, "string");
  (void)curl_easy_setopt(curl, CURLOPT_SSLENGINE, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_SSLENGINE_DEFAULT, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_SSLENGINE_DEFAULT, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_SSLENGINE_DEFAULT, LO);
  (void)curl_easy_setopt(curl, CURLOPT_SSLENGINE_DEFAULT, HI);
  (void)curl_easy_setopt(curl, CURLOPT_DNS_USE_GLOBAL_CACHE, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_DNS_USE_GLOBAL_CACHE, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_DNS_USE_GLOBAL_CACHE, LO);
  (void)curl_easy_setopt(curl, CURLOPT_DNS_USE_GLOBAL_CACHE, HI);
  (void)curl_easy_setopt(curl, CURLOPT_DNS_CACHE_TIMEOUT, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_DNS_CACHE_TIMEOUT, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_DNS_CACHE_TIMEOUT, LO);
  (void)curl_easy_setopt(curl, CURLOPT_DNS_CACHE_TIMEOUT, HI);
  (void)curl_easy_setopt(curl, CURLOPT_PREQUOTE, slist);
  (void)curl_easy_setopt(curl, CURLOPT_PREQUOTE, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_DEBUGFUNCTION,
                         debugcb);
  (void)curl_easy_setopt(curl, CURLOPT_DEBUGFUNCTION, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_DEBUGDATA, &object);
  (void)curl_easy_setopt(curl, CURLOPT_DEBUGDATA, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_COOKIESESSION, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_COOKIESESSION, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_COOKIESESSION, LO);
  (void)curl_easy_setopt(curl, CURLOPT_COOKIESESSION, HI);
  (void)curl_easy_setopt(curl, CURLOPT_CAPATH, "string");
  (void)curl_easy_setopt(curl, CURLOPT_CAPATH, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_BUFFERSIZE, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_BUFFERSIZE, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_BUFFERSIZE, LO);
  (void)curl_easy_setopt(curl, CURLOPT_BUFFERSIZE, HI);
  (void)curl_easy_setopt(curl, CURLOPT_NOSIGNAL, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_NOSIGNAL, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_NOSIGNAL, LO);
  (void)curl_easy_setopt(curl, CURLOPT_NOSIGNAL, HI);
  (void)curl_easy_setopt(curl, CURLOPT_SHARE, share);
  (void)curl_easy_setopt(curl, CURLOPT_SHARE, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_PROXYTYPE, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_PROXYTYPE, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_PROXYTYPE, LO);
  (void)curl_easy_setopt(curl, CURLOPT_PROXYTYPE, HI);
  (void)curl_easy_setopt(curl, CURLOPT_ACCEPT_ENCODING, "string");
  (void)curl_easy_setopt(curl, CURLOPT_ACCEPT_ENCODING, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_PRIVATE, &object);
  (void)curl_easy_setopt(curl, CURLOPT_PRIVATE, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_HTTP200ALIASES, slist);
  (void)curl_easy_setopt(curl, CURLOPT_HTTP200ALIASES, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_UNRESTRICTED_AUTH, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_UNRESTRICTED_AUTH, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_UNRESTRICTED_AUTH, LO);
  (void)curl_easy_setopt(curl, CURLOPT_UNRESTRICTED_AUTH, HI);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_USE_EPRT, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_USE_EPRT, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_USE_EPRT, LO);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_USE_EPRT, HI);
  (void)curl_easy_setopt(curl, CURLOPT_HTTPAUTH, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_HTTPAUTH, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_HTTPAUTH, LO);
  (void)curl_easy_setopt(curl, CURLOPT_HTTPAUTH, HI);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_CTX_FUNCTION,
                         ssl_ctx_cb);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_CTX_FUNCTION, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_CTX_DATA, &object);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_CTX_DATA, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_CREATE_MISSING_DIRS, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_CREATE_MISSING_DIRS, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_CREATE_MISSING_DIRS, LO);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_CREATE_MISSING_DIRS, HI);
  (void)curl_easy_setopt(curl, CURLOPT_PROXYAUTH, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_PROXYAUTH, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_PROXYAUTH, LO);
  (void)curl_easy_setopt(curl, CURLOPT_PROXYAUTH, HI);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_RESPONSE_TIMEOUT, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_RESPONSE_TIMEOUT, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_RESPONSE_TIMEOUT, LO);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_RESPONSE_TIMEOUT, HI);
  (void)curl_easy_setopt(curl, CURLOPT_IPRESOLVE, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_IPRESOLVE, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_IPRESOLVE, LO);
  (void)curl_easy_setopt(curl, CURLOPT_IPRESOLVE, HI);
  (void)curl_easy_setopt(curl, CURLOPT_MAXFILESIZE, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_MAXFILESIZE, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_MAXFILESIZE, LO);
  (void)curl_easy_setopt(curl, CURLOPT_MAXFILESIZE, HI);
  (void)curl_easy_setopt(curl, CURLOPT_INFILESIZE_LARGE, OFF_NO);
  (void)curl_easy_setopt(curl, CURLOPT_INFILESIZE_LARGE, OFF_VAL);
  (void)curl_easy_setopt(curl, CURLOPT_INFILESIZE_LARGE, OFF_LO);
  (void)curl_easy_setopt(curl, CURLOPT_RESUME_FROM_LARGE, OFF_NO);
  (void)curl_easy_setopt(curl, CURLOPT_RESUME_FROM_LARGE, OFF_VAL);
  (void)curl_easy_setopt(curl, CURLOPT_RESUME_FROM_LARGE, OFF_LO);
  (void)curl_easy_setopt(curl, CURLOPT_MAXFILESIZE_LARGE, OFF_NO);
  (void)curl_easy_setopt(curl, CURLOPT_MAXFILESIZE_LARGE, OFF_VAL);
  (void)curl_easy_setopt(curl, CURLOPT_MAXFILESIZE_LARGE, OFF_LO);
  (void)curl_easy_setopt(curl, CURLOPT_NETRC_FILE, "string");
  (void)curl_easy_setopt(curl, CURLOPT_NETRC_FILE, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_USE_SSL, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_USE_SSL, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_USE_SSL, LO);
  (void)curl_easy_setopt(curl, CURLOPT_USE_SSL, HI);
  (void)curl_easy_setopt(curl, CURLOPT_POSTFIELDSIZE_LARGE, OFF_NO);
  (void)curl_easy_setopt(curl, CURLOPT_POSTFIELDSIZE_LARGE, OFF_VAL);
  (void)curl_easy_setopt(curl, CURLOPT_POSTFIELDSIZE_LARGE, OFF_LO);
  (void)curl_easy_setopt(curl, CURLOPT_TCP_NODELAY, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_TCP_NODELAY, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_TCP_NODELAY, LO);
  (void)curl_easy_setopt(curl, CURLOPT_TCP_NODELAY, HI);
  (void)curl_easy_setopt(curl, CURLOPT_FTPSSLAUTH, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_FTPSSLAUTH, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_FTPSSLAUTH, LO);
  (void)curl_easy_setopt(curl, CURLOPT_FTPSSLAUTH, HI);
  (void)curl_easy_setopt(curl, CURLOPT_IOCTLFUNCTION,
                         ioctlcb);
  (void)curl_easy_setopt(curl, CURLOPT_IOCTLFUNCTION, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_IOCTLDATA, &object);
  (void)curl_easy_setopt(curl, CURLOPT_IOCTLDATA, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_ACCOUNT, "string");
  (void)curl_easy_setopt(curl, CURLOPT_FTP_ACCOUNT, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_COOKIELIST, "string");
  (void)curl_easy_setopt(curl, CURLOPT_COOKIELIST, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_IGNORE_CONTENT_LENGTH, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_IGNORE_CONTENT_LENGTH, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_IGNORE_CONTENT_LENGTH, LO);
  (void)curl_easy_setopt(curl, CURLOPT_IGNORE_CONTENT_LENGTH, HI);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_SKIP_PASV_IP, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_SKIP_PASV_IP, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_SKIP_PASV_IP, LO);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_SKIP_PASV_IP, HI);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_FILEMETHOD, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_FILEMETHOD, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_FILEMETHOD, LO);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_FILEMETHOD, HI);
  (void)curl_easy_setopt(curl, CURLOPT_LOCALPORT, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_LOCALPORT, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_LOCALPORT, LO);
  (void)curl_easy_setopt(curl, CURLOPT_LOCALPORT, HI);
  (void)curl_easy_setopt(curl, CURLOPT_LOCALPORTRANGE, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_LOCALPORTRANGE, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_LOCALPORTRANGE, LO);
  (void)curl_easy_setopt(curl, CURLOPT_LOCALPORTRANGE, HI);
  (void)curl_easy_setopt(curl, CURLOPT_CONNECT_ONLY, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_CONNECT_ONLY, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_CONNECT_ONLY, LO);
  (void)curl_easy_setopt(curl, CURLOPT_CONNECT_ONLY, HI);
  (void)curl_easy_setopt(curl, CURLOPT_CONV_FROM_NETWORK_FUNCTION,
                         conv_from_network_cb);
  (void)curl_easy_setopt(curl, CURLOPT_CONV_FROM_NETWORK_FUNCTION, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_CONV_TO_NETWORK_FUNCTION,
                         conv_to_network_cb);
  (void)curl_easy_setopt(curl, CURLOPT_CONV_TO_NETWORK_FUNCTION, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_CONV_FROM_UTF8_FUNCTION,
                         conv_from_utf8_cb);
  (void)curl_easy_setopt(curl, CURLOPT_CONV_FROM_UTF8_FUNCTION, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_MAX_SEND_SPEED_LARGE, OFF_NO);
  (void)curl_easy_setopt(curl, CURLOPT_MAX_SEND_SPEED_LARGE, OFF_VAL);
  (void)curl_easy_setopt(curl, CURLOPT_MAX_SEND_SPEED_LARGE, OFF_LO);
  (void)curl_easy_setopt(curl, CURLOPT_MAX_RECV_SPEED_LARGE, OFF_NO);
  (void)curl_easy_setopt(curl, CURLOPT_MAX_RECV_SPEED_LARGE, OFF_VAL);
  (void)curl_easy_setopt(curl, CURLOPT_MAX_RECV_SPEED_LARGE, OFF_LO);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_ALTERNATIVE_TO_USER, "string");
  (void)curl_easy_setopt(curl, CURLOPT_FTP_ALTERNATIVE_TO_USER, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_SOCKOPTFUNCTION,
                         sockoptcb);
  (void)curl_easy_setopt(curl, CURLOPT_SOCKOPTFUNCTION, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_SOCKOPTDATA, &object);
  (void)curl_easy_setopt(curl, CURLOPT_SOCKOPTDATA, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_SESSIONID_CACHE, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_SESSIONID_CACHE, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_SESSIONID_CACHE, LO);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_SESSIONID_CACHE, HI);
  (void)curl_easy_setopt(curl, CURLOPT_SSH_AUTH_TYPES, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_SSH_AUTH_TYPES, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_SSH_AUTH_TYPES, LO);
  (void)curl_easy_setopt(curl, CURLOPT_SSH_AUTH_TYPES, HI);
  (void)curl_easy_setopt(curl, CURLOPT_SSH_PUBLIC_KEYFILE, "string");
  (void)curl_easy_setopt(curl, CURLOPT_SSH_PUBLIC_KEYFILE, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_SSH_PRIVATE_KEYFILE, "string");
  (void)curl_easy_setopt(curl, CURLOPT_SSH_PRIVATE_KEYFILE, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_SSL_CCC, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_SSL_CCC, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_SSL_CCC, LO);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_SSL_CCC, HI);
  (void)curl_easy_setopt(curl, CURLOPT_TIMEOUT_MS, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_TIMEOUT_MS, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_TIMEOUT_MS, LO);
  (void)curl_easy_setopt(curl, CURLOPT_TIMEOUT_MS, HI);
  (void)curl_easy_setopt(curl, CURLOPT_CONNECTTIMEOUT_MS, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_CONNECTTIMEOUT_MS, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_CONNECTTIMEOUT_MS, LO);
  (void)curl_easy_setopt(curl, CURLOPT_CONNECTTIMEOUT_MS, HI);
  (void)curl_easy_setopt(curl, CURLOPT_HTTP_TRANSFER_DECODING, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_HTTP_TRANSFER_DECODING, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_HTTP_TRANSFER_DECODING, LO);
  (void)curl_easy_setopt(curl, CURLOPT_HTTP_TRANSFER_DECODING, HI);
  (void)curl_easy_setopt(curl, CURLOPT_HTTP_CONTENT_DECODING, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_HTTP_CONTENT_DECODING, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_HTTP_CONTENT_DECODING, LO);
  (void)curl_easy_setopt(curl, CURLOPT_HTTP_CONTENT_DECODING, HI);
  (void)curl_easy_setopt(curl, CURLOPT_NEW_FILE_PERMS, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_NEW_FILE_PERMS, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_NEW_FILE_PERMS, LO);
  (void)curl_easy_setopt(curl, CURLOPT_NEW_FILE_PERMS, HI);
  (void)curl_easy_setopt(curl, CURLOPT_NEW_DIRECTORY_PERMS, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_NEW_DIRECTORY_PERMS, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_NEW_DIRECTORY_PERMS, LO);
  (void)curl_easy_setopt(curl, CURLOPT_NEW_DIRECTORY_PERMS, HI);
  (void)curl_easy_setopt(curl, CURLOPT_POSTREDIR, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_POSTREDIR, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_POSTREDIR, LO);
  (void)curl_easy_setopt(curl, CURLOPT_POSTREDIR, HI);
  (void)curl_easy_setopt(curl, CURLOPT_SSH_HOST_PUBLIC_KEY_MD5, "string");
  (void)curl_easy_setopt(curl, CURLOPT_SSH_HOST_PUBLIC_KEY_MD5, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_OPENSOCKETFUNCTION,
                         opensocketcb);
  (void)curl_easy_setopt(curl, CURLOPT_OPENSOCKETFUNCTION, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_OPENSOCKETDATA, &object);
  (void)curl_easy_setopt(curl, CURLOPT_OPENSOCKETDATA, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_COPYPOSTFIELDS, stringpointerextra);
  (void)curl_easy_setopt(curl, CURLOPT_COPYPOSTFIELDS, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_TRANSFER_MODE, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_TRANSFER_MODE, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_TRANSFER_MODE, LO);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_TRANSFER_MODE, HI);
  (void)curl_easy_setopt(curl, CURLOPT_SEEKFUNCTION,
                         seekcb);
  (void)curl_easy_setopt(curl, CURLOPT_SEEKFUNCTION, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_SEEKDATA, &object);
  (void)curl_easy_setopt(curl, CURLOPT_SEEKDATA, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_CRLFILE, "string");
  (void)curl_easy_setopt(curl, CURLOPT_CRLFILE, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_ISSUERCERT, "string");
  (void)curl_easy_setopt(curl, CURLOPT_ISSUERCERT, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_ADDRESS_SCOPE, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_ADDRESS_SCOPE, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_ADDRESS_SCOPE, LO);
  (void)curl_easy_setopt(curl, CURLOPT_ADDRESS_SCOPE, HI);
  (void)curl_easy_setopt(curl, CURLOPT_CERTINFO, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_CERTINFO, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_CERTINFO, LO);
  (void)curl_easy_setopt(curl, CURLOPT_CERTINFO, HI);
  (void)curl_easy_setopt(curl, CURLOPT_USERNAME, "string");
  (void)curl_easy_setopt(curl, CURLOPT_USERNAME, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_PASSWORD, "string");
  (void)curl_easy_setopt(curl, CURLOPT_PASSWORD, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_PROXYUSERNAME, "string");
  (void)curl_easy_setopt(curl, CURLOPT_PROXYUSERNAME, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_PROXYPASSWORD, "string");
  (void)curl_easy_setopt(curl, CURLOPT_PROXYPASSWORD, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_NOPROXY, "string");
  (void)curl_easy_setopt(curl, CURLOPT_NOPROXY, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_TFTP_BLKSIZE, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_TFTP_BLKSIZE, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_TFTP_BLKSIZE, LO);
  (void)curl_easy_setopt(curl, CURLOPT_TFTP_BLKSIZE, HI);
  (void)curl_easy_setopt(curl, CURLOPT_SOCKS5_GSSAPI_SERVICE, "string");
  (void)curl_easy_setopt(curl, CURLOPT_SOCKS5_GSSAPI_SERVICE, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_SOCKS5_GSSAPI_NEC, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_SOCKS5_GSSAPI_NEC, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_SOCKS5_GSSAPI_NEC, LO);
  (void)curl_easy_setopt(curl, CURLOPT_SOCKS5_GSSAPI_NEC, HI);
  (void)curl_easy_setopt(curl, CURLOPT_PROTOCOLS, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_PROTOCOLS, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_PROTOCOLS, LO);
  (void)curl_easy_setopt(curl, CURLOPT_PROTOCOLS, HI);
  (void)curl_easy_setopt(curl, CURLOPT_REDIR_PROTOCOLS, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_REDIR_PROTOCOLS, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_REDIR_PROTOCOLS, LO);
  (void)curl_easy_setopt(curl, CURLOPT_REDIR_PROTOCOLS, HI);
  (void)curl_easy_setopt(curl, CURLOPT_SSH_KNOWNHOSTS, "string");
  (void)curl_easy_setopt(curl, CURLOPT_SSH_KNOWNHOSTS, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_SSH_KEYFUNCTION,
                         ssh_keycb);
  (void)curl_easy_setopt(curl, CURLOPT_SSH_KEYFUNCTION, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_SSH_KEYDATA, &object);
  (void)curl_easy_setopt(curl, CURLOPT_SSH_KEYDATA, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_MAIL_FROM, "string");
  (void)curl_easy_setopt(curl, CURLOPT_MAIL_FROM, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_MAIL_RCPT, slist);
  (void)curl_easy_setopt(curl, CURLOPT_MAIL_RCPT, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_USE_PRET, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_USE_PRET, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_USE_PRET, LO);
  (void)curl_easy_setopt(curl, CURLOPT_FTP_USE_PRET, HI);
  (void)curl_easy_setopt(curl, CURLOPT_RTSP_REQUEST, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_RTSP_REQUEST, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_RTSP_REQUEST, LO);
  (void)curl_easy_setopt(curl, CURLOPT_RTSP_REQUEST, HI);
  (void)curl_easy_setopt(curl, CURLOPT_RTSP_SESSION_ID, "string");
  (void)curl_easy_setopt(curl, CURLOPT_RTSP_SESSION_ID, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_RTSP_STREAM_URI, "string");
  (void)curl_easy_setopt(curl, CURLOPT_RTSP_STREAM_URI, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_RTSP_TRANSPORT, "string");
  (void)curl_easy_setopt(curl, CURLOPT_RTSP_TRANSPORT, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_RTSP_CLIENT_CSEQ, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_RTSP_CLIENT_CSEQ, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_RTSP_CLIENT_CSEQ, LO);
  (void)curl_easy_setopt(curl, CURLOPT_RTSP_CLIENT_CSEQ, HI);
  (void)curl_easy_setopt(curl, CURLOPT_RTSP_SERVER_CSEQ, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_RTSP_SERVER_CSEQ, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_RTSP_SERVER_CSEQ, LO);
  (void)curl_easy_setopt(curl, CURLOPT_RTSP_SERVER_CSEQ, HI);
  (void)curl_easy_setopt(curl, CURLOPT_INTERLEAVEDATA, &object);
  (void)curl_easy_setopt(curl, CURLOPT_INTERLEAVEDATA, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_INTERLEAVEFUNCTION,
                         interleavecb);
  (void)curl_easy_setopt(curl, CURLOPT_INTERLEAVEFUNCTION, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_WILDCARDMATCH, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_WILDCARDMATCH, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_WILDCARDMATCH, LO);
  (void)curl_easy_setopt(curl, CURLOPT_WILDCARDMATCH, HI);
  (void)curl_easy_setopt(curl, CURLOPT_CHUNK_BGN_FUNCTION,
                         chunk_bgn_cb);
  (void)curl_easy_setopt(curl, CURLOPT_CHUNK_BGN_FUNCTION, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_CHUNK_END_FUNCTION,
                         chunk_end_cb);
  (void)curl_easy_setopt(curl, CURLOPT_CHUNK_END_FUNCTION, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_FNMATCH_FUNCTION,
                         fnmatch_cb);
  (void)curl_easy_setopt(curl, CURLOPT_FNMATCH_FUNCTION, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_CHUNK_DATA, &object);
  (void)curl_easy_setopt(curl, CURLOPT_CHUNK_DATA, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_FNMATCH_DATA, &object);
  (void)curl_easy_setopt(curl, CURLOPT_FNMATCH_DATA, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_RESOLVE, slist);
  (void)curl_easy_setopt(curl, CURLOPT_RESOLVE, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_TLSAUTH_USERNAME, "string");
  (void)curl_easy_setopt(curl, CURLOPT_TLSAUTH_USERNAME, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_TLSAUTH_PASSWORD, "string");
  (void)curl_easy_setopt(curl, CURLOPT_TLSAUTH_PASSWORD, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_TLSAUTH_TYPE, "string");
  (void)curl_easy_setopt(curl, CURLOPT_TLSAUTH_TYPE, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_TRANSFER_ENCODING, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_TRANSFER_ENCODING, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_TRANSFER_ENCODING, LO);
  (void)curl_easy_setopt(curl, CURLOPT_TRANSFER_ENCODING, HI);
  (void)curl_easy_setopt(curl, CURLOPT_CLOSESOCKETFUNCTION,
                         closesocketcb);
  (void)curl_easy_setopt(curl, CURLOPT_CLOSESOCKETFUNCTION, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_CLOSESOCKETDATA, &object);
  (void)curl_easy_setopt(curl, CURLOPT_CLOSESOCKETDATA, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_GSSAPI_DELEGATION, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_GSSAPI_DELEGATION, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_GSSAPI_DELEGATION, LO);
  (void)curl_easy_setopt(curl, CURLOPT_GSSAPI_DELEGATION, HI);
  (void)curl_easy_setopt(curl, CURLOPT_DNS_SERVERS, "string");
  (void)curl_easy_setopt(curl, CURLOPT_DNS_SERVERS, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_ACCEPTTIMEOUT_MS, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_ACCEPTTIMEOUT_MS, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_ACCEPTTIMEOUT_MS, LO);
  (void)curl_easy_setopt(curl, CURLOPT_ACCEPTTIMEOUT_MS, HI);
  (void)curl_easy_setopt(curl, CURLOPT_TCP_KEEPALIVE, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_TCP_KEEPALIVE, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_TCP_KEEPALIVE, LO);
  (void)curl_easy_setopt(curl, CURLOPT_TCP_KEEPALIVE, HI);
  (void)curl_easy_setopt(curl, CURLOPT_TCP_KEEPIDLE, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_TCP_KEEPIDLE, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_TCP_KEEPIDLE, LO);
  (void)curl_easy_setopt(curl, CURLOPT_TCP_KEEPIDLE, HI);
  (void)curl_easy_setopt(curl, CURLOPT_TCP_KEEPINTVL, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_TCP_KEEPINTVL, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_TCP_KEEPINTVL, LO);
  (void)curl_easy_setopt(curl, CURLOPT_TCP_KEEPINTVL, HI);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_OPTIONS, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_OPTIONS, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_OPTIONS, LO);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_OPTIONS, HI);
  (void)curl_easy_setopt(curl, CURLOPT_MAIL_AUTH, "string");
  (void)curl_easy_setopt(curl, CURLOPT_MAIL_AUTH, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_SASL_IR, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_SASL_IR, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_SASL_IR, LO);
  (void)curl_easy_setopt(curl, CURLOPT_SASL_IR, HI);
  (void)curl_easy_setopt(curl, CURLOPT_XFERINFOFUNCTION,
                         xferinfocb);
  (void)curl_easy_setopt(curl, CURLOPT_XFERINFOFUNCTION, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_XOAUTH2_BEARER, "string");
  (void)curl_easy_setopt(curl, CURLOPT_XOAUTH2_BEARER, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_DNS_INTERFACE, "string");
  (void)curl_easy_setopt(curl, CURLOPT_DNS_INTERFACE, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_DNS_LOCAL_IP4, "string");
  (void)curl_easy_setopt(curl, CURLOPT_DNS_LOCAL_IP4, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_DNS_LOCAL_IP6, "string");
  (void)curl_easy_setopt(curl, CURLOPT_DNS_LOCAL_IP6, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_LOGIN_OPTIONS, "string");
  (void)curl_easy_setopt(curl, CURLOPT_LOGIN_OPTIONS, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_ENABLE_NPN, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_ENABLE_NPN, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_ENABLE_NPN, LO);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_ENABLE_NPN, HI);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_ENABLE_ALPN, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_ENABLE_ALPN, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_ENABLE_ALPN, LO);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_ENABLE_ALPN, HI);
  (void)curl_easy_setopt(curl, CURLOPT_EXPECT_100_TIMEOUT_MS, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_EXPECT_100_TIMEOUT_MS, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_EXPECT_100_TIMEOUT_MS, LO);
  (void)curl_easy_setopt(curl, CURLOPT_EXPECT_100_TIMEOUT_MS, HI);
  (void)curl_easy_setopt(curl, CURLOPT_PROXYHEADER, slist);
  (void)curl_easy_setopt(curl, CURLOPT_PROXYHEADER, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_HEADEROPT, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_HEADEROPT, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_HEADEROPT, LO);
  (void)curl_easy_setopt(curl, CURLOPT_HEADEROPT, HI);
  (void)curl_easy_setopt(curl, CURLOPT_PINNEDPUBLICKEY, "string");
  (void)curl_easy_setopt(curl, CURLOPT_PINNEDPUBLICKEY, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_UNIX_SOCKET_PATH, "string");
  (void)curl_easy_setopt(curl, CURLOPT_UNIX_SOCKET_PATH, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_VERIFYSTATUS, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_VERIFYSTATUS, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_VERIFYSTATUS, LO);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_VERIFYSTATUS, HI);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_FALSESTART, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_FALSESTART, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_FALSESTART, LO);
  (void)curl_easy_setopt(curl, CURLOPT_SSL_FALSESTART, HI);
  (void)curl_easy_setopt(curl, CURLOPT_PATH_AS_IS, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_PATH_AS_IS, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_PATH_AS_IS, LO);
  (void)curl_easy_setopt(curl, CURLOPT_PATH_AS_IS, HI);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_SERVICE_NAME, "string");
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_SERVICE_NAME, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_SERVICE_NAME, "string");
  (void)curl_easy_setopt(curl, CURLOPT_SERVICE_NAME, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_PIPEWAIT, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_PIPEWAIT, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_PIPEWAIT, LO);
  (void)curl_easy_setopt(curl, CURLOPT_PIPEWAIT, HI);
  (void)curl_easy_setopt(curl, CURLOPT_DEFAULT_PROTOCOL, "string");
  (void)curl_easy_setopt(curl, CURLOPT_DEFAULT_PROTOCOL, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_STREAM_WEIGHT, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_STREAM_WEIGHT, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_STREAM_WEIGHT, LO);
  (void)curl_easy_setopt(curl, CURLOPT_STREAM_WEIGHT, HI);
  (void)curl_easy_setopt(curl, CURLOPT_STREAM_DEPENDS, dep);
  (void)curl_easy_setopt(curl, CURLOPT_STREAM_DEPENDS, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_STREAM_DEPENDS_E, dep);
  (void)curl_easy_setopt(curl, CURLOPT_STREAM_DEPENDS_E, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_TFTP_NO_OPTIONS, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_TFTP_NO_OPTIONS, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_TFTP_NO_OPTIONS, LO);
  (void)curl_easy_setopt(curl, CURLOPT_TFTP_NO_OPTIONS, HI);
  (void)curl_easy_setopt(curl, CURLOPT_CONNECT_TO, &object);
  (void)curl_easy_setopt(curl, CURLOPT_CONNECT_TO, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_TCP_FASTOPEN, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_TCP_FASTOPEN, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_TCP_FASTOPEN, LO);
  (void)curl_easy_setopt(curl, CURLOPT_TCP_FASTOPEN, HI);
  (void)curl_easy_setopt(curl, CURLOPT_KEEP_SENDING_ON_ERROR, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_KEEP_SENDING_ON_ERROR, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_KEEP_SENDING_ON_ERROR, LO);
  (void)curl_easy_setopt(curl, CURLOPT_KEEP_SENDING_ON_ERROR, HI);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_CAINFO, "string");
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_CAINFO, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_CAPATH, "string");
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_CAPATH, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_SSL_VERIFYPEER, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_SSL_VERIFYPEER, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_SSL_VERIFYPEER, LO);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_SSL_VERIFYPEER, HI);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_SSL_VERIFYHOST, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_SSL_VERIFYHOST, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_SSL_VERIFYHOST, LO);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_SSL_VERIFYHOST, HI);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_SSLVERSION, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_SSLVERSION, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_SSLVERSION, LO);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_SSLVERSION, HI);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_TLSAUTH_USERNAME, "string");
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_TLSAUTH_USERNAME, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_TLSAUTH_PASSWORD, "string");
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_TLSAUTH_PASSWORD, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_TLSAUTH_TYPE, "string");
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_TLSAUTH_TYPE, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_SSLCERT, "string");
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_SSLCERT, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_SSLCERTTYPE, "string");
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_SSLCERTTYPE, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_SSLKEY, "string");
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_SSLKEY, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_SSLKEYTYPE, "string");
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_SSLKEYTYPE, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_KEYPASSWD, "string");
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_KEYPASSWD, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_SSL_CIPHER_LIST, "string");
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_SSL_CIPHER_LIST, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_CRLFILE, "string");
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_CRLFILE, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_SSL_OPTIONS, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_SSL_OPTIONS, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_SSL_OPTIONS, LO);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_SSL_OPTIONS, HI);
  (void)curl_easy_setopt(curl, CURLOPT_PRE_PROXY, "string");
  (void)curl_easy_setopt(curl, CURLOPT_PRE_PROXY, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_PINNEDPUBLICKEY, "string");
  (void)curl_easy_setopt(curl, CURLOPT_PROXY_PINNEDPUBLICKEY, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_ABSTRACT_UNIX_SOCKET, "string");
  (void)curl_easy_setopt(curl, CURLOPT_ABSTRACT_UNIX_SOCKET, NULL);
  (void)curl_easy_setopt(curl, CURLOPT_SUPPRESS_CONNECT_HEADERS, 0L);
  (void)curl_easy_setopt(curl, CURLOPT_SUPPRESS_CONNECT_HEADERS, 22L);
  (void)curl_easy_setopt(curl, CURLOPT_SUPPRESS_CONNECT_HEADERS, LO);
  (void)curl_easy_setopt(curl, CURLOPT_SUPPRESS_CONNECT_HEADERS, HI);
  curl_easy_setopt(curl, 1, 0);

test_cleanup:
  curl_easy_cleanup(curl);
  curl_easy_cleanup(dep);
  curl_share_cleanup(share);

  return res;
}
